/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.BiddingConformityReviewApi;
import api.BiddingLogApi;
import api.BiddingMainApi;
import api.BiddingResponseApi;
import api.BiddingVoteApi;
import api.MallAttachmentApi;
import api.query.BdDemandCodeRuleApi;
import api.query.BiddingCodeRuleApi;
import api.query.BiddingConformityReviewQueryApi;
import api.query.BiddingDemandApi;
import api.query.BiddingLogQueryApi;
import api.query.BiddingMainQueryApi;
import api.query.BiddingOrderQueryApi;
import api.query.BiddingQueryApi;
import api.query.BiddingResponseQueryApi;
import api.query.BiddingRoleOperationQueryApi;
import api.query.BiddingSupplierOrderManagerApi;
import api.query.MallAttachmentQueryApi;
import bidding.api.vo.BiddingMemberLoginInfoVo;
import bidding.web.service.BiddingOperatorService;
import bidding.web.service.ProtocolService;
import bidding.web.vo.AuditorInfoVO;
import bidding.web.vo.BiddingAuditInfoVo;
import bidding.web.vo.BiddingAuditVo;
import bidding.web.vo.BiddingChangeStateVo;
import bidding.web.vo.BiddingDemandQueryVo;
import bidding.web.vo.BiddingDemandResponseVo;
import bidding.web.vo.BiddingDemandVo;
import bidding.web.vo.BiddingIssueRequestVo;
import bidding.web.vo.BiddingQueryOperativeBuySaveVo;
import bidding.web.vo.BiddingResponseListVo;
import bidding.web.vo.BiddingResponseOutlineVo;
import bidding.web.vo.BiddingResultDemandQueryVo;
import bidding.web.vo.BiddingStatusVo;
import bidding.web.vo.BiddingSupplierResposeListVo;
import bidding.web.vo.ImageVo;
import bidding.web.vo.JcbdBdProviderVo;
import bidding.web.vo.JcbdBiddingConformanceVo;
import bidding.web.vo.JcbdBiddingDemandResponseVo;
import bidding.web.vo.JcbdBiddingGroupMemberVo;
import bidding.web.vo.JcbdBiddingOperationLogVo;
import bidding.web.vo.JcbdBiddingVo;
import bidding.web.vo.JcbdDemandAddressNumVo;
import bidding.web.vo.JcbdProviderAddressResponseVo;
import bidding.web.vo.JcbdProviderConformanceRespVo;
import bidding.web.vo.JcbdRoleOperationVo;
import bidding.web.vo.JcbdStoreContactsVo;
import bidding.web.vo.JcbdTempGoodsVo;
import bidding.web.vo.JcbdTempOrderVo;
import bidding.web.vo.MallAttachmentVo;
import bidding.web.vo.MemberInVoiceVO;
import bidding.web.vo.MemberInvoiceItemVo;
import bidding.web.vo.ProcureInformationVo;
import bidding.web.vo.QueryBiddingRequestVO;
import bidding.web.vo.QueryStatus;
import bidding.web.vo.SubmitResultVo;
import bidding.web.vo.TempBatchListVo;
import bidding.web.vo.TempBatchVo;
import bidding.web.vo.TempJcbdOrderVo;
import bidding.web.vo.TempPurchaseVo;
import bidding.web.vo.TianXianRequestVo;
import bidding.web.vo.TiaoXianCompanyVo;
import bidding.web.vo.UserInformationVo;
import bidding.web.vo.VoteQueryResultVo;
import cart.api.OrderMainApi;
import cart.api.difinication.UserCodeType;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.definition.OrderType;
import cart.api.dto.payment.PaymentConfigDto;
import cart.api.vo.FashionDetailVo;
import cart.api.vo.TempBatchPurchaseOrderVo;
import cart.api.vo.TempInvoiceAddrVo;
import cart.api.vo.TempInvoiceItemVo;
import cart.api.vo.TempInvoiceVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import cms.api.AddressApi;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingAuditStatus;
import definition.BiddingGroupMemberStatus;
import definition.BiddingOperateCode;
import definition.BiddingOrderStatus;
import definition.BiddingRoleStatus;
import definition.BiddingStatus;
import definition.MailTemplateEnum;
import definition.MallAttachmentBusinessCode;
import definition.StatusOperateModule;
import dto.BiddingAuditDTO;
import dto.BiddingChangeStateDto;
import dto.BiddingDemandQueryDto;
import dto.BiddingPriceParityDto;
import dto.BiddingResultDemandQueryDto;
import dto.BiddingResultSupplierInfoQueryDto;
import dto.BiddingStateResponseDto;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingDemandDto;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingGroupMemberDto;
import dto.JcbdBiddingOperationLogDto;
import dto.JcbdBiddingOrderItemDto;
import dto.JcbdBiddingPurchaseLogDto;
import dto.JcbdBiddingQueryDto;
import dto.JcbdBiddingQueryResultDto;
import dto.JcbdMallOrderDto;
import dto.JcbdOrderDto;
import dto.JcbdTempOrderDto;
import dto.MallAttachmentDto;
import dto.PriceParityInfoDto;
import dto.ProcureInformationDto;
import dto.TempBatchDto;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductFashionApi;
import goods.dto.goods.GoodsConfigDto;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import ma.glasnost.orika.MapperFacade;
import member.api.CoreCompDepartUserApi;
import member.api.CoreCompanyApi;
import member.api.CoreDepartmentApi;
import member.api.CoreRoleApi;
import member.api.CoreUserApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.MemberInvoinceApi;
import member.api.MemberMenuRoleApi;
import member.api.QueryInformationApi;
import member.api.dto.core.CoreCompDepartUserDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CoreDepartmentDto;
import member.api.dto.core.CoreRoleDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.menu.MemberMenuRoleDto;
import member.api.dto.menu.MemberMenuRoleUserDto;
import member.api.dto.order.OrderInvoiceDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.JsonModel;
import member.api.vo.MemberAddressVo;
import member.api.vo.MemberVo;
import member.api.vo.cart.InvoiceInfoVo;
import member.api.vo.cart.InvoiceItemInfoVo;
import member.api.vo.cart.InvoiceReceiverVo;
import member.api.vo.cart.OrderSubmitVo;
import member.model.core.CoreCompany;
import member.model.core.CoreDepartment;
import member.model.repository.core.CompanyRepos;
import member.model.repository.core.DepartmentRepos;
import message.MailModule;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.mail.vo.MailTemplateReq;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import query.BiddingDemandListQuery;
import query.BiddingDemandRespQuery;
import query.BiddingOperatorQuery;
import query.SupplierBiddingDamandQuery;
import shipping.api.InvoiceInfoApi;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreExtDto;
import sysmg.api.SystemConfigApi;
import uninogift.api.protocol.SupplierLoginApi;
import uninogift.vo.protocol.SupplierContactDto;
import uninogift.vo.protocol.outside.ContactPersonDto;
import uninogift.vo.protocol.outside.Response;
import uninogift.vo.protocol.outside.VendorDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.security.AesUtil;
import utils.sql.PageVo;
import utils.web.ResponseMapUtils;
import workflow.api.WfWorkFlowRelationApi;
import workflow.api.WorkFlowServiceApi;
import workflow.api.business.bidding.WfBiddingResultDataApi;
import workflow.definition.AuditBusinessCode;
import workflow.definition.AuditFlowImplInstance;
import workflow.definition.WorkFlowCode;
import workflow.dto.WfBiddingResultDataDto;
import workflow.dto.WfBiddingResultDataQuery;
import workflow.dto.WfBiddingResultDto;
import workflow.dto.WfWorkFlowDefinitionDto;
import workflow.dto.WfWorkFlowRelationDto;
import workflow.dto.WorkFlowRequestDto;

@Service
public class BiddingOperatorServiceImpl
implements BiddingOperatorService {
    public static final Logger log = LoggerFactory.getLogger(BiddingOperatorServiceImpl.class);
    public static ExecutorService executorService;
    public static final String INVOICE_ADDRESS_FLAG_NO = "0";
    public static final String INVOICE_ADDRESS_FLAG_YES = "1";
    public static final String IMPORT_SUCCESS = "\u5bfc\u5165\u6210\u529f";
    public static final String BIDDING_TITILE_SHOW_MODULE = "BiddingShow";
    public static final String ORGANIZATIONCODE = "jicai";
    private String GROUPMEMBER_STATUS_TRUE;
    private String GROUPMEMBER_STATUS_FALSE;
    private static final String CONSIGNEE_FLAG_TRUE = "1";
    private static final String CONSIGNEE_FLAG_FALSE = "0";
    private static final String ORDER_TYPE = "\u7ade\u4ef7\u8ba2\u5355";
    private static final String TPJT = "\u592a\u5e73\u96c6\u56e2";
    public String BIDDING_CODE_REDIS_KEY;
    public String DEMAND_CODE_REDIS_KEY;
    @MotanReferer
    CoreUserApi coreUserApi;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    BiddingMainApi biddingMainApi;
    @MotanReferer
    BiddingConformityReviewQueryApi biddingConformityReviewQueryApi;
    @MotanReferer
    MailApi mailApi;
    @MotanReferer
    BiddingResponseQueryApi biddingResponseQueryApi;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    ProtocolService protocolService;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    BiddingLogApi biddingLogApi;
    @MotanReferer
    MemberInvoinceApi memberInvoinceApi;
    @MotanReferer
    BiddingResponseApi biddingResponseApi;
    @MotanReferer
    BiddingVoteApi biddingVoteApi;
    @MotanReferer
    BiddingQueryApi biddingQueryApi;
    @MotanReferer
    MallAttachmentApi mallAttachmentApi;
    @MotanReferer
    BiddingLogQueryApi biddingLogQueryApi;
    @MotanReferer
    QueryInformationApi queryInformationApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    BiddingConformityReviewApi biddingConformityReviewApi;
    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;
    @MotanReferer
    WorkFlowServiceApi workFlowServiceApi;
    @MotanReferer
    BiddingDemandApi biddingDemandApi;
    @MotanReferer
    WfBiddingResultDataApi wfBiddingResultDataApi;
    @MotanReferer
    BiddingSupplierOrderManagerApi biddingSupplierOrderManagerApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @MotanReferer
    BiddingCodeRuleApi biddingCodeRuleApi;
    @MotanReferer
    BdDemandCodeRuleApi bdDemandCodeRuleApi;
    @MotanReferer
    CoreRoleApi coreRoleApi;
    @Autowired
    BiddingOperatorServiceImpl biddingOperatorService;
    @Value(value="${organization.code}")
    private String organizationCode;
    @Value(value="${bid.trading.limit}")
    private String tradingLimit;
    @Value(value="${spring.mail.username}")
    String mailFrom;
    @Value(value="${bidding.result.baseurl}")
    String bidding_result_baseurl;
    @Value(value="${bidding.groupMember.login.params}")
    String aesKey;
    @Value(value="${bidding.groupMember.loginUrl}")
    String loginUrl;
    @MotanReferer
    BiddingRoleOperationQueryApi biddingRoleOperationQueryApi;
    @MotanReferer
    AddressApi addressApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer
    MemberMenuRoleApi memberMenuRoleApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @MotanReferer
    InvoiceInfoApi invoiceInfoApi;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @MotanReferer
    CoreDepartmentApi coreDepartmentApi;
    @MotanReferer
    WfWorkFlowRelationApi wfWorkFlowRelationApi;
    @MotanReferer
    CoreCompanyApi coreCompanyApi;
    @MotanReferer
    SupplierLoginApi supplierLoginApi;
    @Autowired
    CompanyRepos companyRepos;
    @Autowired
    DepartmentRepos departmentRepos;

    public BiddingOperatorServiceImpl() {
        executorService = Executors.newFixedThreadPool(5);
        this.GROUPMEMBER_STATUS_TRUE = "1";
        this.GROUPMEMBER_STATUS_FALSE = "0";
        this.BIDDING_CODE_REDIS_KEY = "BIDDING:BIDDING_CODE_REDIS_KEY:";
        this.DEMAND_CODE_REDIS_KEY = "BIDDING:DEMAND_CODE_REDIS_KEY:";
    }

    public BaseResponse startComplianceAudit(@RequestBody BiddingChangeStateVo biddingChangeStateVo, String biddingMemberId) {
        BiddingStateResponseDto biddingStateResponseDto = null;
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        String companyName = this.getOperateInformation(biddingMemberId).getWholeJobName();
        JcbdBiddingVo jcbdBiddingVo = this.getBiddingByBiddingCode(biddingChangeStateVo.getBiddingNo());
        JcbdBiddingVo operator = this.getOperator(jcbdBiddingVo.getOperatorId());
        try {
            if (jcbdBiddingVo.getStatus().equals(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue())) {
                biddingChangeStateVo.setCurrentState(BiddingStatus.OM_CONFORM_AUDIT_NO.getValue());
                biddingChangeStateVo.setOpcode(BiddingOperateCode.RESTART_CONFORMITY_REVIEW.getCode());
            } else {
                biddingChangeStateVo.setCurrentState(BiddingStatus.OM_RESPONSE_STOP.getValue());
                biddingChangeStateVo.setOpcode(BiddingOperateCode.START_CONFORMITY_REVIEW.getCode());
            }
            BiddingChangeStateDto changeStateDto = (BiddingChangeStateDto)BeanMapper.map((Object)biddingChangeStateVo, BiddingChangeStateDto.class);
            biddingStateResponseDto = this.biddingMainApi.changeBiddingState(changeStateDto);
            if (!Lang.isEmpty((Object)biddingStateResponseDto.getBiddingState())) {
                log.info("\u5f00\u542f\u7b26\u5408\u6027\u5ba1\u67e5\uff1a\u8bf7\u6c42\u53c2\u6570{}\uff0c\u8fd4\u56de\u53c2\u6570{}", (Object)JSON.toJSONString((Object)changeStateDto), (Object)biddingStateResponseDto.getBiddingState());
                if (BiddingStatus.OM_CONFORM_AUDIT_IN.getValue().equals(biddingStateResponseDto.getBiddingState())) {
                    BaseResponse biddingGroupMembers = this.biddingConformityReviewQueryApi.findBiddingGroupMember(changeStateDto.getBiddingNo());
                    int size = ((List)biddingGroupMembers.getResult()).size();
                    String[] sendEmail = new String[size];
                    if (biddingGroupMembers.isSuccess()) {
                        for (int i = 0; i < size; ++i) {
                            sendEmail[i] = ((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getEmail();
                            mailReq.setTo(new String[]{sendEmail[i]});
                            mailReq.setFrom(operator.getEmail());
                            mailReq.setSentDate(new Date());
                            mailReq.setChannel("jc");
                            mailTemplateReq.setMailReq(mailReq);
                            String templateCode = MailTemplateEnum.BID_CONFORMANCE_AUDIT.getTemplateCode();
                            String redirectUrl = "/operator/complianceAudit";
                            String url = this.makeLoginUrl(StringUtils.join((Object[])new String[]{sendEmail[i]}), changeStateDto.getBiddingNo(), redirectUrl);
                            mailTemplateReq.setTemplateCode(templateCode);
                            ArrayList<String> subjectArgs = new ArrayList<String>();
                            subjectArgs.add(changeStateDto.getBiddingNo());
                            ArrayList<String> contextArgs = new ArrayList<String>();
                            if (!Lang.isEmpty((Object)((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getName())) {
                                contextArgs.add(((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getName());
                            } else {
                                contextArgs.add(((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getEmail());
                            }
                            contextArgs.add(companyName);
                            contextArgs.add(operator.getUsername());
                            contextArgs.add(changeStateDto.getBiddingNo());
                            contextArgs.add(url);
                            contextArgs.add(url);
                            mailTemplateReq.setSubjectArgList(subjectArgs);
                            mailTemplateReq.setContentArgList(contextArgs);
                            mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                            this.mailApi.sendMailByTemplate(mailTemplateReq);
                            log.info("\u5f00\u542f\u7b26\u5408\u6027\u5ba1\u67e5 \u90ae\u4ef6\u53d1\u9001{}", JSON.toJSON((Object)mailTemplateReq));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5f00\u542f\u7b26\u5408\u6027\u5ba1\u67e5 \u53d1\u9001\u90ae\u4ef6\u5931\u8d25");
        }
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public String makeLoginUrl(String email, String biddingNo, String redirectUrl) {
        String url = "";
        BiddingMemberLoginInfoVo biddingMemberLoginInfoVo = new BiddingMemberLoginInfoVo();
        biddingMemberLoginInfoVo.setBiddingNo(biddingNo);
        biddingMemberLoginInfoVo.setEmail(email);
        biddingMemberLoginInfoVo.setRedirectUrl(redirectUrl);
        String paramsJsonStr = JSON.toJSONString((Object)biddingMemberLoginInfoVo);
        try {
            String params = AesUtil.Encrypt((String)paramsJsonStr, (String)this.aesKey);
            params = new String(Base64.getEncoder().encode(params.getBytes()));
            url = this.loginUrl + "?params=" + params;
            log.info("\u751f\u6210\u7684url\u4e3a{}", (Object)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String biddingMemberId, String biddingEmail, List<String> biddingMemberRoles, QueryBiddingRequestVO queryBiddingRequestVO) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        JcbdBiddingQueryDto biddingQueryDto = new JcbdBiddingQueryDto();
        biddingQueryDto.setJcbdBiddingNo(queryBiddingRequestVO.getJcbdBiddingNo());
        biddingQueryDto.setDescribe(queryBiddingRequestVO.getJcbdBiddingDescribe());
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getState())) {
            if (BiddingStatus.OM_RESULT_SELECT_WAIT.getValue().equals(queryBiddingRequestVO.getState())) {
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.OM_RESULT_SELECT_WAIT_VOTE.getValue(), BiddingStatus.OM_RESULT_SELECT_WAIT_RANDOM.getValue()));
            } else {
                biddingQueryDto.setStates(Arrays.asList(queryBiddingRequestVO.getState()));
            }
        }
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getStartTime())) {
            biddingQueryDto.setStartTime(DateUtils.strToDate((String)queryBiddingRequestVO.getStartTime(), (String)"yyyy-MM-dd"));
        }
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getEndTime())) {
            biddingQueryDto.setEndTime(DateUtils.strToDate((String)queryBiddingRequestVO.getEndTime(), (String)"yyyy-MM-dd"));
        }
        biddingQueryDto.setRoles(biddingMemberRoles);
        biddingQueryDto.setUserId(biddingMemberId);
        biddingQueryDto.setEmail(biddingEmail);
        biddingQueryDto.setPageable((Pageable)pageable);
        Long totalElement = 0L;
        Page page = this.biddingMainQueryApi.operatorFindJcbdBiddingByParams(biddingQueryDto);
        ArrayList<BiddingResponseListVo> biddingResponseListVos = new ArrayList<BiddingResponseListVo>();
        if (!Lang.isEmpty((Object)page)) {
            for (JcbdBiddingQueryResultDto jcbdBiddingQueryResultDto : page.getContent()) {
                BiddingResponseListVo biddingResponseListVo = new BiddingResponseListVo();
                this.mapperFacade.map((Object)jcbdBiddingQueryResultDto, (Object)biddingResponseListVo);
                biddingResponseListVo.setStateName(((BiddingStatus)BiddingStatus.biddingStatusMap.get(jcbdBiddingQueryResultDto.getState())).getDescription());
                biddingResponseListVo.setStartTime(DateUtils.toString((Date)jcbdBiddingQueryResultDto.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                biddingResponseListVo.setEndTime(DateUtils.toString((Date)jcbdBiddingQueryResultDto.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (!Lang.isEmpty((Object)jcbdBiddingQueryResultDto.getOperations())) {
                    biddingResponseListVo.setOperations(this.mapperFacade.mapAsList((Iterable)jcbdBiddingQueryResultDto.getOperations(), JcbdRoleOperationVo.class));
                }
                biddingResponseListVos.add(biddingResponseListVo);
            }
            totalElement = page.getTotalElements();
            returnModel.put("aaData", biddingResponseListVos);
            returnModel.put("iTotalRecords", totalElement);
            returnModel.put("iTotalDisplayRecords", totalElement);
        } else {
            returnModel.put("aaData", biddingResponseListVos);
            returnModel.put("iTotalRecords", totalElement);
            returnModel.put("iTotalDisplayRecords", totalElement);
        }
        return returnModel;
    }

    public List<BiddingStatusVo> getAllStatusByRoles(List<String> biddingMemberRoles) {
        ArrayList<BiddingStatusVo> biddingStatusVos = new ArrayList<BiddingStatusVo>();
        if (biddingMemberRoles.contains("BIDDING_GROUP_MEMBER")) {
            Map stringBiddingStatusMap = (Map)BiddingRoleStatus.biddingRoleStatus.get("BIDDING_GROUP_MEMBER");
            Set strings = stringBiddingStatusMap.keySet();
            strings.forEach(key -> {
                BiddingStatusVo biddingStatusVo = new BiddingStatusVo();
                biddingStatusVo.setStatus(key);
                biddingStatusVo.setStatusName(((BiddingStatus)stringBiddingStatusMap.get(key)).getDescription());
                biddingStatusVos.add(biddingStatusVo);
            });
        } else if (biddingMemberRoles.contains("BIDDING_AUDITOR")) {
            Map stringBiddingStatusMap = (Map)BiddingRoleStatus.biddingRoleStatus.get("BIDDING_AUDITOR");
            Set strings = stringBiddingStatusMap.keySet();
            strings.forEach(key -> {
                BiddingStatusVo biddingStatusVo = new BiddingStatusVo();
                biddingStatusVo.setStatus(key);
                biddingStatusVo.setStatusName(((BiddingStatus)stringBiddingStatusMap.get(key)).getDescription());
                biddingStatusVos.add(biddingStatusVo);
            });
        }
        biddingStatusVos.forEach(biddingStatus -> {});
        return biddingStatusVos;
    }

    public Map issueBidding(BiddingIssueRequestVo biddingIssueRequestVo, String biddingMemberId) {
        BaseResponse biddingCodeResp = this.biddingMainQueryApi.getBiddingByBiddingCode(biddingIssueRequestVo.getBiddingCode());
        if (!biddingCodeResp.isSuccess()) {
            return ResponseMapUtils.error((String)"\u67e5\u8be2\u65e0\u8be5\u7ade\u4ef7\u4fe1\u606f");
        }
        BaseResponse response = this.biddingMainApi.updateBiddingTime(biddingIssueRequestVo.getBiddingCode(), new Date(), DateUtils.strToDate((String)biddingIssueRequestVo.getTimeEndResponse(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (!response.isSuccess()) {
            return ResponseMapUtils.error((String)"\u66f4\u65b0\u7ade\u4ef7\u5931\u8d25");
        }
        BaseResponse baseResponse = this.biddingResponseApi.supplierInitStatus(biddingIssueRequestVo.getBiddingCode());
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error((String)"\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
        }
        BiddingChangeStateDto biddingChangeStateDto = new BiddingChangeStateDto();
        biddingChangeStateDto.setBiddingNo(biddingIssueRequestVo.getBiddingCode());
        biddingChangeStateDto.setCurrentState(BiddingStatus.OM_ISSUE_WAIT.getValue());
        biddingChangeStateDto.setOpcode(BiddingOperateCode.ISSUE_BIDDING.getCode());
        BiddingStateResponseDto biddingStateResponseDto = this.biddingMainApi.changeBiddingState(biddingChangeStateDto);
        if (!BiddingStatus.OM_RESPONSE_WAIT.getValue().equals(biddingStateResponseDto.getBiddingState())) {
            return ResponseMapUtils.error((String)"\u7ade\u4ef7\u72b6\u6001\u53d8\u66f4\u9519\u8bef");
        }
        try {
            ArrayList storeContacts = new ArrayList();
            List providerVoList = this.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
            if (!Lang.isEmpty((Object)providerVoList)) {
                providerVoList.forEach(jcbdBdProviderVo -> {
                    if (!Lang.isEmpty((Object)jcbdBdProviderVo.getJcbdStoreContactsVos())) {
                        jcbdBdProviderVo.getJcbdStoreContactsVos().forEach(jcbdStoreContactsVo -> storeContacts.add(jcbdStoreContactsVo));
                    }
                });
            }
            if (Lang.isEmpty(storeContacts)) {
                log.info("\u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u5931\u8d25", (Object)biddingIssueRequestVo.getBiddingCode());
            } else {
                MailReq mailReq = new MailReq();
                MailTemplateReq mailTemplateReq = new MailTemplateReq();
                String companyName = this.getOperateInformation(biddingMemberId).getWholeJobName();
                JcbdBiddingVo jcbdBiddingVo = this.getBiddingByBiddingCode(biddingIssueRequestVo.getBiddingCode());
                JcbdBiddingVo operator = this.getOperator(jcbdBiddingVo.getOperatorId());
                storeContacts.forEach(supplierContant -> {
                    mailReq.setTo(new String[]{supplierContant.getEmail()});
                    mailReq.setFrom(this.mailFrom);
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel("jc");
                    mailTemplateReq.setMailReq(mailReq);
                    mailTemplateReq.setTemplateCode(MailTemplateEnum.BID_ISSUE.getTemplateCode());
                    ArrayList<String> subjectArgs = new ArrayList<String>();
                    subjectArgs.add(biddingIssueRequestVo.getBiddingCode());
                    ArrayList<String> contextArgs = new ArrayList<String>();
                    contextArgs.add(supplierContant.getName());
                    contextArgs.add(companyName.toString());
                    contextArgs.add(operator.getUsername());
                    contextArgs.add(biddingIssueRequestVo.getBiddingCode());
                    contextArgs.add(biddingIssueRequestVo.getTimeEndResponse());
                    mailTemplateReq.setSubjectArgList(subjectArgs);
                    mailTemplateReq.setContentArgList(contextArgs);
                    mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                    log.info("\u7ade\u4ef7\u53d1\u5e03\u90ae\u4ef6\u6a21\u677f\u5c01\u88c5\u6570\u636e{}", (Object)JSON.toJSONString((Object)mailTemplateReq));
                    this.mailApi.sendMailByTemplate(mailTemplateReq);
                });
            }
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7{}\u7684\u53d1\u5e03\u7ade\u4ef7\u64cd\u4f5c\u90ae\u4ef6\u901a\u77e5\u4f9b\u5e94\u5546\u5931\u8d25", (Object)biddingIssueRequestVo.getBiddingCode(), (Object)e);
        }
        return ResponseMapUtils.success((Object)"");
    }

    public String getBiddingCode() {
        BaseResponse biddingNo = this.biddingMainApi.getBiddingNo();
        log.info("biddingNo={}", biddingNo.getResult());
        return (String)biddingNo.getResult();
    }

    public JcbdBiddingVo getOperator(String memberId) {
        MemberDto member = this.memberApi.findMemberById(memberId);
        JcbdBiddingVo jcbdBiddingVo = new JcbdBiddingVo();
        if (!Lang.isEmpty((Object)member)) {
            jcbdBiddingVo.setUsername(member.getRealName());
            CoreUserDto coreUser = member.getCoreUser();
            if (!Lang.isEmpty((Object)coreUser)) {
                jcbdBiddingVo.setPhone(coreUser.getPhone());
                jcbdBiddingVo.setEmail(coreUser.getEmail());
            }
        }
        return jcbdBiddingVo;
    }

    public MemberDto getMember(String memberId) {
        return this.memberApi.findMemberById(memberId);
    }

    public Map saveOrUpdateBiddingBaseInfo(JcbdBiddingVo jcbdBiddingVo, String[] biddingGroups, String[] hiddenBiddingGroupMemberIds, String[] hiddenBiddingSpliceStringIds, List<ImageVo> imageVoList, String userId) {
        ArrayList<MallAttachmentVo> mallAttachmentVos = new ArrayList<MallAttachmentVo>();
        if (imageVoList != null) {
            for (ImageVo imageVo : imageVoList) {
                MallAttachmentVo mallAttachmentVo = new MallAttachmentVo();
                mallAttachmentVo.setAttachmentCorrelation(jcbdBiddingVo.getBiddingCode());
                mallAttachmentVo.setUrl(imageVo.getAbsoluteFilePath());
                mallAttachmentVo.setPath(imageVo.getFilePath());
                mallAttachmentVo.setAttachmentName(imageVo.getSourceName());
                mallAttachmentVo.setOrganizationCode("jiacai");
                mallAttachmentVo.setBusinessCode(MallAttachmentBusinessCode.BIDBASE_ATTACH_BUSCODE.getValue());
                mallAttachmentVos.add(mallAttachmentVo);
            }
            List mallAttachmentDtos = BeanMapper.mapList(mallAttachmentVos, MallAttachmentVo.class, MallAttachmentDto.class);
            if (!Lang.isEmpty((Object)mallAttachmentDtos)) {
                this.mallAttachmentApi.batchSave(mallAttachmentDtos);
            }
        } else {
            this.mallAttachmentApi.deleteMallAttachments(jcbdBiddingVo.getBiddingCode(), MallAttachmentBusinessCode.BIDBASE_ATTACH_BUSCODE.getValue());
        }
        OrganizationDto organization = this.organizationApi.findOrganizationByOrgCode(this.organizationCode);
        ArrayList<JcbdBiddingGroupMemberVo> groupMemberList = new ArrayList<JcbdBiddingGroupMemberVo>();
        for (int i = 0; i < biddingGroups.length; ++i) {
            if (!Lang.isEmpty((Object)biddingGroups[i]) && !Lang.isEmpty((Object)organization.getId())) {
                JcbdBiddingGroupMemberVo jbgmd = new JcbdBiddingGroupMemberVo();
                jbgmd.setGroupMemberInfo(biddingGroups[i]);
                String[] split = biddingGroups[i].split(",");
                CoreUserDto coreUserDto = null;
                if (!Lang.isEmpty((Object)split[2])) {
                    coreUserDto = this.coreUserApi.findByPhoneOrEmail(split[2], organization.getId());
                }
                List memberDtoList = null;
                if (!Lang.isEmpty(coreUserDto)) {
                    memberDtoList = this.memberApi.findByCoreUserId(coreUserDto.getId());
                    MemberDto memberDto = null;
                    if (!Lang.isEmpty((Object)memberDtoList)) {
                        memberDto = (MemberDto)memberDtoList.get(0);
                    }
                    if (!Lang.isEmpty(memberDto)) {
                        jbgmd.setGroupMemberId(memberDto.getId());
                        jbgmd.setName(memberDto.getRealName());
                        jbgmd.setPhone(coreUserDto.getPhone());
                        jbgmd.setEmail(coreUserDto.getEmail());
                    }
                } else {
                    jbgmd.setEmail(split[2]);
                }
                jbgmd.setEffective(BiddingGroupMemberStatus.VALID.getValue());
                groupMemberList.add(jbgmd);
                continue;
            }
            groupMemberList.add(null);
        }
        jcbdBiddingVo.setJcbdBiddingGroupMembers(groupMemberList);
        if (!Lang.isEmpty((Object)hiddenBiddingGroupMemberIds) && !Lang.isEmpty((Object)hiddenBiddingSpliceStringIds)) {
            for (int j = 0; j < hiddenBiddingGroupMemberIds.length; ++j) {
                if (Lang.isEmpty((Object)hiddenBiddingGroupMemberIds[j]) || Lang.isEmpty((Object)hiddenBiddingSpliceStringIds[j])) continue;
                try {
                    this.grantPermission4BiddingGroupMember(hiddenBiddingGroupMemberIds[j], hiddenBiddingSpliceStringIds[j], GlobalContants.ROLE_CODE_JC_JJXZ);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u4e3a\u7b2c" + j + "\u4e2a\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u6388\u6743\u51fa\u9519:", (Throwable)e);
                }
            }
        }
        ArrayList<JcbdBdProviderVo> jcbdBdProviderVos = new ArrayList<JcbdBdProviderVo>();
        List storeList = this.storeApi.findByTpye(StoreDto.STORE_TYPE_SUPLIER);
        for (StoreDto storeDto : storeList) {
            StoreExtDto storeExt = storeDto.getStoreExt();
            Response response = this.protocolService.getGysxx(storeExt.getdVendorId());
            VendorDto vendorDto = (VendorDto)response.getData();
            if (Lang.isEmpty((Object)vendorDto) || Lang.isEmpty((Object)vendorDto.getGysmc())) continue;
            JcbdBdProviderVo jcbdBdProviderVo = new JcbdBdProviderVo();
            jcbdBdProviderVo.setProviderId(storeDto.getId());
            jcbdBdProviderVo.setProviderName(vendorDto.getGysmc());
            jcbdBdProviderVos.add(jcbdBdProviderVo);
        }
        jcbdBiddingVo.setJcbdBdProviders(jcbdBdProviderVos);
        JcbdBiddingDto jcbdBiddingDto = (JcbdBiddingDto)BeanMapper.map((Object)jcbdBiddingVo, JcbdBiddingDto.class);
        jcbdBiddingDto.setOperatorName(jcbdBiddingVo.getUsername());
        jcbdBiddingDto.setOperatorPhone(jcbdBiddingVo.getPhone());
        jcbdBiddingDto.setProviderInviteNum(Integer.valueOf(jcbdBiddingVo.getJcbdBdProviders().size()));
        BaseResponse response = this.biddingMainApi.saveOrUpdateBiddingBaseInfo(jcbdBiddingDto);
        if (!response.isSuccess()) {
            return ResponseMapUtils.error((String)response.getResultMessage());
        }
        jcbdBiddingDto = (JcbdBiddingDto)response.getResult();
        JcbdBiddingVo biddingVo = null;
        if (!Lang.isEmpty((Object)jcbdBiddingDto)) {
            biddingVo = (JcbdBiddingVo)BeanMapper.map((Object)jcbdBiddingDto, JcbdBiddingVo.class);
        }
        return ResponseMapUtils.success(biddingVo);
    }

    public BaseResponse commitJcbdOrderData(TempPurchaseVo tempPurchaseVoData, String memberId) {
        TempPurchaseVo tempPurchaseVo = this.dealTempPurchaseVo(tempPurchaseVoData);
        log.info("Jcbd\u6267\u884c\u91c7\u8d2d\u6570\u636e\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)tempPurchaseVo));
        BaseResponse response = new BaseResponse();
        response.setSuccess(true);
        JcbdBiddingDto biddingDto = this.biddingQueryApi.findByBiddingCodeAndIsDelete(tempPurchaseVo.getBiddingCode());
        if (!biddingDto.getStatus().equals(BiddingStatus.OM_DO_BUY.getValue())) {
            response.setSuccess(false);
            response.setResultMessage("\u4f9b\u5e94\u5546\u5df2\u91cd\u65b0\u7f16\u8f91\u4e86\u672c\u6b21\u7ade\u4ef7\u7684\u5546\u54c1\uff0c\u8bf7\u5ba1\u6838\u5546\u54c1\u7f16\u7801\u540e\u518d\u6267\u884c\u91c7\u8d2d\uff01");
        }
        log.info("Jcbd\u6267\u884c\u91c7\u8d2d\u6570\u636e\u9a8c\u8bc1\u901a\u8fc7\uff0c\u4f1a\u5458ID\uff1a{}\uff0c\u6267\u884c\u91c7\u8d2d\u7ade\u4ef7\u7f16\u53f7\uff1a{}", (Object)memberId, (Object)biddingDto.getBiddingCode());
        BaseResponse baseResponse = this.createJcbdOrder(tempPurchaseVo, memberId);
        this.biddingMainApi.deleteTempOrderByBiddingCode(tempPurchaseVo.getBiddingCode());
        return baseResponse;
    }

    private TempPurchaseVo dealTempPurchaseVo(TempPurchaseVo tempPurchaseVoData) {
        List tempOrderDtos = this.biddingOrderQueryApi.findTempOrderByBiddingCode(tempPurchaseVoData.getBiddingCode());
        TempPurchaseVo tempPurchaseVo = new TempPurchaseVo();
        tempPurchaseVo.setUsageCode(tempPurchaseVoData.getUsageCode());
        tempPurchaseVo.setRemarks(tempPurchaseVoData.getRemarks());
        tempPurchaseVo.setPayMethodCode(tempPurchaseVoData.getPayMethodCode());
        tempPurchaseVo.setMallAttachments(tempPurchaseVoData.getMallAttachments());
        tempPurchaseVo.setBiddingCode(tempPurchaseVoData.getBiddingCode());
        tempPurchaseVo.setProcessId(tempPurchaseVoData.getProcessId());
        tempPurchaseVo.setTianxianDepartMentId(tempPurchaseVoData.getTianxianDepartMentId());
        ArrayList orders = new ArrayList();
        for (JcbdTempOrderDto tempOrderDto : tempOrderDtos) {
            tempOrderDto.getJcbdTempGoodses().forEach(n -> {
                TempJcbdOrderVo orderVo = new TempJcbdOrderVo();
                orderVo.setSku(n.getSku());
                orderVo.setResponsePrice(n.getPrice());
                orderVo.setCount(n.getNum());
                orderVo.setJcbdBiddingDemandId(n.getDemandId());
                orderVo.setMemberAddrId(tempOrderDto.getMemberAddressId());
                orderVo.setStoreId(tempOrderDto.getStoreId());
                orderVo.setProductFashionId(n.getProductFashionId());
                orderVo.setGoodsId(n.getGoodsId());
                orderVo.setJcbdBiddingDemandCode(n.getDemandCode());
                MemberAddressDto memberAddressDto = this.memberAddressApi.findByIdAndIsDelete(tempOrderDto.getMemberAddressId(), false);
                orderVo.setProvinceCode(memberAddressDto.getProvinceCode());
                orderVo.setCityCode(memberAddressDto.getCityCode());
                orderVo.setTownCode(memberAddressDto.getTownCode());
                orderVo.setAreaCode(memberAddressDto.getAreaCode());
                orderVo.setAddressDetail(memberAddressDto.getAddressDetail());
                orderVo.setPhone(memberAddressDto.getPhone());
                orderVo.setUsername(memberAddressDto.getUsername());
                MemberInVoiceVO inVoiceVO = new MemberInVoiceVO();
                inVoiceVO.setType(tempOrderDto.getInvoiceType());
                if ("1".equals(tempOrderDto.getConsigneeFlag())) {
                    inVoiceVO.setSameAsAchiever(true);
                    inVoiceVO.setAddressDetail(memberAddressDto.getAddressDetail());
                    inVoiceVO.setConsigneeName(memberAddressDto.getUsername());
                    inVoiceVO.setConsigneeCityCode(memberAddressDto.getCityCode());
                    inVoiceVO.setConsigneeProvinceCode(memberAddressDto.getProvinceCode());
                    inVoiceVO.setConsigneePhone(memberAddressDto.getTel());
                } else if ("0".equals(tempOrderDto.getConsigneeFlag())) {
                    inVoiceVO.setSameAsAchiever(false);
                    inVoiceVO.setAddressDetail(tempOrderDto.getAddressDetail());
                    inVoiceVO.setConsigneeName(tempOrderDto.getConsigneeName());
                    inVoiceVO.setConsigneeCityCode(tempOrderDto.getConsigneeCityCode());
                    inVoiceVO.setConsigneeProvinceCode(tempOrderDto.getConsigneeProvinceCode());
                    inVoiceVO.setConsigneePhone(tempOrderDto.getConsigneePhone());
                }
                if ("004".equals(tempOrderDto.getInvoiceType())) {
                    inVoiceVO.setCompanyId(tempOrderDto.getCompanyId());
                } else if ("007".equals(tempOrderDto.getInvoiceType())) {
                    inVoiceVO.setInvoiceName(tempOrderDto.getInvoiceTitle());
                    inVoiceVO.setInvoiceCode(tempOrderDto.getTaxIdentification());
                }
                orderVo.setMemberInVoice(inVoiceVO);
                orders.add(orderVo);
            });
        }
        tempPurchaseVo.setOrders(orders);
        tempPurchaseVo.setRequestId(tempPurchaseVoData.getRequestId());
        return tempPurchaseVo;
    }

    public BaseResponse createJcbdOrder(TempPurchaseVo tempPurchaseVo, String memberId) {
        Long startTime = System.currentTimeMillis();
        MemberDto memberDto = this.memberApi.findMemberById(memberId);
        BaseResponse response = new BaseResponse();
        response.setSuccess(true);
        ArrayList<JcbdBiddingPurchaseLogDto> purchaseLogDtos = new ArrayList<JcbdBiddingPurchaseLogDto>();
        Map<String, List<TempJcbdOrderVo>> listMap = tempPurchaseVo.getOrders().stream().collect(Collectors.groupingBy(TempJcbdOrderVo::getSku));
        for (Map.Entry<String, List<TempJcbdOrderVo>> entry : listMap.entrySet()) {
            JcbdBiddingPurchaseLogDto purchaseLogDto = new JcbdBiddingPurchaseLogDto();
            purchaseLogDto.setSku(entry.getKey());
            List<TempJcbdOrderVo> value = entry.getValue();
            purchaseLogDto.setNumberBuy(value.stream().collect(Collectors.summingInt(TempJcbdOrderVo::getCount)));
            JcbdBiddingDemandDto jcbdBiddingDemand = new JcbdBiddingDemandDto();
            jcbdBiddingDemand.setId(value.get(0).getJcbdBiddingDemandId());
            purchaseLogDto.setJcbdBiddingDemand(jcbdBiddingDemand);
            purchaseLogDtos.add(purchaseLogDto);
        }
        TempPurchaseVo tempOrderData = new TempPurchaseVo();
        this.mapperFacade.map((Object)tempPurchaseVo, (Object)tempOrderData);
        List tempBatchPurchaseOrderVos = this.dealWithBatchPurchaseData(tempPurchaseVo);
        log.info("\u5408\u5e76\u8ba2\u5355\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)tempBatchPurchaseOrderVos));
        log.info("\u5904\u7406\u63d0\u4ea4\u6570\u636e\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        Long tempOrderStart = System.currentTimeMillis();
        BaseResponse baseResponse = this.orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        log.info("\u751f\u6210\u4e34\u65f6\u8ba2\u5355{}", (Object)JSON.toJSONString((Object)baseResponse.getResult()));
        if (!baseResponse.isSuccess()) {
            log.error(baseResponse.getResultMessage());
            response.setSuccess(false);
            response.setResultMessage("\u751f\u6210\u4e34\u65f6\u8ba2\u5355\u65f6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return response;
        }
        ((List)baseResponse.getResult()).forEach(tempOrderVo -> tempOrderVo.getStoreList().forEach(tempOrderStoreVo -> tempOrderStoreVo.setType("3")));
        Long oderMainStart = System.currentTimeMillis();
        List tempOrderVos = (List)baseResponse.getResult();
        if (!Lang.isEmpty((Object)tempOrderVos)) {
            if (!Lang.isEmpty((Object)tempOrderData) && !Lang.isEmpty((Object)tempOrderData.getOrders())) {
                Map<String, List<TempJcbdOrderVo>> orderMap = tempOrderData.getOrders().stream().collect(Collectors.groupingBy(TempJcbdOrderVo::getSku));
                tempOrderVos.forEach(tempOrder -> {
                    tempOrder.getStoreList().forEach(store -> store.getOrderItems().forEach(item -> {
                        List tempJcbdOrderVos = (List)orderMap.get(item.getProductCode());
                        if (!Lang.isEmpty((Object)tempJcbdOrderVos)) {
                            TempJcbdOrderVo tempJcbdOrderVo = (TempJcbdOrderVo)tempJcbdOrderVos.get(0);
                            item.setSalePrice(tempJcbdOrderVo.getResponsePrice());
                            item.setBusinessCode(tempJcbdOrderVo.getJcbdBiddingDemandCode());
                        }
                    }));
                    String requestId = String.format("%s-%s", tempOrder.getTmpOrderNo(), tempPurchaseVo.getRequestId());
                    tempOrder.setRequestId(requestId);
                });
            }
            log.info("\u91cd\u65b0\u8bbe\u7f6e\u54cd\u5e94\u4ef7\u683c\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)tempOrderVos));
        }
        BaseResponse orderBaseRsp = this.orderMainApi.batchCreateOrder(tempOrderVos, memberId, tempPurchaseVo.getUsageCode(), tempPurchaseVo.getPayMethodCode());
        log.info("\u751f\u6210\u8ba2\u5355\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - oderMainStart));
        if (orderBaseRsp.isSuccess() && !Lang.isEmpty((Object)orderBaseRsp.getResult())) {
            response.setSuccess(true);
            List orderMainDtos = (List)orderBaseRsp.getResult();
            log.info("\u751f\u6210\u8ba2\u5355\u4e3a{}", (Object)orderMainDtos.stream().map(OrderMainDto::getOrderNo).collect(Collectors.toList()).toString());
            int orderCreatedNum = orderMainDtos.size();
            BigDecimal totalPriceOfAllOrders = orderMainDtos.stream().map(OrderMainDto::getSumPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            response.setResult((Object)orderMainDtos);
            StringBuffer resultStr = new StringBuffer("\u6267\u884c\u91c7\u8d2d\u6210\u529f\uff0c\u5df2\u4e3a\u60a8\u751f\u6210").append(orderCreatedNum).append("\u5f20\u8ba2\u5355\uff0c\u603b\u91d1\u989d").append(totalPriceOfAllOrders.toString()).append("\u5143\uff0c\u751f\u6210\u7684\u5168\u90e8\u8ba2\u5355\u53ef\u5728\u672c\u5546\u57ce\u7ade\u4ef7\u7684\u6267\u884c\u91c7\u8d2d\u7ed3\u679c\u4e2d\u67e5\u770b\uff0c\u4e5f\u53ef\u5728\u8ba2\u5355\u7ba1\u7406\u4e2d\u67e5\u770b");
            response.setResultMessage(resultStr.toString());
            this.batchCreateInvoices(orderMainDtos, tempPurchaseVo, memberDto);
            BaseResponse saveJcbdOrderResponse = this.saveJcbdOrder(orderMainDtos, tempPurchaseVo, totalPriceOfAllOrders, memberId);
            if (saveJcbdOrderResponse.isSuccess()) {
                JcbdOrderDto jcbdOrderDto = (JcbdOrderDto)saveJcbdOrderResponse.getResult();
                List orderNos = jcbdOrderDto.getJcbdMallOrders().parallelStream().map(JcbdMallOrderDto::getOrderNo).collect(Collectors.toList());
                try {
                    UserInformationVo operateInformation = this.getOperateInformation(memberId);
                    String organizationName = operateInformation.getWholeJobName();
                    HashMap<String, Object> bussinessDataMap = new HashMap<String, Object>();
                    bussinessDataMap.put("organizationName", organizationName);
                    bussinessDataMap.put("orderTime", new Date());
                    bussinessDataMap.put("biddingNo", tempPurchaseVo.getBiddingCode());
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(jcbdOrderDto.getBdOrderNo());
                    MemberVo memberInfo = this.memberApi.getMemberInfo(memberId);
                    WorkFlowRequestDto flowRequestDto = new WorkFlowRequestDto();
                    flowRequestDto.setMemberId(memberId);
                    flowRequestDto.setTiaoxian(tempPurchaseVo.getTianxianDepartMentId());
                    flowRequestDto.setWorkflowId(tempPurchaseVo.getProcessId());
                    flowRequestDto.setUserId(memberInfo.getUser().getId());
                    flowRequestDto.setOrderIds(list);
                    flowRequestDto.setReason(jcbdOrderDto.getRemark());
                    flowRequestDto.setRealName(memberInfo.getMember().getRealName());
                    flowRequestDto.setBussinessCode(AuditBusinessCode.BIDDING_ORDER_AUDIT.getBusinessCode());
                    flowRequestDto.setFlowIdentificationCode(WorkFlowCode.BIDDING_ORDER_WORKFLOW_CODE.getCode());
                    flowRequestDto.setTiaoxian(tempPurchaseVo.getTianxianDepartMentId());
                    flowRequestDto.setTotalMoney(jcbdOrderDto.getTotalMoney());
                    flowRequestDto.setCorePositionCode("JC_CGJBR");
                    flowRequestDto.setImplementClassBeanName(AuditFlowImplInstance.BIDDING_ORDER_AUDIT.getInstance());
                    flowRequestDto.setBussinessDataMap(bussinessDataMap);
                    this.workFlowServiceApi.startWorkFlow(flowRequestDto);
                    orderMainDtos.forEach(orderMain -> this.orderMainApi.updateOrderStatus(orderMain.getId(), "10"));
                    this.biddingLogApi.savePurchaseLog(purchaseLogDtos);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u91c7\u8d2d\u5ba1\u6838\u6d41\u5f00\u542f\u5931\u8d25\uff1a{}", (Throwable)e);
                    this.biddingMainApi.changeBiddingOrderState(orderNos, "9");
                    orderMainDtos.forEach(orderMain -> this.orderMainApi.updateOrderStatus(orderMain.getId(), "9"));
                    response.setSuccess(false);
                    response.setResultMessage("\u751f\u6210\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
            }
        } else {
            log.info("\u751f\u6210\u6b63\u5f0f\u8ba2\u5355\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)orderBaseRsp));
            response.setSuccess(false);
            response.setResultMessage("\u751f\u6210\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return response;
    }

    private List<TempBatchPurchaseOrderVo> dealWithBatchPurchaseData(TempPurchaseVo tempPurchaseVo) {
        ArrayList<TempBatchPurchaseOrderVo> tempBatchPurchaseOrderVos = new ArrayList<TempBatchPurchaseOrderVo>();
        List tempJcbdOrderVos = tempPurchaseVo.getOrders();
        for (TempJcbdOrderVo tempJcbdOrderVo : tempJcbdOrderVos) {
            MemberInvoiceItemVo memberInvoiceItemVo = new MemberInvoiceItemVo();
            memberInvoiceItemVo.setSku(tempJcbdOrderVo.getSku());
            memberInvoiceItemVo.setCount(tempJcbdOrderVo.getCount().intValue());
            memberInvoiceItemVo.setGoodsId(tempJcbdOrderVo.getGoodsId());
            memberInvoiceItemVo.setSalePrice(tempJcbdOrderVo.getResponsePrice());
            ArrayList<MemberInvoiceItemVo> memberInvoiceItemVoList = new ArrayList<MemberInvoiceItemVo>();
            memberInvoiceItemVoList.add(memberInvoiceItemVo);
            tempJcbdOrderVo.getMemberInVoice().setMemberInvoiceItemVos(memberInvoiceItemVoList);
        }
        while (tempJcbdOrderVos.size() > 0) {
            ArrayList<FashionDetailVo> fashionDetailVoList = new ArrayList<FashionDetailVo>();
            ArrayList tempDetailVoList = new ArrayList();
            TempJcbdOrderVo orderVoA = (TempJcbdOrderVo)tempJcbdOrderVos.get(0);
            FashionDetailVo fashionDetailVoA = new FashionDetailVo();
            fashionDetailVoA.setCount(orderVoA.getCount());
            fashionDetailVoA.setGoodsId(orderVoA.getGoodsId());
            fashionDetailVoA.setProductFashionId(orderVoA.getProductFashionId());
            fashionDetailVoA.setSalePrice(orderVoA.getResponsePrice());
            fashionDetailVoList.add(fashionDetailVoA);
            String memberAddrId = orderVoA.getMemberAddrId();
            String areaCode = orderVoA.getMemberAddrId();
            MemberInVoiceVO memberInVoiceA = ((TempJcbdOrderVo)tempJcbdOrderVos.get(0)).getMemberInVoice();
            ArrayList<MemberInVoiceVO> toBeHandledIvoiceVos = new ArrayList<MemberInVoiceVO>();
            toBeHandledIvoiceVos.add(memberInVoiceA);
            ArrayList<TempJcbdOrderVo> doneComparedOrderVo = new ArrayList<TempJcbdOrderVo>();
            doneComparedOrderVo.add(orderVoA);
            for (int j = 1; j <= tempJcbdOrderVos.size() - 1; ++j) {
                TempJcbdOrderVo orderVoB = (TempJcbdOrderVo)tempJcbdOrderVos.get(j);
                if (!StringUtils.equals((CharSequence)orderVoA.getUsername(), (CharSequence)orderVoB.getUsername()) || !StringUtils.equals((CharSequence)orderVoA.getProvinceCode(), (CharSequence)orderVoB.getProvinceCode()) || !StringUtils.equals((CharSequence)orderVoA.getCityCode(), (CharSequence)orderVoB.getCityCode()) || !StringUtils.equals((CharSequence)orderVoA.getTownCode(), (CharSequence)orderVoB.getTownCode()) || !StringUtils.equals((CharSequence)orderVoA.getAreaCode(), (CharSequence)orderVoB.getAreaCode()) || !StringUtils.equals((CharSequence)orderVoA.getAddressDetail(), (CharSequence)orderVoB.getAddressDetail()) || !StringUtils.equals((CharSequence)orderVoA.getPhone(), (CharSequence)orderVoB.getPhone()) || !StringUtils.equals((CharSequence)orderVoA.getStoreId(), (CharSequence)orderVoB.getStoreId())) continue;
                Optional<FashionDetailVo> detailVoOptional = fashionDetailVoList.stream().filter(fashionDetailVo -> StringUtils.equals((CharSequence)fashionDetailVo.getGoodsId(), (CharSequence)orderVoB.getGoodsId())).findFirst();
                FashionDetailVo detailVo = null;
                if (detailVoOptional.isPresent()) {
                    detailVo = detailVoOptional.get();
                }
                if (!Lang.isEmpty(detailVo)) {
                    detailVo.setCount(Integer.valueOf(detailVo.getCount() + orderVoB.getCount()));
                } else {
                    FashionDetailVo fashionDetailVoB = new FashionDetailVo();
                    fashionDetailVoB.setGoodsId(orderVoB.getGoodsId());
                    fashionDetailVoB.setCount(orderVoB.getCount());
                    fashionDetailVoB.setProductFashionId(orderVoB.getProductFashionId());
                    fashionDetailVoList.add(fashionDetailVoB);
                }
                toBeHandledIvoiceVos.add(((TempJcbdOrderVo)tempJcbdOrderVos.get(j)).getMemberInVoice());
                doneComparedOrderVo.add(orderVoB);
            }
            if (!Lang.isEmpty(tempDetailVoList)) {
                fashionDetailVoList.removeAll(tempDetailVoList);
            }
            tempJcbdOrderVos.removeAll(doneComparedOrderVo);
            tempPurchaseVo.setOrders(doneComparedOrderVo);
            ArrayList<TempInvoiceVo> tempInvoiceVoList = new ArrayList<TempInvoiceVo>();
            ArrayList<MemberInVoiceVO> doneComparedInvoiceVos = new ArrayList<MemberInVoiceVO>();
            while (toBeHandledIvoiceVos.size() > 0) {
                MemberInVoiceVO inVoiceVOA = (MemberInVoiceVO)toBeHandledIvoiceVos.get(0);
                TempInvoiceVo tempInvoiceVo = new TempInvoiceVo();
                tempInvoiceVo.setInvoiceName(inVoiceVOA.getInvoiceName());
                tempInvoiceVo.setInvoiceCode(inVoiceVOA.getInvoiceCode());
                tempInvoiceVo.setInvoiceType(inVoiceVOA.getType());
                tempInvoiceVo.setCompanyId(inVoiceVOA.getCompanyId());
                List memberInvoiceItemVos = inVoiceVOA.getMemberInvoiceItemVos();
                TempInvoiceAddrVo tempInvoiceAddrVo = new TempInvoiceAddrVo();
                tempInvoiceAddrVo.setProvinceCode(inVoiceVOA.getConsigneeProvinceCode());
                tempInvoiceAddrVo.setCityCode(inVoiceVOA.getConsigneeCityCode());
                tempInvoiceAddrVo.setName(inVoiceVOA.getConsigneeName());
                tempInvoiceAddrVo.setPhone(inVoiceVOA.getConsigneePhone());
                tempInvoiceAddrVo.setAddress(inVoiceVOA.getAddressDetail());
                tempInvoiceAddrVo.setSameAsAchiever(inVoiceVOA.isSameAsAchiever());
                tempInvoiceVo.setTempInvoiceAddrVo(tempInvoiceAddrVo);
                doneComparedInvoiceVos.add(inVoiceVOA);
                for (int k = 1; k <= toBeHandledIvoiceVos.size() - 1; ++k) {
                    MemberInVoiceVO inVoiceVOB = (MemberInVoiceVO)toBeHandledIvoiceVos.get(k);
                    if (!StringUtils.equals((CharSequence)inVoiceVOA.getType(), (CharSequence)inVoiceVOB.getType()) || !StringUtils.equals((CharSequence)inVoiceVOA.getInvoiceCode(), (CharSequence)inVoiceVOB.getInvoiceCode()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneeName(), (CharSequence)inVoiceVOB.getConsigneeName()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneePhone(), (CharSequence)inVoiceVOB.getConsigneePhone()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneeProvinceCode(), (CharSequence)inVoiceVOB.getConsigneeProvinceCode()) || !StringUtils.equals((CharSequence)inVoiceVOA.getConsigneeCityCode(), (CharSequence)inVoiceVOB.getConsigneeCityCode()) || !StringUtils.equals((CharSequence)inVoiceVOA.getAddressDetail(), (CharSequence)inVoiceVOB.getAddressDetail()) || !StringUtils.equals((CharSequence)inVoiceVOA.getInvoiceName(), (CharSequence)inVoiceVOB.getInvoiceName()) || !StringUtils.equals((CharSequence)inVoiceVOA.getCompanyId(), (CharSequence)inVoiceVOB.getCompanyId())) continue;
                    memberInvoiceItemVos.addAll(inVoiceVOB.getMemberInvoiceItemVos());
                    doneComparedInvoiceVos.add(inVoiceVOB);
                }
                List tempInvoiceItemVos = this.mapperFacade.mapAsList((Iterable)memberInvoiceItemVos, TempInvoiceItemVo.class);
                tempInvoiceVo.setTempInvoiceItemVos(tempInvoiceItemVos);
                tempInvoiceVoList.add(tempInvoiceVo);
                toBeHandledIvoiceVos.removeAll(doneComparedInvoiceVos);
            }
            TempBatchPurchaseOrderVo tempBatchPurchaseOrderVo = new TempBatchPurchaseOrderVo();
            tempBatchPurchaseOrderVo.setFashionDetailVoList(fashionDetailVoList);
            tempBatchPurchaseOrderVo.setTempInvoiceVoList(tempInvoiceVoList);
            tempBatchPurchaseOrderVo.setAreaCode(areaCode);
            tempBatchPurchaseOrderVo.setOrganizationCode(this.organizationCode);
            tempBatchPurchaseOrderVo.setMemberAddrId(memberAddrId);
            tempBatchPurchaseOrderVo.setType(Integer.valueOf(OrderType.bidding.getCode()));
            tempBatchPurchaseOrderVos.add(tempBatchPurchaseOrderVo);
        }
        return tempBatchPurchaseOrderVos;
    }

    private BaseResponse batchCreateInvoices(List<OrderMainDto> orderMainDtos, TempPurchaseVo tempPurchaseVo, MemberDto memberDto) {
        Long invoiceStart = System.currentTimeMillis();
        BaseResponse baseResponse = new BaseResponse();
        ArrayList orderInvoiceDtos = new ArrayList();
        orderMainDtos.forEach(n -> {
            OrderInvoiceDto orderInvoiceDto = new OrderInvoiceDto();
            OrderSubmitVo orderSubmitVo = new OrderSubmitVo();
            orderSubmitVo.setInvoiceInfos(new ArrayList());
            orderSubmitVo.setAddressId(n.getAddressId());
            orderSubmitVo.setNeedBills(Boolean.valueOf(true));
            orderSubmitVo.setOrderUsageCode(tempPurchaseVo.getUsageCode());
            orderSubmitVo.setPayMethodCode(tempPurchaseVo.getPayMethodCode());
            List tempInvoiceVos = n.getTempInvoiceVoList();
            Boolean hasShippingFee = false;
            BigDecimal freight = n.getFreight();
            BigDecimal evenShippingFee = BigDecimal.ZERO;
            if (freight.compareTo(BigDecimal.ZERO) > 0) {
                hasShippingFee = true;
                evenShippingFee = freight.divide(new BigDecimal(tempInvoiceVos.size()), 2, 4);
            }
            ArrayList<InvoiceInfoVo> invoiceInfoVos = new ArrayList<InvoiceInfoVo>();
            for (int i = 0; i < tempInvoiceVos.size(); ++i) {
                TempInvoiceVo tempInvoiceVo = (TempInvoiceVo)tempInvoiceVos.get(i);
                ArrayList<InvoiceItemInfoVo> invoiceInfoItems = new ArrayList<InvoiceItemInfoVo>();
                InvoiceInfoVo invoiceInfoVo = new InvoiceInfoVo();
                String invocieType = tempInvoiceVo.getInvoiceType();
                invoiceInfoVo.setInvoiceType(invocieType);
                if (invocieType.equals("007")) {
                    String invoiceName = tempInvoiceVo.getInvoiceName();
                    if (!Lang.isEmpty((Object)invoiceName)) {
                        invoiceInfoVo.setName(invoiceName);
                    }
                    invoiceInfoVo.setIdentificationCode(tempInvoiceVo.getInvoiceCode());
                }
                invoiceInfoVo.setCoreConpanyId(tempInvoiceVo.getCompanyId());
                List tempInvoiceItemVos = tempInvoiceVo.getTempInvoiceItemVos();
                for (TempInvoiceItemVo tempInvoiceItemVo : tempInvoiceItemVos) {
                    InvoiceItemInfoVo invoiceItemInfoVo = new InvoiceItemInfoVo();
                    invoiceItemInfoVo.setCount(Integer.valueOf(tempInvoiceItemVo.getCount()));
                    invoiceItemInfoVo.setFreigh(Lang.isEmpty((Object)tempInvoiceItemVo.getFreigh()) ? false : tempInvoiceItemVo.getFreigh());
                    invoiceItemInfoVo.setGoodsId(tempInvoiceItemVo.getGoodsId());
                    invoiceItemInfoVo.setPrice(tempInvoiceItemVo.getSalePrice());
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                if (hasShippingFee.booleanValue()) {
                    InvoiceItemInfoVo invoiceItemInfoVo = new InvoiceItemInfoVo();
                    invoiceItemInfoVo.setGoodsId("shippingFee");
                    invoiceItemInfoVo.setPrice(evenShippingFee);
                    invoiceInfoItems.add(invoiceItemInfoVo);
                }
                InvoiceReceiverVo receiverVo = new InvoiceReceiverVo();
                TempInvoiceAddrVo tempInvoiceAddrVo = tempInvoiceVo.getTempInvoiceAddrVo();
                if (tempInvoiceAddrVo.isSameAsAchiever()) {
                    receiverVo.setSameAsAchiever(Boolean.valueOf(true));
                } else {
                    receiverVo.setSameAsAchiever(Boolean.valueOf(false));
                }
                receiverVo.setAddress(tempInvoiceAddrVo.getAddress());
                receiverVo.setName(tempInvoiceAddrVo.getName());
                receiverVo.setPhone(tempInvoiceAddrVo.getPhone());
                receiverVo.setCityCode(tempInvoiceAddrVo.getCityCode());
                receiverVo.setProvinceCode(tempInvoiceAddrVo.getProvinceCode());
                invoiceInfoVo.setInvoiceItems(invoiceInfoItems);
                invoiceInfoVo.setInvoiceReceiver(receiverVo);
                invoiceInfoVos.add(invoiceInfoVo);
            }
            for (InvoiceItemInfoVo invoiceItemInfoVo : ((InvoiceInfoVo)invoiceInfoVos.get(invoiceInfoVos.size() - 1)).getInvoiceItems()) {
                if (!"shippingFee".equals(invoiceItemInfoVo.getGoodsId())) continue;
                invoiceItemInfoVo.setPrice(freight.subtract(evenShippingFee.multiply(new BigDecimal(invoiceInfoVos.size() - 1))));
            }
            orderSubmitVo.setInvoiceInfos(invoiceInfoVos);
            orderInvoiceDto.setMemberDto(memberDto);
            member.api.dto.order.OrderMainDto memberOrderMainDto = (member.api.dto.order.OrderMainDto)this.mapperFacade.map(n, member.api.dto.order.OrderMainDto.class);
            orderInvoiceDto.setOrderMainDto(memberOrderMainDto);
            orderInvoiceDto.setOrderSubmitVo(orderSubmitVo);
            orderInvoiceDtos.add(orderInvoiceDto);
        });
        baseResponse = this.memberInvoinceApi.createOrderInvoices(orderInvoiceDtos);
        log.info("\u751f\u6210\u53d1\u7968\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - invoiceStart));
        if (baseResponse.isSuccess()) {
            log.info("\u751f\u6210\u53d1\u7968\u6210\u529f");
        } else {
            log.info("\u751f\u6210\u53d1\u7968\u5931\u8d25");
        }
        return baseResponse;
    }

    public BaseResponse<JcbdOrderDto> saveJcbdOrder(List<OrderMainDto> orderMainDtos, TempPurchaseVo tempPurchaseVo, BigDecimal totalMoney, String memberId) {
        BaseResponse baseResponse = new BaseResponse();
        ArrayList jcbdMallOrderDtoList = new ArrayList();
        HashMap orderItemDtosMap = new HashMap();
        BigDecimal[] sumFreight = new BigDecimal[]{BigDecimal.ZERO};
        orderMainDtos.forEach(n -> {
            JcbdMallOrderDto mallOrderDto = new JcbdMallOrderDto();
            mallOrderDto.setOrderNo(n.getOrderNo());
            mallOrderDto.setProviderId(n.getStoreId());
            MemberAddressDto addressDto = this.memberAddressApi.findByIdAndIsDelete(n.getAddressId(), false);
            mallOrderDto.setAddress(addressDto.getAddressDetail());
            mallOrderDto.setStatus(BiddingOrderStatus.ORDER_STATUS_INREVIEW.getCode());
            orderItemDtosMap.put(n.getOrderNo(), n.getOrderItems());
            if (!Lang.isEmpty((Object)n.getFreight())) {
                sumFreight[0] = sumFreight[0].add(n.getFreight());
            }
            jcbdMallOrderDtoList.add(mallOrderDto);
        });
        jcbdMallOrderDtoList.parallelStream().forEach(mallOrder -> {
            List orderItemDtos = (List)orderItemDtosMap.get(mallOrder.getOrderNo());
            ArrayList orderItemDtoList = new ArrayList();
            orderItemDtos.parallelStream().forEach(orderItem -> {
                JcbdBiddingOrderItemDto jcbdBiddingOrderItemDto = new JcbdBiddingOrderItemDto();
                jcbdBiddingOrderItemDto.setCount(orderItem.getCount());
                jcbdBiddingOrderItemDto.setSku(orderItem.getSku());
                jcbdBiddingOrderItemDto.setJcbdMallOrder(mallOrder);
                orderItemDtoList.add(jcbdBiddingOrderItemDto);
            });
            mallOrder.setJcbdBiddingOrderItems(orderItemDtoList);
        });
        DecimalFormat df = new DecimalFormat("#.00");
        JcbdOrderDto jcbdOrderDto = new JcbdOrderDto();
        jcbdOrderDto.setRemark(tempPurchaseVo.getRemarks());
        jcbdOrderDto.setTotalMoney(new BigDecimal(df.format(totalMoney.doubleValue())));
        jcbdOrderDto.setStatus(BiddingOrderStatus.ORDER_STATUS_INREVIEW.getCode());
        jcbdOrderDto.setFreight(sumFreight[0]);
        if (!Lang.isEmpty((Object)tempPurchaseVo.getSumfreight())) {
            jcbdOrderDto.setGoodsPrice(df.format(totalMoney.subtract(tempPurchaseVo.getSumfreight()).doubleValue()));
        } else {
            jcbdOrderDto.setGoodsPrice(df.format(totalMoney.doubleValue()));
        }
        jcbdOrderDto.setOrderUse(((UserCodeType)UserCodeType.userCodeTypeMap.get(tempPurchaseVo.getUsageCode())).getDescription());
        UserInformationVo operateInformation = this.getOperateInformation(memberId);
        String organizationName = operateInformation.getWholeJobName();
        jcbdOrderDto.setCompanyName(organizationName);
        jcbdOrderDto.setPayType((String)PaymentConfigDto.payMethodMap.get(tempPurchaseVo.getPayMethodCode()));
        jcbdOrderDto.setOrderType(ORDER_TYPE);
        JcbdBiddingDto biddingDto = this.biddingQueryApi.findByBiddingCodeAndIsDelete(tempPurchaseVo.getBiddingCode());
        jcbdOrderDto.setJcbdBidding(biddingDto);
        JcbdBdProviderDto jcbdBdProvider = this.biddingSupplierOrderManagerApi.findJcbdBdProvider(biddingDto.getId(), orderMainDtos.get(0).getStoreId());
        jcbdOrderDto.setSupplierId(jcbdBdProvider.getId());
        jcbdOrderDto.setSupplierName(jcbdBdProvider.getProviderName());
        jcbdOrderDto.setBdOrderNo(this.orderMainApi.generateOrderNo());
        jcbdOrderDto.setPurchaseNo(this.orderMainApi.generateOrderNo());
        jcbdOrderDto.setJcbdMallOrders(jcbdMallOrderDtoList);
        JcbdOrderDto saveJcbdOrder = this.biddingMainApi.saveJcbdOrder(jcbdOrderDto);
        List mallAttachmentVos = tempPurchaseVo.getMallAttachments();
        mallAttachmentVos.parallelStream().forEach(mallAttachmentVo -> {
            mallAttachmentVo.setAttachmentCorrelation(jcbdOrderDto.getBdOrderNo());
            mallAttachmentVo.setBusinessCode(MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getValue());
            mallAttachmentVo.setBusinessDescription(MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getDescription());
            mallAttachmentVo.setOrganizationCode(ORGANIZATIONCODE);
        });
        if (!Lang.isEmpty((Object)mallAttachmentVos)) {
            try {
                List mallAttachmentDtos = this.mapperFacade.mapAsList((Iterable)mallAttachmentVos, MallAttachmentDto.class);
                this.mallAttachmentApi.batchSave(mallAttachmentDtos);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u91c7\u8d2d\u4e0b\u5355\u9644\u4ef6\u5931\u8d25,biddingDto={}", (Object)JSON.toJSONString((Object)biddingDto), (Object)e);
            }
        } else {
            try {
                this.mallAttachmentApi.deleteMallAttachments(jcbdOrderDto.getBdOrderNo(), MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getValue());
            }
            catch (Exception e) {
                log.error("\u6e05\u7a7a\u91c7\u8d2d\u4e0b\u5355\u9644\u4ef6\u5931\u8d25,biddingDto={}", (Object)JSON.toJSONString((Object)biddingDto), (Object)e);
            }
        }
        baseResponse.setSuccess(true);
        baseResponse.setResult((Object)saveJcbdOrder);
        return baseResponse;
    }

    public List<JcbdBdProviderVo> findStoreContacts(String type) {
        ArrayList<JcbdBdProviderVo> jcbdBdProviderVos = new ArrayList<JcbdBdProviderVo>();
        List storeList = this.storeApi.findByTpye(type);
        for (StoreDto storeDto : storeList) {
            VendorDto vendorDto;
            ArrayList<JcbdStoreContactsVo> jcbdStoreContactsVoList = new ArrayList<JcbdStoreContactsVo>();
            StoreExtDto storeExt = storeDto.getStoreExt();
            Response response = this.protocolService.getGysxx(storeExt.getdVendorId());
            log.info("response{}", (Object)JSON.toJSONString((Object)response));
            if (!response.getSuccess().booleanValue() || Lang.isEmpty((Object)(vendorDto = (VendorDto)response.getData())) || Lang.isEmpty((Object)vendorDto.getGysmc())) continue;
            JcbdBdProviderVo jcbdBdProviderVo = new JcbdBdProviderVo();
            jcbdBdProviderVo.setProviderId(storeDto.getId());
            jcbdBdProviderVo.setProviderName(vendorDto.getGysmc());
            List lxrlist = vendorDto.getLxrlist();
            for (ContactPersonDto contactPersonDto : lxrlist) {
                JcbdStoreContactsVo jcbdStoreContactsVo = new JcbdStoreContactsVo();
                jcbdStoreContactsVo.setStoreName(vendorDto.getGysmc());
                jcbdStoreContactsVo.setName(contactPersonDto.getName());
                jcbdStoreContactsVo.setPhone(contactPersonDto.getTel());
                jcbdStoreContactsVo.setEmail(contactPersonDto.getEmail());
                jcbdStoreContactsVoList.add(jcbdStoreContactsVo);
            }
            jcbdBdProviderVo.setJcbdStoreContactsVos(jcbdStoreContactsVoList);
            jcbdBdProviderVos.add(jcbdBdProviderVo);
        }
        return jcbdBdProviderVos;
    }

    public String getDemandCode(String biddingCode) {
        String one = "D" + (biddingCode + "101".substring(1)).substring(1);
        JcbdBiddingDto biddingDto = this.biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);
        if (!Lang.isEmpty((Object)biddingDto)) {
            Integer countByBid = this.bdDemandCodeRuleApi.findDemandCountByBid(biddingDto.getId());
            if (Lang.isEmpty((Object)countByBid) || countByBid == 0) {
                return one;
            }
            String bdDcode = biddingCode + (101 + countByBid + "").substring(1);
            return "D" + bdDcode.substring(1);
        }
        return one;
    }

    public void saveOrUpdateBiddingDemand(BiddingDemandVo biddingDemandVo, String[] demandAddress, String[] numberNeed, String[] conformances) {
        BaseResponse demandInfo;
        JcbdBiddingDemandDto demandDto;
        ArrayList<JcbdDemandAddressNumVo> demandAddressNumVos = new ArrayList<JcbdDemandAddressNumVo>();
        for (int i = 0; i < demandAddress.length; ++i) {
            JcbdDemandAddressNumVo demandAddressNumVo = new JcbdDemandAddressNumVo();
            String[] demandAddres = demandAddress[i].split("\\s+");
            if (Lang.isEmpty((Object)demandAddres[0]) || Lang.isEmpty((Object)demandAddres[1]) || Lang.isEmpty((Object)numberNeed[i])) continue;
            demandAddressNumVo.setProvinceName(demandAddres[0]);
            demandAddressNumVo.setCityName(demandAddres[1]);
            demandAddressNumVo.setNumberNeed(Long.valueOf(Long.parseLong(numberNeed[i])));
            demandAddressNumVos.add(demandAddressNumVo);
        }
        if (!Lang.isEmpty(demandAddressNumVos)) {
            biddingDemandVo.setJcbdDemandAddressNums(demandAddressNumVos);
        }
        ArrayList<JcbdBiddingConformanceVo> biddingConformanceVoList = new ArrayList<JcbdBiddingConformanceVo>();
        for (int i = 0; i < conformances.length; ++i) {
            if (Lang.isEmpty((Object)conformances[i])) continue;
            JcbdBiddingConformanceVo biddingConformanceVo = new JcbdBiddingConformanceVo();
            biddingConformanceVo.setConformance(conformances[i]);
            biddingConformanceVoList.add(biddingConformanceVo);
        }
        if (!Lang.isEmpty(biddingConformanceVoList)) {
            biddingDemandVo.setJcbdBiddingConformances(biddingConformanceVoList);
        }
        if (!Lang.isEmpty((Object)(demandDto = (JcbdBiddingDemandDto)(demandInfo = this.biddingMainQueryApi.getBiddingDemandInfo(biddingDemandVo.getDemandCode())).getResult()))) {
            biddingDemandVo.setId(demandDto.getId());
        }
        biddingDemandVo.setDateRequiredDelivery(DateUtils.strToDate((String)biddingDemandVo.getDateRequiredDeliveryTime(), (String)"yyyy-MM-dd"));
        this.biddingMainApi.saveOrUpdateBiddingDemand((JcbdBiddingDemandDto)BeanMapper.map((Object)biddingDemandVo, JcbdBiddingDemandDto.class));
    }

    public JcbdBiddingVo getBiddingByBiddingCode(String biddingCode) {
        BaseResponse bidresulBaseResponse;
        BaseResponse biddingResponse = this.biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
        JcbdBiddingDto jcbdBiddingDto = (JcbdBiddingDto)biddingResponse.getResult();
        JcbdBiddingVo biddingVo = (JcbdBiddingVo)BeanMapper.map((Object)jcbdBiddingDto, JcbdBiddingVo.class);
        BaseResponse bidbaseBaseResponse = this.mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(biddingCode, MallAttachmentBusinessCode.BIDBASE_ATTACH_BUSCODE.getValue());
        if (bidbaseBaseResponse.isSuccess() && !Lang.isEmpty((Object)bidbaseBaseResponse.getResult())) {
            biddingVo.setMallAttachmentVos(BeanMapper.mapList((Iterable)((Iterable)bidbaseBaseResponse.getResult()), MallAttachmentDto.class, MallAttachmentVo.class));
        }
        if ((bidresulBaseResponse = this.mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(biddingCode, MallAttachmentBusinessCode.BIDRESUL_ATTACH_BUSCODE.getValue())).isSuccess() && !Lang.isEmpty((Object)bidresulBaseResponse.getResult())) {
            biddingVo.setBidresulMallAttachmentVos(BeanMapper.mapList((Iterable)((Iterable)bidresulBaseResponse.getResult()), MallAttachmentDto.class, MallAttachmentVo.class));
        }
        return biddingVo;
    }

    public List<JcbdRoleOperationVo> getRoleBiddingOperates(BiddingOperatorQuery biddingOperatorQuery) {
        List operates = this.biddingRoleOperationQueryApi.getOperatorBiddingOperateByBiddingCode(biddingOperatorQuery);
        if (Lang.isEmpty((Object)operates)) {
            return null;
        }
        return this.mapperFacade.mapAsList((Iterable)operates, JcbdRoleOperationVo.class);
    }

    public void changeBiddingState(BiddingChangeStateVo changeStateVo) {
        BiddingChangeStateDto changeStateDto = (BiddingChangeStateDto)this.mapperFacade.map((Object)changeStateVo, BiddingChangeStateDto.class);
        BiddingStateResponseDto biddingState = this.biddingMainApi.changeBiddingState(changeStateDto);
        if (!StringUtils.equals((CharSequence)BiddingStatus.OM_AUDIT_WAIT.getValue(), (CharSequence)biddingState.getBiddingState())) {
            throw new RuntimeException("\u4fee\u6539\u5931\u8d25");
        }
    }

    public Map querryPageBiddingDemad(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "demandCode")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        SupplierBiddingDamandQuery supplierBiddingDamandQuery = new SupplierBiddingDamandQuery();
        supplierBiddingDamandQuery.setBiddingCode(biddingCode);
        supplierBiddingDamandQuery.setPageable((Pageable)pageable);
        BaseResponse pageBaseResponse = this.biddingResponseQueryApi.supplierBiddingResponseDemandOutline(supplierBiddingDamandQuery);
        ArrayList supplierResposeListVos = new ArrayList();
        Long totalElement = 0L;
        if (pageBaseResponse.isSuccess() && !Lang.isEmpty((Object)pageBaseResponse.getResult())) {
            ((Page)pageBaseResponse.getResult()).getContent().forEach(biddingDemandOutlineDto -> {
                BiddingSupplierResposeListVo resposeListVo = (BiddingSupplierResposeListVo)this.mapperFacade.map(biddingDemandOutlineDto, BiddingSupplierResposeListVo.class);
                resposeListVo.setRequiredDeliveryDateTime(DateUtils.dateToStr((Date)biddingDemandOutlineDto.getRequiredDeliveryDate(), (String)"yyyy-MM-dd"));
                supplierResposeListVos.add(resposeListVo);
            });
            totalElement = ((Page)pageBaseResponse.getResult()).getContent().size();
        }
        returnModel.put("aaData", supplierResposeListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public Map queryDemandResponse(String biddingCode, String demandCode, String supplierId) {
        BiddingDemandRespQuery biddingDemandRespQuery = new BiddingDemandRespQuery();
        biddingDemandRespQuery.setDemandCode(demandCode);
        biddingDemandRespQuery.setSupplierId(supplierId);
        biddingDemandRespQuery.setBiddingNo(biddingCode);
        BaseResponse demandResponseDtoResponse = this.biddingResponseQueryApi.queryBiddingDemandResponse(biddingDemandRespQuery);
        if (!demandResponseDtoResponse.isSuccess()) {
            return ResponseMapUtils.error((String)demandResponseDtoResponse.getResultMessage());
        }
        JcbdBiddingDemandResponseDto demandResponseDto = (JcbdBiddingDemandResponseDto)demandResponseDtoResponse.getResult();
        if (!Lang.isEmpty((Object)demandResponseDto)) {
            BaseResponse bidbaseBaseResponse;
            BiddingDemandResponseVo demandResponseVo = (BiddingDemandResponseVo)this.mapperFacade.map((Object)demandResponseDto, BiddingDemandResponseVo.class);
            if (!Lang.isEmpty((Object)demandResponseDto.getOfferValidity())) {
                demandResponseVo.setOfferValidityTime(DateUtils.dateToStr((Date)demandResponseDto.getOfferValidity(), (String)"yyyy-MM-dd"));
            }
            BiddingDemandVo demandVo = new BiddingDemandVo();
            this.mapperFacade.map((Object)demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdBiddingDemand())) {
                demandVo = (BiddingDemandVo)this.mapperFacade.map((Object)demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
                if (!Lang.isEmpty((Object)demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery())) {
                    demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr((Date)demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery(), (String)"yyyy-MM-dd"));
                }
            }
            demandResponseVo.setBiddingDemand(demandVo);
            if (!Lang.isEmpty((Object)demandResponseDto.getId()) && (bidbaseBaseResponse = this.mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(demandResponseDto.getId(), MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue())).isSuccess() && !Lang.isEmpty((Object)bidbaseBaseResponse.getResult())) {
                demandResponseVo.setAttachment(BeanMapper.mapList((Iterable)((Iterable)bidbaseBaseResponse.getResult()), MallAttachmentDto.class, MallAttachmentVo.class));
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdProviderAddressResponses())) {
                demandResponseVo.setProviderAddressResponses(this.mapperFacade.mapAsList((Iterable)demandResponseDto.getJcbdProviderAddressResponses(), JcbdProviderAddressResponseVo.class));
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdProviderConformanceResps())) {
                demandResponseVo.setProviderConformanceResps(this.mapperFacade.mapAsList((Iterable)demandResponseDto.getJcbdProviderConformanceResps(), JcbdProviderConformanceRespVo.class));
            }
            return ResponseMapUtils.success((Object)demandResponseVo);
        }
        return ResponseMapUtils.error((String)"\u672a\u67e5\u5230\u8be5\u9700\u6c42\u54cd\u5e94\u4fe1\u606f");
    }

    public Map submitResultAudit(SubmitResultVo submitResultVo, String memberId) {
        BaseResponse biddingResultResult = this.biddingMainApi.updateBiddingResultResult(submitResultVo.getBiddingCode(), submitResultVo.getRemark());
        if (!biddingResultResult.isSuccess()) {
            return ResponseMapUtils.error((String)biddingResultResult.getResultMessage());
        }
        JcbdBiddingDto biddingDto = this.biddingQueryApi.findByBiddingCodeAndIsDelete(submitResultVo.getBiddingCode());
        if (!Lang.isEmpty((Object)submitResultVo.getMallAttachmentVos())) {
            List mallAttachmentDtos = this.mapperFacade.mapAsList((Iterable)submitResultVo.getMallAttachmentVos(), MallAttachmentDto.class);
            mallAttachmentDtos.forEach(mallAttachmentDto -> {
                mallAttachmentDto.setAttachmentCorrelation(biddingDto.getId());
                mallAttachmentDto.setOrganizationCode(ORGANIZATIONCODE);
                mallAttachmentDto.setBusinessCode(MallAttachmentBusinessCode.BIDRESUL_ATTACH_BUSCODE.getValue());
                mallAttachmentDto.setBusinessDescription(BiddingOperateCode.SUBMIT_BIDDING_RESULT.getCodeName());
            });
            this.mallAttachmentApi.batchSave(mallAttachmentDtos);
        } else {
            this.mallAttachmentApi.deleteMallAttachments(biddingDto.getId(), MallAttachmentBusinessCode.BIDRESUL_ATTACH_BUSCODE.getValue());
        }
        String biddingCode = submitResultVo.getBiddingCode();
        UserInformationVo operateInformation = this.getOperateInformation(memberId);
        String remark = submitResultVo.getRemark();
        String tiaoxian = submitResultVo.getTiaoxian();
        String organizationName = operateInformation.getWholeJobName();
        BigDecimal totalMoney = null;
        try {
            totalMoney = this.getResponseBiddingTotalMonay(biddingCode);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7ade\u4ef7\u54cd\u5e94\u603b\u91d1\u989d\u51fa\u9519,biddingCode={}", (Object)biddingCode);
            return ResponseMapUtils.error((String)e.getMessage());
        }
        HashMap<String, Object> bussinessDataMap = new HashMap<String, Object>();
        bussinessDataMap.put("organizationName", organizationName);
        bussinessDataMap.put("biddingStartTime", biddingDto.getTimeStartResponse());
        bussinessDataMap.put("biddingEndTime", biddingDto.getTimeEndResponse());
        WorkFlowRequestDto flowRequestDto = new WorkFlowRequestDto();
        flowRequestDto.setWorkflowId(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{submitResultVo.getProcessId()}) ? submitResultVo.getProcessId() : null);
        flowRequestDto.setMemberId(memberId);
        ArrayList<String> list = new ArrayList<String>();
        list.add(biddingCode);
        flowRequestDto.setUserId(operateInformation.getUser().getId());
        flowRequestDto.setOrderIds(list);
        flowRequestDto.setReason(remark);
        flowRequestDto.setRealName(operateInformation.getMember().getRealName());
        flowRequestDto.setBussinessCode(AuditBusinessCode.BIDDING_RESULT_AUDIT.getBusinessCode());
        flowRequestDto.setFlowIdentificationCode(WorkFlowCode.BIDDING_RESULT_WORKFLOW_CODE.getCode());
        flowRequestDto.setTiaoxian(tiaoxian);
        flowRequestDto.setTotalMoney(totalMoney);
        flowRequestDto.setCorePositionCode("JC_CGJBR");
        flowRequestDto.setImplementClassBeanName(AuditFlowImplInstance.BIDDING_RESULT_AUDIT.getInstance());
        flowRequestDto.setBussinessDataMap(bussinessDataMap);
        this.workFlowServiceApi.startWorkFlow(flowRequestDto);
        BiddingChangeStateDto stateDto = new BiddingChangeStateDto();
        stateDto.setBiddingNo(submitResultVo.getBiddingCode());
        stateDto.setCurrentState(BiddingStatus.OM_RESULT_SUBMIT_WAIT.getValue());
        stateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_RESULT.getCode());
        BiddingStateResponseDto stateResponseDto = this.biddingMainApi.changeBiddingState(stateDto);
        if (!BiddingStatus.OM_RESULT_AUDIT_WAIT.getValue().equals(stateResponseDto.getBiddingState())) {
            return ResponseMapUtils.error((String)"\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
        }
        return ResponseMapUtils.success((Object)"");
    }

    private BigDecimal getResponseBiddingTotalMonay(String biddingCode) {
        BaseResponse biddingPriceParityDtoBaseResponse = this.biddingResponseQueryApi.queryBiddingPriceParity(biddingCode);
        if (!biddingPriceParityDtoBaseResponse.isSuccess()) {
            new RuntimeException(biddingPriceParityDtoBaseResponse.getResultMessage());
        }
        List collect = ((BiddingPriceParityDto)biddingPriceParityDtoBaseResponse.getResult()).getPriceParityInfosDtos().stream().sorted(Comparator.comparing(PriceParityInfoDto::getSummation).reversed()).collect(Collectors.toList());
        BigDecimal totalMoney = ((PriceParityInfoDto)collect.get(0)).getSummation();
        return totalMoney;
    }

    public Map getBiddingResultDemandList(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "demandCode"), new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        BiddingDemandListQuery biddingDemandListQuery = new BiddingDemandListQuery();
        biddingDemandListQuery.setBiddingCode(biddingCode);
        biddingDemandListQuery.setPageable((Pageable)pageable);
        BaseResponse pageBaseResponse = this.biddingResponseQueryApi.getBiddingResultDemandList(biddingDemandListQuery);
        Page page = (Page)pageBaseResponse.getResult();
        ArrayList<BiddingResultDemandQueryVo> resultDemandQueryVos = new ArrayList<BiddingResultDemandQueryVo>();
        if (page != null && !Lang.isEmpty((Object)page.getContent())) {
            for (BiddingResultDemandQueryDto resultDemandQueryDto : page) {
                BiddingResultDemandQueryVo resultDemandQueryVo = (BiddingResultDemandQueryVo)BeanMapper.map((Object)resultDemandQueryDto, BiddingResultDemandQueryVo.class);
                resultDemandQueryVos.add(resultDemandQueryVo);
            }
        }
        Long totalElement = resultDemandQueryVos.size();
        returnModel.put("aaData", resultDemandQueryVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public Map queryBiddingDemandResponse(String biddingNo, String demandCode) {
        BiddingDemandRespQuery biddingDemandRespQuery = new BiddingDemandRespQuery();
        BaseResponse supplierInfo = this.biddingResponseQueryApi.getBiddingResultSupplierInfo(demandCode);
        if (supplierInfo.isSuccess()) {
            biddingDemandRespQuery.setSupplierId(((BiddingResultSupplierInfoQueryDto)supplierInfo.getResult()).getSupplierId());
            biddingDemandRespQuery.setBiddingNo(biddingNo);
            biddingDemandRespQuery.setDemandCode(demandCode);
            BaseResponse demandResponse = this.biddingResponseQueryApi.queryBiddingDemandResponse(biddingDemandRespQuery);
            if (demandResponse.isSuccess()) {
                JcbdBiddingDemandResponseDto responseDto = (JcbdBiddingDemandResponseDto)demandResponse.getResult();
                JcbdBiddingDemandResponseVo demandResponseVo = (JcbdBiddingDemandResponseVo)BeanMapper.map((Object)responseDto, JcbdBiddingDemandResponseVo.class);
                if (responseDto.getOfferValidity() != null) {
                    demandResponseVo.setOfferValidityTime(DateUtils.dateToStr((Date)responseDto.getOfferValidity(), (String)"yyyy-MM-dd"));
                }
                return ResponseMapUtils.success((Object)demandResponseVo);
            }
            return ResponseMapUtils.error((String)demandResponse.getResultMessage());
        }
        return ResponseMapUtils.error((String)supplierInfo.getResultMessage());
    }

    public Map getBiddingDemandList(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "demandCode")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        BiddingDemandListQuery biddingDemandListQuery = new BiddingDemandListQuery();
        biddingDemandListQuery.setBiddingCode(biddingCode);
        biddingDemandListQuery.setPageable((Pageable)pageable);
        BaseResponse biddingDemandList = this.biddingMainQueryApi.getBiddingDemandList(biddingDemandListQuery);
        ArrayList<BiddingDemandQueryVo> biddingDemandVos = new ArrayList<BiddingDemandQueryVo>();
        Page page = (Page)biddingDemandList.getResult();
        if (!Lang.isEmpty((Object)page.getContent())) {
            for (BiddingDemandQueryDto biddingDemandQueryDto : page.getContent()) {
                BiddingDemandQueryVo demandVo = (BiddingDemandQueryVo)BeanMapper.map((Object)biddingDemandQueryDto, BiddingDemandQueryVo.class);
                String dateRequiredDelivery = DateUtils.dateToStr((Date)biddingDemandQueryDto.getDateRequiredDelivery(), (String)"yyyy-MM-dd");
                if (!Lang.isEmpty((Object)dateRequiredDelivery)) {
                    demandVo.setDateRequiredDeliveryTime(dateRequiredDelivery);
                }
                biddingDemandVos.add(demandVo);
            }
        }
        Long totalElement = biddingDemandVos.size();
        returnModel.put("aaData", biddingDemandVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public BiddingDemandVo getBiddingDemandInfo(String demandCode) {
        BaseResponse biddingDemandDto = this.biddingMainQueryApi.getBiddingDemandInfo(demandCode);
        JcbdBiddingDemandDto demandDto = (JcbdBiddingDemandDto)biddingDemandDto.getResult();
        BiddingDemandVo demandVo = (BiddingDemandVo)this.mapperFacade.map((Object)demandDto, BiddingDemandVo.class);
        demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr((Date)demandVo.getDateRequiredDelivery(), (String)"yyyy-MM-dd"));
        return demandVo;
    }

    public BaseResponse deleteBidDemand(String demandCode) {
        BaseResponse baseResponse = this.biddingMainApi.deleteBiddingDemand(demandCode);
        return baseResponse;
    }

    public BaseResponse openPrice(String biddingNo) {
        BaseResponse baseResponse = this.biddingMainApi.openPrice(biddingNo);
        return baseResponse;
    }

    public Map queryResponseOutline(String biddingCode, String demandCode) {
        BaseResponse demandOutlineDtos = this.biddingResponseQueryApi.queryBiddingResponseOutline(biddingCode, demandCode);
        if (!demandOutlineDtos.isSuccess()) {
            return ResponseMapUtils.error((String)demandOutlineDtos.getResultMessage());
        }
        if (!Lang.isEmpty((Object)demandOutlineDtos.getResult())) {
            List outlineVos = this.mapperFacade.mapAsList((Iterable)demandOutlineDtos.getResult(), BiddingResponseOutlineVo.class);
            return ResponseMapUtils.success((Object)outlineVos);
        }
        return ResponseMapUtils.error((String)"\u672a\u67e5\u5230\u4f9b\u5e94\u5546\u4fe1\u606f");
    }

    public BaseResponse randomConfirmSupplier(String biddingCode) {
        BaseResponse baseResponse = this.biddingVoteApi.randomConfirmSupplier(biddingCode);
        if (Lang.isEmpty((Object)baseResponse)) {
            return new BaseResponse(false, "\u64cd\u4f5c\u5931\u8d25");
        }
        return baseResponse;
    }

    public MemberAddressVo defaultAddress(String memberId) {
        MemberAddressDto memberAddressDto = this.memberAddressApi.defaultAddress(memberId);
        return (MemberAddressVo)BeanMapper.map((Object)memberAddressDto, MemberAddressVo.class);
    }

    public List<MemberAddressVo> defaultAddressList(String memberId) {
        List list = this.memberAddressApi.list(memberId);
        return BeanMapper.mapList((Iterable)list, MemberAddressDto.class, MemberAddressVo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map auditSku(BiddingAuditVo biddingAuditVo, String biddingMemberId) {
        JcbdBiddingDto jcbdBiddingDto = this.biddingMainQueryApi.queryBidding(biddingAuditVo.getBiddingNo());
        BiddingAuditDTO biddingAuditDTO = (BiddingAuditDTO)this.mapperFacade.map((Object)biddingAuditVo, BiddingAuditDTO.class);
        biddingAuditDTO.setAuditorId(biddingMemberId);
        BaseResponse baseResponse = this.biddingMainApi.auditBiddingSku(biddingAuditDTO);
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error((String)"\u5ba1\u6838\u5931\u8d25");
        }
        try {
            block7: {
                if (!biddingAuditVo.getStatus().equals("0")) break block7;
                MailTemplateReq mailTemplateReq = new MailTemplateReq();
                MailReq mailReq = new MailReq();
                JcbdBdProviderDto provider = this.biddingMainQueryApi.getTransactionSupplier(biddingAuditVo.getBiddingNo());
                StoreDto storeDto = this.storeApi.findByStoreId(provider.getProviderId());
                StoreExtDto storeExt = storeDto.getStoreExt();
                Response response = this.protocolService.getGysxx(storeExt.getdVendorId());
                VendorDto vendorDto = (VendorDto)response.getData();
                if (Lang.isEmpty((Object)vendorDto)) break;
                if (!Lang.isEmpty((Object)vendorDto.getGysmc())) {
                    List lxrlist = vendorDto.getLxrlist();
                    lxrlist.forEach(contactPersonDto -> {
                        mailReq.setTo(new String[]{contactPersonDto.getEmail()});
                        mailReq.setFrom(this.mailFrom);
                        mailReq.setSentDate(new Date());
                        mailReq.setChannel("jc");
                        mailTemplateReq.setTemplateCode(MailTemplateEnum.SKU_NOT_APPROVED.getTemplateCode());
                        ArrayList<String> subjectArgs = new ArrayList<String>();
                        subjectArgs.add(biddingAuditVo.getBiddingNo());
                        ArrayList<String> contextArgs = new ArrayList<String>();
                        contextArgs.add(contactPersonDto.getName());
                        contextArgs.add(biddingAuditVo.getBiddingNo());
                        contextArgs.add(biddingAuditVo.getContent());
                        contextArgs.add(jcbdBiddingDto.getOperatorName());
                        contextArgs.add(jcbdBiddingDto.getOperatorPhone());
                        mailTemplateReq.setSubjectArgList(subjectArgs);
                        mailTemplateReq.setContentArgList(contextArgs);
                        mailTemplateReq.setMailReq(mailReq);
                        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                        this.mailApi.sendMailByTemplate(mailTemplateReq);
                    });
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7{}\u7684sku\u5ba1\u6838\u4e0d\u901a\u8fc7\u64cd\u4f5c\u90ae\u4ef6\u901a\u77e5\u4f9b\u5e94\u5546\u5931\u8d25", (Object)biddingAuditVo.getBiddingNo(), (Object)e);
        }
        finally {
            return ResponseMapUtils.success((Object)"");
        }
    }

    public BaseResponse saveOrderGoodsInfo(BiddingQueryOperativeBuySaveVo biddingQueryOperativeBuySaveVo) {
        JcbdTempOrderDto jcbdTempOrderDto = (JcbdTempOrderDto)BeanMapper.map((Object)biddingQueryOperativeBuySaveVo, JcbdTempOrderDto.class);
        log.info("\u6267\u884c\u91c7\u8d2d\u4e34\u65f6\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)jcbdTempOrderDto));
        BaseResponse baseResponse = this.biddingMainApi.saveBiddingTempOrderInfo(jcbdTempOrderDto);
        return baseResponse;
    }

    public BaseResponse queryTempOrderInfo(String biddingNo) {
        ArrayList<TempBatchVo> tempBatchVoList = new ArrayList<TempBatchVo>();
        List tempBatchList = this.biddingMainQueryApi.getTempBatchList(biddingNo);
        for (TempBatchDto tempBatchDto : tempBatchList) {
            TempBatchVo tempBatchVo = (TempBatchVo)BeanMapper.map((Object)tempBatchDto, TempBatchVo.class);
            List tempBatchLists = tempBatchVo.getTempBatchLists();
            ArrayList<TempBatchListVo> tempBatchListVoList = new ArrayList<TempBatchListVo>();
            for (TempBatchListVo tempBatchListVo : tempBatchLists) {
                if (!Lang.isEmpty((Object)tempBatchListVo.getAddressId())) {
                    MemberAddressDto memberAddressDto = this.memberAddressApi.findById(tempBatchListVo.getAddressId());
                    tempBatchListVo.setAddressName(memberAddressDto.getProvinceName() + memberAddressDto.getCityName() + memberAddressDto.getAreaName() + memberAddressDto.getAddressDetail());
                    tempBatchListVo.setName(memberAddressDto.getUsername());
                    tempBatchListVo.setTel(memberAddressDto.getPhone());
                } else {
                    tempBatchListVo.setAddressName("");
                    tempBatchListVo.setName("");
                    tempBatchListVo.setTel("");
                }
                tempBatchListVoList.add(tempBatchListVo);
                tempBatchVo.setTempBatchLists(tempBatchListVoList);
            }
            tempBatchVoList.add(tempBatchVo);
        }
        return new BaseResponse(true, "\u4e34\u65f6\u8ba2\u5355\u83b7\u53d6\u6210\u529f", tempBatchVoList);
    }

    public BaseResponse updateTempOrderInfo(String temOrderId) {
        JcbdTempOrderDto jcbdTempOrderDto = this.biddingMainApi.modifyTempOrderById(temOrderId);
        MemberAddressDto memberAddress = this.memberAddressApi.findById(jcbdTempOrderDto.getMemberAddressId());
        JcbdTempOrderVo jcbdTempOrderVo = (JcbdTempOrderVo)BeanMapper.map((Object)jcbdTempOrderDto, JcbdTempOrderVo.class);
        if (!Lang.isEmpty((Object)jcbdTempOrderDto.getCompanyId())) {
            CoreCompanyDto coreCompany = this.coreCompanyApi.findById(jcbdTempOrderDto.getCompanyId());
            jcbdTempOrderVo.setCompanyAddressAndPhone(coreCompany.getAddress() + " " + coreCompany.getPhone());
            jcbdTempOrderVo.setBankAndAccount(coreCompany.getBankDeposit() + " " + coreCompany.getBankAccount());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(memberAddress.getProvinceName());
        stringBuilder.append(memberAddress.getCityName());
        stringBuilder.append(memberAddress.getAreaName());
        stringBuilder.append(memberAddress.getTownName());
        stringBuilder.append(memberAddress.getAddressDetail());
        jcbdTempOrderVo.setMemberAddressName(stringBuilder.toString());
        jcbdTempOrderVo.setMemberProviceCode(memberAddress.getProvinceCode());
        jcbdTempOrderVo.setMemberCityCode(memberAddress.getCityCode());
        jcbdTempOrderVo.setMemberAreaCode(memberAddress.getAreaCode());
        jcbdTempOrderVo.setMemberTownCode(memberAddress.getTownCode());
        jcbdTempOrderVo.setMemberProviceName(memberAddress.getProvinceName());
        jcbdTempOrderVo.setMemberCityName(memberAddress.getCityName());
        jcbdTempOrderVo.setMemberAreaName(memberAddress.getAreaName());
        jcbdTempOrderVo.setMemberTownName(memberAddress.getTownName());
        jcbdTempOrderVo.setMemberName(memberAddress.getUsername());
        jcbdTempOrderVo.setTel(memberAddress.getTel());
        if ("0".equals(jcbdTempOrderVo.getConsigneeFlag())) {
            String consigneeProvinceName = this.addressApi.findShortNameById(jcbdTempOrderVo.getConsigneeProvinceCode());
            String consigneeCityName = this.addressApi.findShortNameById(jcbdTempOrderVo.getConsigneeCityCode());
            jcbdTempOrderVo.setConsigneeProvinceName(consigneeProvinceName);
            jcbdTempOrderVo.setConsigneeCityName(consigneeCityName);
            StringBuffer invoiceAddress = new StringBuffer();
            invoiceAddress.append(consigneeProvinceName);
            invoiceAddress.append(consigneeCityName);
            invoiceAddress.append(jcbdTempOrderVo.getAddressDetail());
            jcbdTempOrderVo.setInvoiceAddress(invoiceAddress.toString());
        }
        return new BaseResponse(true, "\u4e34\u65f6\u8ba2\u5355\u6570\u636e\u83b7\u53d6\u6210\u529f", (Object)jcbdTempOrderVo);
    }

    public BaseResponse deleteTempOrderInfo(List<String> temOrderId) {
        BaseResponse baseResponse = this.biddingMainApi.deleteTempOrderById(temOrderId);
        return baseResponse;
    }

    public Map findbiddingLog(JqueryDataTablesVo jqueryDataTablesVo, String biddingNo) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        ArrayList<JcbdBiddingOperationLogVo> biddingOperationLogVos = new ArrayList<JcbdBiddingOperationLogVo>();
        Page logDtoPage = this.biddingLogQueryApi.findAllByBiddingNo(biddingNo, (Pageable)pageable);
        if (!Lang.isEmpty((Object)logDtoPage.getContent())) {
            for (JcbdBiddingOperationLogDto logDto : logDtoPage.getContent()) {
                JcbdBiddingOperationLogVo biddingOperationLogVo = (JcbdBiddingOperationLogVo)BeanMapper.map((Object)logDto, JcbdBiddingOperationLogVo.class);
                biddingOperationLogVo.setOperationTimeNew(DateUtils.dateToStr((Date)biddingOperationLogVo.getOperationTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                biddingOperationLogVos.add(biddingOperationLogVo);
            }
        }
        returnModel.put("aaData", biddingOperationLogVos);
        returnModel.put("iTotalRecords", Long.valueOf(logDtoPage.getTotalElements()));
        returnModel.put("iTotalDisplayRecords", Long.valueOf(logDtoPage.getTotalElements()));
        return returnModel;
    }

    public List<BiddingDemandVo> findByJcbdBiddingCodeAndIsDelete(String biddingCode) {
        List demandDtos = this.biddingDemandApi.findByJcbdBiddingCodeAndIsDelete(biddingCode);
        return BeanMapper.mapList((Iterable)demandDtos, JcbdBiddingDemandDto.class, BiddingDemandVo.class);
    }

    public JcbdBiddingVo findByBiddingCodeAndIsDelete(String biddingCode) {
        JcbdBiddingDto jcbdBiddingDto = this.biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);
        return (JcbdBiddingVo)BeanMapper.map((Object)jcbdBiddingDto, JcbdBiddingVo.class);
    }

    public BaseResponse queryPermitGoodsInfo(String biddingNo) {
        ArrayList procureInformationVos = new ArrayList();
        List biddingDemandSku = this.biddingMainQueryApi.getBiddingDemandSku(biddingNo);
        if (!Lang.isEmpty((Object)biddingDemandSku)) {
            biddingDemandSku.parallelStream().forEach(biddingDemandGood -> {
                List goods = this.goodsConfigApi.findBySkuAndOrganizationCode(biddingDemandGood.getSku(), ORGANIZATIONCODE);
                if (!Lang.isEmpty((Object)goods)) {
                    String goodsId = ((GoodsConfigDto)goods.get(0)).getGoodsId();
                    String goodsName = ((GoodsConfigDto)goods.get(0)).getTitle();
                    biddingDemandGood.setGoodsName(goodsName);
                    biddingDemandGood.setGoodsId(goodsId);
                }
                ProcureInformationVo procureInformationVo = (ProcureInformationVo)BeanMapper.map((Object)biddingDemandGood, ProcureInformationVo.class);
                List productFashionIds = this.productFashionApi.findProductFashionIdBySku(biddingDemandGood.getSku());
                if (!Lang.isEmpty((Object)productFashionIds)) {
                    procureInformationVo.setProductFashionId((String)productFashionIds.get(0));
                }
                procureInformationVos.add(procureInformationVo);
            });
        }
        return new BaseResponse(true, "\u53ef\u91c7\u8d2d\u5546\u54c1\u67e5\u8be2\u6210\u529f", procureInformationVos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map finishBidding(String biddingNo, String remark, String biddingMemberId) {
        BaseResponse baseResponse = this.biddingMainApi.finishBidding(biddingNo);
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error((String)"\u64cd\u4f5c\u5931\u8d25");
        }
        String companyName = this.getOperateInformation(biddingMemberId).getWholeJobName();
        JcbdBiddingVo jcbdBiddingVo = this.getBiddingByBiddingCode(biddingNo);
        JcbdBiddingVo operator = this.getOperator(jcbdBiddingVo.getOperatorId());
        try {
            ArrayList storeContacts = new ArrayList();
            List providerVoList = this.findStoreContacts(StoreDto.STORE_TYPE_SUPLIER);
            if (!Lang.isEmpty((Object)providerVoList)) {
                providerVoList.forEach(jcbdBdProviderVo -> {
                    JcbdBdProviderDto provider = this.biddingMainQueryApi.getProvider(biddingNo, jcbdBdProviderVo.getProviderId());
                    if (!Lang.isEmpty((Object)provider) && !Lang.isEmpty((Object)provider.getPublish()) && provider.getPublish().booleanValue() && !Lang.isEmpty((Object)jcbdBdProviderVo.getJcbdStoreContactsVos())) {
                        jcbdBdProviderVo.getJcbdStoreContactsVos().forEach(jcbdStoreContactsVo -> storeContacts.add(jcbdStoreContactsVo));
                    }
                });
            }
            if (Lang.isEmpty(storeContacts)) {
                log.info("\u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u5931\u8d25", (Object)biddingNo);
            } else {
                MailReq mailReq = new MailReq();
                MailTemplateReq mailTemplateReq = new MailTemplateReq();
                storeContacts.forEach(supplierContant -> {
                    mailReq.setTo(new String[]{supplierContant.getEmail()});
                    mailReq.setFrom(this.mailFrom);
                    mailReq.setSentDate(new Date());
                    mailReq.setChannel("jc");
                    mailTemplateReq.setMailReq(mailReq);
                    mailTemplateReq.setTemplateCode(MailTemplateEnum.BID_TERMINATED.getTemplateCode());
                    ArrayList<String> subjectArgs = new ArrayList<String>();
                    subjectArgs.add(biddingNo);
                    ArrayList<String> contextArgs = new ArrayList<String>();
                    contextArgs.add(supplierContant.getName());
                    contextArgs.add(companyName);
                    contextArgs.add(operator.getUsername());
                    contextArgs.add(biddingNo);
                    contextArgs.add(remark);
                    mailTemplateReq.setSubjectArgList(subjectArgs);
                    mailTemplateReq.setContentArgList(contextArgs);
                    mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                    log.info("\u7ade\u4ef7\u7ec8\u6b62\u901a\u77e5\u4f9b\u5e94\u5546\u90ae\u4ef6\u6a21\u677f\u5c01\u88c5\u6570\u636e{}", (Object)JSON.toJSONString((Object)mailTemplateReq));
                    this.mailApi.sendMailByTemplate(mailTemplateReq);
                });
            }
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7{}\u7684\u7ade\u4ef7\u7ec8\u6b62\u64cd\u4f5c\u90ae\u4ef6\u901a\u77e5\u4f9b\u5e94\u5546\u5931\u8d25", (Object)biddingNo, (Object)e);
        }
        try {
            BaseResponse biddingGroupMemberResponse = this.biddingConformityReviewQueryApi.findBiddingGroupMember(biddingNo);
            if (!biddingGroupMemberResponse.isSuccess()) {
                log.info("\u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)biddingNo, (Object)biddingGroupMemberResponse.getResultMessage());
            }
            MailReq mailReq = new MailReq();
            MailTemplateReq mailTemplateReq = new MailTemplateReq();
            List groupMembers = (List)biddingGroupMemberResponse.getResult();
            groupMembers.forEach(groupMember -> {
                mailReq.setTo(new String[]{groupMember.getEmail()});
                mailReq.setFrom(this.mailFrom);
                mailReq.setSentDate(new Date());
                mailReq.setChannel("jc");
                mailTemplateReq.setMailReq(mailReq);
                mailTemplateReq.setTemplateCode(MailTemplateEnum.BID_TERMINATED.getTemplateCode());
                ArrayList<String> subjectArgs = new ArrayList<String>();
                subjectArgs.add(biddingNo);
                ArrayList<String> contextArgs = new ArrayList<String>();
                if (!Lang.isEmpty((Object)groupMember.getName())) {
                    contextArgs.add(groupMember.getName());
                } else {
                    contextArgs.add(groupMember.getEmail());
                }
                contextArgs.add(companyName);
                contextArgs.add(operator.getUsername());
                contextArgs.add(biddingNo);
                contextArgs.add(remark);
                mailTemplateReq.setSubjectArgList(subjectArgs);
                mailTemplateReq.setContentArgList(contextArgs);
                mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                log.info("\u7ade\u4ef7\u7ec8\u6b62\u901a\u77e5\u7ade\u4ef7\u5c0f\u7ec4\u90ae\u4ef6\u6a21\u677f\u5c01\u88c5\u6570\u636e{}", (Object)JSON.toJSONString((Object)mailTemplateReq));
                this.mailApi.sendMailByTemplate(mailTemplateReq);
            });
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7{}\u7684\u7ade\u4ef7\u7ec8\u6b62\u64cd\u4f5c\u90ae\u4ef6\u901a\u77e5\u7ade\u4ef7\u5c0f\u7ec4\u5931\u8d25", (Object)biddingNo, (Object)e);
        }
        finally {
            return ResponseMapUtils.success((Object)"");
        }
    }

    public Boolean goodIsNull(String biddingNo, String sku) {
        List biddingDemandSku = this.biddingMainQueryApi.getBiddingDemandSku(biddingNo);
        for (ProcureInformationDto biddingDemand : biddingDemandSku) {
            if (!biddingDemand.getSku().equals(sku)) continue;
            return true;
        }
        return false;
    }

    public Map audirQuerryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String workId, List<String> biddingMemberRoles, BiddingAuditInfoVo biddingAuditInfoVo) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        PageRequest pageable = new PageRequest(pageindex + 1, jqueryDataTablesVo.getiDisplayLength().intValue());
        WfBiddingResultDataQuery wfBiddingResultDataQuery = (WfBiddingResultDataQuery)BeanMapper.map((Object)biddingAuditInfoVo, WfBiddingResultDataQuery.class);
        ArrayList<String> workerIdList = new ArrayList<String>();
        workerIdList.add(workId);
        wfBiddingResultDataQuery.setWorkerId(workerIdList);
        WfBiddingResultDataDto wfBiddingResultDataDto = this.wfBiddingResultDataApi.getBiddingNo(wfBiddingResultDataQuery, (Pageable)pageable);
        ArrayList<String> biddingNoList = new ArrayList<String>();
        List wfBiddingResultDtos = wfBiddingResultDataDto.getWfBiddingResultDtos();
        for (WfBiddingResultDto wfBiddingResultDto : wfBiddingResultDtos) {
            biddingNoList.add(wfBiddingResultDto.getBiddingNo());
        }
        List jcbdBiddingDtos = this.biddingQueryApi.findJcbdBiddingByBiddingNo(biddingNoList);
        List jcbdBiddingVoList = this.mapperFacade.mapAsList((Iterable)jcbdBiddingDtos, JcbdBiddingVo.class);
        HashMap<String, JcbdBiddingVo> jcbdBiddingVoMap = new HashMap<String, JcbdBiddingVo>();
        for (JcbdBiddingVo jcbdBiddingVo : jcbdBiddingVoList) {
            jcbdBiddingVoMap.put(jcbdBiddingVo.getBiddingCode(), jcbdBiddingVo);
        }
        ArrayList<JcbdBiddingVo> jcbdBiddingVos = new ArrayList<JcbdBiddingVo>();
        for (WfBiddingResultDto wfBiddingResultDto : wfBiddingResultDtos) {
            JcbdBiddingVo jcbdBiddingVo = (JcbdBiddingVo)jcbdBiddingVoMap.get(wfBiddingResultDto.getBiddingNo());
            JcbdBiddingVo biddingVo = (JcbdBiddingVo)BeanMapper.map((Object)jcbdBiddingVo, JcbdBiddingVo.class);
            biddingVo.setStatus(wfBiddingResultDto.getStatus());
            BiddingAuditStatus biddingAuditStatus = (BiddingAuditStatus)BiddingAuditStatus.biddingAuditStatusMap.get(wfBiddingResultDto.getStatus());
            biddingVo.setStatusDescription(biddingAuditStatus.getDescription());
            List operationDtoList = this.biddingQueryApi.findByRoleCodeAndStatusAndModuleOrderByShowIndex("BIDDING_AUDITOR", wfBiddingResultDto.getStatus(), StatusOperateModule.BIDDING_AUDIT_MANAGE.getCode());
            biddingVo.setOperation(operationDtoList);
            jcbdBiddingVos.add(biddingVo);
        }
        returnModel.put("aaData", jcbdBiddingVos);
        returnModel.put("iTotalRecords", wfBiddingResultDataDto.getITotalRecords());
        returnModel.put("iTotalDisplayRecords", wfBiddingResultDataDto.getITotalRecords());
        return returnModel;
    }

    public List<QueryStatus> getAuditStatus() {
        ArrayList<QueryStatus> allStatusList = new ArrayList<QueryStatus>();
        Map biddingAuditStatusMap = BiddingAuditStatus.biddingAuditStatusMap;
        for (String statusCode : biddingAuditStatusMap.keySet()) {
            QueryStatus queryStatus = new QueryStatus();
            queryStatus.setStatusCode(statusCode);
            BiddingAuditStatus biddingAuditStatus = (BiddingAuditStatus)biddingAuditStatusMap.get(statusCode);
            queryStatus.setStatusDescription(biddingAuditStatus.getDescription());
            allStatusList.add(queryStatus);
        }
        return allStatusList;
    }

    public UserInformationVo getOperateInformation(String biddingMemberId) {
        UserInformationVo informationVo = new UserInformationVo();
        Map queryUser = this.queryInformationApi.queryUser(biddingMemberId);
        List companyPositions = (List)queryUser.get("companyPositions");
        StringBuilder companyName = new StringBuilder();
        companyPositions.forEach(companyPosition -> {
            String positionCode = (String)companyPosition.get("positionCode");
            if ("JC_CGJBR".equals(positionCode)) {
                List companyNameList = (List)companyPosition.get("companyNames");
                companyNameList.forEach(name -> companyName.append((String)name));
            }
        });
        informationVo.setMember((MemberDto)queryUser.get("member"));
        informationVo.setUser((CoreUserDto)queryUser.get("coreUser"));
        informationVo.setWholeJobName(companyName.toString());
        return informationVo;
    }

    public UserInformationVo getMemberCompanyInformatio(String biddingUserId) {
        UserInformationVo informationVo = new UserInformationVo();
        StringBuilder companyName = new StringBuilder();
        long start = System.currentTimeMillis();
        Map queryUser = this.queryInformationApi.queryUser(biddingUserId);
        log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        CoreUserDto coreUser = (CoreUserDto)queryUser.get("coreUser");
        long start1 = System.currentTimeMillis();
        String positionId = this.queryInformationApi.getPositionId("JC_CGJBR");
        log.info("\u67e5\u8be2\u804c\u4f4did\u4fe1\u606f\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start1));
        long start2 = System.currentTimeMillis();
        CoreCompanyDto coreCompany = this.coreCompDepartUserApi.getCompanyByUserIdAndPositon(coreUser.getId(), "JC_CGJBR");
        log.info("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4fe1\u606f\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start2));
        long start3 = System.currentTimeMillis();
        CoreCompDepartUserDto coreCompanyAndDepartment = this.coreCompDepartUserApi.getCoreCompanyAndDepartment(coreCompany.getId(), coreUser.getId(), positionId);
        log.info("\u67e5\u8be2\u673a\u6784\u90e8\u95e8\u6620\u5c04\u4fe1\u606f\u4fe1\u606f\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start3));
        if (!Lang.isEmpty((Object)coreCompany.getId())) {
            long start4 = System.currentTimeMillis();
            String company = this.coreCompanyApi.getCompanyName(coreCompany.getId());
            log.info("\u67e5\u8be2\u673a\u6784\u90e8\u95e8\u6620\u5c04\u4e2d\u673a\u6784\u4fe1\u606f\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start4));
            if (!Lang.isEmpty((Object)company)) {
                companyName.append(company);
            }
            if (!Lang.isEmpty((Object)coreCompanyAndDepartment.getDepartmentId())) {
                long start5 = System.currentTimeMillis();
                String department = this.coreDepartmentApi.findById(coreCompanyAndDepartment.getDepartmentId());
                log.info("\u67e5\u8be2\u673a\u6784\u90e8\u95e8\u6620\u5c04\u4e2d\u90e8\u95e8\u4fe1\u606f\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start5));
                if (!Lang.isEmpty((Object)department) && !Lang.isEmpty((Object)company)) {
                    companyName.append("-").append(department);
                } else {
                    companyName.append(department);
                }
            }
        }
        informationVo.setMember((MemberDto)queryUser.get("member"));
        informationVo.setUser((CoreUserDto)queryUser.get("coreUser"));
        informationVo.setWholeJobName(companyName.toString());
        return informationVo;
    }

    public CoreCompanyDto getCompanyInfo(String memberId) {
        MemberDto memberDto = this.memberApi.findMemberById(memberId);
        CoreCompanyDto coreCompanyDto = this.coreCompDepartUserApi.getBuyerCompany(memberDto.getCoreUser().getId());
        return coreCompanyDto;
    }

    public Boolean queryIdentificationCode(String identificationCode) {
        Boolean byIdentificationCode = this.invoiceInfoApi.findByIdentificationCode(identificationCode);
        return byIdentificationCode;
    }

    public Boolean queryAddressExist(String[] address) {
        for (String addressCode : address) {
            Boolean byaddressCode;
            if (Lang.isEmpty((Object)addressCode) || (byaddressCode = this.addressApi.findByaddressCode(addressCode)).booleanValue()) continue;
            return byaddressCode;
        }
        return true;
    }

    public Map mailOfGroupMembers(String biddingNo, String biddingMemberId) {
        JcbdBiddingDto jcbdBiddingDto = this.biddingMainQueryApi.queryBidding(biddingNo);
        String companyName = this.getOperateInformation(biddingMemberId).getWholeJobName();
        JcbdBiddingVo jcbdBiddingVo = this.getBiddingByBiddingCode(biddingNo);
        JcbdBiddingVo operator = this.getOperator(jcbdBiddingVo.getOperatorId());
        if (!Lang.isEmpty((Object)jcbdBiddingDto) && BiddingStatus.OM_AUDIT_WAIT.getValue().equals(jcbdBiddingDto.getStatus())) {
            BaseResponse biddingGroupMemberResponse = this.biddingConformityReviewQueryApi.findBiddingGroupMember(biddingNo);
            try {
                if (!biddingGroupMemberResponse.isSuccess()) {
                    log.info("\u7f16\u53f7\u4e3a{}\u7684\u7ade\u4ef7\u83b7\u53d6\u7ade\u4ef7\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)biddingNo, (Object)biddingGroupMemberResponse.getResultMessage());
                } else {
                    ((List)biddingGroupMemberResponse.getResult()).parallelStream().forEach(biddingGroupMember -> {
                        MailTemplateReq mailTemplateReq = new MailTemplateReq();
                        MailReq mailReq = new MailReq();
                        Object[] email = new String[]{biddingGroupMember.getEmail()};
                        mailReq.setTo((String[])email);
                        mailReq.setFrom(operator.getEmail());
                        mailReq.setSentDate(new Date());
                        mailReq.setChannel("jc");
                        mailTemplateReq.setMailReq(mailReq);
                        String templateCode = MailTemplateEnum.BID_AUDIT.getTemplateCode();
                        String redirectUrl = "/operator/auditBidding";
                        String url = this.makeLoginUrl(StringUtils.join((Object[])email), biddingNo, redirectUrl);
                        mailTemplateReq.setTemplateCode(templateCode);
                        ArrayList<String> subjectArgs = new ArrayList<String>();
                        subjectArgs.add(biddingNo);
                        ArrayList<String> contextArgs = new ArrayList<String>();
                        contextArgs.add(Lang.isEmpty((Object)biddingGroupMember.getName()) ? biddingGroupMember.getEmail() : biddingGroupMember.getName());
                        contextArgs.add(companyName);
                        contextArgs.add(operator.getUsername());
                        contextArgs.add(biddingNo);
                        contextArgs.add(url);
                        contextArgs.add(url);
                        mailTemplateReq.setSubjectArgList(subjectArgs);
                        mailTemplateReq.setContentArgList(contextArgs);
                        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                        log.info("\u7ade\u4ef7\u5ba1\u6838\u91cd\u53d1\u90ae\u4ef6\u6a21\u677f\u5c01\u88c5\u6570\u636e{}", (Object)JSON.toJSONString((Object)mailTemplateReq));
                        MailRsp mailRsp = this.mailApi.sendMailByTemplate(mailTemplateReq);
                    });
                }
            }
            catch (Exception e) {
                log.error("\u7ade\u4ef7{}\u7684\u7ade\u4ef7\u7ec8\u6b62\u64cd\u4f5c\u90ae\u4ef6\u901a\u77e5\u7ade\u4ef7\u5c0f\u7ec4\u5931\u8d25", (Object)biddingNo, (Object)e);
            }
        }
        return ResponseMapUtils.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public MemberAddressDto findMemberAddress(String[] address, String detailAddress, String memberName, String memberTel) {
        MemberAddressDto memberAddressDto = new MemberAddressDto();
        if (!Lang.isEmpty((Object)address[0])) {
            memberAddressDto.setProvinceCode(address[0]);
        }
        if (!Lang.isEmpty((Object)address[1])) {
            memberAddressDto.setCityCode(address[1]);
        }
        if (!Lang.isEmpty((Object)address[2])) {
            memberAddressDto.setAreaCode(address[2]);
        }
        if (!Lang.isEmpty((Object)address[3])) {
            memberAddressDto.setTownCode(address[3]);
        }
        memberAddressDto.setDetailaddress(detailAddress);
        memberAddressDto.setTel(memberTel);
        memberAddressDto.setUsername(memberName);
        MemberAddressDto byAddressInfo = this.memberAddressApi.findByAddressInfo(memberAddressDto);
        return byAddressInfo;
    }

    public MemberAddressDto saveExcelImportData(String[] address, String detailAddress, String memberName, String memberTel) {
        MemberAddressDto memberAddressDto = new MemberAddressDto();
        String[] addressName = new String[5];
        for (int i = 0; i < address.length; ++i) {
            String shortName;
            if (Lang.isEmpty((Object)address[i])) continue;
            addressName[i] = shortName = this.addressApi.findShortNameById(address[i]);
        }
        memberAddressDto.setProvinceCode(address[0]);
        memberAddressDto.setProvinceName(addressName[0]);
        memberAddressDto.setCityCode(address[1]);
        memberAddressDto.setCityName(addressName[1]);
        memberAddressDto.setAreaCode(address[2]);
        memberAddressDto.setAreaName(addressName[2]);
        memberAddressDto.setTownCode(address[3]);
        memberAddressDto.setTownName(addressName[3]);
        memberAddressDto.setDetailaddress(detailAddress);
        memberAddressDto.setAddressDetail(detailAddress);
        memberAddressDto.setUsername(memberName);
        memberAddressDto.setTel(memberTel);
        MemberAddressDto memberAddressResp = this.memberAddressApi.saveAddressInfo(memberAddressDto);
        return memberAddressResp;
    }

    public BaseResponse findAllTempOrder(String biddingNo) {
        List allTempOrder = this.biddingMainQueryApi.findAllTempOrderByBiddingNo(biddingNo);
        if (!Lang.isEmpty((Object)allTempOrder)) {
            List tempOrderVos = this.mapperFacade.mapAsList((Iterable)allTempOrder, JcbdTempOrderVo.class);
            for (JcbdTempOrderVo tempOrderVo : tempOrderVos) {
                if (!Lang.isEmpty((Object)tempOrderVo.getMemberAddressId())) {
                    MemberAddressDto memberAddressDto = this.memberAddressApi.findById(tempOrderVo.getMemberAddressId());
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(memberAddressDto.getProvinceName());
                    stringBuilder.append(memberAddressDto.getCityName());
                    stringBuilder.append(memberAddressDto.getAreaName());
                    stringBuilder.append(memberAddressDto.getTownName());
                    stringBuilder.append(memberAddressDto.getAddressDetail());
                    tempOrderVo.setMemberAddressName(stringBuilder.toString());
                    tempOrderVo.setMemberName(memberAddressDto.getUsername());
                    tempOrderVo.setTel(memberAddressDto.getPhone());
                    StringBuffer consigneeName = new StringBuffer();
                    if ("1".equals(tempOrderVo.getConsigneeFlag())) {
                        consigneeName.append(memberAddressDto.getProvinceName());
                        consigneeName.append(memberAddressDto.getCityName());
                        consigneeName.append(memberAddressDto.getAreaName());
                        consigneeName.append(memberAddressDto.getTownName());
                        consigneeName.append(memberAddressDto.getAddressDetail());
                        tempOrderVo.setInvoiceAddress(consigneeName.toString());
                        tempOrderVo.setConsigneeName(memberAddressDto.getUsername());
                        tempOrderVo.setConsigneePhone(memberAddressDto.getPhone());
                    } else {
                        if (!Lang.isEmpty((Object)tempOrderVo.getConsigneeProvinceCode())) {
                            String consigneeProvince = this.addressApi.findShortNameById(tempOrderVo.getConsigneeProvinceCode());
                            consigneeName.append(consigneeProvince);
                        }
                        if (!Lang.isEmpty((Object)tempOrderVo.getConsigneeCityCode())) {
                            String consigneeCity = this.addressApi.findShortNameById(tempOrderVo.getConsigneeCityCode());
                            consigneeName.append(consigneeCity);
                        }
                        consigneeName.append(tempOrderVo.getAddressDetail());
                        tempOrderVo.setInvoiceAddress(consigneeName.toString());
                    }
                } else {
                    tempOrderVo.setMemberAddressName("");
                    tempOrderVo.setMemberName("");
                    tempOrderVo.setTel("");
                    StringBuffer consigneeName = new StringBuffer();
                    if ("1".equals(tempOrderVo.getConsigneeFlag())) {
                        tempOrderVo.setInvoiceAddress("");
                        tempOrderVo.setConsigneeName("");
                        tempOrderVo.setConsigneePhone("");
                    } else {
                        if (!Lang.isEmpty((Object)tempOrderVo.getConsigneeProvinceCode())) {
                            String consigneeProvince = this.addressApi.findShortNameById(tempOrderVo.getConsigneeProvinceCode());
                            consigneeName.append(consigneeProvince);
                        }
                        if (!Lang.isEmpty((Object)tempOrderVo.getConsigneeCityCode())) {
                            String consigneeCity = this.addressApi.findShortNameById(tempOrderVo.getConsigneeCityCode());
                            consigneeName.append(consigneeCity);
                        }
                        consigneeName.append(tempOrderVo.getAddressDetail());
                        tempOrderVo.setInvoiceAddress(consigneeName.toString());
                    }
                }
                if (Lang.isEmpty((Object)tempOrderVo.getCompanyId())) continue;
                CoreCompanyDto coreCompany = this.coreCompanyApi.findById(tempOrderVo.getCompanyId());
                tempOrderVo.setCompanyAddressAndPhone(coreCompany.getAddress() + " " + coreCompany.getPhone());
                tempOrderVo.setBankAndAccount(coreCompany.getBankDeposit() + " " + coreCompany.getBankAccount());
            }
            return new BaseResponse(true, "\u6279\u91cf\u4e34\u65f6\u8ba2\u5355\u67e5\u8be2\u5b8c\u6210", (Object)tempOrderVos);
        }
        ArrayList<JcbdTempOrderVo> tempOrderVos = new ArrayList<JcbdTempOrderVo>();
        ArrayList<JcbdTempGoodsVo> jcbdTempGoodsVos = new ArrayList<JcbdTempGoodsVo>();
        JcbdTempOrderVo jcbdTempOrderVo = new JcbdTempOrderVo();
        jcbdTempOrderVo.setInvoiceAddress("");
        JcbdTempGoodsVo jcbdTempGoodsVo = new JcbdTempGoodsVo();
        jcbdTempGoodsVo.setSku("");
        jcbdTempGoodsVos.add(jcbdTempGoodsVo);
        jcbdTempOrderVo.setJcbdTempGoodses(jcbdTempGoodsVos);
        tempOrderVos.add(jcbdTempOrderVo);
        return new BaseResponse(true, "\u6279\u91cf\u4e34\u65f6\u8ba2\u5355\u67e5\u8be2\u5b8c\u6210", tempOrderVos);
    }

    public List<VoteQueryResultVo> voteDetailsQuery(String biddingNo) {
        List voteQueryResultDtos = this.biddingVoteApi.voteDetailsQuery(biddingNo);
        return this.mapperFacade.mapAsList((Iterable)voteQueryResultDtos, VoteQueryResultVo.class);
    }

    public String updateBiddingGroupCheckNo(String bidddingNo) {
        return this.biddingMainApi.updateBiddingGroupCheckNo(bidddingNo);
    }

    public BaseResponse getOrderFee(TempPurchaseVo tempPurchaseVoData, String memberId) {
        TempPurchaseVo tempPurchaseVo = this.dealTempPurchaseVo(tempPurchaseVoData);
        List tempBatchPurchaseOrderVos = this.dealWithBatchPurchaseData(tempPurchaseVo);
        BaseResponse baseResponse = this.orderMainApi.batchTempOrderByBatchPurchase(tempBatchPurchaseOrderVos);
        BigDecimal sumOrderFee = BigDecimal.ZERO;
        if (baseResponse.isSuccess()) {
            List tempOrderVos = (List)baseResponse.getResult();
            if (!Lang.isEmpty((Object)tempOrderVos)) {
                for (TempOrderVo tempOrderVo : tempOrderVos) {
                    for (TempOrderStoreVo tempOrderStoreVo : tempOrderVo.getStoreList()) {
                        BigDecimal singleFee = this.orderMainApi.queryShippingFee(tempOrderStoreVo.getStoreId(), tempOrderStoreVo.getOrderItems(), tempOrderVo.getMemberAddrId());
                        if (Lang.isEmpty((Object)singleFee)) continue;
                        sumOrderFee = sumOrderFee.add(singleFee);
                    }
                }
            }
        } else {
            return new BaseResponse("\u83b7\u53d6\u4e34\u65f6\u8ba2\u5355\u5931\u8d25!");
        }
        return new BaseResponse(true, "\u83b7\u53d6\u8fd0\u8d39\u6210\u529f\uff01", (Object)sumOrderFee);
    }

    public BaseResponse checkLimit(String biddingCode) {
        BigDecimal totalPrice;
        List tempOrderDtos = this.biddingOrderQueryApi.findTempOrderByBiddingCode(biddingCode);
        TempPurchaseVo tempPurchaseVo = new TempPurchaseVo();
        ArrayList orders = new ArrayList();
        for (JcbdTempOrderDto tempOrderDto : tempOrderDtos) {
            tempOrderDto.getJcbdTempGoodses().forEach(n -> {
                TempJcbdOrderVo orderVo = new TempJcbdOrderVo();
                orderVo.setResponsePrice(n.getPrice());
                orderVo.setCount(n.getNum());
                orders.add(orderVo);
            });
        }
        tempPurchaseVo.setOrders(orders);
        List tempJcbdOrderVos = tempPurchaseVo.getOrders();
        BigDecimal newOrderSumPirce = BigDecimal.ZERO;
        for (int j = 0; j < tempJcbdOrderVos.size(); ++j) {
            if (Lang.isEmpty((Object)newOrderSumPirce) || Lang.isEmpty((Object)((TempJcbdOrderVo)tempJcbdOrderVos.get(j)).getResponsePrice())) continue;
            newOrderSumPirce = newOrderSumPirce.add(((TempJcbdOrderVo)tempJcbdOrderVos.get(j)).getResponsePrice().multiply(new BigDecimal(((TempJcbdOrderVo)tempJcbdOrderVos.get(j)).getCount())));
        }
        List b4jcbdOrderDtoList = this.biddingOrderQueryApi.findByJcbdBiddingId(biddingCode);
        BigDecimal oldOrderSumPrice = BigDecimal.ZERO;
        if (b4jcbdOrderDtoList.size() > 0) {
            for (JcbdOrderDto jcbdOrderDto : b4jcbdOrderDtoList) {
                oldOrderSumPrice = oldOrderSumPrice.add(jcbdOrderDto.getTotalMoney());
            }
        }
        if ((totalPrice = newOrderSumPirce.add(oldOrderSumPrice)).compareTo(new BigDecimal(this.tradingLimit)) > 0) {
            return new BaseResponse(false, "\u60a8\u6b64\u6b21\u4e0b\u5355\u7684\u91d1\u989d\u4e0e\u5386\u53f2\u4e0b\u5355\u91d1\u989d\u76f8\u52a0\u8d85\u8fc7100\u4e07\uff0c\u4e0d\u53ef\u4e0b\u5355");
        }
        return new BaseResponse(true, "\u6821\u9a8c\u901a\u8fc7");
    }

    public BaseResponse<Boolean> getVoteStatus(String biddingNo, String memberId) {
        return this.biddingMainApi.getVoteStatus(biddingNo, memberId);
    }

    public TiaoXianCompanyVo getTiaoXianCompany(TianXianRequestVo tianXianRequestVo) {
        TiaoXianCompanyVo tiaoXianCompanyVo = new TiaoXianCompanyVo();
        CoreCompanyDto coreCompany = null;
        coreCompany = this.coreCompDepartUserApi.getCompanyByUserIdAndPositon(tianXianRequestVo.getUserId(), "JC_CGJBR");
        if (!Lang.isEmpty((Object)coreCompany)) {
            if (coreCompany.getCompanyLevel() == CoreCompanyDto.COMPANY_LEVEL_FOUR) {
                String isOpen;
                String parentCode = this.getParentCode(coreCompany);
                Boolean isIncludeCode = false;
                String excuArray = this.systemConfigApi.getConfigValue(this.organizationCode, "WORKFLOWSTRIPEREXCU", "WORKFLOWSTRIPEREXCU", Boolean.valueOf(true), Boolean.valueOf(true));
                if (!Lang.isEmpty((Object)excuArray) && !Lang.isEmpty((Object)parentCode)) {
                    String[] includeArray;
                    for (String value : includeArray = excuArray.split(",")) {
                        if (!value.equals(parentCode)) continue;
                        isIncludeCode = true;
                        break;
                    }
                }
                if (!isIncludeCode.booleanValue() && !Lang.isEmpty((Object)(isOpen = this.systemConfigApi.getConfigValue(this.organizationCode, "OPENCONFIGWORKFLOWSTRIPER", "OPENCONFIGWORKFLOWSTRIPER", Boolean.valueOf(true), Boolean.valueOf(true)))) && isOpen.equals("true")) {
                    WfWorkFlowRelationDto wfWorkFlowRelation;
                    List workFlowRelations = this.wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
                    WfWorkFlowDefinitionDto wfWorkFlowDefinition = null;
                    if (!Lang.isEmpty((Object)workFlowRelations) && !Lang.isEmpty((Object)(wfWorkFlowRelation = (WfWorkFlowRelationDto)workFlowRelations.get(0)))) {
                        wfWorkFlowDefinition = wfWorkFlowRelation.getWorkFlowDefinition();
                    }
                    String valus = this.systemConfigApi.getConfigValue(this.organizationCode, "WORKFLOWSTRIPERMONEY", "WORKFLOWSTRIPERMONEY", Boolean.valueOf(true), Boolean.valueOf(true));
                    Double thirdTiaoxianMoney = 0.0;
                    String thirdTiaoxianUnit = "5\u4e07";
                    String thirdTiaoxianMoneyStr = "50000";
                    if (!Lang.isEmpty((Object)valus)) {
                        if (!Lang.isEmpty((Object)wfWorkFlowDefinition)) {
                            JSONArray jsonArray = JSON.parseArray((String)valus);
                            for (int i = 0; i < jsonArray.size(); ++i) {
                                JSONObject obj = jsonArray.getJSONObject(i);
                                String companyCode = obj.getString("companyCode");
                                if (!wfWorkFlowDefinition.getCompanyCode().equals(companyCode)) continue;
                                thirdTiaoxianMoneyStr = obj.getString("money");
                                thirdTiaoxianUnit = obj.getString("unit");
                            }
                        }
                        try {
                            thirdTiaoxianMoney = Double.parseDouble(thirdTiaoxianMoneyStr);
                        }
                        catch (Exception e) {
                            log.info("\u8c03\u7ebf\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
                            e.printStackTrace();
                        }
                    }
                    BigDecimal totalMoney = tianXianRequestVo.getTotalMoney();
                    if (coreCompany != null) {
                        switch (coreCompany.getCompanyLevel()) {
                            case 4: {
                                this.handleThirdTiaoXian(tiaoXianCompanyVo, Double.valueOf(totalMoney.doubleValue()), coreCompany, thirdTiaoxianMoney, thirdTiaoxianUnit);
                            }
                        }
                    }
                }
            }
            List workFlowRelations = this.wfWorkFlowRelationApi.findByWorkIdAndUseCode(tianXianRequestVo.getUserId(), tianXianRequestVo.getUseCode());
            ArrayList<WfWorkFlowDefinitionDto> wfWorkFlowDefinitions = new ArrayList<WfWorkFlowDefinitionDto>();
            for (WfWorkFlowRelationDto wf_r : workFlowRelations) {
                if (wf_r.getWorkFlowDefinition().getIsDelete() != null && wf_r.getWorkFlowDefinition().getIsDelete().booleanValue()) continue;
                wfWorkFlowDefinitions.add(wf_r.getWorkFlowDefinition());
            }
            tiaoXianCompanyVo.setWfWorkFlowDefinitions(wfWorkFlowDefinitions);
        }
        return tiaoXianCompanyVo;
    }

    private String getParentCode(CoreCompanyDto coreCompany) {
        String parentId = coreCompany.getParent().getId();
        CoreCompanyDto coreCompanyP1 = this.coreCompanyApi.getParentCompany(parentId, CoreCompanyDto.COMPANY_LEVEL_TWO);
        return coreCompanyP1.getCode();
    }

    public void handleThirdTiaoXian(TiaoXianCompanyVo tiaoXianCompanyVo, Double sumCartPrice, CoreCompanyDto coreCompany, Double thirdTiaoxianMoney, String thirdTiaoxianUnit) {
        if (sumCartPrice > thirdTiaoxianMoney) {
            CoreCompanyDto coreCompanyParent = coreCompany.getParent();
            Integer departmentLevel = 1;
            List tiaoXianDepartment = this.coreDepartmentApi.findTiaoXianDepartment(coreCompanyParent.getId(), departmentLevel);
            tiaoXianCompanyVo.setIsTiaoXian(Boolean.valueOf(true));
            tiaoXianCompanyVo.setTianXianDepartmentDtos(tiaoXianDepartment);
            tiaoXianCompanyVo.setThirdTiaoxianMoney(new BigDecimal(thirdTiaoxianMoney));
        }
    }

    public BaseResponse reSendAuditEmail(String biddingNo, String biddingMemberId) {
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        JcbdBiddingDto jcbdBiddingDto = this.biddingMainQueryApi.queryBidding(biddingNo);
        String companyName = this.getOperateInformation(biddingMemberId).getWholeJobName();
        JcbdBiddingVo jcbdBiddingVo = this.getBiddingByBiddingCode(biddingNo);
        JcbdBiddingVo operator = this.getOperator(jcbdBiddingVo.getOperatorId());
        if (!Lang.isEmpty((Object)jcbdBiddingDto) && BiddingStatus.OM_CONFORM_AUDIT_IN.getValue().equals(jcbdBiddingDto.getStatus())) {
            BaseResponse biddingGroupMembers = this.biddingConformityReviewQueryApi.findBiddingGroupMember(biddingNo);
            try {
                if (!Lang.isEmpty((Object)biddingGroupMembers)) {
                    int size = ((List)biddingGroupMembers.getResult()).size();
                    String[] sendEmail = new String[size];
                    if (biddingGroupMembers.isSuccess()) {
                        for (int i = 0; i < size; ++i) {
                            sendEmail[i] = ((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getEmail();
                            mailReq.setTo(new String[]{sendEmail[i]});
                            mailReq.setFrom(operator.getEmail());
                            mailReq.setSentDate(new Date());
                            mailReq.setChannel("jc");
                            mailTemplateReq.setMailReq(mailReq);
                            String templateCode = MailTemplateEnum.BID_CONFORMANCE_AUDIT.getTemplateCode();
                            String redirectUrl = "/operator/complianceAudit";
                            String url = this.makeLoginUrl(StringUtils.join((Object[])new String[]{sendEmail[i]}), biddingNo, redirectUrl);
                            mailTemplateReq.setTemplateCode(templateCode);
                            ArrayList<String> subjectArgs = new ArrayList<String>();
                            subjectArgs.add(biddingNo);
                            ArrayList<String> contextArgs = new ArrayList<String>();
                            if (!Lang.isEmpty((Object)((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getName())) {
                                contextArgs.add(((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getName());
                            } else {
                                contextArgs.add(((JcbdBiddingGroupMemberDto)((List)biddingGroupMembers.getResult()).get(i)).getEmail());
                            }
                            contextArgs.add(companyName);
                            contextArgs.add(operator.getUsername());
                            contextArgs.add(biddingNo);
                            contextArgs.add(url);
                            contextArgs.add(url);
                            mailTemplateReq.setSubjectArgList(subjectArgs);
                            mailTemplateReq.setContentArgList(contextArgs);
                            mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
                            log.info("\u7b26\u5408\u6027\u5ba1\u67e5\u91cd\u53d1\u90ae\u4ef6\u6a21\u677f\u5c01\u88c5\u6570\u636e{}", (Object)JSON.toJSONString((Object)mailTemplateReq));
                            MailRsp mailRsp = this.mailApi.sendMailByTemplate(mailTemplateReq);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25{}", (Throwable)e);
                return new BaseResponse(false, "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25");
            }
        }
        return new BaseResponse(true);
    }

    public BaseResponse<Boolean> saveOperatorsLog(String operatorsId, String biddingCode, JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto) {
        JcbdBiddingDto jcbdBiddingDto = this.biddingMainQueryApi.queryBidding(biddingCode);
        String operatorName = this.biddingOperatorService.getOperatorName(operatorsId);
        jcbdBiddingOperationLogDto.setOperatorName(operatorName);
        jcbdBiddingOperationLogDto.setOperationTime(new Date());
        jcbdBiddingOperationLogDto.setBiddingId(jcbdBiddingDto.getId());
        this.biddingLogApi.saveBiddingOperationLog(jcbdBiddingOperationLogDto);
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public BaseResponse<Boolean> saveAuditOperatorsLog(String operatorsId, String biddingCode, JcbdBiddingOperationLogDto jcbdBiddingOperationLogDto) {
        JcbdBiddingDto jcbdBiddingDto = this.biddingMainQueryApi.queryBidding(biddingCode);
        CoreCompDepartUserDto coreCompDepartUserDto = this.coreCompDepartUserApi.findByIdAndIsDelete(operatorsId, false);
        CoreUserDto coreUserDto = this.coreUserApi.findById(coreCompDepartUserDto.getUserId());
        jcbdBiddingOperationLogDto.setOperatorName(coreUserDto.getUsername());
        jcbdBiddingOperationLogDto.setOperationTime(new Date());
        jcbdBiddingOperationLogDto.setBiddingId(jcbdBiddingDto.getId());
        this.biddingLogApi.saveBiddingOperationLog(jcbdBiddingOperationLogDto);
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
    }

    public Map deleteBidding(String biddingNo) {
        BaseResponse baseResponse = this.biddingMainApi.deleteBidding(biddingNo);
        if (!baseResponse.isSuccess()) {
            ResponseMapUtils.error((String)baseResponse.getResultMessage());
        }
        return ResponseMapUtils.success((Object)baseResponse.getResultMessage());
    }

    public JcbdBiddingDemandResponseDto findGoodsPriceBySku(String biddingNo, String sku) {
        return this.biddingResponseQueryApi.findProviderResponsePrice(biddingNo, sku);
    }

    public String findGoodsIdBySku(String sku) {
        List goodsConfigDtos = this.goodsConfigApi.findBySkuAndOrganizationCode(sku, ORGANIZATIONCODE);
        if (!Lang.isEmpty((Object)goodsConfigDtos)) {
            return ((GoodsConfigDto)goodsConfigDtos.get(0)).getGoodsId();
        }
        return null;
    }

    public String findProductFashionId(String sku) {
        List fashionIds = this.productFashionApi.findProductFashionIdBySku(sku);
        if (!Lang.isEmpty((Object)fashionIds)) {
            return (String)fashionIds.get(0);
        }
        return null;
    }

    public List<String> findBiddingShowTitle(String biddingNo) {
        JcbdBiddingDto jcbdBiddingDto = this.biddingMainQueryApi.queryBidding(biddingNo);
        String status = jcbdBiddingDto.getStatus();
        return this.biddingRoleOperationQueryApi.getBiddingShowTitle(status, BIDDING_TITILE_SHOW_MODULE);
    }

    public TiaoXianCompanyVo getBiddingResultTiaoXian(String userId, String biddingNo) {
        TianXianRequestVo tianXianRequestVo = new TianXianRequestVo();
        tianXianRequestVo.setTotalMoney(this.getResponseBiddingTotalMonay(biddingNo));
        tianXianRequestVo.setUseCode(WorkFlowCode.BIDDING_RESULT_WORKFLOW_CODE.getCode());
        tianXianRequestVo.setUserId(userId);
        return this.getTiaoXianCompany(tianXianRequestVo);
    }

    public TiaoXianCompanyVo getBiddingOrderTiaoXian(TianXianRequestVo tianXianRequestVo) {
        return this.getTiaoXianCompany(tianXianRequestVo);
    }

    public BaseResponse checkGoodNums(String biddingCode) {
        BaseResponse baseResponse = new BaseResponse();
        List tempOrderDtos = this.biddingOrderQueryApi.findTempOrderByBiddingCode(biddingCode);
        TempPurchaseVo tempPurchaseVo = new TempPurchaseVo();
        ArrayList orders = new ArrayList();
        for (JcbdTempOrderDto tempOrderDto : tempOrderDtos) {
            tempOrderDto.getJcbdTempGoodses().forEach(n -> {
                TempJcbdOrderVo orderVo = new TempJcbdOrderVo();
                orderVo.setSku(n.getSku());
                orderVo.setResponsePrice(n.getPrice());
                orderVo.setCount(n.getNum());
                orderVo.setJcbdBiddingDemandId(n.getDemandId());
                orderVo.setMemberAddrId(tempOrderDto.getMemberAddressId());
                orderVo.setStoreId(tempOrderDto.getStoreId());
                orderVo.setProductFashionId(n.getProductFashionId());
                orderVo.setGoodsId(n.getGoodsId());
                orders.add(orderVo);
            });
        }
        tempPurchaseVo.setOrders(orders);
        List tempJcbdOrderVos = tempPurchaseVo.getOrders();
        List jcbdOrderDtos = this.biddingOrderQueryApi.findAllByBiddingCode(biddingCode);
        ArrayList jcbdMallOrderDtos = new ArrayList();
        ArrayList<String> orderStatusFilter = new ArrayList<String>();
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_INREVIEW.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_COMPLETED.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_TOBECONFIRMED.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_TOBERECEIVED.getCode());
        orderStatusFilter.add(BiddingOrderStatus.ORDER_STATUS_HAVEGOODS.getCode());
        ArrayList orderItems = new ArrayList();
        if (!Lang.isEmpty((Object)jcbdOrderDtos)) {
            jcbdOrderDtos.forEach(jcbdOrder -> jcbdMallOrderDtos.addAll(jcbdOrder.getJcbdMallOrders()));
            List<JcbdMallOrderDto> mallOrderDtos = jcbdMallOrderDtos.stream().filter(item -> orderStatusFilter.contains(item.getStatus())).collect(Collectors.toList());
            if (!Lang.isEmpty(mallOrderDtos)) {
                List orderNos = mallOrderDtos.stream().map(JcbdMallOrderDto::getOrderNo).collect(Collectors.toList());
                mallOrderDtos.forEach(mallOrder -> orderItems.addAll(mallOrder.getJcbdBiddingOrderItems()));
            }
        }
        Map<String, List<JcbdBiddingOrderItemDto>> orderItemMap = null;
        if (!Lang.isEmpty(orderItems)) {
            orderItemMap = orderItems.stream().collect(Collectors.groupingBy(JcbdBiddingOrderItemDto::getSku));
        }
        Map<String, List<TempJcbdOrderVo>> orderDataMap = tempJcbdOrderVos.stream().collect(Collectors.groupingBy(TempJcbdOrderVo::getSku));
        ArrayList<String> overBuySkuList = new ArrayList<String>();
        for (String skuKey : orderDataMap.keySet()) {
            List<JcbdBiddingOrderItemDto> orderItemDtos;
            List<TempJcbdOrderVo> orderVoList = orderDataMap.get(skuKey);
            TempJcbdOrderVo tempJcbdOrderVo = orderVoList.get(0);
            String demandId = tempJcbdOrderVo.getJcbdBiddingDemandId();
            Integer thisTimeBuyCount = orderVoList.stream().collect(Collectors.reducing(0, TempJcbdOrderVo::getCount, (i, j) -> i + j));
            JcbdBiddingDemandDto demandQuery = new JcbdBiddingDemandDto();
            demandQuery.setId(demandId);
            JcbdBiddingDto jcbdBiddingDto = new JcbdBiddingDto();
            jcbdBiddingDto.setBiddingCode(biddingCode);
            demandQuery.setJcbdBidding(jcbdBiddingDto);
            JcbdBiddingDemandDto demandDto = this.biddingMainQueryApi.getBiddingDemandFindOne(demandQuery);
            Long maxPurchaseAmount = demandDto.getMaxPurchaseAmount();
            if (Lang.isEmpty(orderItemMap) || Lang.isEmpty(orderItemDtos = orderItemMap.get(skuKey))) continue;
            Integer historyBuyCount = orderItemDtos.stream().collect(Collectors.reducing(0, JcbdBiddingOrderItemDto::getCount, (i, j) -> i + j));
            if ((long)(thisTimeBuyCount + historyBuyCount) <= maxPurchaseAmount) continue;
            overBuySkuList.add(skuKey);
        }
        if (overBuySkuList.size() > 0) {
            baseResponse.setSuccess(true);
            StringBuilder sb = new StringBuilder();
            sb.append("\u60a8\u6b64\u6b21\u4e0b\u5355\u7684\u3010");
            for (int i2 = 0; i2 < overBuySkuList.size(); ++i2) {
                if (i2 != overBuySkuList.size() - 1) {
                    sb.append((String)overBuySkuList.get(i2)).append(",");
                    continue;
                }
                sb.append((String)overBuySkuList.get(i2));
            }
            sb.append("\u3011\u5546\u54c1\u603b\u8ba1\u6570\u91cf\u4e0e\u5386\u53f2\u4e0b\u5355\u6570\u91cf\u76f8\u52a0\u8d85\u8fc7\u6b64\u9700\u6c42\u7684\u6700\u9ad8\u91c7\u8d2d\u6570\u91cf\uff0c\u4e0d\u53ef\u4e0b\u5355");
            baseResponse.setResultMessage(sb.toString());
        }
        return baseResponse;
    }

    public CoreCompanyDto getCoreCompanyInfoById(String companyId) {
        return this.coreCompanyApi.getCoreCompanyInfoById(companyId);
    }

    public Boolean compareCurrentMemberId(String memberId, String biddingCode) {
        if (Lang.isEmpty((Object)memberId)) {
            return false;
        }
        JcbdBiddingDto jcbdBidding = this.biddingQueryApi.findByBiddingCodeAndIsDelete(biddingCode);
        if (StringUtils.equals((CharSequence)memberId, (CharSequence)jcbdBidding.getOperatorId())) {
            return true;
        }
        return false;
    }

    public Boolean biddingIsFinish(String biddingNo) {
        if (Lang.isEmpty((Object)biddingNo)) {
            return true;
        }
        JcbdBiddingVo biddingVo = this.getBiddingByBiddingCode(biddingNo);
        if (Lang.isEmpty((Object)biddingVo)) {
            return true;
        }
        return BiddingStatus.OM_BIDDING_END.getValue().equals(biddingVo.getStatus());
    }

    public JcbdBiddingGroupMemberDto findGroupStatus(String email, String biddingId) {
        return this.biddingQueryApi.findGroupStatus(email, biddingId);
    }

    public String getOperatorName(String operatorId) {
        JcbdBiddingGroupMemberDto jcbdBiddingGroupMember = this.biddingMainApi.findByMemberId(operatorId);
        if (jcbdBiddingGroupMember != null) {
            if (!Lang.isEmpty((Object)jcbdBiddingGroupMember.getName())) {
                return jcbdBiddingGroupMember.getName();
            }
            if (!Lang.isEmpty((Object)jcbdBiddingGroupMember.getEmail())) {
                return jcbdBiddingGroupMember.getEmail();
            }
        } else {
            List supplierContact = this.supplierLoginApi.findByDUserIdAndIsDelete(operatorId);
            if (!(Lang.isEmpty((Object)supplierContact) || Lang.isEmpty((Object)((SupplierContactDto)supplierContact.get(0)).getdUserName()) || Lang.isEmpty((Object)((SupplierContactDto)supplierContact.get(0)).getdVendorName()))) {
                return new StringBuffer(((SupplierContactDto)supplierContact.get(0)).getdVendorName()).append("-").append(((SupplierContactDto)supplierContact.get(0)).getdUserName()).toString();
            }
        }
        return operatorId;
    }

    public List<JsonModel> jsTree() {
        ArrayList<JsonModel> list = new ArrayList();
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)"protocol:companyListTree");
        if (boundValueOperations.get() != null) {
            list = (List)boundValueOperations.get();
            return list;
        }
        List hq = this.companyRepos.findByIsDelete(Boolean.valueOf(false));
        List compIds = Lang.grepList((List)hq, (String)"id", (Object)"");
        List allDeparts = this.getAllDepartment(compIds);
        for (int i = 0; i < hq.size(); ++i) {
            JsonModel jsonModel;
            if (Lang.isEmpty((Object)((CoreCompany)hq.get(i)).getParent())) {
                jsonModel = new JsonModel();
                jsonModel.setId(((CoreCompany)hq.get(i)).getId());
                jsonModel.setParent("#");
                jsonModel.setText(((CoreCompany)hq.get(i)).getName());
                jsonModel.setIcon("false");
                jsonModel.setType1("company");
                list.add(jsonModel);
                continue;
            }
            jsonModel = new JsonModel();
            jsonModel.setId(((CoreCompany)hq.get(i)).getId());
            jsonModel.setParent(((CoreCompany)hq.get(i)).getParent().getId());
            jsonModel.setText(((CoreCompany)hq.get(i)).getName());
            jsonModel.setType1("company");
            jsonModel.setIcon("false");
            list.add(jsonModel);
            this.generateDept(list, hq, i, allDeparts);
        }
        boundValueOperations.set(list);
        return list;
    }

    public List<CoreDepartment> getAllDepartment(List<String> companyIds) {
        ArrayList<CoreDepartment> departmentList = new ArrayList<CoreDepartment>();
        ArrayList compIdsPageable = new ArrayList();
        ArrayList<String> tmpCompIds = new ArrayList<String>();
        compIdsPageable.add(tmpCompIds);
        for (String string : companyIds) {
            if (tmpCompIds.size() < 1000) {
                tmpCompIds.add(string);
                continue;
            }
            tmpCompIds = new ArrayList();
            tmpCompIds.add(string);
            compIdsPageable.add(tmpCompIds);
        }
        for (List list : compIdsPageable) {
            List tempDepList = this.departmentRepos.findAll((Specification)new /* Unavailable Anonymous Inner Class!! */);
            departmentList.addAll(tempDepList);
        }
        if (Lang.isEmpty(departmentList)) {
            return null;
        }
        return departmentList;
    }

    private void generateDept(List<JsonModel> list, List<CoreCompany> hq, int i, List<CoreDepartment> allDeps) {
        ArrayList<CoreDepartment> bm = new ArrayList<CoreDepartment>();
        for (CoreDepartment d : allDeps) {
            if (!d.getCoreCompany().getId().equals(hq.get(i).getId())) continue;
            bm.add(d);
        }
        for (int j = 0; j < bm.size(); ++j) {
            JsonModel jsonModel1;
            if (((CoreDepartment)bm.get(j)).getParent() == null) {
                jsonModel1 = new JsonModel();
                jsonModel1.setId(((CoreDepartment)bm.get(j)).getId());
                jsonModel1.setParent(((CoreDepartment)bm.get(j)).getCoreCompany().getId());
                if ("2".equals(((CoreDepartment)bm.get(j)).getCoreCompany().getCompanyLevel().toString())) {
                    jsonModel1.setType1("department2");
                } else {
                    jsonModel1.setType1("department");
                }
                jsonModel1.setText(((CoreDepartment)bm.get(j)).getName());
                jsonModel1.setIcon("false");
                list.add(jsonModel1);
                continue;
            }
            jsonModel1 = new JsonModel();
            jsonModel1.setId(((CoreDepartment)bm.get(j)).getId());
            jsonModel1.setParent(((CoreDepartment)bm.get(j)).getParent().getId());
            jsonModel1.setText(((CoreDepartment)bm.get(j)).getName());
            jsonModel1.setType1("department");
            jsonModel1.setIcon("false");
            list.add(jsonModel1);
        }
    }

    public List<JsonModel> compJsTree(String userId, String roleCode) {
        ArrayList<JsonModel> companyTree = new ArrayList<JsonModel>();
        List list = new ArrayList();
        CoreCompDepartUserDto coreCompDepartUserDto = this.getCompDepartUserByUserIdAndRoleCode(userId, roleCode);
        if (null != coreCompDepartUserDto && !Lang.isEmpty((Object)coreCompDepartUserDto.getCompanyId())) {
            String companyId = coreCompDepartUserDto.getCompanyId();
            Long startTime = System.currentTimeMillis();
            BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)"protocol:companyListTree");
            if (boundValueOperations.get() != null) {
                list = (List)boundValueOperations.get();
                this.filterTree4FloatLayer(companyTree, list, companyId);
                Long t1 = System.currentTimeMillis();
                log.info("##\u7ade\u4ef7\u5c0f\u7ec4\u6811\u67e5\u8be2\u4f7f\u7528\u7f13\u5b58- \u8017\u65f6 {}\u6beb\u79d2milliseconds##", (Object)(t1 - startTime));
            } else {
                List ccDTOs = this.coreCompanyApi.findByIsDelete(false);
                Long t2 = System.currentTimeMillis();
                log.info("##\u7ade\u4ef7\u5c0f\u7ec4\u5de6\u8fb9\u6811\u67e5\u8be2\u6570\u636e\u5e93- \u8017\u65f6 {}\u6beb\u79d2milliseconds##", (Object)(t2 - startTime));
                list = this.getListFromDTOs(ccDTOs);
                this.filterTree4FloatLayer(companyTree, list, companyId);
            }
        }
        return companyTree;
    }

    private List<JsonModel> getListFromDTOs(List<CoreCompanyDto> ccDTOs) {
        ArrayList<JsonModel> rtnList = new ArrayList<JsonModel>();
        for (CoreCompanyDto tmpDto : ccDTOs) {
            if (Lang.isEmpty((Object)tmpDto.getParent()) || tmpDto.getCompanyLevel() == 2) {
                if (tmpDto.getCompanyLevel() != 2) continue;
                JsonModel jm = new JsonModel();
                jm.setId(tmpDto.getId());
                jm.setTpHrId(tmpDto.getTpHrId());
                jm.setParent("#");
                jm.setText(tmpDto.getName());
                jm.setIcon("false");
                jm.setType1("company");
                rtnList.add(jm);
                continue;
            }
            JsonModel jsonModel = new JsonModel();
            jsonModel.setId(tmpDto.getId());
            jsonModel.setParent(tmpDto.getParent().getId());
            jsonModel.setTpHrId(tmpDto.getTpHrId());
            jsonModel.setText(tmpDto.getName());
            jsonModel.setType1("company");
            jsonModel.setIcon("false");
            rtnList.add(jsonModel);
        }
        return rtnList;
    }

    private void filterTree4FloatLayer(List<JsonModel> companyTree, List<JsonModel> list, String companyId) {
        for (JsonModel jm : list) {
            if (companyId.equals(jm.getId())) {
                companyTree.add(jm);
                continue;
            }
            if (!companyId.equals(jm.getParent())) continue;
            this.filterTree4FloatLayer(companyTree, list, jm.getId());
        }
    }

    private CoreCompDepartUserDto getCompDepartUserByUserIdAndRoleCode(String userId, String roleCode) {
        CoreRoleDto crDto = this.coreRoleApi.findByCode(roleCode);
        CoreCompDepartUserDto coreCompDepartUserDto = new CoreCompDepartUserDto();
        if (!Lang.isEmpty((Object)crDto) && !Lang.isEmpty((Object)crDto.getId())) {
            coreCompDepartUserDto = this.coreCompDepartUserApi.findByUserIdAndRoleId(userId, crDto.getId(), false);
        }
        return coreCompDepartUserDto;
    }

    public Map getTechAuditorListBySearchCondition(JqueryDataTablesVo jqueryDataTablesVo, String selectedCompanyOrDepartmentName, String selectedCompanyOrDepartmentId, String nameLike, String emailLike, boolean isDelete, String userId, String roleCode, Pageable pageable) {
        CoreDepartmentDto coreDepartmentDto;
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        long totalElement = 0L;
        Long startTime = System.currentTimeMillis();
        int pageIndex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        pageable = new PageRequest(pageIndex, jqueryDataTablesVo.getiDisplayLength().intValue(), null);
        ArrayList<AuditorInfoVO> techAuditVOs = new ArrayList<AuditorInfoVO>();
        if (Lang.isEmpty((Object)selectedCompanyOrDepartmentName)) {
            returnModel.put("aaData", techAuditVOs);
            returnModel.put("iTotalRecords", Long.valueOf(totalElement));
            returnModel.put("iTotalDisplayRecords", Long.valueOf(totalElement));
            return returnModel;
        }
        PageVo rtnTechAuditorPage = !Lang.isEmpty((Object)selectedCompanyOrDepartmentId) ? (!Lang.isEmpty((Object)(coreDepartmentDto = this.coreDepartmentApi.getDepartmentInfo(selectedCompanyOrDepartmentId))) ? this.coreCompDepartUserApi.getPersonsByCondition(null, selectedCompanyOrDepartmentId, nameLike, emailLike, isDelete, pageable) : this.coreCompDepartUserApi.getPersonsByCondition(selectedCompanyOrDepartmentId, null, nameLike, emailLike, isDelete, pageable)) : this.coreCompDepartUserApi.getPersonsByCondition(null, null, nameLike, emailLike, isDelete, pageable);
        Long endTime = System.currentTimeMillis();
        log.info("############\u7ade\u4ef7\u91c7\u8d2d----\u7ade\u4ef7\u5c0f\u7ec4\u67e5\u8be2 \u8017\u65f6 {}################", (Object)(endTime - startTime));
        if (!Lang.isEmpty((Object)rtnTechAuditorPage)) {
            List list = rtnTechAuditorPage.getResult();
            for (Map map : list) {
                AuditorInfoVO aiVO = this.convertMap2AuditorInfoVO(map);
                techAuditVOs.add(aiVO);
            }
            totalElement = rtnTechAuditorPage.getTotalCount().intValue();
            returnModel.put("aaData", techAuditVOs);
            returnModel.put("iTotalRecords", Long.valueOf(totalElement));
            returnModel.put("iTotalDisplayRecords", Long.valueOf(totalElement));
        } else {
            returnModel.put("aaData", techAuditVOs);
            returnModel.put("iTotalRecords", Long.valueOf(totalElement));
            returnModel.put("iTotalDisplayRecords", Long.valueOf(totalElement));
        }
        return returnModel;
    }

    public Boolean disJcbdBiddingGroup(String userId, List<JcbdBiddingGroupMemberVo> groupMemberVoList) {
        String email;
        if (!Lang.isEmpty((Object)userId)) {
            return false;
        }
        CoreUserDto userDto = this.coreUserApi.findById(userId);
        if (!Lang.isEmpty((Object)userDto) && !Lang.isEmpty((Object)(email = userDto.getEmail()))) {
            for (JcbdBiddingGroupMemberVo groupMemberVo : groupMemberVoList) {
                if (Lang.isEmpty((Object)groupMemberVo)) continue;
                String gEmail = groupMemberVo.getEmail();
                if (!Lang.isEmpty((Object)gEmail) && email.equals(gEmail)) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private AuditorInfoVO convertMap2AuditorInfoVO(Map map) {
        AuditorInfoVO rtnVO = new AuditorInfoVO();
        if (!Lang.isEmpty((Object)map)) {
            rtnVO.setId((String)map.get("ID"));
            rtnVO.setUsername((String)map.get("USERNAME"));
            rtnVO.setEmail((String)map.get("EMAIL"));
            rtnVO.setCompanyId((String)map.get("COMPANY_ID"));
            rtnVO.setCompanyCode((String)map.get("COMPANY_CODE"));
            rtnVO.setHrId((String)map.get("HR_ID"));
            rtnVO.setCompanyName((String)map.get("COMPANY_NAME"));
            rtnVO.setDepartmentId((String)map.get("DEPARTMENT_ID"));
            rtnVO.setDepartmentCode((String)map.get("DEPARTMENT_CODE"));
            rtnVO.setDepartmentName((String)map.get("DEPARTMENT_NAME"));
            rtnVO.setTechAuditorMemberId((String)map.get("MEMBERID"));
        }
        return rtnVO;
    }

    public void grantPermission4BiddingGroupMember(String memberId, String biddingSpliceStringId, String roleCode) {
        MemberMenuRoleUserDto memberMenuRoleUserDto = new MemberMenuRoleUserDto();
        memberMenuRoleUserDto.setMemberId(memberId);
        MemberMenuRoleDto memberMenuRoleDto = null;
        memberMenuRoleDto = this.memberMenuRoleApi.findByRoleCode(roleCode);
        memberMenuRoleUserDto.setRoleId(memberMenuRoleDto.getId());
        this.memberMenuRoleApi.saveOrUpdateMenusByMemberIdAndRoleId(memberMenuRoleUserDto);
        CoreRoleDto crDto = this.coreRoleApi.findByCode(roleCode);
        if (!Lang.isEmpty((Object)crDto) && !Lang.isEmpty((Object)biddingSpliceStringId)) {
            String[] strArr = biddingSpliceStringId.split(",");
            String userId = strArr[0];
            String companyId = strArr[2];
            String departmentId = strArr[3];
            CoreCompDepartUserDto ccduDto = this.coreCompDepartUserApi.findByUserIdAndRoleId(userId, crDto.getId(), false);
            if (Lang.isEmpty((Object)ccduDto)) {
                CoreCompDepartUserDto dto = new CoreCompDepartUserDto();
                dto.setRoleId(crDto.getId());
                dto.setUserId(userId);
                dto.setCompanyId(companyId);
                if (!Lang.isEmpty((Object)departmentId)) {
                    dto.setDepartmentId(departmentId);
                }
                this.coreCompDepartUserApi.save(dto);
            }
        }
    }
}

