/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.query.BiddingMallOrderQueryApi;
import api.query.BiddingOrderManagerApi;
import api.query.BiddingOrderQueryApi;
import api.query.BiddingRoleOperationQueryApi;
import api.query.MallAttachmentQueryApi;
import bidding.web.service.BiddingOrderManagerService;
import bidding.web.vo.ImageVo;
import bidding.web.vo.JcbdMallOrderVo;
import bidding.web.vo.OrderAuditInfoVo;
import bidding.web.vo.QueryStatus;
import cart.api.OrderItemApi;
import cart.api.OrderMainApi;
import cart.api.OrderMainAttrApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOrderStatus;
import definition.MallAttachmentBusinessCode;
import definition.StatusOperateModule;
import dto.BiddingOrderAffiliationDto;
import dto.BiddingOrderInfoDto;
import dto.BiddingOrderMangerDto;
import dto.JcbdMallOrderDto;
import dto.JcbdRoleOperationDto;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import member.api.CoreCompDepartUserApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import query.BiddingOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.data.BeanMapper;
import utils.rpc.motan.ApiResponseVo;
import workflow.api.WorkFlowQueryApi;
import workflow.api.WorkFlowServiceApi;
import workflow.definition.AuditBusinessCode;
import workflow.dto.OrderAuditInfoDto;
import workflow.dto.WfWorkFlowLogDto;
import workflow.query.WorkFlowInfoQuery;
import workflow.vo.WorkFlowNodeVo;

@Service
public class BiddingOrderManagerServiceImpl
implements BiddingOrderManagerService {
    public static final Logger log = LoggerFactory.getLogger(BiddingOrderManagerServiceImpl.class);
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    CoreCompDepartUserApi coreCompDepartUserApi;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderManagerApi biddingOrderManagerApi;
    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;
    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;
    @MotanReferer
    OrderItemApi orderItemApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    OrderMainAttrApi orderMainAttrApi;
    @MotanReferer
    WorkFlowQueryApi workFlowQueryApi;
    @MotanReferer
    WorkFlowServiceApi workFlowServiceApi;
    @MotanReferer
    BiddingRoleOperationQueryApi biddingRoleOperationQueryApi;

    public Map getBiddingOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingOrderManagerListQuery biddingOrderManagerListQuery, Pageable pageable) {
        HashMap<String, Object> returnModel = new HashMap<String, Object>(16);
        Long totalElement = 0L;
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page page = this.biddingOrderManagerApi.getBiddingOrderMangerList(biddingOrderManagerListQuery, pageable);
        List contentList = page.getContent();
        for (BiddingOrderMangerDto biddingOrderMangerDto : contentList) {
            List itemDtoList = this.orderItemApi.findByOrderNo(biddingOrderMangerDto.getOrderNo());
            if (itemDtoList != null) {
                biddingOrderMangerDto.setGoodsNumber(new BigDecimal(itemDtoList.size()));
            }
            BigDecimal singleAmount = BigDecimal.ZERO;
            OrderMainDto orderMainDto = this.orderMainApi.findByOrderNo(biddingOrderMangerDto.getOrderNo());
            if (orderMainDto != null) {
                singleAmount = orderMainDto.getSumPrice();
            }
            biddingOrderMangerDto.setSingleAmount(singleAmount);
        }
        totalElement = page.getTotalElements();
        returnModel.put("aaData", page.getContent());
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public List<QueryStatus> getAllStatus() {
        ArrayList<QueryStatus> allStatusList = new ArrayList<QueryStatus>();
        Map biddingOrderStatusMap = BiddingOrderStatus.biddingOrderStatusMap;
        for (String statusCode : biddingOrderStatusMap.keySet()) {
            QueryStatus queryStatus = new QueryStatus();
            queryStatus.setStatusCode(statusCode);
            BiddingOrderStatus biddingOrderStatus = (BiddingOrderStatus)biddingOrderStatusMap.get(statusCode);
            queryStatus.setStatusDescription(biddingOrderStatus.getDescription());
            allStatusList.add(queryStatus);
        }
        return allStatusList;
    }

    public JcbdMallOrderVo updateStatusByOrderNo(String status, String orderNo) {
        JcbdMallOrderDto jcbdMallOrderDto = new JcbdMallOrderDto();
        ApiResponseVo apiResponseVo = this.orderMainApi.cancelOrder(orderNo, OrderMainApi.CancelOrderType.ERROR);
        if (apiResponseVo.getStatus().equals("success")) {
            jcbdMallOrderDto = this.biddingMallOrderQueryApi.updateStatusByOrderNo(status, orderNo);
            BaseResponse baseResponse = this.biddingOrderQueryApi.queryBiddingOrderNoByMallOrderNo(orderNo);
            BiddingOrderAffiliationDto biddingOrderAffiliationDto = this.biddingOrderQueryApi.checkIsBiddingOrder(baseResponse.getResult().toString());
            if (Lang.isEmpty((Object)biddingOrderAffiliationDto.getOrderNos())) {
                this.biddingOrderQueryApi.updateStatus(baseResponse.getResult().toString(), BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode());
                this.workFlowServiceApi.cancelWorkFlow(baseResponse.getResult().toString());
            }
            this.cancelPurchaseLogOrder(orderNo);
        }
        return (JcbdMallOrderVo)this.mapperFacade.map((Object)jcbdMallOrderDto, JcbdMallOrderVo.class);
    }

    public JcbdMallOrderVo deleteJcbdMallOrderByOrderNo(String orderNo) {
        JcbdMallOrderDto jcbdMallOrderDto = this.biddingMallOrderQueryApi.deleteJcbdMallOrderByOrderNo(orderNo);
        return (JcbdMallOrderVo)this.mapperFacade.map((Object)jcbdMallOrderDto, JcbdMallOrderVo.class);
    }

    public void getFlowSteps(String orderNo, Map<String, Object> stringObjectMap) {
        WorkFlowInfoQuery workFlowInfoQuery = new WorkFlowInfoQuery();
        workFlowInfoQuery.setBusinessCode(AuditBusinessCode.BIDDING_ORDER_AUDIT.getBusinessCode());
        workFlowInfoQuery.setBusinessNo(orderNo);
        List workFlowLogs = this.workFlowQueryApi.findByWorkFlowInfoQuery(workFlowInfoQuery);
        if (!Lang.isEmpty((Object)workFlowLogs)) {
            Collections.reverse(workFlowLogs);
            List flowSteps = this.getWorkFlowdWholeStepMaps(workFlowLogs);
            stringObjectMap.put("flowSteps", flowSteps);
        }
    }

    public List<Map<String, Object>> getWorkFlowdWholeStepMaps(List<WfWorkFlowLogDto> workFlowLogs) {
        ArrayList<Map<String, Object>> flowSteps = new ArrayList<Map<String, Object>>();
        int step = 0;
        HashMap<String, Object> steps = new HashMap<String, Object>();
        List wholeFlowLog = null;
        String orderId = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List wholeFlowStrLog = null;
        if (workFlowLogs != null && !workFlowLogs.isEmpty()) {
            for (WfWorkFlowLogDto workFlowLog : workFlowLogs) {
                OrderMainDto orderMain;
                String reason;
                if (workFlowLog.getApplyForWorker().booleanValue()) {
                    if (step > 0) {
                        steps.put("currentStep", step);
                        flowSteps.add(steps);
                        steps = new HashMap();
                    }
                    step = 0;
                    wholeFlowLog = JSON.parseArray((String)workFlowLog.getWorkWholeFlow(), WorkFlowNodeVo.class);
                    Collections.reverse(wholeFlowLog);
                }
                String dateStr = "";
                Date updateDate = null;
                if (workFlowLog.getHandleTime() != null) {
                    updateDate = workFlowLog.getHandleTime();
                }
                if (step == 0) {
                    updateDate = workFlowLog.getDateCreated();
                }
                dateStr = updateDate != null ? format.format(updateDate) : "";
                String string = reason = workFlowLog.getReason() == null ? "" : workFlowLog.getReason();
                if (!workFlowLog.getApplyForWorker().booleanValue()) {
                    if (workFlowLog.getWorkerId() == null) {
                        reason = "";
                    } else if (workFlowLog.getStatus() == null) {
                        reason = "";
                    } else if (workFlowLog.getStatus().equals(WfWorkFlowLogDto.check_order_status_pass)) {
                        if (reason == null || reason.trim().equals("")) {
                            reason = "\u65e0";
                        }
                        reason = "  \u5ba1\u6838\u901a\u8fc7  \u539f\u56e0\uff1a " + reason;
                    } else if (workFlowLog.getStatus().equals(WfWorkFlowLogDto.check_order_status_no_pass)) {
                        if (reason == null || reason.trim().equals("")) {
                            reason = "\u65e0";
                        }
                        reason = "  \u5ba1\u6838\u4e0d\u901a\u8fc7  \u539f\u56e0\uff1a " + reason;
                    }
                }
                if (workFlowLog == workFlowLogs.get(workFlowLogs.size() - 1) && workFlowLog.getOrderId() != null && (orderMain = this.orderMainApi.findById(orderId = workFlowLog.getOrderId())) != null) {
                    if (orderMain.getStatus().equals("6")) {
                        reason = reason + "  \u91c7\u8d2d\u5458\u5df2\u53d6\u6d88\u8ba2\u5355 ";
                        dateStr = format.format(orderMain.getLastUpdated());
                    } else if (orderMain.getStatus().equals("8")) {
                        reason = reason + "  \u5ba1\u6838\u8d85\u8fc77\u5929\uff0c\u7cfb\u7edf\u5df2\u53d6\u6d88\u8ba2\u5355 ";
                        dateStr = format.format(orderMain.getLastUpdated());
                    }
                }
                String style = "";
                if (!dateStr.equals("")) {
                    // empty if block
                }
                if (wholeFlowLog.size() - step - 1 >= 0) {
                    WorkFlowNodeVo node = (WorkFlowNodeVo)wholeFlowLog.get(wholeFlowLog.size() - step - 1);
                    node.setRemark(" <div style=' " + style + " '>" + dateStr + node.getRemark() + " " + reason + "</div>");
                }
                ++step;
            }
            wholeFlowStrLog = Lang.grepList(wholeFlowLog, (String)"remark", (Object)"");
            steps.put("wholeFlowStep", wholeFlowStrLog);
            steps.put("currentStep", step);
            flowSteps.add(steps);
            Collections.reverse(flowSteps);
        }
        return flowSteps;
    }

    public List<ImageVo> getOrderUploadFiles(String orderNo) {
        BaseResponse baseResponse = this.biddingOrderQueryApi.queryBiddingOrderNoByMallOrderNo(orderNo);
        BaseResponse mallOrderAttachmentsResponse = this.mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(baseResponse.getResult().toString(), MallAttachmentBusinessCode.OPERATIVEBUY_ATTACH_BUSCODE.getValue());
        List mallAttachmentDtoList = (List)mallOrderAttachmentsResponse.getResult();
        ArrayList<ImageVo> imageVos = new ArrayList<ImageVo>();
        if (mallAttachmentDtoList != null && !mallAttachmentDtoList.isEmpty()) {
            mallAttachmentDtoList.forEach(mallAttachmentDto -> {
                ImageVo imageVo = new ImageVo();
                imageVo.setFilePath(mallAttachmentDto.getPath());
                imageVo.setSourceName(mallAttachmentDto.getAttachmentName());
                imageVos.add(imageVo);
            });
        }
        return imageVos;
    }

    public OrderAuditInfoVo getBusinessWorkFlowInfo(String orderNo, String userId) {
        BaseResponse baseResponse = this.biddingOrderQueryApi.queryBiddingOrderNoByMallOrderNo(orderNo);
        WorkFlowInfoQuery workFlowInfoQuery = new WorkFlowInfoQuery();
        workFlowInfoQuery.setBusinessCode(AuditBusinessCode.BIDDING_ORDER_AUDIT.getBusinessCode());
        workFlowInfoQuery.setBusinessNo(baseResponse.getResult().toString());
        List compDepartUserDtos = this.coreCompDepartUserApi.findByUserId(userId);
        ArrayList workerIds = new ArrayList();
        compDepartUserDtos.forEach(coreCompDepartUserDto -> workerIds.add(coreCompDepartUserDto.getId()));
        OrderAuditInfoDto auditInfoDto = this.workFlowQueryApi.findByOrderAuditInfo(workFlowInfoQuery);
        if (auditInfoDto != null) {
            return (OrderAuditInfoVo)BeanMapper.map((Object)auditInfoDto, OrderAuditInfoVo.class);
        }
        return null;
    }

    public BiddingOrderInfoDto getOrderInfoByOrderNo(String orderNo) {
        return this.biddingMallOrderQueryApi.getOrderInfoByOrderNo(orderNo);
    }

    public List<JcbdRoleOperationDto> getOpertionByStatus(String status) {
        List operationDtos = this.biddingRoleOperationQueryApi.findByRoleCodeAndStatusAndModuleOrderByShowIndex("BIDDING_OPERATOR", status, StatusOperateModule.BIDDING_ORDER_MANAGE.getCode());
        return operationDtos;
    }

    public List<JcbdRoleOperationDto> getSuperlierOpertionByStatus(String status) {
        List operationDtos = this.biddingRoleOperationQueryApi.findByRoleCodeAndStatusAndModuleOrderByShowIndex("BIDDING_SUPPLIER", status, StatusOperateModule.BIDDING_MANAGE_SUPPLIER.getCode());
        return operationDtos;
    }

    public void cancelPurchaseLogOrder(String orderNo) {
        this.biddingMallOrderQueryApi.cancelPurchaseLogOrder(orderNo);
    }
}

