/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.query.BiddingDemandApi;
import api.query.BiddingMallOrderQueryApi;
import api.query.BiddingOrderManagerApi;
import api.query.BiddingOrderQueryApi;
import api.query.BiddingOrderResultApi;
import api.query.BiddingPurchaseLogApi;
import bidding.web.service.BiddingOrderResultService;
import bidding.web.vo.BiddingOrderResultInfoVo;
import cart.api.OrderItemApi;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOrderStatus;
import dto.BiddingOrderResultDto;
import dto.JcbdBiddingOrderItemDto;
import dto.JcbdMallOrderDto;
import dto.JcbdOrderDto;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import query.BiddingOrderResultListQuery;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;

@Service
public class BiddingOrderResultServiceImpl
implements BiddingOrderResultService {
    public static final Logger log = LoggerFactory.getLogger(BiddingOrderResultServiceImpl.class);
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    BiddingDemandApi biddingDemandApi;
    @MotanReferer
    BiddingPurchaseLogApi biddingPurchaseLogApi;
    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;
    @MotanReferer
    BiddingOrderResultApi biddingOrderResultApi;
    @MotanReferer
    BiddingOrderManagerApi biddingOrderManagerApi;
    @MotanReferer
    OrderItemApi orderItemApi;
    @MotanReferer
    OrderMainApi orderMainApi;

    public Map getBiddingOrderResultList(JqueryDataTablesVo jqueryDataTablesVo, BiddingOrderResultListQuery biddingOrderResultListQuery, Pageable pageable) {
        HashMap<String, Object> returnModel = new HashMap<String, Object>(16);
        Long totalElement = 0L;
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page page = this.biddingOrderResultApi.getBiddingOrderResultList(biddingOrderResultListQuery, pageable);
        List contentList = page.getContent();
        for (BiddingOrderResultDto biddingOrderResultDto : contentList) {
            BigDecimal count = BigDecimal.ZERO;
            List itemDtoList = this.orderItemApi.findByOrderNo(biddingOrderResultDto.getOrderNo());
            if (itemDtoList != null) {
                for (OrderItemDto orderItemDto : itemDtoList) {
                    count = count.add(BigDecimal.valueOf(orderItemDto.getCount().intValue()));
                }
            }
            biddingOrderResultDto.setGoodsNumber(count);
            BigDecimal singleAmount = BigDecimal.ZERO;
            OrderMainDto orderMainDto = this.orderMainApi.findByOrderNo(biddingOrderResultDto.getOrderNo());
            if (orderMainDto != null) {
                singleAmount = orderMainDto.getSumPrice();
            }
            biddingOrderResultDto.setSingleAmount(singleAmount);
        }
        totalElement = page.getTotalElements();
        returnModel.put("aaData", page.getContent());
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public BiddingOrderResultInfoVo getPurchaseResult(String biddingCode) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalNum = BigDecimal.ZERO;
        BigDecimal totalSingular = BigDecimal.ZERO;
        Integer singularNumber = 0;
        Integer cancelOrder = 0;
        Integer noSingularNumber = 0;
        if (!Lang.isEmpty((Object)biddingCode)) {
            List jcbdOrderDtos = this.biddingOrderQueryApi.findByJcbdBiddingId(biddingCode);
            for (JcbdOrderDto jcbdOrderDto : jcbdOrderDtos) {
                List jcbdMallOrders = jcbdOrderDto.getJcbdMallOrders();
                for (JcbdMallOrderDto jcbdMallOrder : jcbdMallOrders) {
                    if (!(jcbdMallOrder.getIsDelete().booleanValue() || jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode()) || jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_AUDITFAILURE.getCode()))) {
                        if (jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_COMPLETED.getCode()) || jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_HAVEGOODS.getCode())) {
                            singularNumber = singularNumber + 1;
                        }
                        if (jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_TOBECONFIRMED.getCode())) {
                            noSingularNumber = noSingularNumber + 1;
                        }
                        totalAmount = totalAmount.add(jcbdOrderDto.getTotalMoney());
                        totalSingular = totalSingular.add(BigDecimal.valueOf(1L));
                        List orderItems = jcbdMallOrder.getJcbdBiddingOrderItems();
                        for (JcbdBiddingOrderItemDto orderItem : orderItems) {
                            totalNum = totalNum.add(BigDecimal.valueOf(orderItem.getCount().intValue()));
                        }
                    }
                    if (jcbdMallOrder.getIsDelete().booleanValue() || !jcbdMallOrder.getStatus().equals(BiddingOrderStatus.ORDER_STATUS_HAVEBEENCANCELLED.getCode())) continue;
                    cancelOrder = cancelOrder + 1;
                }
            }
        }
        return new BiddingOrderResultInfoVo(totalAmount, totalNum, totalSingular, singularNumber, noSingularNumber, cancelOrder);
    }
}

