/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.BiddingLogApi;
import api.BiddingMainApi;
import api.BiddingResponseApi;
import api.query.BiddingDemandApi;
import api.query.BiddingMainQueryApi;
import api.query.BiddingMallOrderQueryApi;
import api.query.BiddingOrderQueryApi;
import api.query.BiddingResponseQueryApi;
import api.query.BiddingRoleOperationQueryApi;
import api.query.MallAttachmentQueryApi;
import bidding.web.service.BiddingProviderService;
import bidding.web.service.impl.BiddingOperatorServiceImpl;
import bidding.web.vo.BiddingBaseInfoVo;
import bidding.web.vo.BiddingDemandResponseVo;
import bidding.web.vo.BiddingDemandVo;
import bidding.web.vo.BiddingOrderInfoVo;
import bidding.web.vo.BiddingOrderResultItemVo;
import bidding.web.vo.BiddingResponseListVo;
import bidding.web.vo.BiddingStatusVo;
import bidding.web.vo.BiddingSupplierResposeListVo;
import bidding.web.vo.DemandResponseQueryVo;
import bidding.web.vo.JcbdProviderAddressResponseVo;
import bidding.web.vo.JcbdProviderConformanceRespVo;
import bidding.web.vo.JcbdRoleOperationVo;
import bidding.web.vo.MallAttachmentVo;
import bidding.web.vo.QueryBiddingRequestVO;
import bidding.web.vo.SupplierBiddingResponseVo;
import bidding.web.vo.UpdateSkuVo;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.vo.TempOrderItemVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOperateCode;
import definition.BiddingOrderStatus;
import definition.BiddingRoleStatus;
import definition.BiddingStatus;
import definition.MailTemplateEnum;
import definition.MallAttachmentBusinessCode;
import dto.BiddingChangeStateDto;
import dto.BiddingResponseDemandOutlineDto;
import dto.BiddingStateResponseDto;
import dto.BiddingSupplierChangeStateDto;
import dto.DemanResponseParmDto;
import dto.JcbdBdProviderDto;
import dto.JcbdBiddingDemandDto;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdBiddingDto;
import dto.JcbdBiddingOperationLogDto;
import dto.JcbdBiddingQueryDto;
import dto.JcbdBiddingQueryResultDto;
import dto.JcbdMallOrderDto;
import dto.JcbdOrderDto;
import dto.JcbdProviderAddressResponseDto;
import dto.JcbdProviderConformanceRespDto;
import dto.MallAttachmentDto;
import dto.SupplierBiddingResponseDto;
import dto.UpdateSkuDto;
import goods.api.GoodsApi;
import goods.dto.goods.SkuAndUrlDto;
import goods.dto.goods.ValidationSkuEffDto;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import message.MailModule;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.mail.vo.MailTemplateReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.HandlerRespVo;
import query.BiddingDemandRespQuery;
import query.SupplierBiddingDamandQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import store.api.dto.modeldto.core.StoreDto;
import uninogift.api.protocol.TpCloudShieldApi;
import uninogift.api.protocol.TpCloudVerifyLogApi;
import uninogift.vo.protocol.outside.SignQrCodeDto;
import uninogift.vo.protocol.outside.TpCloudAccTokenResponse;
import uninogift.vo.protocol.outside.TpCloudQrCodeResponse;
import uninogift.vo.protocol.outside.TpCloudSignResultResponse;
import uninogift.vo.protocol.outside.TpCloudVerifyLogDto;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.web.ResponseMapUtils;

@Service
public class BiddingProviderServiceImpl
implements BiddingProviderService,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(BiddingProviderServiceImpl.class);
    static final String RESPONSE_END = "1";
    static final String RESPONSE_NOT_ACCORD = "2";
    public static final String BIDDING_SUPPLIER_TITILE_SHOW_MODULE = "BiddingSupplierShow";
    @MotanReferer
    BiddingRoleOperationQueryApi biddingRoleOperationQueryApi;
    @MotanReferer
    BiddingMainQueryApi biddingMainQueryApi;
    @MotanReferer
    BiddingMainApi biddingMainApi;
    @MotanReferer
    BiddingDemandApi biddingDemandApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    BiddingResponseQueryApi biddingResponseQueryApi;
    @MotanReferer
    BiddingResponseApi biddingResponseApi;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    BiddingLogApi biddingLogApi;
    @MotanReferer
    OutsideProductApi outsideProductApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    MailApi mailApi;
    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;
    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @Autowired
    BiddingOperatorServiceImpl biddingOperatorService;
    @MotanReferer
    TpCloudShieldApi tpCloudShieldApi;
    @MotanReferer
    TpCloudVerifyLogApi tpCloudVerifyLogApi;
    @Value(value="${spring.mail.username}")
    String mailFrom;
    @Value(value="${organization.code}")
    private String organiztionCode;
    ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();

    public BiddingProviderServiceImpl() {
        this.threadPoolTaskExecutor.setCorePoolSize(10);
        this.threadPoolTaskExecutor.setMaxPoolSize(100);
        this.threadPoolTaskExecutor.setQueueCapacity(2000);
        this.threadPoolTaskExecutor.setKeepAliveSeconds(60);
        this.threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    public Map querryPageBidding(JqueryDataTablesVo jqueryDataTablesVo, String biddingMemberId, List<String> biddingMemberRoles, QueryBiddingRequestVO queryBiddingRequestVO) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        JcbdBiddingQueryDto biddingQueryDto = new JcbdBiddingQueryDto();
        biddingQueryDto.setJcbdBiddingNo(queryBiddingRequestVO.getJcbdBiddingNo());
        biddingQueryDto.setDescribe(queryBiddingRequestVO.getJcbdBiddingDescribe());
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getState())) {
            if (BiddingStatus.SUPPLIER_RESPONSED.getValue().equals(queryBiddingRequestVO.getState())) {
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.SUPPLIER_RESPONSE_YES.getValue(), BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue()));
            } else if (BiddingStatus.SUPPLIER_AUDIT_IN.getValue().equals(queryBiddingRequestVO.getState())) {
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.SUPPLIER_AUDIT_IN_NOT.getValue(), BiddingStatus.SUPPLIER_AUDIT_IN_YES.getValue()));
            } else if (BiddingStatus.SUPPLIER_BIDDING_DONE.equals((Object)queryBiddingRequestVO.getState())) {
                biddingQueryDto.setStates(Arrays.asList(BiddingStatus.SUPPLIER_BIDDING_YES.getValue(), BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue()));
            } else {
                biddingQueryDto.setStates(Arrays.asList(queryBiddingRequestVO.getState()));
            }
        }
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getStartTime())) {
            biddingQueryDto.setStartTime(DateUtils.toDate((String)queryBiddingRequestVO.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getEndTime())) {
            biddingQueryDto.setEndTime(DateUtils.toDate((String)queryBiddingRequestVO.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getStartTime2())) {
            biddingQueryDto.setStartTime2(DateUtils.toDate((String)queryBiddingRequestVO.getStartTime2(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (!Lang.isEmpty((Object)queryBiddingRequestVO.getEndTime2())) {
            biddingQueryDto.setEndTime2(DateUtils.toDate((String)queryBiddingRequestVO.getEndTime2(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        biddingQueryDto.setRoles(biddingMemberRoles);
        biddingQueryDto.setProviderId(biddingMemberId);
        biddingQueryDto.setPageable((Pageable)pageable);
        Long totalElement = 0L;
        Page page = this.biddingMainQueryApi.supplierFindJcbdBiddingByParams(biddingQueryDto);
        ArrayList<BiddingResponseListVo> biddingResponseListVos = new ArrayList<BiddingResponseListVo>();
        if (!Lang.isEmpty((Object)page)) {
            for (JcbdBiddingQueryResultDto jcbdBiddingQueryResultDto : page.getContent()) {
                BiddingResponseListVo biddingResponseListVo = new BiddingResponseListVo();
                this.mapperFacade.map((Object)jcbdBiddingQueryResultDto, (Object)biddingResponseListVo);
                biddingResponseListVo.setStateName(((BiddingStatus)BiddingStatus.biddingStatusMap.get(jcbdBiddingQueryResultDto.getState())).getDescription());
                biddingResponseListVo.setStartTime(DateUtils.toString((Date)jcbdBiddingQueryResultDto.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                biddingResponseListVo.setEndTime(DateUtils.toString((Date)jcbdBiddingQueryResultDto.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (!Lang.isEmpty((Object)jcbdBiddingQueryResultDto.getOperations())) {
                    biddingResponseListVo.setOperations(this.mapperFacade.mapAsList((Iterable)jcbdBiddingQueryResultDto.getOperations(), JcbdRoleOperationVo.class));
                }
                biddingResponseListVos.add(biddingResponseListVo);
            }
            totalElement = page.getTotalElements();
        }
        returnModel.put("aaData", biddingResponseListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public List<BiddingStatusVo> getAllStatusByRoles(List<String> biddingMemberRoles) {
        ArrayList<BiddingStatusVo> biddingStatusVos = new ArrayList<BiddingStatusVo>();
        if (biddingMemberRoles.contains("BIDDING_SUPPLIER")) {
            Map stringBiddingStatusMap = (Map)BiddingRoleStatus.biddingRoleStatus.get("BIDDING_SUPPLIER");
            Set strings = stringBiddingStatusMap.keySet();
            strings.forEach(key -> {
                BiddingStatusVo biddingStatusVo = new BiddingStatusVo();
                biddingStatusVo.setStatus(key);
                biddingStatusVo.setStatusName(((BiddingStatus)stringBiddingStatusMap.get(key)).getDescription());
                biddingStatusVos.add(biddingStatusVo);
            });
        }
        return biddingStatusVos;
    }

    public BiddingBaseInfoVo getBiddingDetail(String biddingCode) {
        BiddingBaseInfoVo biddingBaseInfoVo = new BiddingBaseInfoVo();
        BaseResponse biddingDtoBaseResponse = this.biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
        JcbdBiddingDto jcbdBiddingDto = (JcbdBiddingDto)biddingDtoBaseResponse.getResult();
        MemberVo memberInfo = this.memberApi.getMemberInfo(jcbdBiddingDto.getOperatorId());
        biddingBaseInfoVo.setId(jcbdBiddingDto.getId());
        biddingBaseInfoVo.setBiddingCode(jcbdBiddingDto.getBiddingCode());
        biddingBaseInfoVo.setStartTime(DateUtils.toString((Date)jcbdBiddingDto.getTimeStartResponse(), (String)"yyyy-MM-dd HH:mm:ss"));
        biddingBaseInfoVo.setEndTime(DateUtils.toString((Date)jcbdBiddingDto.getTimeEndResponse(), (String)"yyyy-MM-dd HH:mm:ss"));
        biddingBaseInfoVo.setUsername(memberInfo.getUser().getUsername());
        biddingBaseInfoVo.setPhone(memberInfo.getUser().getPhone());
        biddingBaseInfoVo.setEmail(memberInfo.getUser().getEmail());
        return biddingBaseInfoVo;
    }

    public Map querryPageBiddingDemand(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, String supplierId) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "demandCode"), new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        SupplierBiddingDamandQuery supplierBiddingDamandQuery = new SupplierBiddingDamandQuery();
        supplierBiddingDamandQuery.setBiddingCode(biddingCode);
        supplierBiddingDamandQuery.setSupplierId(supplierId);
        supplierBiddingDamandQuery.setPageable((Pageable)pageable);
        BaseResponse pageBaseResponse = this.biddingResponseQueryApi.supplierBiddingResponseDemandOutline(supplierBiddingDamandQuery);
        if (!pageBaseResponse.isSuccess()) {
            return ResponseMapUtils.error((String)pageBaseResponse.getResultMessage());
        }
        Page page = (Page)pageBaseResponse.getResult();
        ArrayList<BiddingSupplierResposeListVo> supplierResposeListVos = new ArrayList<BiddingSupplierResposeListVo>();
        Long totalElement = 0L;
        if (!Lang.isEmpty((Object)page.getContent())) {
            for (BiddingResponseDemandOutlineDto biddingDemandOutlineDto : page.getContent()) {
                BiddingSupplierResposeListVo resposeListVo = (BiddingSupplierResposeListVo)this.mapperFacade.map((Object)biddingDemandOutlineDto, BiddingSupplierResposeListVo.class);
                if (!Lang.isEmpty((Object)biddingDemandOutlineDto.getRequiredDeliveryDate())) {
                    resposeListVo.setRequiredDeliveryDateTime(DateUtils.dateToStr((Date)biddingDemandOutlineDto.getRequiredDeliveryDate(), (String)"yyyy-MM-dd"));
                }
                supplierResposeListVos.add(resposeListVo);
            }
            totalElement = page.getTotalElements();
        }
        returnModel.put("aaData", supplierResposeListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return ResponseMapUtils.success(returnModel);
    }

    public BiddingDemandResponseVo getBiddingDemadDetail(String supplierId, String demandCode, String biddingNo) {
        BiddingDemandRespQuery biddingDemandRespQuery = new BiddingDemandRespQuery();
        biddingDemandRespQuery.setBiddingNo(biddingNo);
        biddingDemandRespQuery.setSupplierId(supplierId);
        biddingDemandRespQuery.setDemandCode(demandCode);
        BaseResponse biddingDemandResponseDtoResponse = this.biddingResponseQueryApi.queryBiddingDemandResponse(biddingDemandRespQuery);
        if (!biddingDemandResponseDtoResponse.isSuccess()) {
            log.info("\u7ade\u4ef7\u7f16\u53f7\uff1a{}\u9700\u6c42\u7f16\u53f7\uff1a{}\u4f9b\u5e94\u5546id\uff1a{}\u83b7\u53d6\u9700\u6c42\u54cd\u5e94\u5931\u8d25\uff1a{}", new Object[]{biddingNo, demandCode, supplierId, biddingDemandResponseDtoResponse.getResultMessage()});
            return null;
        }
        JcbdBiddingDemandResponseDto demandResponseDto = (JcbdBiddingDemandResponseDto)biddingDemandResponseDtoResponse.getResult();
        BiddingDemandResponseVo demandResponseVo = new BiddingDemandResponseVo();
        if (!Lang.isEmpty((Object)demandResponseDto)) {
            BaseResponse bidbaseBaseResponse;
            demandResponseVo = (BiddingDemandResponseVo)this.mapperFacade.map((Object)demandResponseDto, BiddingDemandResponseVo.class);
            BiddingDemandVo demandVo = new BiddingDemandVo();
            if (!Lang.isEmpty((Object)demandResponseDto.getOfferValidity())) {
                demandResponseVo.setOfferValidityTime(DateUtils.dateToStr((Date)demandResponseDto.getOfferValidity(), (String)"yyyy-MM-dd"));
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdBiddingDemand())) {
                demandVo = (BiddingDemandVo)this.mapperFacade.map((Object)demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
                if (!Lang.isEmpty((Object)demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery())) {
                    demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr((Date)demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery(), (String)"yyyy-MM-dd"));
                }
            }
            demandResponseVo.setBiddingDemand(demandVo);
            if (!Lang.isEmpty((Object)demandResponseDto.getId()) && (bidbaseBaseResponse = this.mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(demandResponseDto.getId(), MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue())).isSuccess() && !Lang.isEmpty((Object)bidbaseBaseResponse.getResult())) {
                demandResponseVo.setAttachment(BeanMapper.mapList((Iterable)((Iterable)bidbaseBaseResponse.getResult()), MallAttachmentDto.class, MallAttachmentVo.class));
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdProviderAddressResponses())) {
                demandResponseVo.setProviderAddressResponses(this.mapperFacade.mapAsList((Iterable)demandResponseDto.getJcbdProviderAddressResponses(), JcbdProviderAddressResponseVo.class));
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdProviderConformanceResps())) {
                demandResponseVo.setProviderConformanceResps(this.mapperFacade.mapAsList((Iterable)demandResponseDto.getJcbdProviderConformanceResps(), JcbdProviderConformanceRespVo.class));
            }
        }
        return demandResponseVo;
    }

    public Map saveBiddingDemadResp(BiddingDemandResponseVo biddingDemandResponseVo, String supplierId) {
        BiddingDemandVo biddingDemand = biddingDemandResponseVo.getBiddingDemand();
        if (Lang.isEmpty((Object)biddingDemand.getBiddingId())) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u5931\u8d25");
        }
        if (Lang.isEmpty((Object)biddingDemand.getDemandCode())) {
            return ResponseMapUtils.error((String)"\u83b7\u53d6\u7ade\u4ef7\u9700\u6c42\u5931\u8d25");
        }
        BaseResponse biddingDtoResponse = this.biddingMainQueryApi.findOne(biddingDemand.getBiddingId());
        if (!biddingDtoResponse.isSuccess()) {
            return ResponseMapUtils.error((String)"\u65e0\u6b64\u7ade\u4ef7");
        }
        if (System.currentTimeMillis() > ((JcbdBiddingDto)biddingDtoResponse.getResult()).getTimeEndResponse().getTime()) {
            return ResponseMapUtils.error((String)"\u7ade\u4ef7\u5df2\u7ecf\u7ed3\u675f\u54cd\u5e94\uff0c\u4e0d\u53ef\u54cd\u5e94", (String)RESPONSE_END);
        }
        JcbdBiddingDemandResponseDto demandResponseDto = (JcbdBiddingDemandResponseDto)this.mapperFacade.map((Object)biddingDemandResponseVo, JcbdBiddingDemandResponseDto.class);
        demandResponseDto.setStoreId(supplierId);
        demandResponseDto.setJcbdBiddingDemand((JcbdBiddingDemandDto)this.mapperFacade.map((Object)biddingDemand, JcbdBiddingDemandDto.class));
        if (!Lang.isEmpty((Object)biddingDemandResponseVo.getAttachment())) {
            List mallAttachmentDtos = this.mapperFacade.mapAsList((Iterable)biddingDemandResponseVo.getAttachment(), MallAttachmentDto.class);
            mallAttachmentDtos.forEach(mallAttachmentDto -> {
                mallAttachmentDto.setOrganizationCode("jicai");
                mallAttachmentDto.setBusinessCode(MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue());
                mallAttachmentDto.setBusinessDescription(BiddingOperateCode.RESPOND_BIDDING.getCodeName());
            });
            demandResponseDto.setAttachment(mallAttachmentDtos);
        }
        demandResponseDto.setJcbdProviderAddressResponses(this.mapperFacade.mapAsList((Iterable)biddingDemandResponseVo.getProviderAddressResponses(), JcbdProviderAddressResponseDto.class));
        demandResponseDto.setJcbdProviderConformanceResps(this.mapperFacade.mapAsList((Iterable)biddingDemandResponseVo.getProviderConformanceResps(), JcbdProviderConformanceRespDto.class));
        BaseResponse response = this.biddingResponseApi.updateBiddingDemandResponse(demandResponseDto);
        if (!response.isSuccess()) {
            return ResponseMapUtils.error((String)"\u4fdd\u5b58\u9700\u6c42\u54cd\u5e94\u5931\u8d25");
        }
        return ResponseMapUtils.success((Object)"");
    }

    public Map checkIsAllRespond(String biddingCode, String supplierId) {
        BaseResponse baseResponse = this.biddingResponseQueryApi.isAllDemandAreResponse(biddingCode, supplierId);
        if (baseResponse.isSuccess()) {
            return ResponseMapUtils.success((Object)"");
        }
        return ResponseMapUtils.error((String)"\u60a8\u8fd8\u6709\u672a\u54cd\u5e94\u7684\u9700\u6c42\uff0c\u65e0\u6cd5\u63d0\u4ea4\u54cd\u5e94\uff01");
    }

    public Map checkDemadIsAllAccord(String biddingCode, String supplierId) {
        JcbdBdProviderDto provider = this.biddingMainQueryApi.getProvider(biddingCode, supplierId);
        if (Lang.isEmpty((Object)provider)) {
            return ResponseMapUtils.error((String)"\u65e0\u6b64\u4f9b\u5e94\u5546");
        }
        BaseResponse baseResponse = this.biddingResponseQueryApi.demandResponseIsAllAccord(biddingCode, provider.getId());
        if (baseResponse.isSuccess()) {
            return ResponseMapUtils.success((Object)"");
        }
        return ResponseMapUtils.error((String)"\u9700\u6c42\u4e2d\u7684\u8981\u6c42\uff0c\u60a8\u52fe\u9009\u4e86\u65e0\u6cd5\u6ee1\u8db3\uff0c\u8fd9\u5c06\u9020\u6210\u60a8\u7ade\u4ef7\u7ed3\u679c\u5931\u8d25\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f", (String)RESPONSE_NOT_ACCORD);
    }

    public Map submitResp(SupplierBiddingResponseVo supplierBiddingResponseVo, String userId, String supplierId) {
        BaseResponse biddingResponse;
        BaseResponse biddingDtoResponse = this.biddingMainQueryApi.getBiddingByBiddingCode(supplierBiddingResponseVo.getJcbdBiddingNo());
        if (!biddingDtoResponse.isSuccess()) {
            return ResponseMapUtils.error((String)biddingDtoResponse.getResultMessage());
        }
        if (System.currentTimeMillis() > ((JcbdBiddingDto)biddingDtoResponse.getResult()).getTimeEndResponse().getTime()) {
            this.biddingMainApi.biddingResponseFinishValidate(((JcbdBiddingDto)biddingDtoResponse.getResult()).getBiddingCode());
            return ResponseMapUtils.error((String)"\u7ade\u4ef7\u5df2\u7ecf\u7ed3\u675f\u54cd\u5e94\uff0c\u4e0d\u53ef\u54cd\u5e94", (String)RESPONSE_END);
        }
        supplierBiddingResponseVo.setProviderId(supplierId);
        supplierBiddingResponseVo.setContactsId(userId);
        SupplierBiddingResponseDto biddingResponseDto = (SupplierBiddingResponseDto)this.mapperFacade.map((Object)supplierBiddingResponseVo, SupplierBiddingResponseDto.class);
        if (!Lang.isEmpty((Object)supplierBiddingResponseVo.getOfferValidityTime())) {
            biddingResponseDto.setOfferValidity(DateUtils.strToDate((String)supplierBiddingResponseVo.getOfferValidityTime(), (String)"yyyy-MM-dd"));
        }
        if ((biddingResponse = this.biddingResponseApi.supplierBiddingResponse(biddingResponseDto)).isSuccess()) {
            TpCloudVerifyLogDto tpCloudVerifyLogDto = new TpCloudVerifyLogDto();
            tpCloudVerifyLogDto.setOperateType("\u63d0\u4ea4\u54cd\u5e94");
            tpCloudVerifyLogDto.setSignValue(supplierBiddingResponseVo.getSignValue());
            tpCloudVerifyLogDto.setSource("bidding");
            tpCloudVerifyLogDto.setUserId(supplierId);
            tpCloudVerifyLogDto.setBusinessCode(supplierBiddingResponseVo.getJcbdBiddingNo());
            this.tpCloudVerifyLogApi.saveTpCloudVerifyLog(tpCloudVerifyLogDto);
            return ResponseMapUtils.success((Object)"");
        }
        return ResponseMapUtils.error((String)biddingResponse.getResultMessage());
    }

    public BaseResponse confirmOrder(String mallOrderNo) {
        String orderMainNo = null;
        try {
            long mallOrderTime = System.currentTimeMillis();
            JcbdMallOrderDto mallOrder = this.biddingMallOrderQueryApi.findByOrderNo(mallOrderNo);
            log.info("\u67e5\u8be2 MallOrder \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - mallOrderTime));
            if (Lang.isEmpty((Object)mallOrder)) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u4f9b\u5e94\u5546\u8ba2\u5355\u6570\u636e\u65e0\u6548", (Object)mallOrderNo);
                return new BaseResponse("\u8ba2\u5355\u6570\u636e\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + mallOrderNo);
            }
            orderMainNo = mallOrder.getOrderNo();
            if (Lang.isEmpty((Object)orderMainNo)) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u4f9b\u5e94\u5546\u8ba2\u5355\u8ba2\u5355\u53f7\u4e3a\u7a7a", (Object)mallOrderNo);
                return new BaseResponse("\u8ba2\u5355\u6570\u636e\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + mallOrderNo);
            }
            if (!BiddingOrderStatus.SUPPLIER_ORDER_STATUS_TOBECONFIRMED.getCode().equals(mallOrder.getSupplierOrderStatus())) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u4f9b\u5e94\u5546\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u786e\u8ba4", (Object)orderMainNo);
                return new BaseResponse("\u8ba2\u5355\u72b6\u6001\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + orderMainNo);
            }
            JcbdOrderDto order = this.biddingOrderQueryApi.findById(mallOrder.getJdbdOrderId());
            if (Lang.isEmpty((Object)order)) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u7ade\u4ef7\u8ba2\u5355 Order \u6570\u636e\u4e3a\u7a7a", (Object)orderMainNo);
                return new BaseResponse("\u8ba2\u5355\u6570\u636e\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + orderMainNo);
            }
            String biddingCode = order.getJcbdBidding().getBiddingCode();
            if (Lang.isEmpty((Object)biddingCode)) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u4f9b\u5e94\u5546\u8ba2\u5355\u5bf9\u5e94\u7684\u7ade\u4ef7\u7f16\u53f7\u4e3a\u7a7a", (Object)orderMainNo);
                return new BaseResponse("\u8ba2\u5355\u6570\u636e\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + orderMainNo);
            }
            String storeId = mallOrder.getProviderId();
            if (Lang.isEmpty((Object)storeId)) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u4f9b\u5e94\u5546\u8ba2\u5355\u5bf9\u5e94\u7684\u5e97\u94faID\u4e3a\u7a7a", (Object)orderMainNo);
                return new BaseResponse("\u8ba2\u5355\u6570\u636e\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + orderMainNo);
            }
            OrderMainDto orderMain = this.orderMainApi.findByOrderNo(orderMainNo);
            List orderItems = orderMain.getOrderItems();
            if (Lang.isEmpty((Object)orderItems)) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u8ba2\u5355 OrderItem \u6570\u636e\u4e3a\u7a7a", (Object)orderMainNo);
                return new BaseResponse("\u8ba2\u5355\u6570\u636e\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + orderMainNo);
            }
            if (orderItems.stream().filter(orderItem -> Lang.isEmpty((Object)orderItem.getSku())).collect(Collectors.toList()).size() > 0) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, {} \u8ba2\u5355 OrderItem \u4e2d sku \u4e3a\u7a7a", (Object)orderMainNo);
                return new BaseResponse("\u8ba2\u5355\u6570\u636e\u6709\u8bef, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + orderMainNo);
            }
            ArrayList fashionPriceParamVos = new ArrayList();
            orderItems.forEach(n -> {
                FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
                fashionPriceParamVo.setFactionId(n.getProductFashId());
                fashionPriceParamVo.setProductCode(n.getSku());
                fashionPriceParamVos.add(fashionPriceParamVo);
            });
            FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
            long addressTime = System.currentTimeMillis();
            MemberAddressDto addressDto = this.memberAddressApi.findById(orderMain.getAddressId());
            log.info("\u67e5\u8be2\u8ba2\u5355\u5730\u5740\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - addressTime));
            fashionPriceRequestVo.setProvinceCode(addressDto.getProvinceCode());
            fashionPriceRequestVo.setCityCode(addressDto.getCityCode());
            fashionPriceRequestVo.setCountyCode(addressDto.getAreaCode());
            fashionPriceRequestVo.setTownCode(addressDto.getTownCode());
            fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);
            long queryFashionPriceTime = System.currentTimeMillis();
            HandlerRespVo listHandlerRespVo = this.outsideProductApi.queryFashionPrice(storeId, fashionPriceRequestVo);
            log.info("\u6279\u91cf\u67e5\u8be2\u7b2c\u4e09\u65b9\u4ef7\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionPriceTime));
            ArrayList difSkuList = new ArrayList();
            List fashionPriceVos = (List)listHandlerRespVo.getData();
            fashionPriceVos.forEach(m -> {
                for (OrderItemDto orderItemDto : orderItems) {
                    if (!m.getFashionId().equals(orderItemDto.getProductFashId())) continue;
                    if (m.getSalePrice().compareTo(orderItemDto.getSalePrice()) == 0) break;
                    difSkuList.add(orderItemDto.getSku());
                    break;
                }
            });
            if (difSkuList.size() > 0) {
                String message = "\u5546\u54c1 " + (String)difSkuList.get(0) + " \u552e\u4ef7\u4e0e\u62a5\u4ef7\u4e0d\u7b26, \u8bf7\u5148\u8c03\u6574\u5546\u54c1\u7684\u534f\u8bae\u4ef7\u683c\u540e\u518d\u786e\u8ba4\u8ba2\u5355 " + orderMainNo;
                log.info(message);
                BaseResponse baseResponse = new BaseResponse();
                baseResponse.setResultMessage(message);
                baseResponse.setResultCode("price");
                baseResponse.setResult((Object)orderMainNo);
                return new BaseResponse(message);
            }
            FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
            requetVo.setProvinceCode(addressDto.getProvinceCode());
            requetVo.setCityCode(addressDto.getCityCode());
            requetVo.setCountyCode(addressDto.getAreaCode());
            requetVo.setTownCode(addressDto.getTownCode());
            ArrayList fashionNums = new ArrayList();
            orderItems.forEach(m -> {
                FashionNumsVo fashionNumsVo = new FashionNumsVo(m.getProductFashId(), m.getSku(), new Long(m.getCount().intValue()));
                fashionNums.add(fashionNumsVo);
            });
            requetVo.setFashionNums(fashionNums);
            StoreDto store = new StoreDto();
            store.setId(storeId);
            long queryFashionStockStateTime = System.currentTimeMillis();
            HandlerRespVo fashionStockState = this.outsideProductApi.getFashionStockState(store, requetVo);
            log.info("\u6279\u91cf\u67e5\u8be2\u7b2c\u4e09\u65b9\u5e93\u5b58\u72b6\u6001\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - queryFashionStockStateTime));
            if (!HandlerRespVo.RESPONSE_STATUS_SUCCESS.equals(fashionStockState.getStatus())) {
                return new BaseResponse(fashionStockState.getMessage());
            }
            List data = (List)fashionStockState.getData();
            ArrayList noStockAreaList = new ArrayList();
            data.forEach(o -> {
                if (!o.getOnSale().booleanValue() || o.getStockFlag() != 1) {
                    difSkuList.add(o.getProductCode());
                    StringBuffer sb = new StringBuffer();
                    sb.append(addressDto.getProvinceName()).append(addressDto.getCityName()).append(!Lang.isEmpty((Object)addressDto.getAreaName()) ? addressDto.getAreaName() : "").append(!Lang.isEmpty((Object)addressDto.getTownName()) ? addressDto.getTownName() : "");
                    noStockAreaList.add(sb.toString());
                }
            });
            if (difSkuList.size() > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("\u5546\u54c1 ").append((String)difSkuList.get(0)).append(" \u5728 ").append((String)noStockAreaList.get(0)).append(" \u5730\u533a\u5e93\u5b58\u4e0d\u8db3, \u8bf7\u5148\u4fdd\u8bc1\u5e93\u5b58\u5145\u8db3\u540e\u518d\u786e\u8ba4\u8ba2\u5355 ").append(orderMainNo);
                return new BaseResponse(sb.toString());
            }
            ArrayList tempOrderItemVoList = new ArrayList();
            orderItems.forEach(p -> {
                TempOrderItemVo tempOrderItemVo = new TempOrderItemVo();
                tempOrderItemVo.setProductFashionId(p.getProductFashId());
                tempOrderItemVo.setCount(p.getCount());
                tempOrderItemVo.setProductCode(p.getSku());
                tempOrderItemVoList.add(tempOrderItemVo);
            });
            long shippingFeeTime = System.currentTimeMillis();
            BigDecimal shippingFee = this.orderMainApi.queryShippingFee(storeId, tempOrderItemVoList, orderMain.getAddressId());
            log.info("\u67e5\u8be2\u7b2c\u4e09\u65b9\u8d39\u7387\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - shippingFeeTime));
            if (shippingFee.compareTo(orderMain.getFreight()) != 0) {
                BigDecimal oldSumPrice = orderMain.getSumPrice();
                BigDecimal oldShippingFee = orderMain.getFreight();
                orderMain.setFreight(shippingFee);
                BigDecimal sumPrice = orderMain.getSumNofreightPrice().add(shippingFee);
                orderMain.setSumPrice(sumPrice);
                this.orderMainApi.save(orderMain);
                BiddingOrderInfoVo orderInfoVo = new BiddingOrderInfoVo();
                orderInfoVo.setOrderNo(orderMain.getOrderNo());
                orderInfoVo.setFreight(shippingFee.toString());
                orderInfoVo.setOrderAmount(sumPrice.toString());
                StringBuffer sb = new StringBuffer();
                sb.append("\u8fd0\u8d39\u5df2\u91cd\u65b0\u83b7\u53d6\uff0c\u8ba2\u5355\u91d1\u989d\u7531 ").append(oldSumPrice).append("\u5143\u53d8\u4e3a ").append(orderMain.getSumPrice()).append(" \u5143, \u8bf7\u786e\u8ba4\u8ba2\u5355 ").append(orderMainNo);
                long biddingTime = System.currentTimeMillis();
                BaseResponse biddingDtoResponse = this.biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
                log.info("\u67e5\u8be2\u7ade\u4ef7\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - biddingTime));
                this.sendSumPriceChangeMail((JcbdBiddingDto)biddingDtoResponse.getResult(), orderMain, oldSumPrice, oldShippingFee);
                return new BaseResponse(false, sb.toString(), (Object)orderInfoVo);
            }
            Map preOccupyStockMap = this.orderMainApi.occupyStock(orderMain);
            log.info("\u9884\u5360\u5e93\u5b58\u54cd\u5e94: {}", (Object)JSON.toJSONString((Object)preOccupyStockMap));
            if (!"success".equals(preOccupyStockMap.get("returnCode"))) {
                log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5931\u8d25, \u9884\u5360\u5e93\u5b58\u5931\u8d25: {}", (Object)JSON.toJSONString((Object)preOccupyStockMap));
                return new BaseResponse("\u9884\u5360\u5e93\u5b58\u5931\u8d25, \u8bf7\u786e\u8ba4\u8ba2\u5355 " + orderMainNo);
            }
            this.orderMainApi.confirmOrder(orderMain.getOrderNo());
            long updateOrderStatusTime = System.currentTimeMillis();
            this.biddingMallOrderQueryApi.updateStatusAndSupplierStatus(mallOrderNo, BiddingOrderStatus.ORDER_STATUS_TOBERECEIVED.getCode(), BiddingOrderStatus.SUPPLIER_ORDER_STATUS_CONFIRMED.getCode());
            log.info("\u66f4\u65b0 MallOrder \u72b6\u6001\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - updateOrderStatusTime));
            long biddingTime = System.currentTimeMillis();
            BaseResponse biddingDtoResponse = this.biddingMainQueryApi.getBiddingByBiddingCode(biddingCode);
            log.info("\u67e5\u8be2\u7ade\u4ef7\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - biddingTime));
            JcbdBiddingOperationLogDto logDto = new JcbdBiddingOperationLogDto();
            JcbdBiddingDto jcbdBiddingDto = (JcbdBiddingDto)biddingDtoResponse.getResult();
            logDto.setBiddingId(jcbdBiddingDto.getId());
            logDto.setOperationTime(new Date());
            logDto.setOperationContent("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355");
            logDto.setOperatorName(order.getSupplierName());
            this.biddingLogApi.saveBiddingOperationLog(logDto);
            return new BaseResponse(true, "\u786e\u8ba4\u8ba2\u5355" + orderMainNo + "\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new BaseResponse("\u786e\u8ba4\u8ba2\u5355 " + (orderMainNo != null ? orderMainNo : mallOrderNo) + "\u9047\u5230\u95ee\u9898, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public BaseResponse batchConfirmOrder(List<BiddingOrderResultItemVo> orderResultItemVoList, String storeId, String memberId) {
        BaseResponse response = new BaseResponse();
        List orderNoList = orderResultItemVoList.stream().map(BiddingOrderResultItemVo::getOrderNo).collect(Collectors.toList());
        String biddingCode = orderResultItemVoList.get(0).getBiddingCode();
        log.info("\u6279\u91cf\u786e\u8ba4\u7684\u8ba2\u5355\u53f7{}", (Object)orderNoList.toString());
        List orderMainDtoList = this.orderMainApi.findByOrderNos(orderNoList);
        ArrayList difSkuList = new ArrayList();
        ArrayList difOrderNoList = new ArrayList();
        ArrayList noStockAreaList = new ArrayList();
        ArrayList exceptionOrderNoList = new ArrayList();
        try {
            CountDownLatch countDownLatch = new CountDownLatch(orderMainDtoList.size());
            for (int i = 0; i < orderMainDtoList.size(); ++i) {
                OrderMainDto orderMainDto = (OrderMainDto)orderMainDtoList.get(i);
                List orderItems = orderMainDto.getOrderItems();
                this.threadPoolTaskExecutor.execute(() -> {
                    try {
                        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
                        ArrayList fashionPriceParamVos = new ArrayList();
                        orderItems.forEach(n -> {
                            FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
                            fashionPriceParamVo.setFactionId(n.getProductFashId());
                            fashionPriceParamVo.setProductCode(n.getSku());
                            fashionPriceParamVos.add(fashionPriceParamVo);
                        });
                        MemberAddressDto addressDto = this.memberAddressApi.findDtoByIdAndIsDelete(orderMainDto.getAddressId(), false);
                        fashionPriceRequestVo.setProvinceCode(addressDto.getProvinceCode());
                        fashionPriceRequestVo.setCityCode(addressDto.getCityCode());
                        fashionPriceRequestVo.setCountyCode(addressDto.getAreaCode());
                        fashionPriceRequestVo.setTownCode(addressDto.getTownCode());
                        fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);
                        HandlerRespVo listHandlerRespVo = this.outsideProductApi.queryFashionPrice(storeId, fashionPriceRequestVo);
                        List fashionPriceVos = (List)listHandlerRespVo.getData();
                        fashionPriceVos.forEach(m -> {
                            for (OrderItemDto orderItemDto : orderItems) {
                                if (!m.getFashionId().equals(orderItemDto.getProductFashId()) || m.getCostPrice().compareTo(orderItemDto.getCostPrice()) == 0) continue;
                                difSkuList.add(orderItemDto.getSku());
                                difOrderNoList.add(orderMainDto.getOrderNo());
                            }
                        });
                        FashionStatusRequetVo requetVo = new FashionStatusRequetVo();
                        requetVo.setProvinceCode(addressDto.getProvinceCode());
                        requetVo.setCityCode(addressDto.getCityCode());
                        requetVo.setCountyCode(addressDto.getAreaCode());
                        requetVo.setTownCode(addressDto.getTownCode());
                        ArrayList fashionNums = new ArrayList();
                        orderItems.forEach(m -> {
                            FashionNumsVo fashionNumsVo = new FashionNumsVo(m.getProductFashId(), m.getSku(), new Long(m.getCount().intValue()));
                            fashionNums.add(fashionNumsVo);
                        });
                        requetVo.setFashionNums(fashionNums);
                        StoreDto storeDto = new StoreDto();
                        storeDto.setId(orderMainDto.getStoreId());
                        HandlerRespVo fashionStockState = this.outsideProductApi.getFashionStockState(storeDto, requetVo);
                        if (!fashionStockState.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                            log.info("\u8c03\u7528\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7orderNO{}", (Object)orderMainDto.getOrderNo());
                        } else {
                            List data = (List)fashionStockState.getData();
                            data.forEach(o -> {
                                if (!o.getOnSale().booleanValue() || o.getStockFlag() != 1) {
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("\u3010\u5546\u54c1").append(o.getProductCode()).append("\u3011");
                                    sb.append(addressDto.getProvinceName()).append(addressDto.getCityName()).append(!Lang.isEmpty((Object)addressDto.getAreaName()) ? addressDto.getAreaName() : "").append(!Lang.isEmpty((Object)addressDto.getTownName()) ? addressDto.getTownName() : "").append("\u5730\u533a");
                                    noStockAreaList.add(sb.toString());
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        log.error("\u786e\u8ba4\u8ba2\u5355\u524d\u7684\u62a5\u4ef7\u6821\u9a8c\u51fa\u9519\uff0c\u8ba2\u5355\u53f7{}", (Object)orderMainDto.getOrderNo(), (Object)e);
                        exceptionOrderNoList.add(orderMainDto.getOrderNo());
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            countDownLatch.await();
            if (exceptionOrderNoList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                sb.append("\u8ba2\u5355\u53f7");
                for (String orderNo : exceptionOrderNoList) {
                    sb.append(orderNo).append(",");
                }
                sb.append("\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                response.setResultMessage(sb.toString());
                return response;
            }
            if (difSkuList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                for (String sku : difSkuList) {
                    sb.append("\u3010\u5546\u54c1").append(sku).append("\u3011");
                }
                sb.append("\u552e\u4ef7\u4e0e\u62a5\u4ef7\u4e0d\u7b26\uff0c\u8bf7\u5148\u8c03\u6574\u5546\u54c1\u7684\u534f\u8bae\u4ef7\u683c\u540e\u518d\u786e\u8ba4");
                for (int i = 0; i < difOrderNoList.size(); ++i) {
                    sb.append("\u8ba2\u5355").append((String)difOrderNoList.get(i));
                    if (i != difOrderNoList.size() - 1) {
                        sb.append(",");
                        continue;
                    }
                    sb.append("\u3002");
                }
                response.setResultMessage(sb.toString());
                return response;
            }
            if (noStockAreaList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < noStockAreaList.size(); ++i) {
                    sb.append((String)noStockAreaList.get(i)).append(",");
                }
                sb.append("\u5e93\u5b58\u4e0d\u8db3\uff0c\r\n\u8bf7\u5148\u4fdd\u8bc1\u5e93\u5b58\u5145\u8db3\u540e\u518d\u786e\u8ba4\u8ba2\u5355");
                response.setResultMessage(sb.toString());
                return response;
            }
        }
        catch (Exception e) {
            log.error("\u786e\u8ba4\u8ba2\u5355\uff0c\u62a5\u4ef7\u6821\u9a8c\u671f\u95f4\u51fa\u9519", (Throwable)e);
            response.setSuccess(false);
            response.setResultMessage("\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return response;
        }
        try {
            CountDownLatch countDownLatch2 = new CountDownLatch(orderMainDtoList.size());
            ArrayList orderUpdateVoList = new ArrayList();
            ArrayList infoList = new ArrayList();
            orderMainDtoList.forEach(om -> this.threadPoolTaskExecutor.execute(() -> {
                try {
                    ArrayList tempOrderItemVoList = new ArrayList();
                    om.getOrderItems().forEach(p -> {
                        TempOrderItemVo tempOrderItemVo = new TempOrderItemVo();
                        tempOrderItemVo.setProductFashionId(p.getProductFashId());
                        tempOrderItemVo.setCount(p.getCount());
                        tempOrderItemVoList.add(tempOrderItemVo);
                    });
                    BigDecimal shippingFee = this.orderMainApi.queryShippingFee(storeId, tempOrderItemVoList, om.getAddressId());
                    if (shippingFee.compareTo(om.getFreight()) != 0) {
                        BigDecimal oldSumPrice = om.getSumPrice();
                        BigDecimal oldFreight = om.getFreight();
                        om.setFreight(shippingFee);
                        BigDecimal sumPrice = om.getSumNofreightPrice().add(shippingFee);
                        om.setSumPrice(sumPrice);
                        this.orderMainApi.save(om);
                        StringBuffer sb = new StringBuffer();
                        sb.append("\u8fd0\u8d39\u5df2\u91cd\u65b0\u83b7\u53d6\uff0c\u8ba2\u5355\u91d1\u989d\u7531").append(oldSumPrice).append("\u5143\u53d8\u4e3a").append(om.getSumPrice()).append("\u5143");
                        infoList.add(sb);
                        BiddingOrderInfoVo orderInfoVo = new BiddingOrderInfoVo();
                        orderInfoVo.setOrderNo(om.getOrderNo());
                        orderInfoVo.setFreight(shippingFee.toString());
                        orderInfoVo.setOrderAmount(sumPrice.toString());
                        orderUpdateVoList.add(orderInfoVo);
                        this.sendSumPriceChangeMail(biddingCode, om, oldSumPrice, oldFreight);
                    }
                }
                catch (Exception e) {
                    log.error("\u786e\u8ba4\u8ba2\u5355\u524d\u7684\u8fd0\u8d39\u6821\u9a8c\u51fa\u9519\uff0c\u8ba2\u5355\u53f7{}", (Object)om.getOrderNo(), (Object)e);
                    exceptionOrderNoList.add(om.getOrderNo());
                }
                finally {
                    countDownLatch2.countDown();
                }
            }));
            countDownLatch2.await();
            if (exceptionOrderNoList.size() > 0) {
                response.setSuccess(false);
                StringBuffer sb = new StringBuffer();
                sb.append("\u8ba2\u5355\u53f7");
                for (String orderNo : exceptionOrderNoList) {
                    sb.append(orderNo).append(",");
                }
                sb.append("\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                response.setResultMessage(sb.toString());
                return response;
            }
            if (infoList.size() > 0) {
                response.setSuccess(false);
                StringBuffer strBuffer = new StringBuffer();
                for (StringBuffer sb : infoList) {
                    strBuffer.append(sb).append("\r\n");
                }
                response.setResultMessage(strBuffer.toString());
                response.setResult(orderUpdateVoList);
                return response;
            }
        }
        catch (Exception e) {
            log.error("\u786e\u8ba4\u8ba2\u5355\uff0c\u8fd0\u8d39\u6821\u9a8c\u671f\u95f4\u51fa\u9519", (Throwable)e);
            response.setSuccess(false);
            response.setResultMessage("\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return response;
        }
        List orderMainIds = orderMainDtoList.stream().map(OrderMainDto::getId).collect(Collectors.toList());
        return response;
    }

    private void sendSumPriceChangeMail(JcbdBiddingDto bidding, OrderMainDto orderMain, BigDecimal oldSumPrice, BigDecimal oldFreight) {
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        MemberDto buyerMemberDto = this.memberApi.findMemberById(bidding.getOperatorId());
        mailReq.setTo(new String[]{buyerMemberDto.getCoreUser().getEmail()});
        mailReq.setFrom(this.mailFrom);
        mailReq.setSentDate(new Date());
        mailReq.setChannel("jc");
        mailTemplateReq.setMailReq(mailReq);
        mailTemplateReq.setTemplateCode(MailTemplateEnum.PRICE_CHANGED_AFTER_ORDER_CONFIRMED.getTemplateCode());
        ArrayList<String> subjectArgs = new ArrayList<String>();
        subjectArgs.add(bidding.getBiddingCode());
        ArrayList<String> contextArgs = new ArrayList<String>();
        StringBuilder mailStr = new StringBuilder();
        mailStr.append(!Lang.isEmpty((Object)buyerMemberDto.getCoreUser().getUsername()) ? buyerMemberDto.getCoreUser().getUsername() : buyerMemberDto.getCoreUser().getEmail());
        mailStr.append(",\u60a8\u597d\uff01\r\n");
        mailStr.append("    \u60a8\u5728\u96c6\u56e2\u96c6\u91c7\u7f51\u4e0a\u5546\u57ce\u5546\u57ce\u7ade\u4ef7\u3010\u7ade\u4ef7\u7f16\u53f7\u3011\u63d0\u4ea4\u7684\u8ba2\u5355\uff0c\u5728\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u65f6\u53d1\u751f\u4e86\u4ef7\u683c\u53d8\u52a8\uff1a\r\n");
        mailStr.append("    \u3010\u8ba2\u5355\u53f7 ").append(orderMain.getOrderNo()).append(" \u3011\u4ef7\u683c\u7531 ").append(oldSumPrice.setScale(2)).append(" \u5143\u53d8\u66f4\u4e3a ").append(orderMain.getSumPrice().setScale(2)).append("\u5143 \r\n");
        mailStr.append("\u8fd0\u8d39\u7531 ").append(oldFreight.setScale(2)).append(" \u5143\u53d8\u66f4\u4e3a ").append(orderMain.getFreight().setScale(2)).append(" \u5143");
        contextArgs.add(mailStr.toString());
        mailTemplateReq.setSubjectArgList(subjectArgs);
        mailTemplateReq.setContentArgList(contextArgs);
        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
        log.info("\u53d1\u9001\u90ae\u4ef6\u8bf7\u6c42 : {}", (Object)JSON.toJSONString((Object)mailTemplateReq));
        MailRsp mailRsp = this.mailApi.sendMailByTemplate(mailTemplateReq);
        log.info("\u4f9b\u5e94\u5546\u90ae\u4ef6\u53d1\u9001\u54cd\u5e94 : {}", (Object)JSON.toJSONString((Object)mailReq));
    }

    @Deprecated
    private void sendSumPriceChangeMail(String biddingCode, OrderMainDto orderMainDto, BigDecimal oldSumPrice, BigDecimal oldFreight) {
        MailTemplateReq mailTemplateReq = new MailTemplateReq();
        MailReq mailReq = new MailReq();
        MemberDto buyerMemberDto = this.memberApi.findMemberById(orderMainDto.getMemberId());
        mailReq.setTo(new String[]{buyerMemberDto.getCoreUser().getEmail()});
        mailReq.setFrom(this.mailFrom);
        mailReq.setSentDate(new Date());
        mailReq.setChannel("jc");
        mailTemplateReq.setMailReq(mailReq);
        mailTemplateReq.setTemplateCode(MailTemplateEnum.PRICE_CHANGED_AFTER_ORDER_CONFIRMED.getTemplateCode());
        ArrayList<String> subjectArgs = new ArrayList<String>();
        subjectArgs.add(biddingCode);
        ArrayList<String> contextArgs = new ArrayList<String>();
        StringBuilder mailStr = new StringBuilder();
        mailStr.append(!Lang.isEmpty((Object)buyerMemberDto.getCoreUser().getUsername()) ? buyerMemberDto.getCoreUser().getUsername() : buyerMemberDto.getCoreUser().getEmail());
        mailStr.append(",\u60a8\u597d\uff01\r\n");
        mailStr.append("    \u60a8\u5728\u96c6\u56e2\u96c6\u91c7\u7f51\u4e0a\u5546\u57ce\u5546\u57ce\u7ade\u4ef7\u3010\u7ade\u4ef7\u7f16\u53f7\u3011\u63d0\u4ea4\u7684\u8ba2\u5355\uff0c\u5728\u4f9b\u5e94\u5546\u786e\u8ba4\u8ba2\u5355\u65f6\u53d1\u751f\u4e86\u4ef7\u683c\u53d8\u52a8\uff1a\r\n");
        mailStr.append("    \u3010\u8ba2\u5355\u53f7 ").append(orderMainDto.getOrderNo()).append(" \u3011\u4ef7\u683c\u7531 ").append(oldSumPrice.setScale(2)).append(" \u5143\u53d8\u66f4\u4e3a ").append(orderMainDto.getSumPrice().setScale(2)).append("\u5143 \r\n");
        mailStr.append("\u8fd0\u8d39\u7531 ").append(oldFreight.setScale(2)).append(" \u5143\u53d8\u66f4\u4e3a ").append(orderMainDto.getFreight().setScale(2)).append(" \u5143");
        contextArgs.add(mailStr.toString());
        mailTemplateReq.setSubjectArgList(subjectArgs);
        mailTemplateReq.setContentArgList(contextArgs);
        mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
        MailRsp mailRsp = this.mailApi.sendMailByTemplate(mailTemplateReq);
        log.info("\u4f9b\u5e94\u5546\u90ae\u4ef6\u53d1\u9001\u54cd\u5e94 : {}", (Object)JSON.toJSONString((Object)mailReq));
    }

    public Map sureResult(String biddingCode, String signValue, String supplierId) {
        BiddingStateResponseDto biddingStatusChange;
        BiddingStateResponseDto stateResponseDto;
        List biddingDemands = this.biddingDemandApi.findByJcbdBiddingCodeAndIsDelete(biddingCode);
        List skus = this.biddingResponseQueryApi.findBiddingResponseSkus(biddingCode, supplierId);
        ValidationSkuEffDto skuValidity = this.goodsApi.findSkuValidity(skus, supplierId);
        BiddingChangeStateDto changeStateDto = new BiddingChangeStateDto();
        BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
        if (biddingDemands.size() != skus.size() || !skuValidity.isAllEffective()) {
            changeStateDto.setBiddingNo(biddingCode);
            changeStateDto.setCurrentState(BiddingStatus.OM_RESULT_CONFIRM_WAIT.getValue());
            changeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_NO.getCode());
            stateResponseDto = this.biddingMainApi.changeBiddingState(changeStateDto);
            if (!BiddingStatus.OM_SKU_MAKEUP_WAIT.getValue().equals(stateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u72b6\u6001\u53d8\u66f4\u9519\u8bef");
            }
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_NO.getCode());
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_BIDDING_YES.getValue());
            biddingStatusChange = this.biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue().equals(biddingStatusChange.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u4f9b\u5e94\u5546\u72b6\u6001\u53d8\u66f4\u9519\u8bef");
            }
        } else {
            changeStateDto.setBiddingNo(biddingCode);
            changeStateDto.setCurrentState(BiddingStatus.OM_RESULT_CONFIRM_WAIT.getValue());
            changeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_YES.getCode());
            stateResponseDto = this.biddingMainApi.changeBiddingState(changeStateDto);
            if (!BiddingStatus.OM_DO_BUY.getValue().equals(stateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u72b6\u6001\u53d8\u66f4\u9519\u8bef");
            }
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.CONFIRM_BIDDING_RESULT_YES.getCode());
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_BIDDING_YES.getValue());
            biddingStatusChange = this.biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue().equals(biddingStatusChange.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u4f9b\u5e94\u5546\u72b6\u6001\u53d8\u66f4\u9519\u8bef");
            }
        }
        TpCloudVerifyLogDto tpCloudVerifyLogDto = new TpCloudVerifyLogDto();
        tpCloudVerifyLogDto.setBusinessCode(biddingCode);
        tpCloudVerifyLogDto.setUserId(supplierId);
        tpCloudVerifyLogDto.setSource("bidding");
        tpCloudVerifyLogDto.setSignValue(signValue);
        tpCloudVerifyLogDto.setOperateType("\u63d0\u4ea4\u7ade\u4ef7\u7ed3\u679c");
        this.tpCloudVerifyLogApi.saveTpCloudVerifyLog(tpCloudVerifyLogDto);
        try {
            MailTemplateReq mailTemplateReq = new MailTemplateReq();
            MailReq mailReq = new MailReq();
            BiddingBaseInfoVo biddingDetail = this.getBiddingDetail(biddingCode);
            mailReq.setTo(new String[]{biddingDetail.getEmail()});
            mailReq.setFrom(this.mailFrom);
            mailReq.setSentDate(new Date());
            mailReq.setChannel("jc");
            mailTemplateReq.setTemplateCode(MailTemplateEnum.SUPPLIER_CONFIRM_BIDRESULT.getTemplateCode());
            ArrayList<String> subjectArgs = new ArrayList<String>();
            subjectArgs.add(biddingDetail.getBiddingCode());
            ArrayList<String> contextArgs = new ArrayList<String>();
            contextArgs.add(biddingDetail.getUsername());
            contextArgs.add(biddingDetail.getBiddingCode());
            mailTemplateReq.setSubjectArgList(subjectArgs);
            mailTemplateReq.setContentArgList(contextArgs);
            mailTemplateReq.setMailReq(mailReq);
            mailTemplateReq.setServiceModule(MailModule.BIDDING.getModule());
            this.mailApi.sendMailByTemplate(mailTemplateReq);
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7{}\u7684\u786e\u8ba4\u7ade\u4ef7\u7ed3\u679c\u90ae\u4ef6\u901a\u77e5\u7ecf\u529e\u4eba\u5931\u8d25", (Object)biddingCode, (Object)e);
        }
        return ResponseMapUtils.success((Object)biddingCode);
    }

    public Map querryPageSku(JqueryDataTablesVo jqueryDataTablesVo, String biddingCode, String supplierId) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "demandCode"), new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        DemanResponseParmDto demanResponseParmDto = new DemanResponseParmDto();
        demanResponseParmDto.setBiddingNo(biddingCode);
        demanResponseParmDto.setProviderId(supplierId);
        demanResponseParmDto.setPageable((Pageable)pageable);
        Page demandResponsePage = this.biddingResponseQueryApi.findDemandAndResponse(demanResponseParmDto);
        Long totalElement = 0L;
        List demandResponseQueryVos = new ArrayList();
        if (!Lang.isEmpty((Object)demandResponsePage)) {
            demandResponseQueryVos = this.mapperFacade.mapAsList((Iterable)demandResponsePage.getContent(), DemandResponseQueryVo.class);
            totalElement = demandResponsePage.getTotalElements();
        }
        returnModel.put("aaData", (Serializable)((Object)demandResponseQueryVos));
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return ResponseMapUtils.success(returnModel);
    }

    public Map updateSku(UpdateSkuVo updateSkuVo, String supplierId, String loginId) {
        UpdateSkuDto skuDto = (UpdateSkuDto)this.mapperFacade.map((Object)updateSkuVo, UpdateSkuDto.class);
        skuDto.setProviderId(supplierId);
        String operatorName = this.biddingOperatorService.getOperatorName(loginId);
        skuDto.setOperatorName(operatorName);
        BaseResponse baseResponse = this.biddingResponseApi.updateBiddingDemandResponseSku(skuDto);
        if (!baseResponse.isSuccess()) {
            return ResponseMapUtils.error((String)"\u66f4\u65b0sku\u5931\u8d25");
        }
        return ResponseMapUtils.success((Object)"");
    }

    public Map submitSkuAudit(String biddingCode, String supplierId) {
        BiddingChangeStateDto operaChangeState;
        List biddingDemands = this.biddingDemandApi.findByJcbdBiddingCodeAndIsDelete(biddingCode);
        List skus = this.biddingResponseQueryApi.findBiddingResponseSkus(biddingCode, supplierId);
        if (biddingDemands.size() != skus.size()) {
            return ResponseMapUtils.error((String)"\u60a8\u6709\u9700\u6c42\u672a\u586b\u5199\u5546\u54c1\u7f16\u7801\uff0c\u8bf7\u8865\u5f55\uff01");
        }
        ValidationSkuEffDto skuValidity = this.goodsApi.findSkuValidity(skus, supplierId);
        if (!skuValidity.isAllEffective()) {
            StringBuilder notSkus = new StringBuilder();
            skuValidity.getSkuAndUrlDtos().forEach(skuAndUrlDto -> {
                if (Lang.isEmpty((Object)skuAndUrlDto.getUrl())) {
                    notSkus.append(skuAndUrlDto.getSku()).append("\u3001");
                }
            });
            notSkus.deleteCharAt(notSkus.length() - 1);
            return ResponseMapUtils.error((String)("\u60a8\u5f55\u7684\u5546\u54c1" + notSkus.toString() + "\u8fd8\u672a\u540c\u6b65\u5230\u5546\u54c1\u6c60\u4e2d\uff0c\u8bf7\u540c\u6b65\u5230\u5546\u54c1\u6c60\u4e2d\u540e\u518d\u7f16\u8f91\u5546\u54c1\u7f16\u7801\uff01"));
        }
        JcbdBdProviderDto supplier = this.biddingMainQueryApi.getProvider(biddingCode, supplierId);
        if (Lang.isEmpty((Object)supplier)) {
            return ResponseMapUtils.error((String)"\u60a8\u4e0d\u662f\u8be5\u7ade\u4ef7\u7684\u4f9b\u5e94\u5546");
        }
        if (BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue().equals(supplier.getStatus())) {
            operaChangeState = new BiddingChangeStateDto();
            operaChangeState.setBiddingNo(biddingCode);
            operaChangeState.setCurrentState(BiddingStatus.OM_SKU_MAKEUP_WAIT.getValue());
            operaChangeState.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            BiddingStateResponseDto operaBiddingStateResponseDto = this.biddingMainApi.changeBiddingState(operaChangeState);
            if (!operaBiddingStateResponseDto.isSuccess() || !BiddingStatus.OM_SKU_AUDIT_WAIT.getValue().equals(operaBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u66f4\u65b0\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
            }
            BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_SKU_MAKEUP_WAIT.getValue());
            BiddingStateResponseDto supplierBiddingStateResponseDto = this.biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!supplierBiddingStateResponseDto.isSuccess() || !BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(supplierBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u66f4\u65b0\u4f9b\u5e94\u5546\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
            }
        } else if (BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue().equals(supplier.getStatus())) {
            operaChangeState = new BiddingChangeStateDto();
            operaChangeState.setBiddingNo(biddingCode);
            operaChangeState.setCurrentState(BiddingStatus.OM_DO_BUY.getValue());
            operaChangeState.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            BiddingStateResponseDto operaBiddingStateResponseDto = this.biddingMainApi.changeBiddingState(operaChangeState);
            if (!operaBiddingStateResponseDto.isSuccess() || !BiddingStatus.OM_SKU_AUDIT_WAIT.getValue().equals(operaBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u66f4\u65b0\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
            }
            BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_BIDDING_YES_AGAIN.getValue());
            BiddingStateResponseDto supplierBiddingStateResponseDto = this.biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!supplierBiddingStateResponseDto.isSuccess() || !BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(supplierBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u66f4\u65b0\u4f9b\u5e94\u5546\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
            }
        } else if (BiddingStatus.SUPPLIER_SKU_AUDIT_NOT.getValue().equals(supplier.getStatus())) {
            operaChangeState = new BiddingChangeStateDto();
            operaChangeState.setBiddingNo(biddingCode);
            operaChangeState.setCurrentState(BiddingStatus.OM_SKU_AUDIT_NOT.getValue());
            operaChangeState.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            BiddingStateResponseDto operaBiddingStateResponseDto = this.biddingMainApi.changeBiddingState(operaChangeState);
            if (!operaBiddingStateResponseDto.isSuccess() || !BiddingStatus.OM_SKU_AUDIT_WAIT.getValue().equals(operaBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u66f4\u65b0\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
            }
            BiddingSupplierChangeStateDto supplierChangeStateDto = new BiddingSupplierChangeStateDto();
            supplierChangeStateDto.setSupplierId(supplierId);
            supplierChangeStateDto.setOpcode(BiddingOperateCode.SUBMIT_BIDDING_SKU.getCode());
            supplierChangeStateDto.setBiddingNo(biddingCode);
            supplierChangeStateDto.setCurrentState(BiddingStatus.SUPPLIER_SKU_AUDIT_NOT.getValue());
            BiddingStateResponseDto supplierBiddingStateResponseDto = this.biddingResponseApi.supplierBiddingStatusChange(supplierChangeStateDto);
            if (!supplierBiddingStateResponseDto.isSuccess() || !BiddingStatus.SUPPLIER_SKU_AUDIT_WAIT.getValue().equals(supplierBiddingStateResponseDto.getBiddingState())) {
                return ResponseMapUtils.error((String)"\u66f4\u65b0\u4f9b\u5e94\u5546\u7ade\u4ef7\u72b6\u6001\u5931\u8d25");
            }
        } else {
            return ResponseMapUtils.error((String)"\u6570\u636e\u5f02\u5e38");
        }
        BaseResponse baseResponse = this.biddingResponseApi.supplierInitModifySku(biddingCode, supplierId);
        return ResponseMapUtils.success((Object)"");
    }

    public Map findUrlBySku(String sku, String supplierId) {
        ValidationSkuEffDto skuValidity = this.goodsApi.findSkuValidity(Arrays.asList(sku), supplierId);
        if (!skuValidity.isAllEffective()) {
            return ResponseMapUtils.error((String)"\u8be5\u5546\u54c1\u8fd8\u672a\u540c\u6b65\u5230\u5546\u54c1\u6c60\u4e2d\uff0c\u8bf7\u540c\u6b65\u5230\u5546\u54c1\u6c60\u4e2d\u540e\u518d\u7f16\u8f91\u5546\u54c1\u7f16\u7801");
        }
        String url = ((SkuAndUrlDto)skuValidity.getSkuAndUrlDtos().get(0)).getUrl();
        return ResponseMapUtils.success((Object)url);
    }

    public BaseResponse deleteMallOrder(String mallOrderNo) {
        try {
            if (Lang.isEmpty((Object)mallOrderNo)) {
                throw new IllegalArgumentException("MallOrderId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            JcbdMallOrderDto mallOrder = this.biddingMallOrderQueryApi.findByOrderNo(mallOrderNo);
            if (Lang.isEmpty((Object)mallOrder)) {
                throw new IllegalArgumentException("MallOrderId \u4e0d\u662f\u6709\u6548\u6570\u636e");
            }
            if (!BiddingOrderStatus.SUPPLIER_ORDER_STATUS_CANCELLED.getCode().equals(mallOrder.getSupplierOrderStatus())) {
                throw new IllegalStateException("MallOrder \u4f9b\u5e94\u5546\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            this.biddingMallOrderQueryApi.deleteJcbdMallOrderByOrderNo(mallOrderNo);
            JcbdOrderDto order = this.biddingOrderQueryApi.findById(mallOrder.getJdbdOrderId());
            if (!Lang.isEmpty((Object)order)) {
                JcbdBiddingOperationLogDto logDto = new JcbdBiddingOperationLogDto();
                JcbdBiddingDto jcbdBiddingDto = order.getJcbdBidding();
                logDto.setBiddingId(jcbdBiddingDto.getId());
                logDto.setOperationTime(new Date());
                logDto.setOperationContent("\u4f9b\u5e94\u5546\u5220\u9664\u8ba2\u5355");
                logDto.setOperatorName(order.getSupplierName());
                this.biddingLogApi.saveBiddingOperationLog(logDto);
            }
            return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u5220\u9664\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new BaseResponse("\u4f9b\u5e94\u5546\u5220\u9664\u8ba2\u5355\u5931\u8d25");
        }
    }

    public void destroy() throws Exception {
        this.threadPoolTaskExecutor.shutdown();
    }

    public Map checkModifySku(String biddingCode, String supplierId) {
        BaseResponse modifySkuFlag = this.biddingResponseQueryApi.findModifySkuFlag(biddingCode, supplierId);
        if (!modifySkuFlag.isSuccess()) {
            return ResponseMapUtils.error((String)modifySkuFlag.getResultMessage());
        }
        return ResponseMapUtils.success((Object)modifySkuFlag.getResult(), (String)"");
    }

    public JcbdBdProviderDto getProviderByBiddingNoAndSupplierId(String biddingId, String supplierId) {
        return this.biddingResponseQueryApi.getProviderByBiddingNoAndSupplierId(biddingId, supplierId);
    }

    public Map responseGiveUp(String biddingCode, String supplierId) {
        BaseResponse baseResponse = this.biddingResponseApi.responseGiveUp(biddingCode, supplierId);
        if (baseResponse.isSuccess()) {
            return ResponseMapUtils.success((Object)"");
        }
        return ResponseMapUtils.error((String)baseResponse.getResultMessage());
    }

    public List<String> findBiddingShowTitle(String biddingNo, String supplierId) {
        JcbdBdProviderDto provider = this.biddingMainQueryApi.getProvider(biddingNo, supplierId);
        String status = provider.getStatus();
        return this.biddingRoleOperationQueryApi.getBiddingShowTitle(status, BIDDING_SUPPLIER_TITILE_SHOW_MODULE);
    }

    public List<JcbdRoleOperationVo> getSupplierBiddingOperateByBiddingCode(String biddingNo, String supplierId) {
        JcbdBdProviderDto provider = this.biddingMainQueryApi.getProvider(biddingNo, supplierId);
        List operates = this.biddingRoleOperationQueryApi.getSupplierBiddingOperateByBiddingCode(biddingNo, provider.getStatus());
        if (Lang.isEmpty((Object)operates)) {
            return null;
        }
        return this.mapperFacade.mapAsList((Iterable)operates, JcbdRoleOperationVo.class);
    }

    public Map loadQrcode(String account, String businessCode, String operateType) {
        StringBuffer originalDataStrBuffer = new StringBuffer();
        originalDataStrBuffer.append(this.organiztionCode).append(account).append(DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")).append(businessCode).append(operateType);
        TpCloudQrCodeResponse tpCloundQrCodeResponse = this.tpCloudShieldApi.createSign(account, originalDataStrBuffer.toString());
        if (!Lang.isEmpty((Object)tpCloundQrCodeResponse)) {
            SignQrCodeDto qrCodeDto = tpCloundQrCodeResponse.getData();
            return ResponseMapUtils.success((Object)qrCodeDto);
        }
        return ResponseMapUtils.error((String)"\u62c9\u53d6\u9a8c\u8bc1\u4e8c\u7ef4\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    public Map getAccToken(String eventId) {
        TpCloudAccTokenResponse tpCloudAccTokenResponse = this.tpCloudShieldApi.longUserCheck(eventId);
        log.info("\u626b\u7801\u51ed\u8bc1\uff1a{},eventId\uff1a{}", (Object)JSON.toJSONString((Object)tpCloudAccTokenResponse), (Object)eventId);
        if (!Lang.isEmpty((Object)tpCloudAccTokenResponse) && !Lang.isEmpty((Object)tpCloudAccTokenResponse.getAccToken())) {
            return ResponseMapUtils.success((Object)tpCloudAccTokenResponse, (String)"\u8bf7\u4f7f\u7528\u592a\u5e73\u4e91\u76feapp\u626b\u7801\u9a8c\u8bc1");
        }
        return ResponseMapUtils.error((String)"\u8bf7\u4f7f\u7528\u592a\u5e73\u4e91\u76feapp\u626b\u7801\u9a8c\u8bc1");
    }

    public Map getSignResult(String accToken) {
        TpCloudSignResultResponse signResult = this.tpCloudShieldApi.getSignResult(accToken);
        if ("MOCK_STAMP_DATA".equals(signResult.getStampResult())) {
            return ResponseMapUtils.success((Object)signResult.getStampResult(), (String)"\u592a\u5e73\u4e91\u76fe\u9a8c\u8bc1\u6210\u529f");
        }
        if (!Lang.isEmpty((Object)signResult) && !Lang.isEmpty((Object)signResult.getStampResult())) {
            try {
                String decoderResult = new String(Base64.getDecoder().decode(signResult.getStampResult()), "UTF-8");
                JSONObject jsonObject = JSONObject.parseObject((String)decoderResult);
                JSONArray signValues = jsonObject.getJSONArray("signValues");
                JSONObject signValuesJSONObj = signValues.getJSONObject(0);
                String signValue = signValuesJSONObj.getString("signValue");
                return ResponseMapUtils.success((Object)signValue, (String)"\u592a\u5e73\u4e91\u76fe\u9a8c\u8bc1\u6210\u529f");
            }
            catch (UnsupportedEncodingException e) {
                log.info("\u83b7\u53d6\u626b\u7801\u7ed3\u679c\uff0c\u89e3\u7801\u5931\u8d25\uff1a{}", (Throwable)e);
                return ResponseMapUtils.error((String)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u9a8c\u8bc1");
            }
        }
        log.info("\u83b7\u53d6\u626b\u7801\u7ed3\u679c\uff1amsg:{}", (Object)signResult.getMsg());
        return ResponseMapUtils.error((String)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u9a8c\u8bc1");
    }
}

