/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.query.BiddingConformityReviewQueryApi;
import api.query.BiddingDemandApi;
import api.query.BiddingMallOrderQueryApi;
import api.query.BiddingOrderQueryApi;
import api.query.BiddingOrderResultApi;
import api.query.BiddingPurchaseLogApi;
import api.query.BiddingQueryApi;
import api.query.BiddingResponseQueryApi;
import api.query.MallAttachmentQueryApi;
import bidding.web.service.BiddingQueryService;
import bidding.web.vo.BiddingConformityListVo;
import bidding.web.vo.BiddingConformityQueryVo;
import bidding.web.vo.BiddingDemandResponseVo;
import bidding.web.vo.BiddingDemandVo;
import bidding.web.vo.BiddingResponseOutlineVo;
import bidding.web.vo.JcbdProviderAddressResponseVo;
import bidding.web.vo.JcbdProviderConformanceRespVo;
import bidding.web.vo.MallAttachmentVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.MallAttachmentBusinessCode;
import dto.BiddingConformityQueryDto;
import dto.BiddingPriceParityDto;
import dto.JcbdBiddingDemandResponseDto;
import dto.JcbdBiddingDto;
import dto.MallAttachmentDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import utils.Lang;
import utils.data.BeanMapper;
import utils.date.DateUtils;
import utils.web.ResponseMapUtils;

@Service
public class BiddingQueryServiceImpl
implements BiddingQueryService {
    public static final Logger log = LoggerFactory.getLogger(BiddingQueryServiceImpl.class);
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingOrderQueryApi biddingOrderQueryApi;
    @MotanReferer
    BiddingDemandApi biddingDemandApi;
    @MotanReferer
    BiddingPurchaseLogApi biddingPurchaseLogApi;
    @MotanReferer
    BiddingMallOrderQueryApi biddingMallOrderQueryApi;
    @MotanReferer
    BiddingOrderResultApi biddingOrderResultApi;
    @MotanReferer
    BiddingQueryApi biddingQueryApi;
    @MotanReferer
    BiddingResponseQueryApi biddingResponseQueryApi;
    @MotanReferer
    BiddingConformityReviewQueryApi biddingConformityReviewQueryApi;
    @MotanReferer
    MallAttachmentQueryApi mallAttachmentQueryApi;

    public List<JcbdBiddingDto> findAllJcbdBidding() {
        return this.biddingQueryApi.findAllJcbdBidding();
    }

    public BaseResponse<BiddingPriceParityDto> queryBiddingPriceParity(String biddingNo) {
        BaseResponse biddingPriceParityDtoBaseResponse = this.biddingResponseQueryApi.queryBiddingPriceParity(biddingNo);
        return biddingPriceParityDtoBaseResponse;
    }

    public Map querryPageBiddingDemad(BiddingConformityQueryVo biddingConformityQueryVo, JqueryDataTablesVo jqueryDataTablesVo) {
        HashMap<String, Serializable> returnModel = new HashMap<String, Serializable>();
        returnModel.putAll(jqueryDataTablesVo.toMap());
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "demandCode"), new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        PageRequest pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        BiddingConformityQueryDto biddingConformityQueryDto = (BiddingConformityQueryDto)BeanMapper.map((Object)biddingConformityQueryVo, BiddingConformityQueryDto.class);
        biddingConformityQueryDto.setPageable((Pageable)pageable);
        Page conformityListByQueryDto = this.biddingConformityReviewQueryApi.getConformityListByQueryDto(biddingConformityQueryDto);
        List biddingConformityListDtos = conformityListByQueryDto.getContent();
        ArrayList biddingConformityListVos = new ArrayList();
        Long totalElement = 0L;
        if (!Lang.isEmpty((Object)biddingConformityListDtos)) {
            biddingConformityListDtos.forEach(biddingConformityListDto -> {
                BiddingConformityListVo resposeListVo = (BiddingConformityListVo)this.mapperFacade.map(biddingConformityListDto, BiddingConformityListVo.class);
                resposeListVo.setDateRequiredDelivery(DateUtils.dateToStr((Date)biddingConformityListDto.getDateRequiredDelivery(), (String)"yyyy-MM-dd"));
                biddingConformityListVos.add(resposeListVo);
            });
            totalElement = biddingConformityListDtos.size();
        }
        returnModel.put("aaData", biddingConformityListVos);
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public Map queryResponseOutline(BiddingConformityQueryVo biddingConformityQueryVo) {
        BiddingConformityQueryDto biddingConformityQueryDto = new BiddingConformityQueryDto();
        biddingConformityQueryDto.setBiddingCode(biddingConformityQueryVo.getBiddingCode());
        biddingConformityQueryDto.setDemandCode(biddingConformityQueryVo.getDemandCode());
        biddingConformityQueryDto.setMemberId(biddingConformityQueryVo.getMemberId());
        biddingConformityQueryDto.setEmail(biddingConformityQueryVo.getEmail());
        BaseResponse demandOutlineDtos = this.biddingConformityReviewQueryApi.queryConformityOutline(biddingConformityQueryDto);
        if (!demandOutlineDtos.isSuccess()) {
            return ResponseMapUtils.error((String)demandOutlineDtos.getResultMessage());
        }
        if (!Lang.isEmpty((Object)demandOutlineDtos.getResult())) {
            List outlineVos = this.mapperFacade.mapAsList((Iterable)demandOutlineDtos.getResult(), BiddingResponseOutlineVo.class);
            return ResponseMapUtils.success((Object)outlineVos);
        }
        return ResponseMapUtils.error((String)"\u672a\u67e5\u5230\u4f9b\u5e94\u5546\u4fe1\u606f");
    }

    public Map queryDemandResponse(BiddingConformityQueryVo biddingConformityQueryVo) {
        BiddingConformityQueryDto biddingConformityQueryDto = new BiddingConformityQueryDto();
        biddingConformityQueryDto.setBiddingCode(biddingConformityQueryVo.getBiddingCode());
        biddingConformityQueryDto.setDemandCode(biddingConformityQueryVo.getDemandCode());
        biddingConformityQueryDto.setProviderId(biddingConformityQueryVo.getProviderId());
        biddingConformityQueryDto.setMemberId(biddingConformityQueryVo.getMemberId());
        biddingConformityQueryDto.setEmail(biddingConformityQueryVo.getEmail());
        BaseResponse demandResponseDtoResponse = this.biddingConformityReviewQueryApi.getConformityDetail(biddingConformityQueryDto);
        if (!demandResponseDtoResponse.isSuccess()) {
            return ResponseMapUtils.error((String)demandResponseDtoResponse.getResultMessage());
        }
        JcbdBiddingDemandResponseDto demandResponseDto = (JcbdBiddingDemandResponseDto)demandResponseDtoResponse.getResult();
        if (!Lang.isEmpty((Object)demandResponseDto)) {
            BaseResponse bidbaseBaseResponse;
            BiddingDemandResponseVo demandResponseVo = (BiddingDemandResponseVo)this.mapperFacade.map((Object)demandResponseDto, BiddingDemandResponseVo.class);
            if (!Lang.isEmpty((Object)demandResponseDto.getOfferValidity())) {
                demandResponseVo.setOfferValidityTime(DateUtils.dateToStr((Date)demandResponseDto.getOfferValidity(), (String)"yyyy-MM-dd"));
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdBiddingDemand())) {
                BiddingDemandVo demandVo = (BiddingDemandVo)this.mapperFacade.map((Object)demandResponseDto.getJcbdBiddingDemand(), BiddingDemandVo.class);
                demandResponseVo.setBiddingDemand(demandVo);
                if (!Lang.isEmpty((Object)demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery())) {
                    demandVo.setDateRequiredDeliveryTime(DateUtils.dateToStr((Date)demandResponseDto.getJcbdBiddingDemand().getDateRequiredDelivery(), (String)"yyyy-MM-dd"));
                }
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getId()) && (bidbaseBaseResponse = this.mallAttachmentQueryApi.findAttachmentByBiddingCodeAndBusinessCode(demandResponseDto.getId(), MallAttachmentBusinessCode.SUPBIDRELEV_ATTACH_BUSCODE.getValue())).isSuccess() && !Lang.isEmpty((Object)bidbaseBaseResponse.getResult())) {
                demandResponseVo.setAttachment(BeanMapper.mapList((Iterable)((Iterable)bidbaseBaseResponse.getResult()), MallAttachmentDto.class, MallAttachmentVo.class));
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdProviderAddressResponses())) {
                List providerAddressResponseVos = this.mapperFacade.mapAsList((Iterable)demandResponseDto.getJcbdProviderAddressResponses(), JcbdProviderAddressResponseVo.class);
                providerAddressResponseVos.forEach(n -> {
                    if ("1".equals(n.getStatus())) {
                        n.setStatus("\u6ee1\u8db3");
                    } else {
                        n.setStatus("\u4e0d\u6ee1\u8db3");
                    }
                });
                demandResponseVo.setProviderAddressResponses(providerAddressResponseVos);
            }
            if (!Lang.isEmpty((Object)demandResponseDto.getJcbdProviderConformanceResps())) {
                List conformanceRespVos = this.mapperFacade.mapAsList((Iterable)demandResponseDto.getJcbdProviderConformanceResps(), JcbdProviderConformanceRespVo.class);
                conformanceRespVos.forEach(n -> {
                    if ("\u7b26\u5408".equals(n.getStatus())) {
                        n.setStatus("\u7b26\u5408");
                    } else {
                        n.setStatus("\u4e0d\u7b26\u5408");
                    }
                    n.setSupplierId(biddingConformityQueryVo.getProviderId());
                });
                demandResponseVo.setProviderConformanceResps(conformanceRespVos);
            }
            return ResponseMapUtils.success((Object)demandResponseVo);
        }
        return ResponseMapUtils.error((String)"\u672a\u67e5\u5230\u6539\u9700\u6c42\u54cd\u5e94\u4fe1\u606f");
    }
}

