/*
 * Decompiled with CFR 0.152.
 */
package bidding.web.service.impl;

import api.query.BiddingSupplierOrderManagerApi;
import bidding.web.service.BiddingProviderService;
import bidding.web.service.BiddingSupplierOrderManagerService;
import bidding.web.vo.QueryStatus;
import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import com.google.common.base.Joiner;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import definition.BiddingOrderStatus;
import dto.BiddingSupplierOrderMangerDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import query.BiddingSupplierOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;
import sinomall.global.common.vo.JqueryDataTablesVo;
import uninogift.api.protocol.TpCloudVerifyLogApi;
import uninogift.vo.protocol.outside.TpCloudVerifyLogDto;
import utils.Lang;

@Service
public class BiddingSupplierOrderManagerServiceImpl
implements BiddingSupplierOrderManagerService {
    public static final Logger log = LoggerFactory.getLogger(BiddingSupplierOrderManagerServiceImpl.class);
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    RedisTemplate redisTemplate;
    @MotanReferer
    BiddingSupplierOrderManagerApi biddingSupplierOrderManagerApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @Autowired
    BiddingProviderService biddingProviderService;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    TpCloudVerifyLogApi tpCloudVerifyLogApi;

    public Map getBiddingSupplierOrderMangerList(JqueryDataTablesVo jqueryDataTablesVo, BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable) {
        HashMap<String, Object> returnModel = new HashMap<String, Object>(16);
        Long totalElement = 0L;
        int pageindex = jqueryDataTablesVo.getiDisplayStart() / jqueryDataTablesVo.getiDisplayLength();
        Sort sort = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "dateCreated"), new Sort.Order(Sort.Direction.DESC, "lastUpdated")});
        pageable = new PageRequest(pageindex, jqueryDataTablesVo.getiDisplayLength().intValue(), sort);
        Page page = this.getSupplierOrderMangerList(biddingSupplierOrderManagerListQuery, pageable);
        totalElement = page.getTotalElements();
        returnModel.put("aaData", page.getContent());
        returnModel.put("iTotalRecords", totalElement);
        returnModel.put("iTotalDisplayRecords", totalElement);
        return returnModel;
    }

    public Page<BiddingSupplierOrderMangerDto> getSupplierOrderMangerList(BiddingSupplierOrderManagerListQuery biddingSupplierOrderManagerListQuery, Pageable pageable) {
        long biddingOrderTime = System.currentTimeMillis();
        Page page = this.biddingSupplierOrderManagerApi.getBiddingSupplierOrderMangerList(biddingSupplierOrderManagerListQuery, pageable);
        log.info("\u5206\u9875\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba2\u5355\u6570\u636e\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - biddingOrderTime));
        biddingOrderTime = System.currentTimeMillis();
        List contentList = page.getContent();
        contentList.parallelStream().forEach(biddingSupplierOrderManger -> {
            OrderMainDto orderMain = this.orderMainApi.findByOrderNo(biddingSupplierOrderManger.getOrderNo());
            MemberAddressDto memberAddress = this.memberAddressApi.findById(orderMain.getAddressId());
            StringBuilder address = new StringBuilder(memberAddress.getProvinceName());
            address.append(memberAddress.getCityName());
            address.append(memberAddress.getAreaName());
            address.append(memberAddress.getTownName());
            address.append(biddingSupplierOrderManger.getAddress());
            biddingSupplierOrderManger.setAddress(address.toString().replaceAll("null", ""));
            List orderItems = orderMain.getOrderItems();
            if (!Lang.isEmpty((Object)orderItems)) {
                biddingSupplierOrderManger.setGoodsNumber(Integer.valueOf(orderItems.size()));
            }
            StringBuilder goodsCode = new StringBuilder();
            for (OrderItemDto orderItem : orderItems) {
                goodsCode.append(orderItem.getSku()).append(",");
            }
            if (!Lang.isEmpty((Object)goodsCode)) {
                goodsCode = goodsCode.replace(goodsCode.length() - 1, goodsCode.length(), "");
            }
            biddingSupplierOrderManger.setGoodsCode(goodsCode.toString());
            BigDecimal singleAmount = orderMain.getSumPrice().setScale(2);
            biddingSupplierOrderManger.setSingleAmount(singleAmount);
        });
        log.info("orderMain \u67e5\u8be2\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - biddingOrderTime));
        return page;
    }

    public List<QueryStatus> getAllSupplierStatus() {
        ArrayList<QueryStatus> allStatusList = new ArrayList<QueryStatus>();
        Map biddingSupplierOrderStatusMap = BiddingOrderStatus.biddingSupplierOrderStatusMap;
        for (String s : biddingSupplierOrderStatusMap.keySet()) {
            QueryStatus queryStatus = new QueryStatus();
            queryStatus.setStatusCode(s);
            BiddingOrderStatus biddingOrderStatus = (BiddingOrderStatus)biddingSupplierOrderStatusMap.get(s);
            queryStatus.setStatusDescription(biddingOrderStatus.getDescription());
            allStatusList.add(queryStatus);
        }
        return allStatusList;
    }

    public BaseResponse<List<String>> confirmOrder(List<String> mallOrderNos, String biddingMemberId, String signValue) {
        Vector confirmedMessages = new Vector();
        Vector unConfirmedMessages = new Vector();
        mallOrderNos.parallelStream().forEach(mallOrderNo -> {
            BaseResponse baseResponseTemp = this.biddingProviderService.confirmOrder(mallOrderNo);
            if (baseResponseTemp.isSuccess()) {
                confirmedMessages.add(baseResponseTemp.getResultMessage());
            } else {
                unConfirmedMessages.add(baseResponseTemp.getResultMessage());
            }
        });
        ArrayList allMessages = new ArrayList();
        allMessages.addAll(confirmedMessages);
        allMessages.addAll(unConfirmedMessages);
        if (allMessages.size() > 1) {
            allMessages.add(confirmedMessages.size() + " \u5f20\u8ba2\u5355\u786e\u8ba4\u6210\u529f, " + unConfirmedMessages.size() + " \u5f20\u8ba2\u5355\u786e\u8ba4\u5931\u8d25");
        }
        String resultCode = "0";
        if (confirmedMessages.size() > 0) {
            resultCode = "1";
        }
        TpCloudVerifyLogDto tpCloudVerifyLogDto = new TpCloudVerifyLogDto();
        tpCloudVerifyLogDto.setOperateType("\u786e\u8ba4\u8ba2\u5355");
        tpCloudVerifyLogDto.setSignValue(signValue);
        tpCloudVerifyLogDto.setSource("bidding");
        tpCloudVerifyLogDto.setUserId(biddingMemberId);
        tpCloudVerifyLogDto.setBusinessCode(Joiner.on((String)",").skipNulls().join(mallOrderNos));
        this.tpCloudVerifyLogApi.saveTpCloudVerifyLog(tpCloudVerifyLogDto);
        return new BaseResponse(true, "\u64cd\u4f5c\u6210\u529f", allMessages, resultCode);
    }

    public BaseResponse deleteMallOrder(String mallOrderNo) {
        return this.biddingProviderService.deleteMallOrder(mallOrderNo);
    }
}

