/** 地区选择控件 Start */
var AreaSelectPlugin = {
    GLOBAL_AREA_CACHE: {},
    // 地区层级代码
    AREA_LEVELS: { PROVINCE: 1,CITY: 2,AREA: 3,TOWN: 4},
    // 地区层级名称
    AREA_LEVELS_NAMES: {PROVINCE: "province",CITY: "city",AREA: "area",TOWN: "town"},
    // 层级地区映射
    LEVELS_AREA_MAPPING: {1: "province",2: "city",3: "area",4: "town"},
    // 地区层级映射
    AREA_LEVELS_MAPPING: {
        "province": 1,
        "city": 2,
        "area": 3,
        "town": 4
    },
    // 自定义事件名称
    EVENT_KEYS: {
        AREA_SELECTED: "areaSelected"
    },

    // 静态方法：
    isNotEmpty: function(obj) {
        if((typeof obj).toLowerCase() == "string") {
            return $.trim(obj) != "";
        }

        return typeof(obj)!="undefined"&&obj!=null;
    },
    createNew: function() {
        var obj = {};

        /** 属性 */
        obj.input = null; // 关联的input节点
        obj.maxLevel = 4; // 最多显示层级，1只显示省，2只显示到市
        obj.selectedArea = []; // 按级别保存选中的地区代码
        obj.areaCahce = {};
        obj.handleRes = {};
        obj.dataReqUrl = "/members/areaCommon/findAll";
        obj.ipAddressUrl = "/members/areaCommon/ipAddress";
        obj.preLoad = false; // 预加载所有地区数据
        obj.useGlobalCache = true; // 是否启用全局缓存
        obj.remoteDefault = true; // 是否启用远程默认地址，如启用当控件的input中未有默认地址时，使用远程api提供的默认地址

        /** 方法 */
        //判断是否直辖市或其下级
        obj.isDirectArea = function(areaCode) {
            var area = obj.getAreaInCache(null, areaCode, null);
            var directFlag = false;
            if(AreaSelectPlugin.isNotEmpty(area)) {
                if(area.remarks == "direct") {
                    return true;
                } else {
                    while (AreaSelectPlugin.isNotEmpty(area.pCode)) {

                    }
                    return directFlag;
                }
            }

            return directFlag;
        };
        // 获取地区数据（覆盖已缓存数据）
        obj.updateAreaData = function(parameters) {
            var level = parameters.level;
            var parentCode = parameters.parentCode;

            /** 回调函数 */
            var beforeSend = parameters.beforeSend;

            var success = parameters.success;
            var error = parameters.error;

            //var configs = AreaSelectPlugin.AREA_DATA_CONFIGS[level];
            var data = {
                level: level,
                parentId: parentCode
            };

            if(parameters.debug) {
                data.r = Math.random();
            }
            if(level == AreaSelectPlugin.AREA_LEVELS.PROVINCE ||
                (level <= obj.maxLevel && parentCode && typeof parentCode != 'undefined' && $.trim(parentCode) != "")) {
                $.ajax({
                    url: obj.dataReqUrl,
                    data: data,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        //$this.find('.content .nav-tab a').text("加载中...");
                        //$addressList.html("<span class='loading'>加载中...</span>")
                        if(beforeSend && (typeof beforeSend).toLowerCase() == "function") {
                            beforeSend();
                        }
                    },
                    success: function(result) {
                        //console.debug("result: %o", result);

                        if(result.status == "success") {
                            //console.debug("updateAreaData result: %o", result);
                            var cache = obj.getAreaCache();
                            result.data = obj.handleAjaxRes(result.data);
                            if(success && (typeof success).toLowerCase() == "function") {
                                var c = cache[level];
                                if(parentCode && $.trim(("" + parentCode)) != "") {

                                    cache[level] = cache[level] ? cache[level] : {};

                                    cache[level][parentCode] = result.data;
                                } else {
                                    cache[level] = result.data;
                                }

                                /** 判断是否继续获取 */
                                if(obj.selectedArea && obj.selectedArea[level - 1] && obj.selectedArea[level - 1].code && level <= obj.maxLevel) {
                                    var d = obj.getAreaInCache(level, obj.selectedArea[level - 1].code, null);
                                    if(d) {
                                        obj.selectedArea[level - 1] = d;
                                        obj.selectedArea[level - 1].name = d.shortName;
                                        obj.selectedArea[level - 1].fullName = d.fullName;
                                        obj.selectedArea[level - 1].pCode = d.pCode;
                                    }
                                    obj.updateAreaData({
                                        level: level + 1,
                                        parentCode: obj.selectedArea[level - 1].code,
                                        success: success,
                                        error: error
                                    });
                                } else {
                                    var d;
                                    if(obj.hasSelectedArea()) {
                                        if(obj.selectedArea[level - 1]){
                                            d = obj.getAreaInCache(level, obj.selectedArea[level - 1].code, null);
                                        }
                                        if(d) {
                                            obj.selectedArea[level - 1] = d;
                                            obj.selectedArea[level - 1].name = d.shortName;
                                            obj.selectedArea[level - 1].fullName = d.fullName;
                                            obj.selectedArea[level - 1].pCode = d.pCode;
                                        }
                                    }
                                    success(result.data);
                                }
                            }
                        } else {
                            if(error && (typeof error).toLowerCase() == "function") {
                                error(result.error, result.message);
                            }
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        if(typeof console.info != 'undefined') {
                            console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
                        }

                        if(error && (typeof error).toLowerCase() == "function") {
                            error(textStatus, jqXHR+textStatus+errorThrown+"");
                        }
                    }
                });
            } else {
                success({});
            }

        };
        // 一次获取所有地区数据（覆盖已缓存数据）
        obj.updateAllAreaData = function(parameters) {
            var parentCode = parameters.parentCode;
            var data = {
                level: 1,
                withChildren: true
            };
            $.ajax({
                url: obj.dataReqUrl,
                data: data,
                type: "GET",
                dataType: "json",
                beforeSend: function() {
                    //$this.find('.content .nav-tab a').text("加载中...");
                    //$addressList.html("<span class='loading'>加载中...</span>")
                    if(beforeSend && (typeof beforeSend).toLowerCase() == "function") {
                        beforeSend();
                    }
                },
                success: function(result) {
                    //console.debug("result: %o", result);

                    if(result.status == "success") {
                        //console.debug("updateAreaData result: %o", result);
                        var cache = obj.getAreaCache();
                        result.data = obj.handleAjaxRes(result.data);
                        if(success && (typeof success).toLowerCase() == "function") {
                            var nodeStack = [];
                            var rootNode = {
                                code:'root',
                                name:'root',
                                pCode:undefined,
                                child: result.data
                            };

                            var curNode = rootNode;

                            while(!isEmpty(curNode) || nodeStack.length > 0){
                                curNode = nodeStack.pop();
                                if(!isEmpty(curNode)) {
                                    if(curNode.name != 'root') {
                                        var tmpData = obj.getAreaInCache(curNode.level, curNode.code, curNode.pCode);
                                        if(isEmpty(tmpData)) {
                                            if(tmpData.level+'' == '1') {
                                                isEmpty(obj.getAreaCache()[curNode.level]) && (obj.getAreaCache()[curNode.level] = []);
                                                obj.getAreaCache()[curNode.level].push(curNode);
                                            } else {
                                                obj.getAreaCache()[curNode.level][curNode.pCode] = curNode;
                                            }

                                        }
                                    }
                                    // Push right node to stack first, as left should pop out first
                                    for(var k = curNode.child.length - 1; k >= 0; k--) {
                                        nodeStack.push(curNode.child[k]);
                                    }
                                }
                            }
                        }
                    } else {
                        if(error && (typeof error).toLowerCase() == "function") {
                            error(result.error, result.message);
                        }
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    if(typeof console.info != 'undefined') {
                        console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
                    }

                    if(error && (typeof error).toLowerCase() == "function") {
                        error(textStatus, jqXHR+textStatus+errorThrown+"");
                    }
                }
            });
            /** 回调函数 */
            var beforeSend = parameters.beforeSend;
            var success = parameters.success;
            var error = parameters.error;
        };
        // 生成/更新地区选择相关HTML结构
        obj.generateAreaHtml = function(parameters) {
            var $areaSelect = parameters.areaSelect;
            var level = parameters.level;
            var pLevel = parameters.pLevel; // 上级地区层级
            var pArea = parameters.pArea; // 上级地区代码
            var areaSelected = parameters.areaSelected; // 是否最终选择
            var after = parameters.after;
            //var isDirectly = parameters.; // 是否直辖市的3级地区，ture： 当前处理地区上级为直辖市

            level = (typeof level == 'number') ? level : AreaSelectPlugin.AREA_LEVELS_MAPPING[level];
            var levelName = AreaSelectPlugin.LEVELS_AREA_MAPPING[level];

            pLevel = (typeof pLevel == 'number') ? pLevel : AreaSelectPlugin.AREA_LEVELS_MAPPING[pLevel];
            var pLevelName = AreaSelectPlugin.LEVELS_AREA_MAPPING[pLevel];

            var $addressList = $areaSelect.find('.addressList[data-area-level="'+levelName+'"]');
            var $tabTitle = $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+levelName+'"]');
            $addressList.empty();
            $addressList.append("<div style='height: 100px;line-height: 100px;text-align: center'>加载中...</div>");
            var selectedIdx = 0;

            /** 选中当前级别 */
            $tabTitle.show();
            //selectedIdx = areaSelected ? areaSelected : (selectedIdx >= 0 ? areaSelected : 0);
            $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+levelName+'"] a').html('加载中');
            //$areaSelect.find('.nav-tabs .nav-tab a').tab('hide');
            $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+levelName+'"] a').tab('show');



            obj.getAreaData(level, level == AreaSelectPlugin.AREA_LEVELS.PROVINCE ? undefined : pArea, function(hasData, isDirectly, data) {
                $addressList.empty();
                // 上级
                var pData = obj.getAreaInCache(pLevel, pArea, null);
                if(data && data.length > 0) {
                    for(var i in data) {
                        if(!isNaN(i)) {
                            for(var j in obj.selectedArea) {
                                if(obj.selectedArea[j].code == data[i].code) {
                                    /** 防止选定地址数据有误 */
                                    obj.selectedArea[j] = data[i];
                                    obj.selectedArea[j].name = data[i].shortName;
                                    selectedIdx = i;
                                }
                            }

                            var $areaLi = $("<li " +
                                "class='" + (i == selectedIdx ? "selected" : "") + "' " +
                                "data-name='" + data[i].shortName + "' " +
                                "data-full-name='" + data[i].fullName + "' " +
                                "data-code='" + data[i].code + "' " + // 地区代码
                                "data-no-child=" + !data[i].hasChild + //无下级标志
                                "data-p-code='" + data[i].pCode + "' " + // 父级地区代码
                                "data-jdAddressId='" + data[i].jdAddressId + "'"+ // 京东地区代码
                                ">" +
                                "<a href='#none'>" + data[i].shortName+"</a>" +
                                "</li>");

                            $addressList.append($areaLi);
                            $areaLi.off('click', obj.events.areaLiClick);
                            $areaLi.on('click', obj.events.areaLiClick);
                        }
                    }

                    $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+levelName+'"] a').html(data[selectedIdx].shortName);

                    /** 直辖市处理 */
                    if(pData && pData.directly) {
                        $addressList.attr("isdirect", true);
                        var $navTab = $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+pLevelName+'"]');
                        //$navTab && $navTab.length > 0 && $navTab.find('a').tab('hide');
                        //直辖市隐藏上级
                        $navTab.hide();
                        $navTab.attr('data-disabled-area', true);
                        /** 更新1级显示地区名称 */
                        var p = obj.getAreaInCache(pLevel, pArea, null);
                        if(p) {
                            $areaSelect.find('.nav-tab[data-area-level="'+AreaSelectPlugin.AREA_LEVELS_NAMES.PROVINCE+'"] a').text(p.shortName);
                        }
                    } else {
                        /** 显示上级 */
                        for(var i=level - 1; i >= 1; i --){
                            var $cur = $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]')
                            !$cur.attr('data-disabled-area') && $cur.show();
                        }
                        /** 更新上级显示地区名称 */
                        var p = obj.getAreaInCache(pLevel, pArea, null);
                        if(p) {
                            $areaSelect.find('.nav-tab[data-area-level="'+pLevelName+'"] a').text(p.shortName);
                        }

                        /** 隐藏下级 */
                        for(var i=level+1; i <= obj.maxLevel; i++){
                            $areaSelect.find('.addressList[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]')
                                .parents('.tab-pane').removeClass('active');
                            $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]').hide();
                        }
                    }
                } else {
                    /** 如果当前级别没有数据，上级别地区选择标记为无下级状态 */
                    var $li = $areaSelect.find('.addressList[data-area-level="'+pLevelName+'"] li[data-code="'+pArea+'"]');
                    $li.attr('data-no-child', true);

                    /** 隐藏当前级别 */
                    $tabTitle.hide();
                    $areaSelect.find('.nav-tab[data-area-level="'+pLevelName+'"] a').text($li.attr('data-name'));

                    /** 隐藏下级 */
                    for(var i=level+1; i <= obj.maxLevel; i++){
                        $areaSelect.find('.addressList[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]')
                            .parents('.tab-pane').removeClass('active');
                        $areaSelect.find('.nav-tabs .nav-tab[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]').hide();
                    }
                }

                var $selectedVal = $areaSelect.find('.selectedVal');
                if(areaSelected == true && selectedIdx >= 0) {
                    /** 更新全地址显示 */

                    $selectedVal.text("");

                    //if(obj.selectedArea.length > 3) {
                    //    obj.selectedArea.splice(1, 1);
                    //}

                    for(var i = 1; i <= obj.selectedArea.length; i++ ) {
                        if(obj.selectedArea[i - 1] && !obj.selectedArea[i - 1].directly) {
                            if(typeof obj.selectedArea[i - 1].name != 'undefined') {
                                obj.selectedArea[i - 1] = obj.getAreaInCache(null, obj.selectedArea[i-1].code, null);
                            }
                            $selectedVal.text($selectedVal.text() + (typeof obj.selectedArea[i - 1].name != 'undefined' ? obj.selectedArea[i - 1].name : ''));
                            $areaSelect
                                .find('.nav-tabs .nav-tab[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"] a')
                                .html(obj.selectedArea[i - 1].name);
                        }
                    }

                    //obj.input.trigger(AreaSelectPlugin.EVENT_KEYS.AREA_SELECTED, [obj.selectedArea]);
                } else {
                    if($.trim($selectedVal.text()) == '') {
                        $selectedVal.text('请选择');
                    }
                }

                after && (typeof after).toLowerCase() == 'function' && after();
            });
        };
        // Ajax返回数据整理
        obj.handleAjaxRes = function(data) {
            if(data) {
                for(var i in data) {
                    data[i].pCode = data[i].parentCode;
                }
            }

            return data;
        };
        // 初始化默认地址
        obj.initDefaultAddress = function(remote, o){
            obj = obj ? obj : o;
            var defArea = obj.input.attr('data-def-area');
            var defAreaArr = [];
            var noDefArea = (defArea == '' || typeof defArea == 'undefined' || $.trim(defArea) == '' || defArea == null);
            if(remote && noDefArea) {
                // 强制读取远程数据或未给出data-def-area
                $.ajaxSetup({async : false});
                $.get(
                    obj.ipAddressUrl,{},
                    function(json) {
                        if(json.status == 'success') {
                            if(json.data.provoiceId && typeof json.data.provoiceId != 'undefined') {
                                defAreaArr.push(json.data.provoiceId);
                            }
                            if(json.data.cityId && typeof json.data.cityId != 'undefined') {
                                defAreaArr.push(json.data.cityId);
                            }
                            if(json.data.areaId && typeof json.data.areaId != 'undefined') {
                                defAreaArr.push(json.data.areaId);
                            }
                            if(json.data.townId && typeof json.data.townId != 'undefined') {
                                defAreaArr.push(json.data.townId);
                            }
                        }
                    }
                );
                $.ajaxSetup({async : true});
            } else if(noDefArea) {
                defAreaArr = [];
            } else {
                defAreaArr = defArea.split(',');
            }
            if(defAreaArr.length > 0) {
                obj.selectedArea = [];
                for(var i in defAreaArr) {
                    obj.selectedArea[Number(i)] = {code: defAreaArr[i]}
                }
            }
            obj.updateAreaData({
                areaSelect: obj.rootEl,
                level: AreaSelectPlugin.AREA_LEVELS.PROVINCE,
                success: function(data) {
                    var levels = AreaSelectPlugin.AREA_LEVELS.PROVINCE;
                    if(defAreaArr.length > 0) {
                        levels = defAreaArr.length;
                    }

                    for(var i = AreaSelectPlugin.AREA_LEVELS.PROVINCE; i <= levels; i++) {
                        obj.generateAreaHtml({
                            areaSelect: obj.rootEl,
                            level: i,
                            pArea: i == AreaSelectPlugin.AREA_LEVELS.PROVINCE ? null : obj.selectedArea[i - 1].pCode,
                            areaSelected: defAreaArr.length > 0 && i == levels
                        });
                    }
                    if(obj.hasDefaultArea()) {// 当没有默认地址时，不进行触发
                        obj.input.trigger(AreaSelectPlugin.EVENT_KEYS.AREA_SELECTED, [obj.selectedArea]);
                    }
                }
            });
        };
        /**
         * 获取保存数据
         * @param level
         * @param parentCode
         * @param after: function()
         */
        obj.getAreaData = function(level, parentCode, after) {
            var data = {};
            var cache = obj.getAreaCache();
            if(level == AreaSelectPlugin.AREA_LEVELS.PROVINCE) {
                data = cache[level];
                if(!data || data.length <= 0) {
                    obj.updateAreaData({
                        level: level,
                        success: function() {
                            after(true, false, cache[level]);
                        },
                        error: function() {
                            after(false, false);
                        }
                    })
                } else {
                    after(true, false, data);
                }
            } else if(level > obj.maxLevel) {
                after(false, false);
            } else {
                data = cache[level] ? cache[level][parentCode] : null;
                if(!data || data.length <= 0) {
                    obj.updateAreaData({
                        level: level,
                        parentCode: parentCode,
                        beforeSend: function() {
                            obj.rootEl.off('mouseleave', obj.events.mouseleave);
                        },
                        success: function () {
                            var hasData = false;
                            var isDirectly = false; // 直辖市标志
                            if(cache[level][parentCode] && cache[level][parentCode].length > 0) {
                                if(cache[level][parentCode].length == 1) {
                                    //isDirectly = cache[level][parentCode][0].code == parentCode && level == AreaSelectPlugin.AREA_LEVELS.CITY;
                                    cache[level][parentCode][0].remarks = cache[level][parentCode][0].remarks ? $.trim(cache[level][parentCode][0].remarks) : "";
                                    isDirectly = cache[level][parentCode][0].remarks == "direct";
                                }
                                hasData = true;
                            } else {
                                hasData = false;
                            }
                            obj.rootEl.off('mouseleave', obj.events.mouseleave);
                            obj.rootEl.on('mouseleave', obj.events.mouseleave);
                            after(hasData, isDirectly, cache[level][parentCode]);
                        },
                        error: function() {
                            obj.rootEl.off('mouseleave', obj.events.mouseleave);
                            obj.rootEl.on('mouseleave', obj.events.mouseleave);
                            after(false, false);
                        }
                    })
                } else {
                    var hasData = false;
                    var isDirectly = false; // 直辖市标志
                    if(cache[level][parentCode] && cache[level][parentCode].length > 0) {
                        if(cache[level][parentCode].length == 1) {
                            //isDirectly = cache[level][parentCode][0].code == parentCode;
                            cache[level][parentCode][0].remarks = cache[level][parentCode][0].remarks ? $.trim(cache[level][parentCode][0].remarks) : "";
                            isDirectly = cache[level][parentCode][0].remarks == "direct";
                        }
                        hasData = true;
                    } else {
                        hasData = false;
                    }
                    after(hasData, isDirectly, data);
                }
            }
        };
        // 查找某个地区
        obj.getAreaInCache = function(level, code, pCode) {
            var cache = obj.getAreaCache();
            if(AreaSelectPlugin.isNotEmpty(level)) {
                if(cache[level]) {
                    if(pCode && pCode != "" && cache[level][pCode]) {
                        if(AreaSelectPlugin.isNotEmpty(code)) {
                            for(var i in cache[level][pCode]) {

                                if(cache[level][pCode][i].code == code) {
                                    return cache[level][pCode][i];
                                }
                            }
                        } else {
                            return cache[level][pCode][0];
                        }

                    } else {
                        if(level == 1) {
                            if(AreaSelectPlugin.isNotEmpty(code)) {
                                for(var i in cache[level]) {
                                    if(cache[level][i].code == code) {
                                        return cache[level][i];
                                    }
                                }
                            } else {
                                return cache[level][0];
                            }

                        } else {
                            for(var i in cache[level]) {
                                if(cache[level][i]) {
                                    if(AreaSelectPlugin.isNotEmpty(code)) {
                                        for(var j in cache[level][i]) {
                                            if(cache[level][i][j].code == code) {
                                                return cache[level][i][j];
                                            }
                                        }
                                    }
                                }

                            }
                        }


                    }
                }
            } else {
                // 无层级查询
                for(var level in cache) {
                    for(var pCode in cache[level]) {
                        if(level+"" == "1") {
                            if(cache[level][pCode].code == code) {
                                return cache[level][pCode];
                            }
                        } else {
                            for(var i in cache[level][pCode]) {
                                if(cache[level][pCode][i].code == code) {
                                    return cache[level][pCode][i];
                                }
                            }
                        }
                    }
                }
            }

            return null;
        };
        // 获取缓存
        obj.getAreaCache = function() {
            return obj.useGlobalCache ? AreaSelectPlugin.GLOBAL_AREA_CACHE : obj.areaCahce;
        };
        // 判断是否有默认地址
        obj.hasDefaultArea = function () {
            var defArea = obj.input.attr('data-def-area');
            var noDefArea = (defArea == '' || typeof defArea == 'undefined' || $.trim(defArea) == '' || defArea == null);
            return !noDefArea;
        };
        // 判断是否已选中某个地区
        obj.hasSelectedArea = function() {
            return (typeof obj.selectedArea != 'undefined' && obj.selectedArea != null) && obj.selectedArea.length > 0;
        };
        //判断是否点击配送地址下拉框 : true(配送地址下拉框内点击), false(配送地址下拉框外点击)
        var isClickAreaSelects = false;
        // 事件响应方法
        obj.events = {
            // 地区选择
            areaLiClick: function () {
                var $this = $(this);
                var curLevel = AreaSelectPlugin.AREA_LEVELS_MAPPING[$this.parents('.addressList').attr('data-area-level')];
                var nextLevel;
                if($this.parents('.addressList').attr('isdirect')) { //直辖市多处理1级
                    nextLevel = curLevel >= obj.maxLevel + 1 ? obj.maxLevel + 1 : curLevel + 1;
                } else {
                    nextLevel = curLevel >= obj.maxLevel ? obj.maxLevel : curLevel + 1;
                }
                var $root = $this.parents('.area-selects');
                obj.rootEl.off('mouseleave', obj.events.mouseleave);
                //obj.rootEl.off('mouseenter', obj.events.mouseenter);
                $root.attr('selecting', true);
                /** 隐藏下级 */
                for(var i=curLevel+1; i <= obj.maxLevel; i++){
                    $root.find('.addressList[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]')
                        .parents('.tab-pane').removeClass('active');
                    $root.find('.nav-tabs .nav-tab[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]').hide();
                }

                /** 立即更新当前tab内容为所选 */
                $root.find('.nav-tabs .nav-tab[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[curLevel]+'"]a').html($this.attr('data-name'));
                //$root.find('.addressList[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[curLevel]+'"]')
                //    .parents('.tab-pane').empty().append("<div style='height: 100px;line-height: 100px;text-align: center'>加载中...</div>");

                /** 清除上次选择地区 */
                curLevel = parseInt(curLevel);
                //if(obj.selectedArea.length > curLevel) {
                //    obj.selectedArea = obj.selectedArea.slice(curLevel, obj.selectedArea.length - curLevel);
                //}

                /** 获取下级数据 */
                obj.getAreaData(nextLevel, $this.attr('data-code'), function(hasData, isDirectly, lv2Data) {
                    //console.debug("lv2Data: %o", lv2Data);
                    if(isDirectly && lv2Data && lv2Data[0]) {
                        // 直辖市，获取下级城市
                        curLevel = nextLevel;
                        nextLevel = curLevel + 1;
                        $root.find('.addressList[data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"]')
                            .parents('.tab-pane').removeClass('active');
                        obj.getAreaData(nextLevel, lv2Data[0].code, function(hasData, isDirectly) {
                                obj.generateAreaHtml({
                                    areaSelect: $root,
                                    level: nextLevel,
                                    pLevel: curLevel,
                                    pArea: lv2Data[0].code,
                                    isDirectly: true// 直辖市，隐藏市级选项卡
                                });
                                //获取直辖市的城市代码
                                //    obj.getAreaData(AreaSelectPlugin.AREA_LEVELS.CITY, $this.attr('data-code'), function(hasData, isDirectly, data) {
                                //
                                //    });
                            }
                        );
                    } else if(hasData) {
                        // 存在下级数据，显示下级选择UI
                        obj.generateAreaHtml({
                            areaSelect: $root,
                            level: nextLevel,
                            pLevel: curLevel,
                            pArea: $this.attr('data-code')
                        });
                    } else {
                        // 没有数据，选中当前点击的地区作为最终选择数据
                        obj.selectedArea = [];
                        var code = $this.attr('data-code'),
                            name = $this.attr('data-name'),
                            fullName = $this.attr('data-full-name'),
                            pCode = $this.attr('data-p-code'), d, p;

                        obj.selectedArea[curLevel - 1] = {code: code, name: name, fullName: fullName, pCode: pCode};
                        for(var i = curLevel; i >= 1; i --) {
                            if(obj.getAreaCache()[i]) {
                                d = obj.getAreaInCache(i, code, null);
                                code = d.pCode;
                                obj.selectedArea[i - 1] = d;
                                obj.selectedArea[i - 1].name = d.shortName;
                                obj.selectedArea[i - 1].fullName = d.fullName;
                                obj.selectedArea[i - 1].pCode = d.pCode;
                            }
                        }
                        $root.attr('selecting', false);
                        obj.generateAreaHtml({
                            areaSelect: $root,
                            level: nextLevel,
                            pLevel: curLevel,
                            pArea: $this.attr('data-code'),
                            areaSelected: true,
                            after: function() {
                                obj.input.val(obj.selectedArea[obj.selectedArea.length - 1].code);
                                obj.input.trigger(AreaSelectPlugin.EVENT_KEYS.AREA_SELECTED, [obj.selectedArea]);

                                obj.hideContent();
                                obj.rootEl.off('mouseleave', obj.events.mouseleave);
                                obj.rootEl.find('.headTit').off('mouseenter', obj.events.mouseenter);
                                obj.rootEl.on('mouseleave', obj.events.mouseleave);
                                obj.rootEl.find('.headTit').on('mouseenter', obj.events.mouseenter);
                            }
                        });

                    }

                });


            },
            // 鼠标进入
            mouseenter: function(e) {
                // obj.rootEl.off('mouseleave', obj.events.mouseleave);
                var self = $(this);
                if($('.area-selects .content').is(":hidden")) {
                    /** 获取已选择地区 */
                    var curLv = AreaSelectPlugin.AREA_LEVELS.PROVINCE;
                    var pLv = AreaSelectPlugin.AREA_LEVELS.PROVINCE;
                    if(typeof obj.selectedArea != 'undefined' && obj.selectedArea.length > 0) {
                        for(var i in obj.selectedArea) {
                            curLv = Number(i) + 1;
                            pLv = curLv == AreaSelectPlugin.AREA_LEVELS.PROVINCE ? curLv : curLv - 1;
                            obj.generateAreaHtml({
                                areaSelect: obj.rootEl,
                                level: curLv,
                                pLevel: pLv,
                                pArea: obj.selectedArea[pLv - 1].code,
                                areaSelected: true,
                                after: function() {
                                    obj.showContent();
                                    obj.rootEl.off('mouseleave', obj.events.mouseleave);
                                    obj.rootEl.on('mouseleave', obj.events.mouseleave);
                                }
                            });
                        }
                    } else {
                        // 鼠标进入时，如果没有默认值或已选中值的话，展示所有省份
                        obj.updateAreaData({
                            areaSelect: obj.rootEl,
                            level: AreaSelectPlugin.AREA_LEVELS.PROVINCE,
                            success: function(data) {
                                obj.generateAreaHtml({
                                    areaSelect: obj.rootEl,
                                    level: 1,
                                    areaSelected: false,
                                    after: function () {
                                        obj.selectedArea = [];
                                        obj.showContent();
                                        obj.rootEl.off('mouseleave', obj.events.mouseleave);
                                        obj.rootEl.on('mouseleave', obj.events.mouseleave);
                                    }
                                });
                            }
                        });
                    }
                }
            },
            // 鼠标离开
            mouseleave: function() {
                if(!isClickAreaSelects){
                    obj.rootEl.attr('selecting', false);
                    obj.rootEl.find('.content').hide();
                    obj.rootEl.find('.selectIcon').show();
                    obj.rootEl.find('.upSelectIcon').hide();
                    obj.rootEl.off('mouseleave', obj.events.mouseleave);
                    obj.rootEl.off('mouseenter', obj.events.mouseenter);
                    obj.rootEl.on('mouseleave', obj.events.mouseleave);
                    obj.rootEl.on('mouseenter', obj.events.mouseenter);

                    if(obj.selectedArea.length <= 0) {
                        obj.rootEl.find('.selectedVal').html('请选择');
                    }
                }
            },
            //鼠标点击
            mousedown: function () {
                isClickAreaSelects = true;
            },
            // 控件外点击
            clickOutSide: function(e) {
                // 当在控件范围内点击页面时，隐藏控件
                if($(e.target).parents('.area-selects')[0] != obj.rootEl[0]) {
                    isClickAreaSelects = false;
                    obj.hideContent();
                    obj.rootEl.attr('selecting', false);
                }
            },
            // 默认地址更改
            defAreaChanged: function(e, addressId) {
                obj.initDefaultAddress(true, obj);
                obj.input.trigger(AreaSelectPlugin.EVENT_KEYS.AREA_SELECTED, [obj.selectedArea]);
                //obj.rootEl.find('[data-code="'+obj.selectedArea[obj.selectedArea.length - 1]+'"]').trigger('click');
            }
        };
        obj.hideContent = function() {
            obj.rootEl.find('.content').hide();
            obj.rootEl.find('.selectIcon').show();
            obj.rootEl.find('.upSelectIcon').hide();
        };
        obj.showContent = function() {
            obj.rootEl.find('.content').show();
            obj.rootEl.find('.selectIcon').hide();
            obj.rootEl.find('.upSelectIcon').show();
        };
        // 控件初始化
        obj.init = function(options) {
            var $el = options.el;
            var maxLv = options.maxLevel;

            if(AreaSelectPlugin.isNotEmpty(options.dataReqUrl)) {
                obj.dataReqUrl = options.dataReqUrl;
            }

            if(AreaSelectPlugin.isNotEmpty(options.ipAddressUrl)) {
                obj.ipAddressUrl = options.ipAddressUrl;
            }

            if(AreaSelectPlugin.isNotEmpty(options.remoteDefault)) {
                obj.remoteDefault = options.remoteDefault;
            }
            //maxLv = maxLv > 3 ? 3 : (maxLv <= 0 ? 1 : maxLv);
            //var $areaSelect = options.areaSelect;
            //var relInput = $("#"+$areaSelect.attr('rel'));
            obj.input = $el;
            obj.maxLevel = maxLv;

            /** 创建HTML */
            var $root = $(document.createElement("div")).addClass('area-dorpdown-hover').addClass('area-selects').attr('rel', $el.attr('id'));

            obj.rootEl = $root;


            $('<div class="headTit"><span class="selectedVal"></span><span class="icon iconfont selectIcon"></span><span class="icon iconfont upSelectIcon" style="display: none;">&#xe7e0;</span></div>')
                .appendTo($root);
            var $content = $(document.createElement("div")).addClass('content').css({'right': 0, 'left': 'inherit', 'display': 'none'});
            var $closeBtn = $(document.createElement("span"));
            $closeBtn.addClass('iconfont').addClass('closeArea').html('&#xe605;').appendTo($content);
            var $nav = $(document.createElement("ul")).addClass('nav').addClass('nav-tabs').addClass('clearfix');
            var $tabCon = $(document.createElement("div")).addClass('tab-con').addClass('tab-content');

            var $navTab, tabPane;
            for(var i=1; i<=4; i++) {
                $navTab = $(document.createElement("li"));
                $navTab.addClass('nav-tab').addClass("area-sel-item0"+i);
                $navTab.attr('data-area-level', AreaSelectPlugin.LEVELS_AREA_MAPPING[i]);
                $navTab.attr('data-nav', "area-sel-item0"+i);
                $('<a href="#area-sel-item0'+i+'" data-toggle="tab" aria-expanded="' + (i == 1 ? 'true' : 'false') + '"></a>')
                    .appendTo($navTab);
                $navTab.appendTo($nav);

                $('<div class="tab-pane" id="area-sel-item0'+i+'">' +
                    '<ul class="addressList clearfix" data-area-level="'+AreaSelectPlugin.LEVELS_AREA_MAPPING[i]+'"></ul>' +
                    '</div>').appendTo($tabCon);
            }
            $nav.appendTo($content);
            $tabCon.appendTo($content);
            $content.appendTo($root);
            $el.after($root);
            $root.find('.nav-tab:first a').tab('show');

            obj.initDefaultAddress(obj.remoteDefault, obj);

            $root.off('mouseleave', obj.events.mouseleave);
            $root.find('.headTit').on('mouseenter', obj.events.mouseenter);
            $root.off('mouseleave', obj.events.mouseleave);
            $root.on('mouseleave', obj.events.mouseleave);
            $root.off('mousedown', obj.events.mousedown);
            $root.on('mousedown', obj.events.mousedown);
            $(document).off('click', obj.events.clickOutSide);
            $(document).on('click', obj.events.clickOutSide);
            $(document).off('topProvinceChanged', obj.events.defAreaChanged);
            $(document).on('topProvinceChanged', obj.events.defAreaChanged);
            $root.on('click', '.close, .closeArea', function() {
                obj.hideContent();
            });
        };

        return obj;
    }
};
/** 地区选择控件 End */