var bidDemadPageTable;
var biddingCode = biddingNo;
var demandCode = demandCode;

$(function () {
    bidDemadPageTable = $('#bidDemadPageTable').DataTable({
        "oLanguage": {
            "sLengthMenu": "每页显示 _MENU_ 条记录",
            "sZeroRecords": "抱歉， 没有找到",
            "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
            "sInfoEmpty": "",
            "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
            "oPaginate": {
                "sFirst": "首页",
                "sPrevious": "前一页",
                "sNext": "后一页",
                "sLast": "尾页"
            },
            "sZeroRecords": "没有检索到数据",
            "sProcessing": "<img src='./loading.gif' />",
            "sSearch": "搜索"
        },
        "sDom":'rt<"row"<"col-2"i><"col-8"p><"col-2"l>>',//自定义布局
        "bStateSave" : false,
        "bJQueryUI" : true,
        "bPaginate" : true,// 分页按钮
        "bFilter" : false,// 搜索栏
        "aLengthMenu" : [5, 10, 20, 50, 100], //更改显示记录数选项
        "bLengthChange":true,// 每行显示记录数
        "iDisplayLength" : 5,// 每页显示行数
        "bSort" : false,// 排序
        "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
        "bWidth" : true,
        "bScrollCollapse" : true,
        "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
        "bServerSide" : true,
        "bDestroy" : true,
        "bSortCellsTop" : true,
        "sAjaxSource" : "/bidding-web/biddingOperator/findBidDemandPage",
        "fnInitComplete": function() {
            this.fnAdjustColumnSizing(true);
        },
        //向服务器传额外的参数
        "fnServerParams" : function(aoData) {
            // var jcbdBiddingNo = $("#jcbdBiddingNo").val();
            aoData.push({
                "name" : "biddingCode",
                "value" : biddingNo
            });
        },
        "fnDrawCallback" : function(table) {
            //指定跳转页面
            $("#bidDemadPageTable_paginate").append("<input  class='margin text-center paginput' id='changePage' type='text'> 页  <a class='btn btn-default shiny pagbtn' style='margin-bottom:5px' href='javascript:void(0);' id='dataTable-btn'>跳转</a>");
            var oTable = $("#bidDemadPageTable").dataTable();
            $('#dataTable-btn').click(function(e) {
                if($("#changePage").val() && $("#changePage").val() > 0) {
                    var redirectpage = $("#changePage").val() - 1;
                } else {
                    var redirectpage = 0;
                }
                oTable.fnPageChange(redirectpage);
            });
        },
        "aoColumns" : [
            {"data" : "demandCode"},
            {"data" : null},
            {"data" : null},
            {"data" : null},
            {"data" : null},
            {"data" : "dateRequiredDeliveryTime"},
            {"data" : "minPurchaseAmount"},
            {"data" : "maxPurchaseAmount"},
            {"data" : "demandAddress"},
            {"data" : "complianceAuditNum"}
        ],
        "aoColumnDefs":[
            {
                "sClass":"tdTips",
                "aTargets":[1],
                "data":"goodsDesription",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    // debugger;
                    return  c.goodsDesription; // code 到时改为需求编号
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[2],
                "data":"goodsBrand",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return  c.goodsBrand; // code 到时改为需求编号
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[3],
                "data":"goodsModel",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return  c.goodsModel; // code 到时改为需求编号
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[4],
                "data":"specification",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return  c.specification; // code 到时改为需求编号
                }
            },
            {
                "sClass":"or",
                "aTargets":[10],
                "data":"demandCode",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return '<em  onclick="findBidDemand(&quot;' + a + '&quot;)">查看</em>'; // code 到时改为需求编号
                }
            }
        ],
        "fnServerData" : function(sSource, aoData, fnCallback) {
            var serializeData = function(aoData){
                var data = {};
                for(var i = 0 ;i<aoData.length ;i++){
                    var dd = aoData[i];
                    if(dd['value']){
                        data[ dd['name'] ]= dd['value'];
                    }
                }
                return $.param(data);
            };

            $.ajax({
                "type" : 'post',
                "url" : sSource,
               "data" :serializeData(aoData),
                "success" : function(resp) {
                    fnCallback(resp.data);
                    tableTips();
                },
                "error" : function () {
                    showMessage({message: "系统出错，请联系管理员"});
                }
            });
        }

    });

});

//查看
function findBidDemand(demandCode,obj) {
    // $("td").each(function () {
    //     if ($(this).text() == demandCode){
    //         $(this).parent("tr").addClass("showing").siblings().removeClass("showing");
    //         return false;
    //     }
    // });
    $('#bidDemadPageTable').find("tr").each(function () {
        if ($(this).children(":first").text() == demandCode){
            $(this).addClass("showing").siblings().removeClass("showing");
            return false;
        }
    });
    $.ajax({
        url: "/bidding-web/biddingOperator/getBiddingDemandInfo",
        data: {
            // "biddingCode" : biddingNo,
            "demandCode" : demandCode,
        },
        type: 'post',
        success:function (data) {
            var bidDemand;
            if(data){
                $('.relevant-demand-detils').removeClass('hide').html(template('_relevant_demand_container_tpl',{bidDemand: data}));
                $(this).addClass('hover').siblings().removeClass('hover');
            }else {
                showMessage(data.message);
            }
        }
    })
}