var bdl_table;
var biddingCode = biddingNo;

$(function () {
    bdl_table = $('#bdl_table').DataTable({
        "oLanguage": {
            "sLengthMenu": "每页显示 _MENU_ 条记录",
            "sZeroRecords": "抱歉， 没有找到",
            "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
            "sInfoEmpty": "",
            "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
            "oPaginate": {
                "sFirst": "首页",
                "sPrevious": "前一页",
                "sNext": "后一页",
                "sLast": "尾页"
            },
            "sZeroRecords": "没有检索到数据",
            "sProcessing": "<img src='./loading.gif' />",
            "sSearch": "搜索"
        },
        "sDom":'rt<"row"<"col-2"i><"col-8"p><"col-2"l>>',//自定义布局
        "bStateSave" : false,
        "bJQueryUI" : true,
        "bPaginate" : true,// 分页按钮
        "bFilter" : false,// 搜索栏
        "aLengthMenu" : [5, 10, 20, 50, 100], //更改显示记录数选项
        "bLengthChange":true,// 每行显示记录数
        "iDisplayLength" : 5,// 每页显示行数
        "bSort" : false,// 排序
        "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
        "bWidth" : true,
        "bScrollCollapse" : true,
        "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
        "bServerSide" : true,
        "bDestroy" : true,
        "bSortCellsTop" : true,
        "sAjaxSource" : "/bidding-web/biddingOperator/findbiddingLog",
        "fnInitComplete": function() {
            this.fnAdjustColumnSizing(true);
        },
        //向服务器传额外的参数
        "fnServerParams" : function(aoData) {
            // var jcbdBiddingNo = $("#jcbdBiddingNo").val();
            aoData.push({
                "name" : "biddingCode",
                "value" : biddingCode
            });
        },
        "fnDrawCallback" : function(table) {
            //指定跳转页面
            $("#bdl_table_paginate").append("<input  class='margin text-center paginput' id='changePage' type='text'> 页  <a class='btn btn-default shiny pagbtn' style='margin-bottom:5px' href='javascript:void(0);' id='dataTable-btn'>跳转</a>");
            var oTable = $("#bdl_table").dataTable();
            $('#dataTable-btn').click(function(e) {
                if($("#changePage").val() && $("#changePage").val() > 0) {
                    var redirectpage = $("#changePage").val() - 1;
                } else {
                    var redirectpage = 0;
                }
                oTable.fnPageChange(redirectpage);
            });
        },
        "aoColumns" : [
            {"data" :  function(row, type, set, meta) {
                    var c = meta.settings._iDisplayStart + meta.row + 1;
                    return c;
                }},
            {"data" : "operationTimeNew"},
            {"data" : null},
            {"data" : null},
            {"data" : null},
        ],
        "aoColumnDefs":[
            {
                "sClass":"tdTips",
                "aTargets":[2],
                "data":"operatorName",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return a.operatorName;
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[3],
                "data":"operationContent",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return a.operationContent;
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[4],
                "data":"remark",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return a.remark;
                }
            }
        ],
        "fnServerData" : function(sSource, aoData, fnCallback) {
            var serializeData = function(aoData){
                var data = {};
                for(var i = 0 ;i<aoData.length ;i++){
                    var dd = aoData[i];
                    if(dd['value']){
                        data[ dd['name'] ]= dd['value'];
                    }
                }
                return $.param(data);
            };

            $.ajax({
                "type" : 'post',
                "url" : sSource,
                "data" :serializeData(aoData),
                "success" : function(resp) {
                    fnCallback(resp.data);
                    tableTips();
                },
                "error" : function () {
                    hideCannle();
                    showMessage({message: "系统出错，请联系管理员"});
                }
            });
        }

    });

});