var orderResult = {};
orderResult.initTable = function(){
};
orderResult.initTable.prototype = {

    // 表格数据
    initTable : function(){
        $('#orderResultTable').DataTable({
            "sAjaxSource" : "/bidding-web/biddingOperator/getBiddingOrderResultList",
            "fnServerData" : function(sSource, aoData, fnCallback) {
                var serializeData = function(aoData){
                    var data = {};
                    for(var i = 0 ;i<aoData.length ;i++){
                        var dd = aoData[i];
                        if(dd['value']){
                            data[ dd['name'] ]= dd['value'];
                        }
                    }
                    return $.param(data);
                };
                $.ajax({
                    "url" :sSource,
                    //"dataType" : "json",
                    //"dataSrc": "data",
                    type:"POST",
                    "data" :serializeData(aoData),
                    "success" : function(resp) {
                        if (resp.status=="success"){
                            fnCallback(resp.data);
                        }else {
                            showMessage({message: "系统出错，请重新登陆"});
                        }
                    },
                    "error" : function () {
                        showMessage({message: "系统出错，请重新登陆"});
                    }
                });
            },
            "fnInitComplete": function() {
                this.fnAdjustColumnSizing(true);
            },
            //向服务器传额外的参数
            "fnServerParams" : function(aoData) {
                aoData.push({
                    "name" : "biddingNo",
                    "value" : biddingNo
                });
            },
            "fnDrawCallback" : function(table) {
                //指定跳转页面
                $("#orderResultTable_paginate").append("<input  class='margin text-center paginput' id='changePage' type='text'> 页  <a class='btn btn-default shiny pagbtn' style='margin-bottom:5px' href='javascript:void(0);' id='dataTable-btn'>跳转</a>");
                var oTable = $("#orderResultTable").dataTable();
                $('#dataTable-btn').click(function(e) {
                    if($("#changePage").val() && $("#changePage").val() > 0) {
                        var redirectpage = $("#changePage").val() - 1;
                    } else {
                        var redirectpage = 0;
                    }
                    oTable.fnPageChange(redirectpage);
                });
            },
            "columns": [
                { "data": "orderNo" },
                {"data": "purchaseNo"},
                {"data": "orderNo"},
                {
                    "data": null,
                    /*"data": "dateCreated",
                    "render" : function(data) {
                        if(data){
                            return dateFtt("yyyy-MM-dd hh:mm:ss", new Date(data));
                        }else{
                            return data;
                        }
                    }*/
                },
                {"data": "goodsNumber"},
                { "data": "singleAmount" },
                {
                    "data": null ,
                    /*"render" : function(data) {
                        if(data){
                            return dateFtt("yyyy-MM-dd hh:mm:ss", new Date(data));
                        }else{
                            return data;
                        }
                    }*/
                },
                { "data" : "statusDescription" },
                {
                    "data" : "operation",
                    "render" : function(data, type, full, meta) {
                        if(data!=null){
                            // debugger;
                            var option ="";
                            for(var i=0; i<data.length; i++){
                                var eventDes =data[i].event;
                                if(eventDes!=null){
                                    option = option + '<a href="javascript:void(0);"  orderId = "'+ full.id +'" status = "'+ full.status +'" biddingCode = "'+ full.biddingCode +'" orderNo = "'+ full.orderNo +'" onclick="new orderResult.initTable().'+ data[i].event + '"> '+ data[i].operationName + '</a>&nbsp;'
                                }else{
                                    option = option + '<a href="javascript:void(0);"  orderId = "'+ full.id +'" > '+ data[i].operationName + '</a>&nbsp;'
                                }
                            }
                            return option ;
                        }else{
                            return data;
                        }
                    }
                }
            ],
            //隐藏第一列
             "aoColumnDefs":[
                 {
                     "sClass":"or",
                     "aTargets":[0],
                     "data":"operations",
                     "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                         var retur = '' ;
                         return retur;
                     }
                 },
                 {
                     "sClass": "timeC",
                     "aTargets": [3],
                     "data": "dateCreated",
                     "mRender": function (a, b, c, d) {//id，c表示当前记录行对象
                         if(a.dateCreated){
                             return dateFtt("yyyy-MM-dd hh:mm:ss", new Date(a.dateCreated));
                         }else{
                             return a.dateCreated;
                         }
                     }
                 },
                 {
                     "sClass": "timeC",
                     "aTargets": [6],
                     "data": "confirmationTime",
                     "mRender": function (a, b, c, d) {//id，c表示当前记录行对象
                         if(a.confirmationTime){
                             return dateFtt("yyyy-MM-dd hh:mm:ss", new Date(a.confirmationTime));
                         }else{
                             return a.confirmationTime;
                         }
                     }
                 }

             ],
            "sDom":'rt<"row"<"col-2"i><"col-8"p><"col-2"l>>',//自定义布局
            "bServerSide" : true, //需要向后代传jqueryDataTablesVo数据
            "searching":false,
            "paging": true,
            "ordering": false,
            "bPaginate": true,
            "bSort": false, // 排序
            "bFilter" : false,// 搜索栏
            "aLengthMenu" : [5, 10, 20, 50, 100], //更改显示记录数选项
            "bLengthChange":true,// 每行显示记录数
            "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
            "bWidth" : true,
            "bScrollCollapse" : true,
            "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
            "bAutoWidth":true,
            "iDisplayLength" : 5,// 每页显示行数
            //"bServerSide" : true,
            "bDestroy" : true,
            "bSortCellsTop" : true,
            "oLanguage" : {
                "sProcessing" : "正在获取数据，请稍后...",
                "sLengthMenu" : "显示 _MENU_ 条",
                "sZeroRecords" : "没有检索到数据",
                "sInfo" : "从 _START_ 到  _END_ 条记录 总记录数为 _TOTAL_ 条",
                "sInfoEmpty" : "记录数为0",
                "sInfoFiltered" : "(全部记录数 _MAX_ 条)",
                "sInfoPostFix" : "",
                "sSearch" : "搜索",
                "sUrl" : "",
                "oPaginate" : {
                    "sFirst" : "首页",
                    "sPrevious" : "前一页",
                    "sNext" : "后一页",
                    "sLast" : "尾页"
                }
            }
        } );
    },

    //取消订单
    cancelOrder :function (obj) {
        var orderNo = $(obj).attr("orderNo");
        $.ajax({
            url: '/bidding-web/biddingOperator/updateStatusByOrderNo',
            type:"POST",
            data:{
                status:7,
                orderNo:orderNo
            },
            success: function (data) {
                new orderResult.initTable().getInfo();
                new orderResult.initTable().initTable();
                sDefiShowMessage({message:"取消订单成功"});
            },
            error: function () {
                sDefiShowMessage({message:"请求失败"});

            }
        })
    },
    //删除订单
    deleteOrder :function (obj) {
        var orderNo = $(obj).attr("orderNo");
        $.ajax({
            url: '/bidding-web/biddingOperator/deleteJcbdMallOrderByOrderNo',
            type:"POST",
            data:{
                orderNo:orderNo
            },
            success: function (data) {
                new orderResult.initTable().getInfo();
                new orderResult.initTable().initTable();
                sDefiShowMessage({message:"删除订单成功"});
            },
            error: function () {
                sDefiShowMessage({message:"请求失败"});
            }
        })
    },
    getInfo :function () {
        $.ajax({
            url:'/bidding-web/biddingOperator/getOrderResultInfo?biddingNo='+biddingNo,
            type:"GET",
            success:function(data){
                $("#totalAmount").html(data.getTotalAmount);
                $("#totalNum").html(data.getTotalNum);
                $("#totalSingular").html(data.getTotalSingular);
                $("#singularNumber").html(data.getSingularNumber);
                $("#noSingularNumber").html(data.getNoSingularNumber);
                $("#cancelOrder").html(data.getCancelOrderNumber);
            }
        });
    },
    detailOrder :function (obj) {
        var biddingCode = $(obj).attr("biddingCode");
        var orderNo = $(obj).attr("orderNo");
        var status = $(obj).attr("status");
        window.location.href = "/bidding-web/operator/orderDetail?biddingCode=" + biddingCode +"&orderNo=" +orderNo + "&status=" + status ;
    }
}

$(function(){
    var obj = new orderResult.initTable();
    obj.initTable();
    obj.getInfo();
})