var bidDemadPageTable;
var biddingCode = biddingCode;

$(function () {
    bidDemadPageTable = $('#bidDemadPageTable').DataTable({
        "oLanguage": {
            "sLengthMenu": "每页显示 _MENU_ 条记录",
            "sZeroRecords": "抱歉， 没有找到",
            "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
            "sInfoEmpty": "",
            "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
            "oPaginate": {
                "sFirst": "首页",
                "sPrevious": "前一页",
                "sNext": "后一页",
                "sLast": "尾页"
            },
            "sZeroRecords": "没有检索到数据",
            "sProcessing": "<img src='./loading.gif' />",
            "sSearch": "搜索"
        },

        "bStateSave": false,
        "bJQueryUI": true,
        "bPaginate": true,// 分页按钮
        "bFilter": false,// 搜索栏
        "bLengthChange": false,// 每行显示记录数
        "iDisplayLength": 5,// 每页显示行数
        "bSort": false,// 排序
        "bInfo": true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
        "bWidth": true,
        "bScrollCollapse": true,
        "sPaginationType": "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
        "bServerSide": true,
        "bDestroy": true,
        "bSortCellsTop": true,
        "sAjaxSource": "/bidding-web/biddingOperator/findBidDemandPage",
        "fnInitComplete": function () {
            this.fnAdjustColumnSizing(true);
        },
        //向服务器传额外的参数
        "fnServerParams": function (aoData) {
            // var jcbdBiddingNo = $("#jcbdBiddingNo").val();
            aoData.push({
                "name": "biddingCode",
                "value": biddingCode
            });
        },
        "aoColumns": [
            {"data": "demandCode"},
            {"data": "goodsDesription"},
            {"data" : null},
            {"data" : null},
            {"data" : null},
            // {"data" : "goodsBrand"},
            // {"data" : "goodsModel"},
            // {"data" : "specification"},
            {"data": "dateRequiredDeliveryTime"},
            {"data": "minPurchaseAmount"},
            {"data": "maxPurchaseAmount"},
            {"data": "demandAddress"},
            {"data": "complianceAuditNum"}
        ],
        "aoColumnDefs": [
            {
                "sClass":"tdTips",
                "aTargets":[1],
                "data":"goodsDesription",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return  c.goodsDesription; // code 到时改为需求编号
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[2],
                "data":"goodsBrand",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return  c.goodsBrand; // code 到时改为需求编号
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[3],
                "data":"goodsModel",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return  c.goodsModel; // code 到时改为需求编号
                }
            },
            {
                "sClass":"tdTips",
                "aTargets":[4],
                "data":"specification",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    return  c.specification; // code 到时改为需求编号
                }
            },
            {
                "sClass": "or",
                "aTargets": [10],
                "data": "demandCode",
                "mRender": function (a, b, c, d) {//id，c表示当前记录行对象
                    var demandCode = a;
                    return '<em onclick="findBidDemand(&quot;' + demandCode + '&quot;)">查看及修改</em>'
                        + "|" +
                        '<em  onclick="deleteBidDemand(&quot;' + demandCode + '&quot;)">删除</em>';
                }
            }
        ],
        "fnServerData": function (sSource, aoData, fnCallback) {
            // debugger;
            var serializeData = function (aoData) {
                var data = {};
                for (var i = 0; i < aoData.length; i++) {
                    var dd = aoData[i];
                    if (dd['value']) {
                        data[dd['name']] = dd['value'];
                    }
                }
                return $.param(data);
            };

            $.ajax({
                "type": 'post',
                "url": sSource,
                "data": serializeData(aoData),
                "success": function (resp) {
                    fnCallback(resp.data);
                    tableTips();
                },
                "error": function () {
                    showMessage({message: "系统出错，请联系管理员"});
                }
            });
        }

    });

});

//查看及修改
function findBidDemand(demandCode) {
    // debugger;
    $.ajax({
        url: "/bidding-web/biddingOperator/getBiddingDemandInfo",
        data: {
            "demandCode": demandCode,
        },
        type: 'post',
        success: function (data) {
            var bidDemand;
            if (data) {
                $('#demandCode').val(data.demandCode)
                $('#goodsDesription').val(data.goodsDesription)
                $('#goodsBrand').val(data.goodsBrand)
                $('#goodsModel').val(data.goodsModel)
                $('#specification').val(data.specification)
                $('#serviceRequirement').val(data.serviceRequirement)
                $('#dateRequiredDeliveryTime').val(data.dateRequiredDeliveryTime)
                $('#txtNumber').val(data.minPurchaseAmount)
                $('#maxPurchaseAmount').val(data.maxPurchaseAmount)

                //需求数量及地址
                var addAndNeehtml = template('addAndNee', {demand_e: data});
                document.getElementById('addAndNeeId').innerHTML = addAndNeehtml;

                //符合性审查
                var conformanhtml = template('conformans', {demand_e: data});
                document.getElementById('conformanId').innerHTML = conformanhtml;

                defaultAddress();
                $('.area-select-plugin').each(function () {
                    AreaSelectPlugin.createNew().init({
                        el: $(this), maxLevel: 3,
                        autoSelect : false,
                        dataReqUrl: '/members/areaCommon/findAll',
                        ipAddressUrl: '/members/areaCommon/ipAddress'
                    });
                });

                $(".relevant-info").removeClass("dis");
            } else {
            }
        }
    })
}

//删除
function deleteBidDemand(demandCode) {

    bidDemandFormReset();

    $.ajax({
        url: "/bidding-web/biddingOperator/deleteBidDemand",
        async: false,
        data: {
            "demandCode": demandCode,
        },
        type: 'post',

        success: function (data) {
            if (data) {
                reloadDemand();
                sDefiShowMessage({message: "删除成功"});
                if(!$(".relevant-info").hasClass("dis")){
                    $(".relevant-info").addClass("dis");
                }
            } else {
                sDefiShowMessage({message: "删除失败"});
            }
        }

    })
}

function reloadDemand() {
    bidDemadPageTable.ajax.reload();
}