var table;
var searchFlag=false;
var biddingCode = biddingNo;

$(function () {
    table= $('#bidDemadPageTable').DataTable({
//            "dom": '<"toolbar">frtip',
//            "dom": '<"top"i>rt<"bottom"flp><"clear">',
//         "sDom":'rt<"row"<"col-sm-3"i><"col-sm-6"p><"col-sm-3"l>>',//自定义布局
        "oLanguage": {
            "sLengthMenu": "每页显示 _MENU_ 条记录",
            "sZeroRecords": "抱歉， 没有找到",
            "sInfo": "从 _START_ 到 _END_ /共 _TOTAL_ 条数据",
            "sInfoEmpty": "",
            "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
            "oPaginate": {
                "sFirst": "首页",
                "sPrevious": "前一页",
                "sNext": "后一页",
                "sLast": "尾页"
            },
            "sZeroRecords": "没有检索到数据",
            "sProcessing": "<img src='./loading.gif' />",
            "sSearch": "搜索"
        },
        "sDom":'rt<"row"<"col-2"i><"col-8"p><"col-2"l>>',//自定义布局
        "bStateSave" : false,
        "bJQueryUI" : true,
        "bPaginate" : true,// 分页按钮
        "bFilter" : false,// 搜索栏
        "aLengthMenu" : [5, 10, 20, 50, 100], //更改显示记录数选项
        "bLengthChange":true,// 每行显示记录数
        "iDisplayLength" : 5,// 每页显示行数
        "bSort" : false,// 排序
        "bInfo" : true,// Showing 1 to 10 of 23 entries 总记录数没也显示多少等信息
        "bWidth" : true,
        "bScrollCollapse" : true,
        "sPaginationType" : "full_numbers", // 分页，一共两种样式 另一种为two_button // 是datatables默认
        //  "bProcessing" : true,
        "bServerSide" : true,
        "bDestroy" : true,
        "bSortCellsTop" : true,
        "sAjaxSource" : "/bidding-web/biddingOperator/findBidDemandPage",
        //  "sScrollY": "100%",
        "fnInitComplete": function() {
            this.fnAdjustColumnSizing(true);
        },
        //向服务器传额外的参数
        "fnServerParams" : function(aoData) {
            // var jcbdBiddingNo = $("#jcbdBiddingNo").val();
            aoData.push({
                "name" : "biddingCode",
                "value" : encodeURI(biddingCode)
            });
        },
        "fnDrawCallback" : function(table) {
            //指定跳转页面
            $("#bidDemadPageTable_paginate").append("<input  class='margin text-center paginput' id='changePage' type='text'> 页  <a class='btn btn-default shiny pagbtn' style='margin-bottom:5px' href='javascript:void(0);' id='dataTable-btn'>跳转</a>");
            var oTable = $("#bidDemadPageTable").dataTable();
            $('#dataTable-btn').click(function(e) {
                if($("#changePage").val() && $("#changePage").val() > 0) {
                    var redirectpage = $("#changePage").val() - 1;
                } else {
                    var redirectpage = 0;
                }
                oTable.fnPageChange(redirectpage);
            });
        },
        "aoColumns" : [
            {"data" : "demandNo"},
            {"data" : "goodsDesription"},
            {"data" : "requiredDeliveryDateTime"},
            {"data" : "lowestPurchaseNumber"},
            {"data" : "highestPurchaseNumber"},
            {"data" : "demandAddress"},
            {"data" : "conformanceNumber"},
            {"data" : "demandResponseStatus"}
        ],
        "aoColumnDefs":[
            {
                "sClass":"or",
                "aTargets":[8],
                "data":"demandNo",
                "mRender":function(a,b,c,d){//id，c表示当前记录行对象
                    if (c.demandResponseStatus=="已响应"){
                        return '<em onclick="lookDemandResponse(&quot;' + a + '&quot;)">查看及修改</em>';
                    }else{
                        return '<em onclick="lookDemandResponse(&quot;' + a + '&quot;)">删除</em>';
                    }
                }
            }
        ],
        "fnServerData" : function(sSource, aoData, fnCallback) {
            var serializeData = function(aoData){
                var data = {};
                for(var i = 0 ;i<aoData.length ;i++){
                    var dd = aoData[i];
                    if(dd['value']){
                        data[ dd['name'] ]= dd['value'];
                    }
                }
                return $.param(data);
            };

            $.ajax({
                "type" : 'post',
                "url" : sSource,
                //"dataType" : "json",
                //"dataSrc": "data",
                "data" :serializeData(aoData),
                "success" : function(resp) {
                    if (resp.status=="success"){
                        fnCallback(resp.data);
                    }else {
                        hideCannle()
                        showMessage({message: resp.message + "请联系管理员"})
                    }
                },
                "error" : function () {
                    hideCannle()
                    showMessage({message: "系统出错，请联系管理员"});
                }
            });
        }

    });

});



//保存需求
$("#saveRelevant").on("click",saveRelevant);

function saveRelevant() {
    $('#saveRelevant').off("click", saveRelevant);
    $('#saveRelevant').html("保存中...");
    if ($("#saveRelevant").attr("data-code")){
        var submitParam = param();
        if (submitParam){
            $.ajax({
                url: "/bidding-web/biddingProvider/saveBiddingDemadResp",
                data: JSON.stringify(submitParam),
                dataType: "json",
                type: 'post',
                cache: false,
                contentType: "application/json; charset=gbk",
                success: function (data) {
                    if(data.status=='success'){
                        table.ajax.reload();
                        $('#saveRelevant').on("click", saveRelevant);
                        $('#saveRelevant').html("保存");
                    }else {
                        hideCannle();
                        showMessage({message: data.message});
                        $('#saveRelevant').on("click", saveRelevant);
                        $('#saveRelevant').html("保存");
                    }
                },
                error:function(e){
                    console.log(e);
                    hideCannle();
                    showMessage({message: "系统出错,请尝试重新登陆"});
                    $('#saveRelevant').on("click", saveRelevant);
                    $('#saveRelevant').html("保存");
                }
            });
        }
        $('#saveRelevant').on("click", saveRelevant);
        $('#saveRelevant').html("保存")
    }else{
        hideCannle();
        showMessage({message: "请选择需要保存的响应"})
        $('#saveRelevant').on("click", saveRelevant);
        $('#saveRelevant').html("保存")
    }
}

$("#submitResp").on("click",submitResp);

//判断是否所有需求均已经响应
function submitResp() {
    $.ajax({
        url: "/bidding-web/biddingProvider/checkIsAllRespond",
        data: {"biddingCode":biddingCode},
        // dataType: "json",
        type: 'post',
        cache: false,
        // contentType: "application/json; charset=gbk",
        success: function (data) {
            if(data.status=='success'){
                checkDemadIsAllAccord();
            }else {
                hideCannle();
                showMessage({message: data.message});
            }
        },
        error:function(e){
            console.log(e);
            hideCannle();
            showMessage({message: "系统出错,请尝试重新登陆"});
        }
    });
}

//判断所有响应是否都符合
function checkDemadIsAllAccord() {
    $.ajax({
        url: "/bidding-web/biddingProvider/checkDemadIsAllAccord",
        data: {"biddingCode":biddingCode},
        // dataType: "json",
        type: 'post',
        success: function (data) {
            if(data.status=='success'){
                submitResp1();
            }else {
                if (data.error=="2"){
                    showCannle();
                    $(document).on("click","#sureEditBtn",submitResp1);
                    showMessage({message: data.message});
                }else{
                    hideCannle();
                    showMessage({message: data.message});
                }
            }
        },
        error:function(e){
            console.log(e);
            hideCannle();
            showMessage({message: "系统出错,请尝试重新登陆"});
        }
    });
}

function submitResp1() {
    var jcbdBiddingNo = biddingCode;
    var offerValidityTime = $("#offerValidity").val();
    if (offerValidityTime){
        hideCannle();
        showMessage({message: "请输入报价有效期"});
    }
    var supplierBiddingResponseVo = {};
    supplierBiddingResponseVo.jcbdBiddingNo = jcbdBiddingNo;
    supplierBiddingResponseVo.offerValidityTime = offerValidityTime;
    $.ajax({
        url: "/bidding-web/biddingProvider/submitResp",
        data: JSON.stringify(supplierBiddingResponseVo),
        dataType: "json",
        type: 'post',
        success: function (data) {
            if(data.status=='success'){
                window.location.href="biddingManage";
            }else {
                hideCannle();
                showMessage({message: data.message});
            }
        },
        error:function(e){
            console.log(e);
            hideCannle();
            showMessage({message: "系统出错,请尝试重新登陆"});
        }
    });
}


function param() {
    var goodsTitle = $("#goodsTitle").val();
    if (goodsTitle==""){
        hideCannle()
        showMessage({message: "请输入商品名称"});
        return;
    }
    var goodsParams = $("#goodsParams").val();
    if (goodsParams==""){
        hideCannle()
        showMessage({message: "请输入品牌、型号、规格参数"});
        return;
    }
    var servicePromise = $("#servicePromise").val();
    if (servicePromise==""){
        hideCannle()
        showMessage({message: "请输入服务承诺"});
        return;
    }
    var sku = $("#sku").val();
    var goodsLink = $("#goodsLink").val();
    // var strRegex = "\b(([\w-]+://?|www[.])[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|/)))";
    var strRegex = "^(((ht|f)tp(s?))\://)?([a-zA-Z0-9\.\-]+(\:[a-zA-Z0-9\.&%\$\-]+)*@)"
        +"*((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])"
        +"\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)"
        + "\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)"
        +"\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])"
        +"|localhost|([a-zA-Z0-9\-]+\.)*[a-zA-Z0-9\-]+\."
        +"(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2}))"
        +"(\:[0-9]+)*(/($|[a-zA-Z0-9\.\,\?\'\\\+&%\$#\=~_\-]+))*$";
    // var strRegex = "^((https|http|ftp|rtsp|mms)?://)"
    //     + "?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?" //ftp的user@
    //     + "(([0-9]{1,3}\.){3}[0-9]{1,3}" // IP形式的URL- 199.194.52.184
    //     + "|" // 允许IP和DOMAIN（域名）
    //     + "([0-9a-z_!~*'()-]+\.)*" // 域名- www.
    //     + "([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\." // 二级域名
    //     + "[a-z]{2,6})" // first level domain- .com or .museum
    //     + "(:[0-9]{1,4})?" // 端口- :80
    //     + "((/?)|" // a slash isn't required if there is no file name
    //     + "(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$";
    var re = new RegExp(strRegex)
    if (goodsLink){
        if (!re.test(goodsLink)){
            hideCannle()
            showMessage({message: "请有效的网址"});
            return;
        }
    }
    var mallAttachmentVos = $("[name=uploadFileInputs[]]")
    var attachment = new Array();
    for (var i= 0;i<mallAttachmentVos.length;i++){
        var mallAttachmentVo = {};
        mallAttachmentVo.attachmentName = this.attr("fileName");
        mallAttachmentVo.attachmentCorrelation = $("#biddingId").val();
        mallAttachmentVo.url = this.attr("absoluteFilePath");
        mallAttachmentVo.path = this.attr("filePath");
        attachment.push(mallAttachmentVo);
    }
    var price = $("#price").val();
    if (price==""){
        hideCannle()
        showMessage({message: "请输入报价（单价）"});
        return;
    }
    var supplyPeriod = $("#supplyPeriod").val();
    if (supplyPeriod==""){
        hideCannle()
        showMessage({message: "请输入供货周期"});
        return;
    }
    var remark = $("#remark").val();
    var providerAddressResponses =  new Array();
    var providerConformanceResps =  new Array();
    var address= $(".addr");
    for(var i= 0;i<address.length;i++){
        var providerAddressResponse = {};
        providerAddressResponse.demandAddressId = $(".addr"+i).val();
        providerAddressResponse.remark = $(".addrRemark"+i).val();
        var status = $('input[name="addrStatus'+i+'"]:checked').val();
        if (typeof status === "undefined" ){
            hideCannle()
            showMessage({message: "请选择是否满足需求"});
            return;
        }
        providerAddressResponse.status =status;
        providerAddressResponses.push(providerAddressResponse);
    }
    var conformance= $(".conform");
    for(var i= 0;i<conformance.length;i++){
        var providerConformanceResp = {};
        providerConformanceResp.biddingConformanceId = $(".conform"+i).val();
        providerConformanceResp.remark = $(".conformRemark"+i).val();
        var status = $('input[name="conformStatus'+i+'"]:checked').val();
        if (typeof status === "undefined" ){
            hideCannle()
            showMessage({message: "请选择是否满足符合性审查"});
            return;
        }
        providerConformanceResp.status = status;
        // providerConformanceResp.conformance = "1";
        providerConformanceResps.push(providerConformanceResp);
    }
    var biddingDemand = {};
    biddingDemand.demandCode = $("#saveRelevant").attr("data-code");
    biddingDemand.biddingId = $("#biddingId").val();
    var biddingDemandResponseVo = {};
    biddingDemandResponseVo.goodsTitle = goodsTitle;
    biddingDemandResponseVo.goodsParams = goodsParams;
    biddingDemandResponseVo.servicePromise = servicePromise;
    biddingDemandResponseVo.sku = sku;
    biddingDemandResponseVo.goodsLink = goodsLink;
    biddingDemandResponseVo.price = price;
    biddingDemandResponseVo.supplyPeriod = supplyPeriod;
    biddingDemandResponseVo.remark = remark;
    biddingDemandResponseVo.providerAddressResponses = providerAddressResponses;
    biddingDemandResponseVo.providerConformanceResps = providerConformanceResps;
    biddingDemandResponseVo.biddingDemand = biddingDemand;
    biddingDemandResponseVo.attachment = attachment;
    return biddingDemandResponseVo;
}

function lookDemandResponse(code) {
    // debugger
    $("#saveRelevant").attr("data-code",code);
    $(".supplierBidRelevant_content_").empty();
    $(".supplierBidRelevant_content_").load("/bidding-web/biddingOperator/getBidDemand?demandCode="+code);
    $(".supplierBidRelevant_content_").load("/bidding-web/biddingOperator/deleteBidDemand?demandCode="+code);

}

