
$(function () {
    var demandCode = $("#saveRelevant").attr("data-code");

    $.ajax({
        url: "/bidding-web/biddingProvider/getBiddingDemadDetail",
        data: {
            "demandCode" : demandCode,
            "biddingNo": biddingNo,
        },
        type: 'post',
        success: function (data) {
            $("#offerValidity").val(data.offerValidityTime);
            $('.relevant_info_container').html(template('relevant_info_container_tpl', data));
            $(".saveRelevant").on("click",saveRelevantRespo);
            var attachmentList = data.attachment;

            if(attachmentList != null && typeof attachmentList != 'undefined' && attachmentList.length >0){
                $("#fileinput-container").html('');
                fileUploadViewModel.fileinputs = [];
                for(var i =0;i<attachmentList.length;i++){
                    var model = {
                        title: "请选择文件",
                        showDelBtn: false,
                        idx: i,
                        filePath: attachmentList[i].path,
                        fileName: attachmentList[i].attachmentName,
                        uploading: false
                    };
                    fileUploadViewModel.fileinputs.push(model);
                    addFileUploader(fileUploadViewModel, i)
                    input = $(document.createElement("input")).addClass('upload-file-input')
                        .attr('type', 'hidden')
                        .attr('name', 'uploadFileInputs[]')
                        .attr("filePath",attachmentList[i].path)
                        .attr("absoluteFilePath",attachmentList[i].url)
                        .attr("fileName",attachmentList[i].attachmentName);
                    input.appendTo($('#relevant-info-form'));
                }
            }else{
                /** 默认初始化 */
                addFileUploader(fileUploadViewModel, 0);
            }

             $("#biddingId").val('');
             $("#biddingId").val(data.biddingDemand.biddingId);
        },
        error: function (e) {
            console.log(e);
            hideCannle();
            showMessage({message: "系统出错,请联系管理员"});
        }
    });
});

$(document).on("blur","#supplyPeriod",function(){
    // debugger
    var preg2 = /^[1-9]?[0-9]?$/;
    var preg3 = /\b[1][0-7]{1}[0-9]{1}|[1][8][0]\b/;
    var periodVal = $("#supplyPeriod").val();
    if(periodVal==0){
        $("#supplyPeriod").val('');
        return;
    }
    var leng = periodVal.length;
    if(leng < 3){
        var retVal = preg2.test(periodVal)?periodVal:'';
        $("#supplyPeriod").val(retVal);
    }else if(leng == 3){
        var retVal = preg3.test(periodVal)?periodVal:'';
        $("#supplyPeriod").val(retVal);
    }

});



/** =================文件上传相关 START============== */
var ieVer = function() {
    var rv = -1; // Return value assumes failure.

    if (navigator.appName == 'Microsoft Internet Explorer')
    {
        var ua = navigator.userAgent;
        var re  = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
        if (re.exec(ua) != null)
            rv = parseFloat( RegExp.$1 );
    }

    return rv;
};

var fileUploadViewModel = {
    uploadUrl: '/image/api/textjson/',
    ieVer: ieVer(),
    fileinputs: [
        { // 默认显示一个
            title:"请选择文件",
            showDelBtn: false,
            idx: 0,
            filePath: "",
            uploading: false
        }
    ]
};

$(document).on('click', '.add-fileinput-button', function () {
    // debugger
    var $uploads = $(this).parents('.file-uploads-group').find('.fileupload');
    var curIdx = $uploads.length; // idx 从0开始
    if (curIdx <= 50) {
        var model = {
            title:"请选择文件",
            showDelBtn: curIdx > 0,
            idx: curIdx,
            filePath: "",
            uploading: false
        };
        fileUploadViewModel.fileinputs.push(model);
        addFileUploader(fileUploadViewModel, curIdx);
    } else {
        $('#fileupload-input-counts-overed').removeClass('f-hide').show();
    }
});

var initFileUpload = function ($element) {
    $element.fileupload({
        // maxFileSize: 20 * 1024 * 1024, //20M
        // acceptFileTypes : /(\.|\/)(gif|jpeg|jpg|png|docx|xlsx|doc|xls|pdf|txt|html|htm|csv)$/i,
        iframe: ieVer() > 0 && ieVer() < 50,
        dataType: 'text',
        add: function(e, data) {
            var acceptFileTypes = /(\.|\/)(VBS|VBE|javascript|JSE|WSH|WSF|x-msdownload)$/i;
            //文件类型判断
            if(data.originalFiles[0]['type'].length && acceptFileTypes.test(data.originalFiles[0]['type'])|| data.originalFiles[0]['type']=="") {
                sDefiShowMessage({message:"您上传的文件格式不符合规则,请重新上传"})
                return;
            }else{
                data.submit();
            }
            /* $('#progress').css(
             'width','0%'
             );
             $('#progress .bar').css(
             'width', '0%'
             );*/
        },
        send: function (e, data) {
           
            $(this).parent().find('.fileinput-name').html('上传中...').text('上传中...').css({color: '#333'});;
            fileUploadViewModel.fileinputs[$element.attr('data-fileupload-idx')].uploading = true;
            $(this).attr('data-uploading', true);
            /** 禁用删除按钮 */
            $(this).parents('.fileupload').find('.del-fileinput-button')
            // .removeClass('del-fileinput-button')
            // .addClass('del-fileinput-button-disabled');
                .addClass('disabled');
        },
        done: function (e, data) {
            data.result = JSON.parse(data.result);
            var $uploads = $('#relevant-info-form').find('.upload-file-input');
            if (data.result && data.result[0]) {
                var input = $uploads[$(this).attr('data-fileupload-idx')];
                if (!input) {
                    input = $(document.createElement("input")).addClass('upload-file-input')
                        .attr('type', 'hidden')
                        .attr('name', 'uploadFileInputs[]')
                        .attr("filePath",data.result[0].filePath)
                        .attr("absoluteFilePath",data.result[0].absoluteFilePath)
                        .attr("fileName",data.files[0].name);
                    input.appendTo($('#relevant-info-form'));
                }
                // $(input).val(JSON.stringify(data.result[0]));
                fileUploadViewModel.fileinputs[$(this).attr('data-fileupload-idx')].filePath = data.result[0].filePath;
                fileUploadViewModel.fileinputs[$(this).attr('data-fileupload-idx')].fileName = data.files[0].name;

                $(this).parent().find('.fileinput-name').html(data.files[0].name);
                $(this).parent().find('.fileinput-name').text(data.files[0].name);
            }

            $(this).attr('data-uploading', false);
            /** 禁用删除按钮 */
            $(this).parents('.fileupload').find('.del-fileinput-button')
            // .addClass('del-fileinput-button')
            // .removeClass('del-fileinput-button-disabled')
                .removeClass('disabled');
        },
        fail: function (e, data) {
            
            window.console && $.isFunction(window.console.info) && window.console.info("faild on upload file: %o, %o", e, data);
            $(this).parent().find('.fileinput-name').html('上传失败请重试...').text('上传失败请重试...').css({color: 'red'});
            $(this).attr('data-uploading', false);
            /** 禁用删除按钮 */
            $(this).parents('.fileupload').find('.del-fileinput-button')
            // .addClass('del-fileinput-button')
            // .removeClass('del-fileinput-button-disabled')
                .removeClass('disabled');
            window.setTimeout(function () {
                $(this).parent().find('.fileinput-name').html('').text('').css({color: '#333'});
            }, 5000);
        },
        messages: {
            maxFileSize: '上传文件请勿大于1MB',
            acceptFileTypes: '只能上传pdf、jpg(jpeg)、png、doc(docx)、xls(xlsx)格式文件'
        },
        progressall: function (e, data) {
            var progress = parseInt(data.loaded / data.total * 100, 10);
            $(this).parent().find(".fileinput-name").text("正在上传（"+progress+"%）");
        },
        processfail: function (e, data) {
            failPopShow();
            $(this).attr('data-uploading', false);
            /** 禁用删除按钮 */
            $(this).parents('.fileupload').find('.del-fileinput-button')
            // .addClass('del-fileinput-button')
            // .removeClass('del-fileinput-button-disabled')
                .removeClass('disabled');
        }
    }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');
};

var bindFileuploadDelEvents = function($el) {
    $el.on("click", function() {
        var delIdx = $el.attr("rel-idx");
        if(!isNaN(delIdx)) {
            delIdx = Number(delIdx);
            delFileUploader(fileUploadViewModel, delIdx);
        }
    });
};

/**
 * 添加一个文件选择
 * @param fileUploadViewModel
 * @param idx 当前操作序号
 */
var addFileUploader = function(fileUploadViewModel, idx) {
    // debugger;
    var model = fileUploadViewModel.fileinputs[idx];
    model.uploadUrl = fileUploadViewModel.uploadUrl;
    model.ieVer = ieVer();
    if(model && typeof model != 'undefined') {
        var $uploader = $(template("_file_upload_container_tpl", model));
        $("#fileinput-container").append($uploader);
        initFileUpload($uploader.find('.fileupload-input'));
        bindFileuploadDelEvents($uploader.find('.del-fileinput-button'));
        if(fileUploadViewModel.fileinputs.length < 50) {
            $('.add-fileinput-button').show();
        } else {
            $('.add-fileinput-button').hide();
        }

        /** 多于一个上传控件时，显示删除按钮 */
        if(fileUploadViewModel.fileinputs.length > 1) {
            $('#fileinput-container')
                .find('.fileupload-input')
                .parents('.fileupload').find('.del-fileinput-button').show();
        }
    }
};

/**
 * 删除一个文件选择
 * @param fileUploadViewModel
 * @param idx 当前操作序号
 */
var delFileUploader = function(fileUploadViewModel, idx) {
    var model = fileUploadViewModel.fileinputs[idx];
    var $fileInputs = $('#fileinput-container').find('.fileupload-input');
    if(model && typeof model != 'undefined') {
        var $f = $('#fileinput-container').find('.fileupload-input[data-fileupload-idx="'+idx+'"]');
        if($f.length > 0 && $f.attr('data-uploading') + '' != 'true') {
            fileUploadViewModel.fileinputs.splice(idx, 1);
            $("[name='uploadFileInputs[]']").eq(idx).remove();
            $f.parents('.fileupload').remove();
            $fileInputs = $('#fileinput-container').find('.fileupload-input');
            /** 刷新删除元素后的 idx */
            for(var j = 0; j < $fileInputs.length; j++) {
                /** 重置所有input的序号 */
                var $fileinput = $($fileInputs[j]);
                var $delBtn = $fileinput.parents('.fileupload').find('.del-fileinput-button');
                if(fileUploadViewModel.fileinputs.length <= 1) {
                    $delBtn.hide();
                } else {
                    $delBtn.show();
                }
                fileUploadViewModel.fileinputs[j].idx = j;
                $fileinput.attr('data-fileupload-idx', j);
                $delBtn.attr('rel-idx', j);
                /** 重置z-index */
                $fileinput.css('z-index', 998 - j);
                $delBtn.css('z-index', 999 - j);
            }

            /** 只剩一个上传控件时，隐藏删除按钮 */
            if(fileUploadViewModel.fileinputs.length == 1) {
                $('#fileinput-container').find('.fileupload-input[data-fileupload-idx="0"]')
                    .parents('.fileupload').find('.del-fileinput-button').hide();
            }
            if(fileUploadViewModel.fileinputs.length < 50) {
                $('.add-fileinput-button').show();
            } else {
                $('.add-fileinput-button').hide();
            }
        }
    }
};


// 附件上传失败弹窗 显示
function failPopShow() {
    $('.failCoverLayer').removeClass('f-hide');
}
// 附件上传失败弹窗 隐藏
function failPopHide() {
    $('.failCoverLayer').addClass('f-hide');
}

$('.btnSure').on('click',function () {
    failPopHide();
})

//查询sku链接
function findUrl(sku) {
    $.ajax({
        url: "/bidding-web/biddingProvider/findUrlBySku",
        data: {"sku": sku},
        type: 'post',
        success: function (data) {
            $("#goodsLink").val(data.data);
        },
        error: function (e) {
            console.log(e);
        }
    })
}

