/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.internal.LettuceClassUtils;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class EpollProvider {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollProvider.class);
    public static final Class<EventLoopGroup> epollEventLoopGroupClass = EpollProvider.getClass("io.netty.channel.epoll.EpollEventLoopGroup");
    public static final Class<Channel> epollDomainSocketChannelClass = EpollProvider.getClass("io.netty.channel.epoll.EpollDomainSocketChannel");
    public static final Class<SocketAddress> domainSocketAddressClass = EpollProvider.getClass("io.netty.channel.unix.DomainSocketAddress");

    private static <T> Class<T> getClass(String className) {
        try {
            return LettuceClassUtils.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Cannot load class " + className, (Throwable)e);
            return null;
        }
    }

    static void checkForEpollLibrary() {
        if (domainSocketAddressClass == null || epollDomainSocketChannelClass == null) {
            throw new IllegalStateException("Cannot connect using sockets without the optional netty-transport-native-epoll library on the class path");
        }
    }

    static SocketAddress newSocketAddress(String socketPath) {
        try {
            Constructor<SocketAddress> constructor = domainSocketAddressClass.getConstructor(String.class);
            return constructor.newInstance(socketPath);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        try {
            Constructor<EventLoopGroup> constructor = epollEventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class);
            return constructor.newInstance(nThreads, threadFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        if (epollDomainSocketChannelClass == null || epollEventLoopGroupClass == null) {
            logger.debug("Starting without optional Epoll library");
        }
    }
}

