/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.GeoArgs;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;

public class GeoRadiusStoreArgs<K> {
    private K storeKey;
    private K storeDistKey;
    private Long count;
    private GeoArgs.Sort sort = GeoArgs.Sort.none;

    public GeoRadiusStoreArgs withStore(K storeKey) {
        Preconditions.checkArgument((storeKey != null ? 1 : 0) != 0, (Object)"storeKey must not be null");
        this.storeKey = storeKey;
        return this;
    }

    public GeoRadiusStoreArgs withStoreDist(K storeKey) {
        Preconditions.checkArgument((storeKey != null ? 1 : 0) != 0, (Object)"storeKey must not be null");
        this.storeDistKey = storeKey;
        return this;
    }

    public GeoRadiusStoreArgs withCount(long count) {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"count must be greater 0");
        this.count = count;
        return this;
    }

    public GeoRadiusStoreArgs asc() {
        return this.sort(GeoArgs.Sort.asc);
    }

    public GeoRadiusStoreArgs desc() {
        return this.sort(GeoArgs.Sort.desc);
    }

    public K getStoreKey() {
        return this.storeKey;
    }

    public K getStoreDistKey() {
        return this.storeDistKey;
    }

    public GeoRadiusStoreArgs sort(GeoArgs.Sort sort) {
        Preconditions.checkArgument((sort != null ? 1 : 0) != 0, (Object)"sort must not be null");
        this.sort = sort;
        return this;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.sort != null && this.sort != GeoArgs.Sort.none) {
            args.add(this.sort.name());
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
        if (this.storeKey != null) {
            args.add("STORE").addKey(this.storeKey);
        }
        if (this.storeDistKey != null) {
            args.add("STOREDIST").addKey(this.storeDistKey);
        }
    }
}

