/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.metrics;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.metrics.CommandLatencyCollectorOptions;
import java.util.concurrent.TimeUnit;

public class DefaultCommandLatencyCollectorOptions
implements CommandLatencyCollectorOptions {
    public static final TimeUnit DEFAULT_TARGET_UNIT = TimeUnit.MICROSECONDS;
    public static final double[] DEFAULT_TARGET_PERCENTILES = new double[]{50.0, 90.0, 95.0, 99.0, 99.9};
    public static final boolean DEFAULT_RESET_LATENCIES_AFTER_EVENT = true;
    public static final boolean DEFAULT_LOCAL_DISTINCTION = false;
    public static final boolean DEFAULT_ENABLED = true;
    private static final DefaultCommandLatencyCollectorOptions DISABLED = new Builder().disable().build();
    private final TimeUnit targetUnit;
    private final double[] targetPercentiles;
    private final boolean resetLatenciesAfterEvent;
    private final boolean localDistinction;
    private final boolean enabled;

    protected DefaultCommandLatencyCollectorOptions(Builder builder) {
        this.targetUnit = builder.targetUnit;
        this.targetPercentiles = builder.targetPercentiles;
        this.resetLatenciesAfterEvent = builder.resetLatenciesAfterEvent;
        this.localDistinction = builder.localDistinction;
        this.enabled = builder.enabled;
    }

    @Override
    public TimeUnit targetUnit() {
        return this.targetUnit;
    }

    @Override
    public double[] targetPercentiles() {
        double[] result = new double[this.targetPercentiles.length];
        System.arraycopy(this.targetPercentiles, 0, result, 0, this.targetPercentiles.length);
        return result;
    }

    @Override
    public boolean resetLatenciesAfterEvent() {
        return this.resetLatenciesAfterEvent;
    }

    @Override
    public boolean localDistinction() {
        return this.localDistinction;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public static DefaultCommandLatencyCollectorOptions create() {
        return new Builder().build();
    }

    public static DefaultCommandLatencyCollectorOptions disabled() {
        return DISABLED;
    }

    public static class Builder {
        private TimeUnit targetUnit = DEFAULT_TARGET_UNIT;
        private double[] targetPercentiles = DEFAULT_TARGET_PERCENTILES;
        private boolean resetLatenciesAfterEvent = true;
        private boolean localDistinction = false;
        private boolean enabled = true;

        public Builder disable() {
            this.enabled = false;
            return this;
        }

        public Builder targetUnit(TimeUnit targetUnit) {
            Preconditions.checkArgument((targetUnit != null ? 1 : 0) != 0, (Object)"targetUnit must not be null");
            this.targetUnit = targetUnit;
            return this;
        }

        public Builder targetPercentiles(double[] targetPercentiles) {
            Preconditions.checkArgument((targetPercentiles != null ? 1 : 0) != 0, (Object)"targetPercentiles must not be null");
            this.targetPercentiles = targetPercentiles;
            return this;
        }

        public Builder resetLatenciesAfterEvent(boolean resetLatenciesAfterEvent) {
            this.resetLatenciesAfterEvent = resetLatenciesAfterEvent;
            return this;
        }

        public Builder localDistinction(boolean localDistinction) {
            this.localDistinction = localDistinction;
            return this;
        }

        public DefaultCommandLatencyCollectorOptions build() {
            return new DefaultCommandLatencyCollectorOptions(this);
        }
    }
}

