/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ScoredValueScanCursor;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.ScanOutput;
import java.nio.ByteBuffer;

public class ScoredValueScanOutput<K, V>
extends ScanOutput<K, V, ScoredValueScanCursor<V>> {
    private V value;

    public ScoredValueScanOutput(RedisCodec<K, V> codec) {
        super(codec, new ScoredValueScanCursor());
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = Double.parseDouble(this.decodeAscii(bytes));
        ((ScoredValueScanCursor)this.output).getValues().add(new ScoredValue<V>(score, this.value));
        this.value = null;
    }
}

