/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.protocol.ChannelLogDescriptor;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.util.Collection;

@ChannelHandler.Sharable
public class CommandEncoder
extends MessageToByteEncoder<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CommandEncoder.class);
    private final boolean traceEnabled = logger.isTraceEnabled();
    private final boolean debugEnabled = logger.isDebugEnabled();

    public CommandEncoder() {
        this(true);
    }

    public CommandEncoder(boolean preferDirect) {
        super(preferDirect);
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        if (msg instanceof RedisCommand) {
            RedisCommand command = (RedisCommand)msg;
            this.encode(ctx, out, command);
        }
        if (msg instanceof Collection) {
            Collection commands = (Collection)msg;
            for (RedisCommand command : commands) {
                this.encode(ctx, out, command);
            }
        }
    }

    private void encode(ChannelHandlerContext ctx, ByteBuf out, RedisCommand<?, ?, ?> command) {
        try {
            out.markWriterIndex();
            command.encode(out);
        }
        catch (RuntimeException e) {
            out.resetWriterIndex();
            command.setException((Throwable)new EncoderException("Cannot encode command. Please close the connection as the connection state may be out of sync.", (Throwable)e));
            command.cancel(true);
        }
        if (this.debugEnabled) {
            logger.debug("{} writing command {}", (Object)this.logPrefix(ctx.channel()), command);
            if (this.traceEnabled) {
                logger.trace("{} Sent: {}", (Object)this.logPrefix(ctx.channel()), (Object)out.toString(Charset.defaultCharset()).trim());
            }
        }
    }

    private String logPrefix(Channel channel) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('[').append(ChannelLogDescriptor.logDescriptor(channel)).append(']');
        return buffer.toString();
    }
}

