/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.resource.DnsResolver;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class DirContextDnsResolver
implements DnsResolver,
Closeable {
    static final String PREFER_IPV4_KEY = "java.net.preferIPv4Stack";
    static final String PREFER_IPV6_KEY = "java.net.preferIPv6Stack";
    private static final String CTX_FACTORY_NAME = "com.sun.jndi.dns.DnsContextFactory";
    private static final String INITIAL_TIMEOUT = "com.sun.jndi.dns.timeout.initial";
    private static final String LOOKUP_RETRIES = "com.sun.jndi.dns.timeout.retries";
    private static final String DEFAULT_INITIAL_TIMEOUT = "1000";
    private static final String DEFAULT_RETRIES = "4";
    private final boolean preferIpv4;
    private final boolean preferIpv6;
    private final Properties properties;
    private final InitialDirContext context;

    public DirContextDnsResolver() {
        this(new Properties(), new StackPreference());
    }

    public DirContextDnsResolver(String dnsServer) {
        this(Collections.singleton(dnsServer));
    }

    public DirContextDnsResolver(Iterable<String> dnsServers) {
        this(DirContextDnsResolver.getProperties(dnsServers), new StackPreference());
    }

    public DirContextDnsResolver(boolean preferIpv4, boolean preferIpv6, Properties properties) {
        this.preferIpv4 = preferIpv4;
        this.preferIpv6 = preferIpv6;
        this.properties = properties;
        this.context = this.createContext(properties);
    }

    private DirContextDnsResolver(Properties properties, StackPreference stackPreference) {
        this.properties = new Properties(properties);
        this.preferIpv4 = stackPreference.preferIpv4;
        this.preferIpv6 = stackPreference.preferIpv6;
        this.context = this.createContext(properties);
    }

    private InitialDirContext createContext(Properties properties) {
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"Properties must not be null");
        Properties hashtable = (Properties)properties.clone();
        hashtable.put("java.naming.factory.initial", CTX_FACTORY_NAME);
        if (!hashtable.containsKey(INITIAL_TIMEOUT)) {
            hashtable.put(INITIAL_TIMEOUT, DEFAULT_INITIAL_TIMEOUT);
        }
        if (!hashtable.containsKey(LOOKUP_RETRIES)) {
            hashtable.put(LOOKUP_RETRIES, DEFAULT_RETRIES);
        }
        try {
            return new InitialDirContext(hashtable);
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.context.close();
        }
        catch (NamingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        if (InetAddresses.isInetAddress((String)host)) {
            return new InetAddress[]{InetAddresses.forString((String)host)};
        }
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
        try {
            this.resolve(host, inetAddresses);
        }
        catch (NamingException e) {
            throw new UnknownHostException(String.format("Cannot resolve %s to a hostname because of %s", host, e));
        }
        if (inetAddresses.isEmpty()) {
            throw new UnknownHostException(String.format("Cannot resolve %s to a hostname", host));
        }
        return inetAddresses.toArray(new InetAddress[inetAddresses.size()]);
    }

    private void resolve(String hostname, List<InetAddress> inetAddresses) throws NamingException, UnknownHostException {
        if (this.preferIpv6 || !this.preferIpv4 && !this.preferIpv6) {
            inetAddresses.addAll(this.resolve(hostname, "AAAA"));
            inetAddresses.addAll(this.resolve(hostname, "A"));
        } else {
            inetAddresses.addAll(this.resolve(hostname, "A"));
            inetAddresses.addAll(this.resolve(hostname, "AAAA"));
        }
        if (inetAddresses.isEmpty()) {
            inetAddresses.addAll(this.resolveCname(hostname));
        }
    }

    private List<InetAddress> resolveCname(String hostname) throws NamingException {
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
        Attributes attrs = this.context.getAttributes(hostname, new String[]{"CNAME"});
        Attribute attr = attrs.get("CNAME");
        if (attr != null && attr.size() > 0) {
            NamingEnumeration<?> e = attr.getAll();
            while (e.hasMore()) {
                String h = (String)e.next();
                if (h.endsWith(".")) {
                    h = h.substring(0, h.lastIndexOf(46));
                }
                try {
                    InetAddress[] resolved;
                    for (InetAddress inetAddress : resolved = this.resolve(h)) {
                        inetAddresses.add(InetAddress.getByAddress(hostname, inetAddress.getAddress()));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                }
            }
        }
        return inetAddresses;
    }

    private List<InetAddress> resolve(String hostname, String attrName) throws NamingException, UnknownHostException {
        Attributes attrs = this.context.getAttributes(hostname, new String[]{attrName});
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
        Attribute attr = attrs.get(attrName);
        if (attr != null && attr.size() > 0) {
            NamingEnumeration<?> e = attr.getAll();
            while (e.hasMore()) {
                InetAddress inetAddress = InetAddress.getByName("" + e.next());
                inetAddresses.add(InetAddress.getByAddress(hostname, inetAddress.getAddress()));
            }
        }
        return inetAddresses;
    }

    private static Properties getProperties(Iterable<String> dnsServers) {
        Properties properties = new Properties();
        StringBuffer providerUrl = new StringBuffer();
        for (String dnsServer : dnsServers) {
            Preconditions.checkArgument((boolean)LettuceStrings.isNotEmpty(dnsServer), (Object)"DNS Server must not be empty");
            if (providerUrl.length() != 0) {
                providerUrl.append(' ');
            }
            providerUrl.append(String.format("dns://%s", dnsServer));
        }
        if (providerUrl.length() == 0) {
            throw new IllegalArgumentException("DNS Servers must not be empty");
        }
        properties.put("java.naming.provider.url", providerUrl.toString());
        return properties;
    }

    private static final class StackPreference {
        final boolean preferIpv4;
        final boolean preferIpv6;

        public StackPreference() {
            boolean preferIpv4 = false;
            boolean preferIpv6 = false;
            if (System.getProperty(DirContextDnsResolver.PREFER_IPV4_KEY) == null && System.getProperty(DirContextDnsResolver.PREFER_IPV6_KEY) == null) {
                preferIpv4 = false;
                preferIpv6 = false;
            }
            if (System.getProperty(DirContextDnsResolver.PREFER_IPV4_KEY) == null && System.getProperty(DirContextDnsResolver.PREFER_IPV6_KEY) != null && !(preferIpv6 = Boolean.getBoolean(DirContextDnsResolver.PREFER_IPV6_KEY))) {
                preferIpv4 = true;
            }
            if (System.getProperty(DirContextDnsResolver.PREFER_IPV4_KEY) != null && System.getProperty(DirContextDnsResolver.PREFER_IPV6_KEY) == null && !(preferIpv4 = Boolean.getBoolean(DirContextDnsResolver.PREFER_IPV4_KEY))) {
                preferIpv6 = true;
            }
            if (System.getProperty(DirContextDnsResolver.PREFER_IPV4_KEY) != null && System.getProperty(DirContextDnsResolver.PREFER_IPV6_KEY) != null) {
                preferIpv4 = Boolean.getBoolean(DirContextDnsResolver.PREFER_IPV4_KEY);
                preferIpv6 = Boolean.getBoolean(DirContextDnsResolver.PREFER_IPV6_KEY);
            }
            this.preferIpv4 = preferIpv4;
            this.preferIpv6 = preferIpv6;
        }
    }
}

