/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.OIDTokenizer;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.Strings;

class CertUtil {
    CertUtil() {
    }

    /*
     * Unable to fully structure code
     */
    static Implementation getImplementation(String var0, String var1_1, Provider var2_2) {
        if (var2_2 != null) ** GOTO lbl12
        var3_3 = Security.getProviders();
        var4_5 = 0;
        while (var4_5 != var3_3.length) {
            var5_7 = CertUtil.getImplementation(var0, var1_1, var3_3[var4_5]);
            if (var5_7 != null) {
                return var5_7;
            }
            ++var4_5;
        }
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var3_4;
lbl12:
            // 2 sources

            ** while ((var3_4 = var2_2.getProperty((String)("Alg.Alias." + var0 + "." + var1_1))) != null)
        }
lbl13:
        // 1 sources

        var4_6 = var2_2.getProperty(var0 + "." + var1_1);
        if (var4_6 != null) {
            try {
                return new Implementation(Class.forName(var4_6).newInstance(), var2_2);
            }
            catch (ClassNotFoundException var5_8) {
                throw new IllegalStateException("algorithm " + var1_1 + " in provider " + var2_2.getName() + " but no class found!");
            }
            catch (Exception var6_9) {
                throw new IllegalStateException("algorithm " + var1_1 + " in provider " + var2_2.getName() + " but class inaccessible: " + var6_9.toString());
            }
        }
        return null;
    }

    static Implementation getImplementation(String string, String string2, String string3) throws NoSuchProviderException {
        if (string3 == null) {
            Provider[] providerArray = Security.getProviders();
            int n = 0;
            while (n != providerArray.length) {
                Implementation implementation = CertUtil.getImplementation(string, string2, providerArray[n]);
                if (implementation != null) {
                    return implementation;
                }
                ++n;
            }
        } else {
            Provider provider = Security.getProvider(string3);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string3 + " not found");
            }
            return CertUtil.getImplementation(string, string2, provider);
        }
        return null;
    }

    static Implementation getImplementation(String string, String string2, Provider provider, Class[] classArray, Object[] objectArray) throws InvalidAlgorithmParameterException {
        String string3;
        while ((string3 = ((Properties)provider).getProperty("Alg.Alias." + string + "." + string2)) != null) {
            string2 = string3;
        }
        String string4 = ((Properties)provider).getProperty(string + "." + string2);
        if (string4 != null) {
            try {
                return new Implementation(Class.forName(string4).getConstructor(classArray).newInstance(objectArray), provider);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but no class found!");
            }
            catch (Exception exception) {
                if (exception instanceof InvalidAlgorithmParameterException) {
                    throw (InvalidAlgorithmParameterException)exception;
                }
                throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but class inaccessible!");
            }
        }
        return null;
    }

    static Implementation getImplementation(String string, String string2, String string3, Class[] classArray, Object[] objectArray) throws NoSuchProviderException, InvalidAlgorithmParameterException {
        if (string3 == null) {
            Provider[] providerArray = Security.getProviders();
            int n = 0;
            while (n != providerArray.length) {
                Implementation implementation = CertUtil.getImplementation(string, string2, providerArray[n], classArray, objectArray);
                if (implementation != null) {
                    return implementation;
                }
                ++n;
            }
        } else {
            Provider provider = Security.getProvider(string3);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string3 + " not found");
            }
            return CertUtil.getImplementation(string, string2, provider, classArray, objectArray);
        }
        return null;
    }

    static byte[] parseGeneralName(int n, String string) throws IOException {
        byte[] byArray = null;
        switch (n) {
            case 0: {
                throw new IOException("unable to parse OtherName String representation");
            }
            case 1: {
                byArray = CertUtil.parseRfc822(string.trim());
                break;
            }
            case 2: {
                byArray = CertUtil.parseDNSName(string.trim());
                break;
            }
            case 3: {
                throw new IOException("unable to parse ORAddress String representation");
            }
            case 4: {
                byArray = CertUtil.parseX509Name(string.trim());
                break;
            }
            case 5: {
                throw new IOException("unable to parse EDIPartyName String representation");
            }
            case 6: {
                byArray = CertUtil.parseURI(string.trim());
                break;
            }
            case 7: {
                byArray = CertUtil.parseIP(string.trim());
                break;
            }
            case 8: {
                byArray = CertUtil.parseOID(string.trim());
                break;
            }
            default: {
                throw new IOException("unable to parse unkown type String representation");
            }
        }
        return byArray;
    }

    static byte[] parseOID(String string) throws IOException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(string);
        if (!oIDTokenizer.hasMoreTokens()) {
            throw new IOException("OID contains no tokens");
        }
        String string2 = oIDTokenizer.nextToken();
        if (string2 == null) {
            throw new IOException("OID contains no tokens");
        }
        try {
            int n = Integer.valueOf(string2);
            if (n < 0 || n > 2) {
                throw new IOException("first token is not >= 0 and <=2");
            }
            if (!oIDTokenizer.hasMoreTokens()) {
                throw new IOException("OID contains only one token");
            }
            string2 = oIDTokenizer.nextToken();
            if (string2 == null) {
                throw new IOException("OID contains only one token");
            }
            n = Integer.valueOf(string2);
            if (n < 0 || n > 39) {
                throw new IOException("secon token is not >= 0 and <=39");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("token: " + string2 + ": " + numberFormatException.toString());
        }
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dERObjectIdentifier);
        dEROutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] parseIP(String string) throws IOException {
        byte[] byArray = CertUtil.parseIPv4(string);
        if (byArray == null) {
            byArray = CertUtil.parseIPv6(string);
        }
        if (byArray == null) {
            throw new IOException("unable to parse IP to DER encoded byte array");
        }
        return byArray;
    }

    private static byte[] parseIPv4(String string) {
        if (string.length() == 0) {
            return null;
        }
        int n = 0;
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length() && (n2 = string.indexOf(46, n3)) > n3 && n2 - n3 > 3) {
            int n4;
            try {
                n4 = Integer.valueOf(string.substring(n3, n2 - n3));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n4 < 0 || n4 > 255) {
                return null;
            }
            byArray[n++] = (byte)(n4 & 0xFF);
            n3 = n2 + 1;
        }
        if (n < 4) {
            return null;
        }
        return byArray;
    }

    private static byte[] parseIPv6(String string) {
        return null;
    }

    private static byte[] parseURI(String string) throws IOException {
        DERIA5String dERIA5String = new DERIA5String(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dERIA5String);
        dEROutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] parseRfc822(String string) throws IOException {
        int n = string.indexOf(64);
        if (n < 0 || n >= string.length() - 1) {
            throw new IOException("wrong format of rfc822Name:" + string);
        }
        DERIA5String dERIA5String = new DERIA5String(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dERIA5String);
        dEROutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] parseDNSName(String string) throws IOException {
        DERIA5String dERIA5String = new DERIA5String(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dERIA5String);
        dEROutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] parseX509Name(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(new X509Name(CertUtil.trimX509Name(string)));
        dEROutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    static String trimX509Name(String string) {
        int n;
        String string2 = Strings.toUpperCase(string.trim());
        while ((n = string2.indexOf("  ")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf(" =")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("= ")) >= 0) {
            string2 = string2.substring(0, n + 1) + string2.substring(n + 2);
        }
        return string2;
    }

    static class Implementation {
        Object engine;
        Provider provider;

        Implementation(Object object, Provider provider) {
            this.engine = object;
            this.provider = provider;
        }

        Object getEngine() {
            return this.engine;
        }

        Provider getProvider() {
            return this.provider;
        }
    }
}

