/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.PKIXCertPathChecker;
import org.bouncycastle.jce.cert.TrustAnchor;

public class PKIXParameters
implements CertPathParameters {
    private Set trustAnchors;
    private Set initialPolicies = new HashSet();
    private List certStores = new ArrayList();
    private CertSelector certSelector;
    private List certPathCheckers = new ArrayList();
    private boolean revocationEnabled = true;
    private boolean explicitPolicyRequired = false;
    private boolean policyMappingInhibited = false;
    private boolean anyPolicyInhibited = false;
    private boolean policyQualifiersRejected = true;
    private Date date;
    private String sigProvider;

    public PKIXParameters(Set set) throws InvalidAlgorithmParameterException {
        this.setTrustAnchors(set);
    }

    public PKIXParameters(KeyStore keyStore) throws KeyStoreException, InvalidAlgorithmParameterException {
        if (keyStore == null) {
            throw new NullPointerException("the keystore parameter must be non-null");
        }
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            hashSet.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        this.setTrustAnchors(hashSet);
    }

    public Set getTrustAnchors() {
        return Collections.unmodifiableSet(this.trustAnchors);
    }

    public void setTrustAnchors(Set set) throws InvalidAlgorithmParameterException {
        if (set == null) {
            throw new NullPointerException("the trustAnchors parameter must be non-null");
        }
        if (set.isEmpty()) {
            throw new InvalidAlgorithmParameterException("the trustAnchors parameter must be non-empty");
        }
        Iterator iterator = set.iterator();
        this.trustAnchors = new HashSet();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            if (trustAnchor == null) continue;
            this.trustAnchors.add(trustAnchor);
        }
    }

    public Set getInitialPolicies() {
        HashSet hashSet = this.initialPolicies;
        if (this.initialPolicies == null) {
            hashSet = new HashSet();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void setInitialPolicies(Set set) {
        if (set == null || set.isEmpty()) {
            this.initialPolicies = null;
        } else {
            Iterator iterator = set.iterator();
            this.initialPolicies = new HashSet();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                this.initialPolicies.add(string);
            }
        }
    }

    public void setCertStores(List list) {
        this.certStores = new ArrayList();
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CertStore certStore = (CertStore)iterator.next();
                if (certStore == null) continue;
                this.certStores.add(certStore);
            }
        }
    }

    public void addCertStore(CertStore certStore) {
        if (certStore != null) {
            this.certStores.add(certStore);
        }
    }

    public List getCertStores() {
        return Collections.unmodifiableList(this.certStores);
    }

    public void setRevocationEnabled(boolean bl) {
        this.revocationEnabled = bl;
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setExplicitPolicyRequired(boolean bl) {
        this.explicitPolicyRequired = bl;
    }

    public boolean isExplicitPolicyRequired() {
        return this.explicitPolicyRequired;
    }

    public void setPolicyMappingInhibited(boolean bl) {
        this.policyMappingInhibited = bl;
    }

    public boolean isPolicyMappingInhibited() {
        return this.policyMappingInhibited;
    }

    public void setAnyPolicyInhibited(boolean bl) {
        this.anyPolicyInhibited = bl;
    }

    public boolean isAnyPolicyInhibited() {
        return this.anyPolicyInhibited;
    }

    public void setPolicyQualifiersRejected(boolean bl) {
        this.policyQualifiersRejected = bl;
    }

    public boolean getPolicyQualifiersRejected() {
        return this.policyQualifiersRejected;
    }

    public Date getDate() {
        if (this.date == null) {
            return null;
        }
        return new Date(this.date.getTime());
    }

    public void setDate(Date date) {
        this.date = date == null ? null : new Date(date.getTime());
    }

    public void setCertPathCheckers(List list) {
        this.certPathCheckers = new ArrayList();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.certPathCheckers.add((PKIXCertPathChecker)((PKIXCertPathChecker)iterator.next()).clone());
        }
    }

    public List getCertPathCheckers() {
        ArrayList<PKIXCertPathChecker> arrayList = new ArrayList<PKIXCertPathChecker>();
        Iterator iterator = this.certPathCheckers.iterator();
        while (iterator.hasNext()) {
            arrayList.add((PKIXCertPathChecker)((PKIXCertPathChecker)iterator.next()).clone());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void addCertPathChecker(PKIXCertPathChecker pKIXCertPathChecker) {
        if (pKIXCertPathChecker != null) {
            this.certPathCheckers.add(pKIXCertPathChecker.clone());
        }
    }

    public String getSigProvider() {
        return this.sigProvider;
    }

    public void setSigProvider(String string) {
        this.sigProvider = string;
    }

    public CertSelector getTargetCertConstraints() {
        if (this.certSelector == null) {
            return null;
        }
        return (CertSelector)this.certSelector.clone();
    }

    public void setTargetCertConstraints(CertSelector certSelector) {
        this.certSelector = certSelector == null ? null : (CertSelector)certSelector.clone();
    }

    public Object clone() {
        try {
            PKIXParameters pKIXParameters = (PKIXParameters)super.clone();
            pKIXParameters.certStores = new ArrayList(this.certStores);
            Iterator iterator = this.certPathCheckers.iterator();
            pKIXParameters.certPathCheckers = new ArrayList();
            while (iterator.hasNext()) {
                pKIXParameters.certPathCheckers.add(((PKIXCertPathChecker)iterator.next()).clone());
            }
            if (this.initialPolicies != null) {
                pKIXParameters.initialPolicies = new HashSet(this.initialPolicies);
            }
            if (this.trustAnchors != null) {
                pKIXParameters.trustAnchors = new HashSet(this.trustAnchors);
            }
            if (this.certSelector != null) {
                pKIXParameters.certSelector = (CertSelector)this.certSelector.clone();
            }
            return pKIXParameters;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        if (this.trustAnchors != null) {
            stringBuffer.append("  Trust Anchors: ").append(this.trustAnchors).append('\n');
        }
        if (this.initialPolicies != null) {
            if (this.initialPolicies.isEmpty()) {
                stringBuffer.append("  Initial Policy OIDs: any\n");
            } else {
                stringBuffer.append("  Initial Policy OIDs: [").append(this.initialPolicies).append("]\n");
            }
        }
        stringBuffer.append("  Validity Date: ");
        if (this.date != null) {
            stringBuffer.append(this.date);
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append('\n');
        stringBuffer.append("  Signature Provider: ");
        if (this.sigProvider != null) {
            stringBuffer.append(this.sigProvider);
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append('\n');
        stringBuffer.append("  Default Revocation Enabled: ");
        stringBuffer.append(this.revocationEnabled);
        stringBuffer.append('\n');
        stringBuffer.append("  Explicit Policy Required: ");
        stringBuffer.append(this.explicitPolicyRequired);
        stringBuffer.append('\n');
        stringBuffer.append("  Policy Mapping Inhibited: ");
        stringBuffer.append(this.policyMappingInhibited);
        stringBuffer.append('\n');
        stringBuffer.append("  Any Policy Inhibited: ");
        stringBuffer.append(this.anyPolicyInhibited);
        stringBuffer.append('\n');
        stringBuffer.append("  Policy Qualifiers Rejected: ");
        stringBuffer.append(this.policyQualifiersRejected);
        stringBuffer.append('\n');
        stringBuffer.append("  Target Cert Constraints: ");
        stringBuffer.append(this.certSelector);
        stringBuffer.append('\n');
        stringBuffer.append("  Certification Path Checkers: [");
        stringBuffer.append(this.certPathCheckers);
        stringBuffer.append("}\n");
        stringBuffer.append("  CertStores: [");
        stringBuffer.append(this.certStores);
        stringBuffer.append("}\n");
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }
}

