/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        ECCurve eCCurve = eCPoint.getCurve();
        if (!eCCurve.equals(eCPoint2.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(eCPoint, bigInteger, eCPoint2, bigInteger2);
    }

    public static ECPoint shamirsTrick(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        if (!eCPoint.getCurve().equals(eCPoint2.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(eCPoint, bigInteger, eCPoint2, bigInteger2);
    }

    private static ECPoint implShamirsTrick(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        int n = Math.max(bigInteger.bitLength(), bigInteger2.bitLength());
        ECPoint eCPoint3 = eCPoint.add(eCPoint2);
        ECPoint eCPoint4 = eCPoint.getCurve().getInfinity();
        int n2 = n - 1;
        while (n2 >= 0) {
            eCPoint4 = eCPoint4.twice();
            if (bigInteger.testBit(n2)) {
                eCPoint4 = bigInteger2.testBit(n2) ? eCPoint4.add(eCPoint3) : eCPoint4.add(eCPoint);
            } else if (bigInteger2.testBit(n2)) {
                eCPoint4 = eCPoint4.add(eCPoint2);
            }
            --n2;
        }
        return eCPoint4;
    }
}

