/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.util.IPAddress;

public class IPTest
extends TestCase {
    private static final String[] validIP4v = new String[]{"0.0.0.0", "255.255.255.255", "192.168.0.0"};
    private static final String[] invalidIP4v = new String[]{"0.0.0.0.1", "256.255.255.255", "1", "A.B.C", "1:.4.6.5"};
    private static final String[] validIP6v = new String[]{"0:0:0:0:0:0:0:0", "FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF", "0:1:2:3:FFFF:5:FFFF:1"};
    private static final String[] invalidIP6v = new String[]{"0.0.0.0:1", "FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFFF"};

    private void testIP(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            if (!IPAddress.isValid(stringArray[n])) {
                Assert.fail((String)("Valid input string not accepted: " + stringArray[n] + "."));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (IPAddress.isValid(stringArray2[n2])) {
                Assert.fail((String)("Invalid input string accepted: " + stringArray2[n2] + "."));
            }
            ++n2;
        }
    }

    public String getName() {
        return "IPTest";
    }

    public void testIPv4() {
        this.testIP(validIP4v, invalidIP4v);
    }

    public void testIPv6() {
        this.testIP(validIP6v, invalidIP6v);
    }
}

