/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.imports;

import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.sax.SaxReadCellEntity;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelImportEnum;
import cn.afterturn.easypoi.handler.inter.IExcelDataHandler;
import cn.afterturn.easypoi.handler.inter.IExcelDictHandler;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellValueService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellValueService.class);
    private List<String> handlerList = null;

    private Object getCellValue(String xclass, Cell cell, ExcelImportEntity entity) {
        if (cell == null) {
            return "";
        }
        Object result = null;
        if ("class java.util.Date".equals(xclass) || "class java.sql.Date".equals(xclass) || "class java.sql.Time".equals(xclass) || "class java.sql.Timestamp".equals(xclass)) {
            if (0 == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
                result = DateUtil.getJavaDate((double)cell.getNumericCellValue());
            } else {
                cell.setCellType(CellType.STRING);
                result = this.getDateData(entity, cell.getStringCellValue());
            }
            if ("class java.sql.Date".equals(xclass)) {
                result = new Date(((java.util.Date)result).getTime());
            }
            if ("class java.sql.Time".equals(xclass)) {
                result = new Time(((java.util.Date)result).getTime());
            }
            if ("class java.sql.Timestamp".equals(xclass)) {
                result = new Timestamp(((java.util.Date)result).getTime());
            }
        } else if (0 == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
            result = DateUtil.getJavaDate((double)cell.getNumericCellValue());
        } else {
            switch (cell.getCellType()) {
                case 1: {
                    result = cell.getRichStringCellValue() == null ? "" : cell.getRichStringCellValue().getString();
                    break;
                }
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        if (!"class java.lang.String".equals(xclass)) break;
                        result = this.formateDate(entity, cell.getDateCellValue());
                        break;
                    }
                    result = this.readNumericCell(cell);
                    break;
                }
                case 4: {
                    result = Boolean.toString(cell.getBooleanCellValue());
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    try {
                        result = this.readNumericCell(cell);
                        break;
                    }
                    catch (Exception e1) {
                        try {
                            result = cell.getRichStringCellValue() == null ? "" : cell.getRichStringCellValue().getString();
                            break;
                        }
                        catch (Exception e2) {
                            throw new RuntimeException("\u83b7\u53d6\u516c\u5f0f\u7c7b\u578b\u7684\u5355\u5143\u683c\u5931\u8d25", e2);
                        }
                    }
                }
            }
        }
        return result;
    }

    private Object readNumericCell(Cell cell) {
        Number result = null;
        double value = cell.getNumericCellValue();
        result = (double)((int)value) == value ? (Number)((int)value) : (Number)value;
        return result;
    }

    private java.util.Date getDateData(ExcelImportEntity entity, String value) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getFormat()) && StringUtils.isNotEmpty((CharSequence)value)) {
            SimpleDateFormat format = new SimpleDateFormat(entity.getFormat());
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25,\u683c\u5f0f\u5316:{},\u503c:{}", (Object)entity.getFormat(), (Object)value);
                throw new ExcelImportException(ExcelImportEnum.GET_VALUE_ERROR);
            }
        }
        return null;
    }

    private String formateDate(ExcelImportEntity entity, java.util.Date value) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getFormat()) && value != null) {
            SimpleDateFormat format = new SimpleDateFormat(entity.getFormat());
            return format.format(value);
        }
        return null;
    }

    public Object getValue(IExcelDataHandler<?> dataHandler, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString, IExcelDictHandler dictHandler) throws Exception {
        ExcelImportEntity entity = excelParams.get(titleString);
        String xclass = "class java.lang.Object";
        if (!(object instanceof Map)) {
            Method setMethod = entity.getMethods() != null && entity.getMethods().size() > 0 ? entity.getMethods().get(entity.getMethods().size() - 1) : entity.getMethod();
            Type[] ts = setMethod.getGenericParameterTypes();
            xclass = ts[0].toString();
        }
        Object result = this.getCellValue(xclass, cell, entity);
        if (entity != null) {
            result = this.hanlderSuffix(entity.getSuffix(), result);
            result = this.replaceValue(entity.getReplace(), result);
            result = this.replaceValue(entity.getReplace(), result);
            if (dictHandler != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getDict()})) {
                dictHandler.toValue(entity.getDict(), object, entity.getName(), result);
            }
        }
        result = this.handlerValue(dataHandler, object, result, titleString);
        return this.getValueByType(xclass, result, entity);
    }

    public Object getValue(IExcelDataHandler<?> dataHandler, Object object, SaxReadCellEntity cellEntity, Map<String, ExcelImportEntity> excelParams, String titleString) {
        ExcelImportEntity entity = excelParams.get(titleString);
        Method setMethod = entity.getMethods() != null && entity.getMethods().size() > 0 ? entity.getMethods().get(entity.getMethods().size() - 1) : entity.getMethod();
        Type[] ts = setMethod.getGenericParameterTypes();
        String xclass = ts[0].toString();
        Object result = cellEntity.getValue();
        result = this.hanlderSuffix(entity.getSuffix(), result);
        result = this.replaceValue(entity.getReplace(), result);
        result = this.handlerValue(dataHandler, object, result, titleString);
        return this.getValueByType(xclass, result, entity);
    }

    private Object hanlderSuffix(String suffix, Object result) {
        if (StringUtils.isNotEmpty((CharSequence)suffix) && result != null && result.toString().endsWith(suffix)) {
            String temp = result.toString();
            return temp.substring(0, temp.length() - suffix.length());
        }
        return result;
    }

    private Object getValueByType(String xclass, Object result, ExcelImportEntity entity) {
        try {
            if (result == null || StringUtils.isBlank((CharSequence)result.toString())) {
                return null;
            }
            if ("class java.util.Date".equals(xclass)) {
                return result;
            }
            if ("class java.lang.Boolean".equals(xclass) || "boolean".equals(xclass)) {
                return Boolean.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Double".equals(xclass) || "double".equals(xclass)) {
                return Double.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Long".equals(xclass) || "long".equals(xclass)) {
                try {
                    return Long.valueOf(String.valueOf(result));
                }
                catch (Exception e) {
                    return Double.valueOf(String.valueOf(result)).longValue();
                }
            }
            if ("class java.lang.Float".equals(xclass) || "float".equals(xclass)) {
                return Float.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Integer".equals(xclass) || "int".equals(xclass)) {
                try {
                    return Integer.valueOf(String.valueOf(result));
                }
                catch (Exception e) {
                    return Double.valueOf(String.valueOf(result)).intValue();
                }
            }
            if ("class java.math.BigDecimal".equals(xclass)) {
                return new BigDecimal(String.valueOf(result));
            }
            if ("class java.lang.String".equals(xclass)) {
                if (result instanceof String) {
                    return result;
                }
                if (result instanceof Double) {
                    return PoiPublicUtil.doubleToString((Double)result);
                }
                return String.valueOf(result);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(ExcelImportEnum.GET_VALUE_ERROR);
        }
    }

    private Object handlerValue(IExcelDataHandler dataHandler, Object object, Object result, String titleString) {
        if (dataHandler == null || dataHandler.getNeedHandlerFields() == null || dataHandler.getNeedHandlerFields().length == 0) {
            return result;
        }
        if (this.handlerList == null) {
            this.handlerList = Arrays.asList(dataHandler.getNeedHandlerFields());
        }
        if (this.handlerList.contains(titleString)) {
            return dataHandler.importHandler(object, titleString, result);
        }
        return result;
    }

    private Object replaceValue(String[] replace, Object result) {
        if (replace != null && replace.length > 0) {
            String temp = String.valueOf(result);
            for (int i = 0; i < replace.length; ++i) {
                String[] tempArr = replace[i].split("_");
                if (!temp.equals(tempArr[0])) continue;
                return tempArr[1];
            }
        }
        return result;
    }
}

