/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.cache.manager;

import cn.afterturn.easypoi.cache.manager.FileLoaderImpl;
import cn.afterturn.easypoi.cache.manager.IFileLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POICacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(POICacheManager.class);
    private static IFileLoader fileLoader = new FileLoaderImpl();
    private static ThreadLocal<IFileLoader> LOCAL_FILELOADER = new ThreadLocal();

    public static InputStream getFile(String id) {
        try {
            if (LOCAL_FILELOADER.get() != null) {
                byte[] byArray = LOCAL_FILELOADER.get().getFile(id);
            }
            byte[] result = fileLoader.getFile(id);
            result = Arrays.copyOf(result, result.length);
            return new ByteArrayInputStream(result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void setFileLoader(IFileLoader fileLoader) {
        POICacheManager.fileLoader = fileLoader;
    }

    public static void setFileLoaderOnce(IFileLoader fileLoader) {
        if (fileLoader != null) {
            LOCAL_FILELOADER.set(fileLoader);
        }
    }
}

