/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.export.base;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelCollection;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import cn.afterturn.easypoi.handler.inter.IExcelDataHandler;
import cn.afterturn.easypoi.handler.inter.IExcelDictHandler;
import cn.afterturn.easypoi.handler.inter.IExcelI18nHandler;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportCommonService {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExportCommonService.class);
    protected IExcelDataHandler dataHandler;
    protected IExcelDictHandler dictHandler;
    protected IExcelI18nHandler i18nHandler;
    protected List<String> needHandlerList;

    private ExcelExportEntity createExcelExportEntity(Field field, String targetId, Class<?> pojoClass, List<Method> getMethods, ExcelEntity excelGroup) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(excel.type());
        this.getExcelField(targetId, field, excelEntity, excel, pojoClass, excelGroup);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        return excelEntity;
    }

    private Object dateFormatValue(Object value, ExcelExportEntity entity) throws Exception {
        SimpleDateFormat format;
        java.util.Date temp = null;
        if (value instanceof String && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{value.toString()})) {
            format = new SimpleDateFormat(entity.getDatabaseFormat());
            temp = format.parse(value.toString());
        } else if (value instanceof java.util.Date) {
            temp = (java.util.Date)value;
        } else if (value instanceof Date) {
            temp = new java.util.Date(((Date)value).getTime());
        } else if (value instanceof Time) {
            temp = new java.util.Date(((Time)value).getTime());
        } else if (value instanceof Timestamp) {
            temp = new java.util.Date(((Timestamp)value).getTime());
        }
        if (temp != null) {
            format = new SimpleDateFormat(entity.getFormat());
            value = format.format(temp);
        }
        return value;
    }

    private Object numFormatValue(Object value, ExcelExportEntity entity) {
        if (value == null) {
            return null;
        }
        if (!NumberUtils.isNumber((String)value.toString())) {
            LOGGER.error("data want num format ,but is not num, value is:" + value);
            return null;
        }
        Double d = Double.parseDouble(value.toString());
        DecimalFormat df = new DecimalFormat(entity.getNumFormat());
        return df.format(d);
    }

    public void getAllExcelField(String[] exclusions, String targetId, Field[] fields, List<ExcelExportEntity> excelParams, Class<?> pojoClass, List<Method> getMethods, ExcelEntity excelGroup) throws Exception {
        List<String> exclusionsList = exclusions != null ? Arrays.asList(exclusions) : null;
        for (int i = 0; i < fields.length; ++i) {
            Excel excel;
            Field field = fields[i];
            if (PoiPublicUtil.isNotUserExcelUserThis(exclusionsList, field, targetId)) continue;
            if (field.getAnnotation(Excel.class) != null) {
                excel = field.getAnnotation(Excel.class);
                String name = PoiPublicUtil.getValueByTargetId(excel.name(), targetId, null);
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                excelParams.add(this.createExcelExportEntity(field, targetId, pojoClass, getMethods, excelGroup));
                continue;
            }
            if (PoiPublicUtil.isCollection(field.getType())) {
                excel = field.getAnnotation(ExcelCollection.class);
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class clz = (Class)pt.getActualTypeArguments()[0];
                ArrayList<ExcelExportEntity> list = new ArrayList<ExcelExportEntity>();
                this.getAllExcelField(exclusions, StringUtils.isNotEmpty((CharSequence)excel.id()) ? excel.id() : targetId, PoiPublicUtil.getClassFields(clz), list, clz, null, null);
                ExcelExportEntity excelEntity = new ExcelExportEntity();
                excelEntity.setName(PoiPublicUtil.getValueByTargetId(excel.name(), targetId, null));
                if (this.i18nHandler != null) {
                    excelEntity.setName(this.i18nHandler.getLocaleName(excelEntity.getName()));
                }
                excelEntity.setOrderNum(Integer.valueOf(PoiPublicUtil.getValueByTargetId(excel.orderNum(), targetId, "0")));
                excelEntity.setMethod(PoiReflectorUtil.fromCache(pojoClass).getGetMethod(field.getName()));
                excelEntity.setList(list);
                excelParams.add(excelEntity);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(PoiReflectorUtil.fromCache(pojoClass).getGetMethod(field.getName()));
            ExcelEntity excel2 = field.getAnnotation(ExcelEntity.class);
            if (excel2.show() && StringUtils.isEmpty((CharSequence)excel2.name())) {
                throw new ExcelExportException("if use ExcelEntity ,name mus has value ,data: " + ReflectionToStringBuilder.toString((Object)excel2), ExcelExportEnum.PARAMETER_ERROR);
            }
            this.getAllExcelField(exclusions, StringUtils.isNotEmpty((CharSequence)excel2.id()) ? excel2.id() : targetId, PoiPublicUtil.getClassFields(field.getType()), excelParams, field.getType(), newMethods, (ExcelEntity)(excel2.show() ? excel2 : null));
        }
    }

    public Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value;
        if (obj instanceof Map) {
            value = ((Map)obj).get(entity.getKey());
        } else {
            Object object = value = entity.getMethods() != null ? this.getFieldBySomeMethod(entity.getMethods(), obj) : entity.getMethod().invoke(obj, new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getFormat())) {
            value = this.dateFormatValue(value, entity);
        }
        if (entity.getReplace() != null && entity.getReplace().length > 0) {
            value = this.replaceValue(entity.getReplace(), String.valueOf(value));
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getNumFormat())) {
            value = this.numFormatValue(value, entity);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getDict()) && this.dictHandler != null) {
            value = this.dictHandler.toName(entity.getDict(), obj, entity.getName(), value);
        }
        if (this.needHandlerList != null && this.needHandlerList.contains(entity.getName())) {
            value = this.dataHandler.exportHandler(obj, entity.getName(), value);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getSuffix()) && value != null) {
            value = value + entity.getSuffix();
        }
        if (value != null && StringUtils.isNotEmpty((CharSequence)entity.getEnumExportField())) {
            value = PoiReflectorUtil.fromCache(value.getClass()).getValue(value, entity.getEnumExportField());
        }
        return value == null ? "" : value.toString();
    }

    public Collection<?> getListCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value = obj instanceof Map ? ((Map)obj).get(entity.getKey()) : (Collection)entity.getMethod().invoke(obj, new Object[0]);
        return (Collection)value;
    }

    private void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass, ExcelEntity excelGroup) throws Exception {
        excelEntity.setName(PoiPublicUtil.getValueByTargetId(excel.name(), targetId, null));
        excelEntity.setWidth(excel.width());
        excelEntity.setHeight(excel.height());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setMergeVertical(excel.mergeVertical());
        excelEntity.setMergeRely(excel.mergeRely());
        excelEntity.setReplace(excel.replace());
        excelEntity.setOrderNum(Integer.valueOf(PoiPublicUtil.getValueByTargetId(excel.orderNum(), targetId, "0")));
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setFormat(StringUtils.isNotEmpty((CharSequence)excel.exportFormat()) ? excel.exportFormat() : excel.format());
        excelEntity.setStatistics(excel.isStatistics());
        excelEntity.setHyperlink(excel.isHyperlink());
        excelEntity.setMethod(PoiReflectorUtil.fromCache(pojoClass).getGetMethod(field.getName()));
        excelEntity.setNumFormat(excel.numFormat());
        excelEntity.setColumnHidden(excel.isColumnHidden());
        excelEntity.setDict(excel.dict());
        excelEntity.setEnumExportField(excel.enumExportField());
        if (excelGroup != null) {
            excelEntity.setGroupName(PoiPublicUtil.getValueByTargetId(excelGroup.name(), targetId, null));
        } else {
            excelEntity.setGroupName(excel.groupName());
        }
        if (this.i18nHandler != null) {
            excelEntity.setName(this.i18nHandler.getLocaleName(excelEntity.getName()));
            excelEntity.setGroupName(this.i18nHandler.getLocaleName(excelEntity.getGroupName()));
        }
    }

    public Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    public short getRowHeight(List<ExcelExportEntity> excelParams) {
        double maxHeight = 0.0;
        for (int i = 0; i < excelParams.size(); ++i) {
            double d = maxHeight = maxHeight > excelParams.get(i).getHeight() ? maxHeight : excelParams.get(i).getHeight();
            if (excelParams.get(i).getList() == null) continue;
            for (int j = 0; j < excelParams.get(i).getList().size(); ++j) {
                maxHeight = maxHeight > excelParams.get(i).getList().get(j).getHeight() ? maxHeight : excelParams.get(i).getList().get(j).getHeight();
            }
        }
        return (short)(maxHeight * 50.0);
    }

    private Object replaceValue(String[] replace, String value) {
        for (String str : replace) {
            String[] temp = str.split("_");
            if (!value.equals(temp[1])) continue;
            value = temp[0];
            break;
        }
        return value;
    }

    public void sortAllParams(List<ExcelExportEntity> excelParams) {
        HashMap groupMap = new HashMap();
        for (int i = excelParams.size() - 1; i > -1; --i) {
            if (excelParams.get(i).getList() != null) {
                Collections.sort(excelParams.get(i).getList());
                continue;
            }
            if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{excelParams.get(i).getGroupName()})) continue;
            if (!groupMap.containsKey(excelParams.get(i).getGroupName())) {
                groupMap.put(excelParams.get(i).getGroupName(), new ArrayList());
            }
            ((List)groupMap.get(excelParams.get(i).getGroupName())).add(excelParams.get(i));
            excelParams.remove(i);
        }
        Collections.sort(excelParams);
        if (groupMap.size() > 0) {
            for (Map.Entry entry : groupMap.entrySet()) {
                Collections.sort((List)entry.getValue());
                boolean isInsert = false;
                String groupName = "START";
                for (int i = 0; i < excelParams.size(); ++i) {
                    if (excelParams.get(i).getOrderNum() > ((ExcelExportEntity)((List)entry.getValue()).get(0)).getOrderNum() && !groupName.equals(excelParams.get(i).getGroupName())) {
                        if (StringUtils.isNotEmpty((CharSequence)excelParams.get(i).getGroupName())) {
                            groupName = excelParams.get(i).getGroupName();
                        }
                        excelParams.addAll(i, (Collection)entry.getValue());
                        isInsert = true;
                        break;
                    }
                    if (groupName.equals(excelParams.get(i).getGroupName()) || !StringUtils.isNotEmpty((CharSequence)excelParams.get(i).getGroupName())) continue;
                    groupName = excelParams.get(i).getGroupName();
                }
                if (isInsert) continue;
                excelParams.addAll((Collection)entry.getValue());
            }
        }
    }

    public ExcelExportEntity indexExcelEntity(ExportParams entity) {
        ExcelExportEntity exportEntity = new ExcelExportEntity();
        exportEntity.setOrderNum(Integer.MIN_VALUE);
        exportEntity.setName(entity.getIndexName());
        exportEntity.setWidth(10.0);
        exportEntity.setFormat("isAddIndex");
        return exportEntity;
    }

    public int getFieldLength(List<ExcelExportEntity> excelParams) {
        int length = -1;
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() != null) {
                length += this.getFieldLength(entity.getList()) + 1;
                continue;
            }
            ++length;
        }
        return length;
    }

    public int getRowNums(List<ExcelExportEntity> excelParams, boolean isDeep) {
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() != null && StringUtils.isNotBlank((CharSequence)excelParams.get(i).getName())) {
                return isDeep ? 1 + this.getRowNums(excelParams.get(i).getList(), isDeep) : 2;
            }
            if (!StringUtils.isNotEmpty((CharSequence)excelParams.get(i).getGroupName())) continue;
            return 2;
        }
        return 1;
    }
}

