/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.csv.imports;

import cn.afterturn.easypoi.csv.entity.CsvImportParams;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.params.ExcelCollectionParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelVerifyHandlerResult;
import cn.afterturn.easypoi.excel.imports.CellValueService;
import cn.afterturn.easypoi.excel.imports.base.ImportBaseService;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelImportEnum;
import cn.afterturn.easypoi.handler.inter.IExcelModel;
import cn.afterturn.easypoi.handler.inter.IReadHandler;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import cn.afterturn.easypoi.util.PoiValidationUtil;
import cn.afterturn.easypoi.util.UnicodeInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvImportService
extends ImportBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvImportService.class);
    private CellValueService cellValueServer = new CellValueService();
    private boolean verifyFail = false;

    /*
     * Unable to fully structure code
     */
    public <T> List<T> readExcel(InputStream inputstream, Class<?> pojoClass, CsvImportParams params, IReadHandler readHandler) {
        collection = new ArrayList<Object>();
        try {
            excelParams = new HashMap<String, ExcelImportEntity>();
            excelCollection = new ArrayList<ExcelCollectionParams>();
            targetId = null;
            this.i18nHandler = params.getI18nHandler();
            if (!Map.class.equals(pojoClass)) {
                fileds = PoiPublicUtil.getClassFields(pojoClass);
                etarget = pojoClass.getAnnotation(ExcelTarget.class);
                if (etarget != null) {
                    targetId = etarget.value();
                }
                this.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null, null);
            }
            inputstream = new PushbackInputStream(inputstream, 3);
            head = new byte[3];
            inputstream.read(head);
            if (head[0] == -17 && head[1] == -69 && head[2] == -65) {
                ((PushbackInputStream)inputstream).unread(head, 0, 3);
                inputstream = new UnicodeInputStream(inputstream);
            } else {
                ((PushbackInputStream)inputstream).unread(head, 0, 3);
            }
            rows = new BufferedReader(new InputStreamReader(inputstream, params.getEncoding()));
            for (j = 0; j < params.getTitleRows(); ++j) {
                rows.readLine();
            }
            titlemap = this.getTitleMap(rows, params, excelCollection, excelParams);
            readRow = 0;
            for (i = 0; i < params.getStartRows(); ++i) {
                rows.readLine();
            }
            if (excelCollection.size() > 0 && params.getKeyIndex() == null) {
                params.setKeyIndex(0);
            }
            row = null;
            object = null;
            while ((row = rows.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)row)) continue;
                errorMsg = new StringBuilder();
                cells = row.split(params.getSpiltMark(), -1);
                if (params.getKeyIndex() != null && (cells[params.getKeyIndex()] == null || StringUtils.isEmpty((CharSequence)cells[params.getKeyIndex()])) && object != null) {
                    for (ExcelCollectionParams param : excelCollection) {
                        this.addListContinue(object, param, row, titlemap, targetId, params, errorMsg);
                    }
                } else {
                    object = PoiPublicUtil.createObject(pojoClass, targetId);
                    try {
                        keys = titlemap.keySet();
                        for (Integer cn : keys) {
                            titleString = titlemap.get(cn);
                            if (!excelParams.containsKey(titleString) && !Map.class.equals(pojoClass)) continue;
                            try {
                                this.saveFieldValue(params, object, cells[cn], excelParams, titleString);
                            }
                            catch (ExcelImportException e) {
                                if (!params.isNeedVerify() || !ExcelImportEnum.GET_VALUE_ERROR.equals((Object)e.getType())) continue;
                                errorMsg.append(" ").append(titleString).append(ExcelImportEnum.GET_VALUE_ERROR.getMsg());
                            }
                        }
                        for (ExcelCollectionParams param : excelCollection) {
                            this.addListContinue(object, param, row, titlemap, targetId, params, errorMsg);
                        }
                        if (!this.verifyingDataValidity(object, params, pojoClass, errorMsg)) ** GOTO lbl77
                        if (readHandler != null) {
                            readHandler.handler(object);
                        }
                        collection.add(object);
                    }
                    catch (ExcelImportException e) {
                        CsvImportService.LOGGER.error("excel import error , row num:{},obj:{}", (Object)readRow, (Object)ReflectionToStringBuilder.toString((Object)object));
                        if (e.getType().equals((Object)ExcelImportEnum.VERIFY_ERROR)) ** GOTO lbl77
                        throw new ExcelImportException(e.getType(), (Throwable)e);
                    }
                    catch (Exception e) {
                        CsvImportService.LOGGER.error("excel import error , row num:{},obj:{}", (Object)readRow, (Object)ReflectionToStringBuilder.toString((Object)object));
                        throw new RuntimeException(e);
                    }
                }
lbl77:
                // 5 sources

                ++readRow;
            }
            if (readHandler != null) {
                readHandler.doAfterAll();
            }
        }
        catch (Exception e) {
            CsvImportService.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return collection;
    }

    private void addListContinue(Object object, ExcelCollectionParams param, String row, Map<Integer, String> titlemap, String targetId, CsvImportParams params, StringBuilder errorMsg) throws Exception {
        Collection collection = (Collection)PoiReflectorUtil.fromCache(object.getClass()).getValue(object, param.getName());
        Object entity = PoiPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        String[] cells = row.split(params.getSpiltMark());
        for (int i = 0; i < cells.length; ++i) {
            block4: {
                String cell = cells[i];
                String titleString = titlemap.get(i);
                if (!param.getExcelParams().containsKey(titleString)) continue;
                try {
                    this.saveFieldValue(params, entity, cell, param.getExcelParams(), titleString);
                }
                catch (ExcelImportException e) {
                    if (!params.isNeedVerify() || !ExcelImportEnum.GET_VALUE_ERROR.equals((Object)e.getType())) break block4;
                    errorMsg.append(" ").append(titleString).append(ExcelImportEnum.GET_VALUE_ERROR.getMsg());
                }
            }
            isUsed = true;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private boolean verifyingDataValidity(Object object, CsvImportParams params, Class<?> pojoClass, StringBuilder fieldErrorMsg) {
        ExcelVerifyHandlerResult result;
        IExcelModel model;
        String errorMsg;
        boolean isAdd = true;
        Object cell = null;
        if (params.isNeedVerify() && StringUtils.isNotEmpty((CharSequence)(errorMsg = PoiValidationUtil.validation(object, params.getVerifyGroup())))) {
            if (object instanceof IExcelModel) {
                model = (IExcelModel)object;
                model.setErrorMsg(errorMsg);
            }
            isAdd = false;
            this.verifyFail = true;
        }
        if (params.getVerifyHandler() != null && !(result = params.getVerifyHandler().verifyHandler(object)).isSuccess()) {
            if (object instanceof IExcelModel) {
                model = (IExcelModel)object;
                model.setErrorMsg((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{model.getErrorMsg()}) ? model.getErrorMsg() + "," : "") + result.getMsg());
            }
            isAdd = false;
            this.verifyFail = true;
        }
        if ((params.isNeedVerify() || params.getVerifyHandler() != null) && fieldErrorMsg.length() > 0) {
            if (object instanceof IExcelModel) {
                IExcelModel model2 = (IExcelModel)object;
                model2.setErrorMsg((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{model2.getErrorMsg()}) ? model2.getErrorMsg() + "," : "") + fieldErrorMsg.toString());
            }
            isAdd = false;
            this.verifyFail = true;
        }
        return isAdd;
    }

    private void saveFieldValue(CsvImportParams params, Object object, String cell, Map<String, ExcelImportEntity> excelParams, String titleString) throws Exception {
        if (cell.startsWith(params.getTextMark()) && cell.endsWith(params.getTextMark())) {
            cell = cell.replaceFirst(cell, params.getTextMark());
            cell = cell.substring(0, cell.lastIndexOf(params.getTextMark()));
        }
        Object value = this.cellValueServer.getValue(params.getDataHandler(), object, cell, excelParams, titleString, params.getDictHandler());
        if (object instanceof Map) {
            if (params.getDataHandler() != null) {
                params.getDataHandler().setMapValue((Map)object, titleString, value);
            } else {
                ((Map)object).put(titleString, value);
            }
        } else {
            this.setValues(excelParams.get(titleString), object, value);
        }
    }

    private Map<Integer, String> getTitleMap(BufferedReader rows, CsvImportParams params, List<ExcelCollectionParams> excelCollection, Map<String, ExcelImportEntity> excelParams) throws IOException {
        LinkedHashMap<Integer, String> titlemap = new LinkedHashMap<Integer, String>();
        String collectionName = null;
        ExcelCollectionParams collectionParams = null;
        String row = null;
        for (int j = 0; j < params.getHeadRows(); ++j) {
            row = rows.readLine();
            if (row == null) continue;
            String[] cellTitle = row.split(params.getSpiltMark());
            for (int i = 0; i < cellTitle.length; ++i) {
                String value = cellTitle[i];
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                if (titlemap.containsKey(i)) {
                    collectionName = (String)titlemap.get(i);
                    collectionParams = this.getCollectionParams(excelCollection, collectionName);
                    titlemap.put(i, collectionName + "_" + value);
                } else if (StringUtils.isNotEmpty(collectionName) && collectionParams != null && collectionParams.getExcelParams().containsKey(collectionName + "_" + value)) {
                    titlemap.put(i, collectionName + "_" + value);
                } else {
                    collectionName = null;
                    collectionParams = null;
                }
                if (!StringUtils.isEmpty((CharSequence)collectionName)) continue;
                titlemap.put(i, value);
            }
        }
        Set<String> keys = excelParams.keySet();
        for (String key : keys) {
            if (!key.startsWith("FIXED_")) continue;
            String[] arr = key.split("_");
            titlemap.put(Integer.parseInt(arr[1]), key);
        }
        return titlemap;
    }

    private ExcelCollectionParams getCollectionParams(List<ExcelCollectionParams> excelCollection, String collectionName) {
        for (ExcelCollectionParams excelCollectionParams : excelCollection) {
            if (!collectionName.equals(excelCollectionParams.getExcelName())) continue;
            return excelCollectionParams;
        }
        return null;
    }
}

