/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.cache;

import cn.afterturn.easypoi.cache.manager.POICacheManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImage(String imagePath) {
        InputStream is = POICacheManager.getFile(imagePath);
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        try {
            BufferedImage bufferImg = ImageIO.read(is);
            ImageIO.write((RenderedImage)bufferImg, imagePath.substring(imagePath.lastIndexOf(".") + 1, imagePath.length()), byteArrayOut);
            byte[] byArray = byteArrayOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
            IOUtils.closeQuietly((Closeable)byteArrayOut);
        }
    }
}

