/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.export.template;

import cn.afterturn.easypoi.cache.ExcelCache;
import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.entity.TemplateSumEntity;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.params.ExcelForEachParams;
import cn.afterturn.easypoi.excel.export.base.BaseExportService;
import cn.afterturn.easypoi.excel.export.styler.IExcelExportStyler;
import cn.afterturn.easypoi.excel.export.template.TemplateSumHandler;
import cn.afterturn.easypoi.excel.html.helper.MergedRegionHelper;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import cn.afterturn.easypoi.util.PoiCellUtil;
import cn.afterturn.easypoi.util.PoiDataDesensitizationUtil;
import cn.afterturn.easypoi.util.PoiElUtil;
import cn.afterturn.easypoi.util.PoiExcelGraphDataUtil;
import cn.afterturn.easypoi.util.PoiExcelTempUtil;
import cn.afterturn.easypoi.util.PoiMergeCellUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiSheetUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelExportOfTemplateUtil
extends BaseExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportOfTemplateUtil.class);
    private Set<String> tempCreateCellSet = new HashSet<String>();
    private TemplateExportParams templateParams;
    private MergedRegionHelper mergedRegionHelper;
    private TemplateSumHandler templateSumHandler;

    private void addDataToSheet(Class<?> pojoClass, Collection<?> dataSet, Sheet sheet, Workbook workbook) throws Exception {
        int index;
        Map<String, Integer> titlemap = this.getTitleMap(sheet);
        Drawing patriarch = PoiExcelGraphDataUtil.getDrawingPatriarch(sheet);
        Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.value();
        }
        ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
        this.getAllExcelField(null, targetId, fileds, excelParams, pojoClass, null, null);
        this.sortAndFilterExportField(excelParams, titlemap);
        short rowHeight = this.getRowHeight(excelParams);
        int titleHeight = index = this.templateParams.getHeadingRows() + this.templateParams.getHeadingStartRow();
        int shiftRows = this.getShiftRows(dataSet, excelParams);
        sheet.shiftRows(this.templateParams.getHeadingRows() + this.templateParams.getHeadingStartRow(), sheet.getLastRowNum(), shiftRows, true, true);
        this.mergedRegionHelper.shiftRows(sheet, this.templateParams.getHeadingRows() + this.templateParams.getHeadingStartRow(), shiftRows, sheet.getLastRowNum() - this.templateParams.getHeadingRows() - this.templateParams.getHeadingStartRow());
        this.templateSumHandler.shiftRows(this.templateParams.getHeadingRows() + this.templateParams.getHeadingStartRow(), shiftRows);
        PoiExcelTempUtil.reset(sheet, this.templateParams.getHeadingRows() + this.templateParams.getHeadingStartRow(), sheet.getLastRowNum());
        if (excelParams.size() == 0) {
            return;
        }
        for (Object t : dataSet) {
            index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight, 0)[0];
        }
        this.mergeCells(sheet, excelParams, titleHeight);
    }

    private void addListDataToExcel(Cell cell, Map<String, Object> map, String name) throws Exception {
        Object t;
        boolean isCreate = !name.contains("!fe:");
        boolean isShift = name.contains("$fe:");
        String[] keys = (name = name.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("{{", "")).replaceAll("\\s{1,}", " ").trim().split(" ");
        Collection datas = (Collection)PoiPublicUtil.getParamsValue(keys[0], map);
        if (datas == null) {
            return;
        }
        Object[] columnsInfo = this.getAllDataColumns(cell, name.replace(keys[0], ""), this.mergedRegionHelper);
        Iterator its = datas.iterator();
        int rowspan = (Integer)columnsInfo[0];
        int colspan = (Integer)columnsInfo[1];
        List columns = (List)columnsInfo[2];
        Row row = null;
        int rowIndex = cell.getRow().getRowNum() + 1;
        ExcelForEachParams indexColumn = this.getIndexColumn(columns);
        int loopSize = 0;
        if (its.hasNext()) {
            t = its.next();
            loopSize = this.setForeachRowCellValue(isCreate, cell.getRow(), cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper)[0];
            rowIndex += rowspan - 1 + loopSize - 1;
        }
        if (isShift && datas.size() > 1 && datas.size() * rowspan > 1 && cell.getRowIndex() + rowspan <= cell.getRow().getSheet().getLastRowNum()) {
            int lastRowNum = cell.getRow().getSheet().getLastRowNum();
            int shiftRows = lastRowNum - cell.getRowIndex() - rowspan;
            cell.getRow().getSheet().shiftRows(cell.getRowIndex() + rowspan, lastRowNum, (datas.size() - 1) * rowspan, true, true);
            this.mergedRegionHelper.shiftRows(cell.getSheet(), cell.getRowIndex() + rowspan, (datas.size() - 1) * rowspan, shiftRows);
            this.templateSumHandler.shiftRows(cell.getRowIndex() + rowspan, (datas.size() - 1) * rowspan);
            PoiExcelTempUtil.reset(cell.getSheet(), cell.getRowIndex() + rowspan + (datas.size() - 1) * rowspan, cell.getRow().getSheet().getLastRowNum());
        }
        while (its.hasNext()) {
            t = its.next();
            row = this.createRow(rowIndex, cell.getSheet(), isCreate, rowspan);
            indexColumn.addConstValue(1);
            loopSize = this.setForeachRowCellValue(isCreate, row, cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper)[0];
            rowIndex += rowspan + loopSize - 1;
        }
    }

    private ExcelForEachParams getIndexColumn(List<ExcelForEachParams> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i) == null || !"&INDEX&".equals(columns.get(i).getConstValue())) continue;
            columns.get(i).setConstValue("1");
            return columns.get(i);
        }
        return new ExcelForEachParams();
    }

    private int getShiftRows(Collection<?> dataSet, List<ExcelExportEntity> excelParams) throws Exception {
        int size = 0;
        for (Object t : dataSet) {
            size += this.getOneObjectSize(t, excelParams);
        }
        return size;
    }

    private int getOneObjectSize(Object t, List<ExcelExportEntity> excelParams) throws Exception {
        int maxHeight = 1;
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            Collection list;
            ExcelExportEntity entity = excelParams.get(k);
            if (entity.getList() == null || (list = (Collection)entity.getMethod().invoke(t, new Object[0])) == null || list.size() <= maxHeight) continue;
            maxHeight = list.size();
        }
        return maxHeight;
    }

    public Workbook createExcelCloneByTemplate(TemplateExportParams params, Map<Integer, List<Map<String, Object>>> map) {
        if (params == null || map == null || StringUtils.isEmpty((CharSequence)params.getTemplateUrl())) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            this.templateParams = params;
            wb = ExcelCache.getWorkbook(this.templateParams.getTemplateUrl(), this.templateParams.getSheetNum(), true);
            int oldSheetNum = wb.getNumberOfSheets();
            ArrayList<String> oldSheetName = new ArrayList<String>();
            for (int i = 0; i < oldSheetNum; ++i) {
                oldSheetName.add(wb.getSheetName(i));
            }
            ArrayList<Integer> sheetNumList = new ArrayList<Integer>();
            sheetNumList.addAll(map.keySet());
            Collections.sort(sheetNumList);
            for (Integer sheetNum : sheetNumList) {
                List<Map<String, Object>> mapList = map.get(sheetNum);
                for (int i = mapList.size(); i > 0; --i) {
                    wb.cloneSheet(sheetNum.intValue());
                }
            }
            for (int i = 0; i < oldSheetName.size(); ++i) {
                wb.removeSheetAt(wb.getSheetIndex((String)oldSheetName.get(i)));
            }
            this.setExcelExportStyler((IExcelExportStyler)this.templateParams.getStyle().getConstructor(Workbook.class).newInstance(wb));
            int sheetIndex = 0;
            for (Integer sheetNum : sheetNumList) {
                List<Map<String, Object>> mapList = map.get(sheetNum);
                for (int i = mapList.size() - 1; i >= 0; --i) {
                    this.tempCreateCellSet.clear();
                    if (mapList.get(i).containsKey("sheetName")) {
                        wb.setSheetName(sheetIndex, mapList.get(i).get("sheetName").toString());
                    }
                    this.parseTemplate(wb.getSheetAt(sheetIndex), mapList.get(i), params.isColForEach());
                    if (params.isReadonly()) {
                        wb.getSheetAt(i).protectSheet(UUID.randomUUID().toString());
                    }
                    ++sheetIndex;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return wb;
    }

    public Workbook createExcelByTemplate(TemplateExportParams params, Map<Integer, Map<String, Object>> map) {
        if (params == null || map == null || StringUtils.isEmpty((CharSequence)params.getTemplateUrl())) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            int le;
            this.templateParams = params;
            wb = this.getCloneWorkBook();
            this.setExcelExportStyler((IExcelExportStyler)this.templateParams.getStyle().getConstructor(Workbook.class).newInstance(wb));
            int n = le = params.isScanAllsheet() ? wb.getNumberOfSheets() : params.getSheetNum().length;
            for (int i = 0; i < le; ++i) {
                if (params.getSheetName() != null && params.getSheetName().length > i && StringUtils.isNotEmpty((CharSequence)params.getSheetName()[i])) {
                    wb.setSheetName(i, params.getSheetName()[i]);
                }
                this.tempCreateCellSet.clear();
                this.parseTemplate(wb.getSheetAt(i), map.get(i), params.isColForEach());
                if (!params.isReadonly()) continue;
                wb.getSheetAt(i).protectSheet(UUID.randomUUID().toString());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return wb;
    }

    public Workbook createExcelByTemplate(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        if (params == null || map == null || StringUtils.isEmpty((CharSequence)params.getTemplateUrl()) && params.getTemplateWb() == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            int le;
            this.templateParams = params;
            wb = params.getTemplateWb() != null ? params.getTemplateWb() : this.getCloneWorkBook();
            if (params.getDictHandler() != null) {
                this.dictHandler = params.getDictHandler();
            }
            if (params.getI18nHandler() != null) {
                this.i18nHandler = params.getI18nHandler();
            }
            this.setExcelExportStyler((IExcelExportStyler)this.templateParams.getStyle().getConstructor(Workbook.class).newInstance(wb));
            int n = le = params.isScanAllsheet() ? wb.getNumberOfSheets() : params.getSheetNum().length;
            for (int i = 0; i < le; ++i) {
                if (params.getSheetName() != null && params.getSheetName().length > i && StringUtils.isNotEmpty((CharSequence)params.getSheetName()[i])) {
                    wb.setSheetName(i, params.getSheetName()[i]);
                }
                this.tempCreateCellSet.clear();
                this.parseTemplate(wb.getSheetAt(i), map, params.isColForEach());
                if (!params.isReadonly()) continue;
                wb.getSheetAt(i).protectSheet(UUID.randomUUID().toString());
            }
            if (dataSet != null) {
                this.dataHandler = params.getDataHandler();
                if (this.dataHandler != null) {
                    this.needHandlerList = Arrays.asList(this.dataHandler.getNeedHandlerFields());
                }
                this.addDataToSheet(pojoClass, dataSet, wb.getSheetAt(params.getDataSheetNum()), wb);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return wb;
    }

    private Workbook getCloneWorkBook() throws Exception {
        return ExcelCache.getWorkbook(this.templateParams.getTemplateUrl(), this.templateParams.getSheetNum(), this.templateParams.isScanAllsheet());
    }

    private Map<String, Integer> getTitleMap(Sheet sheet) {
        Row row = null;
        HashMap<String, Integer> titlemap = new HashMap<String, Integer>();
        for (int j = 0; j < this.templateParams.getHeadingRows(); ++j) {
            row = sheet.getRow(j + this.templateParams.getHeadingStartRow());
            Iterator cellTitle = row.cellIterator();
            int i = row.getFirstCellNum();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (!StringUtils.isEmpty((CharSequence)value)) {
                    titlemap.put(value, i);
                }
                ++i;
            }
        }
        return titlemap;
    }

    private void parseTemplate(Sheet sheet, Map<String, Object> map, boolean colForeach) throws Exception {
        if (sheet.getWorkbook() instanceof XSSFWorkbook) {
            this.type = ExcelType.XSSF;
        }
        this.deleteCell(sheet, map);
        this.mergedRegionHelper = new MergedRegionHelper(sheet);
        this.templateSumHandler = new TemplateSumHandler(sheet);
        if (colForeach) {
            this.colForeach(sheet, map);
        }
        Row row = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                if (row.getCell(i) == null || this.tempCreateCellSet.contains(row.getRowNum() + "_" + row.getCell(i).getColumnIndex())) continue;
                this.setValueForCellByMap(row.getCell(i), map);
            }
        }
        this.handlerSumCell(sheet);
    }

    private void handlerSumCell(Sheet sheet) {
        for (TemplateSumEntity sumEntity : this.templateSumHandler.getDataList()) {
            Cell cell = sheet.getRow(sumEntity.getRow()).getCell(sumEntity.getCol());
            if (cell.getStringCellValue().contains(sumEntity.getSumKey())) {
                cell.setCellValue(cell.getStringCellValue().replace("sum:(" + sumEntity.getSumKey() + ")", sumEntity.getValue() + ""));
                continue;
            }
            cell.setCellValue(cell.getStringCellValue() + sumEntity.getValue());
        }
    }

    private void colForeach(Sheet sheet, Map<String, Object> map) throws Exception {
        Row row = null;
        Cell cell = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                String text;
                cell = row.getCell(i);
                if (row.getCell(i) == null || cell.getCellType() != CellType.STRING && cell.getCellType() != CellType.NUMERIC || !(text = PoiCellUtil.getCellValue(cell)).contains("#fe:") && !text.contains("v_fe:")) continue;
                this.foreachCol(cell, map, text);
            }
        }
    }

    private void foreachCol(Cell cell, Map<String, Object> map, String name) throws Exception {
        boolean isCreate = name.contains("v_fe:");
        name = name.replace("v_fe:", "").replace("#fe:", "").replace("{{", "");
        String[] keys = name.replaceAll("\\s{1,}", " ").trim().split(" ");
        Collection datas = (Collection)PoiPublicUtil.getParamsValue(keys[0], map);
        Object[] columnsInfo = this.getAllDataColumns(cell, name.replace(keys[0], ""), this.mergedRegionHelper);
        if (datas == null) {
            return;
        }
        Iterator its = datas.iterator();
        int rowspan = (Integer)columnsInfo[0];
        int colspan = (Integer)columnsInfo[1];
        List columns = (List)columnsInfo[2];
        while (its.hasNext()) {
            Object t = its.next();
            this.setForeachRowCellValue(true, cell.getRow(), cell.getColumnIndex(), t, columns, map, rowspan, colspan, this.mergedRegionHelper);
            if (cell.getRow().getCell(cell.getColumnIndex() + colspan) == null) {
                cell.getRow().createCell(cell.getColumnIndex() + colspan);
            }
            cell = cell.getRow().getCell(cell.getColumnIndex() + colspan);
        }
        if (isCreate) {
            cell = cell.getRow().getCell(cell.getColumnIndex() - 1);
            cell.setCellValue(cell.getStringCellValue() + "}}");
        }
    }

    private void deleteCell(Sheet sheet, Map<String, Object> map) throws Exception {
        Row row = null;
        Cell cell = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                cell = row.getCell(i);
                if (row.getCell(i) == null || cell.getCellType() != CellType.STRING && cell.getCellType() != CellType.NUMERIC) continue;
                cell.setCellType(CellType.STRING);
                String text = cell.getStringCellValue();
                if (!text.contains("!if:")) continue;
                if (Boolean.valueOf(PoiElUtil.eval(text.substring(text.indexOf("{{") + 2, text.indexOf("}}")).trim(), map).toString()).booleanValue()) {
                    PoiSheetUtil.deleteColumn(sheet, i);
                    --i;
                }
                cell.setCellValue("");
            }
        }
    }

    private void setValueForCellByMap(Cell cell, Map<String, Object> map) throws Exception {
        CellType cellType = cell.getCellType();
        if (cellType != CellType.STRING && cellType != CellType.NUMERIC) {
            return;
        }
        String oldString = cell.getStringCellValue();
        if (oldString != null && oldString.indexOf("{{") != -1 && !oldString.contains("fe:")) {
            boolean isNumber = this.isHasSymbol(oldString, "n:");
            Object obj = this.getValByHandler(oldString, map, cell);
            if (obj instanceof ImageEntity) {
                ImageEntity img = (ImageEntity)obj;
                cell.setCellValue("");
                if (img.getRowspan() > 1 || img.getColspan() > 1) {
                    img.setHeight(0);
                    PoiMergeCellUtil.addMergedRegion(cell.getSheet(), cell.getRowIndex(), cell.getRowIndex() + img.getRowspan() - 1, cell.getColumnIndex(), cell.getColumnIndex() + img.getColspan() - 1);
                }
                this.createImageCell(cell, img.getHeight(), img.getRowspan(), img.getColspan(), img.getUrl(), img.getData());
            } else if (isNumber && StringUtils.isNotBlank((CharSequence)obj.toString())) {
                cell.setCellValue(Double.parseDouble(obj.toString()));
            } else {
                cell.setCellValue(obj.toString());
            }
        }
        if (oldString != null && oldString.contains("fe:")) {
            this.addListDataToExcel(cell, map, oldString.trim());
        }
    }

    private Object getValByHandler(String funStr, Map<String, Object> map, Cell cell) throws Exception {
        Object obj;
        if (this.isHasSymbol(funStr, "n:")) {
            funStr = funStr.replaceFirst("n:", "");
        }
        boolean isStyleBySelf = false;
        if (this.isHasSymbol(funStr, "sy:")) {
            isStyleBySelf = true;
            funStr = funStr.replaceFirst("sy:", "");
        }
        boolean isDict = false;
        String dict = null;
        if (this.isHasSymbol(funStr, "dict:")) {
            isDict = true;
            dict = funStr.substring(funStr.indexOf("dict:") + 5).split(";")[0];
            funStr = funStr.replaceFirst("dict:", "");
            funStr = funStr.replaceFirst(dict + ";", "");
        }
        boolean isI18n = false;
        if (this.isHasSymbol(funStr, "i18n:")) {
            isI18n = true;
            funStr = funStr.replaceFirst("i18n:", "");
        }
        boolean isDern = false;
        String dern = null;
        if (this.isHasSymbol(funStr, "deru:")) {
            isDern = true;
            dern = funStr.substring(funStr.indexOf("deru:") + 5).split(";")[0];
            funStr = funStr.replaceFirst("deru:", "");
            funStr = funStr.replaceFirst(dern + ";", "");
        }
        if (this.isHasSymbol(funStr, "merge:")) {
            String mergeStr = PoiPublicUtil.getElStr(funStr, "merge:");
            funStr = funStr.replace(mergeStr, "");
            mergeStr = mergeStr.replaceFirst("merge:", "");
            try {
                int colSpan = (int)Double.parseDouble(PoiPublicUtil.getRealValue(mergeStr, map).toString());
                PoiMergeCellUtil.addMergedRegion(cell.getSheet(), cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex() + colSpan - 1);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        Object object = obj = funStr.indexOf("{{") == -1 ? PoiElUtil.eval(funStr, map) : PoiPublicUtil.getRealValue(funStr, map);
        if (isDict) {
            obj = this.dictHandler.toName(dict, null, funStr, obj);
        }
        if (isI18n) {
            obj = this.i18nHandler.getLocaleName(obj.toString());
        }
        if (isDern) {
            obj = PoiDataDesensitizationUtil.desensitization(dern, obj);
        }
        return obj;
    }

    private boolean isHasSymbol(String text, String symbol) {
        return text.startsWith(symbol) || text.contains("{" + symbol) || text.contains(" " + symbol) || text.contains(";" + symbol);
    }

    private Row createRow(int rowIndex, Sheet sheet, boolean isCreate, int rows) {
        for (int i = 0; i < rows; ++i) {
            if (isCreate) {
                sheet.createRow(rowIndex++);
                continue;
            }
            if (sheet.getRow(rowIndex++) != null) continue;
            sheet.createRow(rowIndex - 1);
        }
        return sheet.getRow(rowIndex - rows);
    }

    private int[] setForeachRowCellValue(boolean isCreate, Row row, int columnIndex, Object t, List<ExcelForEachParams> columns, Map<String, Object> map, int rowspan, int colspan, MergedRegionHelper mergedRegionHelper) throws Exception {
        this.createRowCellSetStyle(row, columnIndex, columns, rowspan, colspan);
        int loopSize = 1;
        int loopCi = 1;
        for (int k = 0; k < rowspan; ++k) {
            int ci = columnIndex;
            row.setHeight(this.getMaxHeight(k, colspan, columns));
            for (int i = 0; i < colspan && i < columns.size(); ++i) {
                boolean isNeedMerge;
                String val;
                boolean isNumber = false;
                ExcelForEachParams params = columns.get(colspan * k + i);
                this.tempCreateCellSet.add(row.getRowNum() + "_" + ci);
                if (params == null) continue;
                if (StringUtils.isEmpty((CharSequence)params.getName()) && StringUtils.isEmpty((CharSequence)params.getConstValue())) {
                    row.getCell(ci).setCellStyle(params.getCellStyle());
                    ci += params.getColspan();
                    continue;
                }
                Object obj = null;
                String tempStr = params.getName();
                if (StringUtils.isEmpty((CharSequence)params.getName())) {
                    val = params.getConstValue();
                } else {
                    map.put(this.templateParams.getTempParams(), t);
                    isNumber = this.isHasSymbol(tempStr, "n:");
                    obj = this.getValByHandler(tempStr, map, row.getCell(ci));
                    val = obj.toString();
                }
                if (obj != null && obj instanceof Collection) {
                    String collectName = PoiElUtil.evalFindName(tempStr, map);
                    int[] loop = this.setForEachLoopRowCellValue(row, ci, (Collection)obj, columns, params, map, rowspan, colspan, mergedRegionHelper, collectName);
                    loopSize = Math.max(loopSize, loop[0]);
                    i += loop[1] - 1;
                    ci = loop[2] - params.getColspan();
                } else if (obj != null && obj instanceof ImageEntity) {
                    ImageEntity img = (ImageEntity)obj;
                    row.getCell(ci).setCellValue("");
                    if (img.getRowspan() > 1 || img.getColspan() > 1) {
                        img.setHeight(0);
                        row.getCell(ci).getSheet().addMergedRegion(new CellRangeAddress(row.getCell(ci).getRowIndex(), row.getCell(ci).getRowIndex() + img.getRowspan() - 1, row.getCell(ci).getColumnIndex(), row.getCell(ci).getColumnIndex() + img.getColspan() - 1));
                    }
                    this.createImageCell(row.getCell(ci), img.getHeight(), img.getRowspan(), img.getColspan(), img.getUrl(), img.getData());
                } else if (isNumber && StringUtils.isNotEmpty((CharSequence)val)) {
                    row.getCell(ci).setCellValue(Double.parseDouble(val));
                } else {
                    try {
                        row.getCell(ci).setCellValue(val);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (params.getCellStyle() != null) {
                    row.getCell(ci).setCellStyle(params.getCellStyle());
                }
                if (params.isNeedSum()) {
                    this.templateSumHandler.addValueOfKey(params.getName(), obj.toString());
                }
                this.setMergedRegionStyle(row, ci, params);
                boolean bl = isNeedMerge = (params.getRowspan() != 1 || params.getColspan() != 1) && !mergedRegionHelper.isMergedRegion(row.getRowNum() + 1, ci);
                if (isNeedMerge) {
                    PoiMergeCellUtil.addMergedRegion(row.getSheet(), row.getRowNum(), row.getRowNum() + params.getRowspan() - 1, ci, ci + params.getColspan() - 1);
                }
                if (params.getRowspan() == 1 && params.getColspan() == 1) {
                    row.getCell(ci).getSheet().setColumnWidth(row.getCell(ci).getColumnIndex(), params.getWidth());
                }
                ci += params.getColspan();
            }
            loopCi = Math.max(loopCi, ci);
            if (loopSize > 1) {
                this.handlerLoopMergedRegion(row, columnIndex, columns, loopSize);
            }
            row = row.getSheet().getRow(row.getRowNum() + 1);
        }
        return new int[]{loopSize, loopCi};
    }

    private void handlerLoopMergedRegion(Row row, int columnIndex, List<ExcelForEachParams> columns, int loopSize) {
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i) == null) continue;
            if (!columns.get(i).isCollectCell()) {
                PoiMergeCellUtil.addMergedRegion(row.getSheet(), row.getRowNum(), row.getRowNum() + loopSize - 1, columnIndex, columnIndex + columns.get(i).getColspan() - 1);
            }
            columnIndex += columns.get(i).getColspan();
        }
    }

    private short getMaxHeight(int k, int colspan, List<ExcelForEachParams> columns) {
        short high = columns.get(0).getHeight();
        for (int n = k; n > 0; --n) {
            if (columns.get(n * colspan).getHeight() == 0) {
                continue;
            }
            high = columns.get(n * colspan).getHeight();
            break;
        }
        return high;
    }

    private int[] setForEachLoopRowCellValue(Row row, int columnIndex, Collection obj, List<ExcelForEachParams> columns, ExcelForEachParams params, Map<String, Object> map, int rowspan, int colspan, MergedRegionHelper mergedRegionHelper, String collectName) throws Exception {
        List<ExcelForEachParams> temp = this.getLoopEachParams(columns, columnIndex, collectName);
        Iterator its = obj.iterator();
        Row tempRow = row;
        int nums = 0;
        int ci = columnIndex;
        while (its.hasNext()) {
            Object data = its.next();
            map.put("loop_" + columnIndex, data);
            int[] loopArr = this.setForeachRowCellValue(false, tempRow, columnIndex, data, temp, map, rowspan, colspan, mergedRegionHelper);
            nums += loopArr[0];
            ci = Math.max(ci, loopArr[1]);
            map.remove("loop_" + columnIndex);
            tempRow = this.createRow(tempRow.getRowNum() + loopArr[0], row.getSheet(), false, rowspan);
        }
        for (int i = 0; i < temp.size(); ++i) {
            temp.get(i).setName(temp.get(i).getTempName().pop());
            temp.get(i).setCollectCell(true);
        }
        return new int[]{nums, temp.size(), ci};
    }

    private List<ExcelForEachParams> getLoopEachParams(List<ExcelForEachParams> columns, int columnIndex, String collectName) {
        ArrayList<ExcelForEachParams> temp = new ArrayList<ExcelForEachParams>();
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i) == null) continue;
            columns.get(i).setCollectCell(false);
            if (columns.get(i) != null && !columns.get(i).getName().contains(collectName)) continue;
            temp.add(columns.get(i));
            if (columns.get(i).getTempName() == null) {
                columns.get(i).setTempName(new Stack<String>());
            }
            columns.get(i).setCollectCell(true);
            columns.get(i).getTempName().push(columns.get(i).getName());
            columns.get(i).setName(columns.get(i).getName().replace(collectName, "loop_" + columnIndex));
        }
        return temp;
    }

    private void createRowCellSetStyle(Row row, int columnIndex, List<ExcelForEachParams> columns, int rowspan, int colspan) {
        for (int i = 0; i < rowspan; ++i) {
            int size = columns.size();
            int max = columnIndex + colspan;
            for (int j = columnIndex; j < max; ++j) {
                CellStyle style;
                if (row.getCell(j) != null) continue;
                row.createCell(j);
                CellStyle cellStyle = row.getRowNum() % 2 == 0 ? this.getStyles(false, size <= j - columnIndex ? null : columns.get(j - columnIndex)) : (style = this.getStyles(true, size <= j - columnIndex ? null : columns.get(j - columnIndex)));
                if (style == null) continue;
                row.getCell(j).setCellStyle(style);
            }
            if (i >= rowspan - 1) continue;
            row = row.getSheet().getRow(row.getRowNum() + 1);
        }
    }

    private CellStyle getStyles(boolean isSingle, ExcelForEachParams excelForEachParams) {
        return this.excelExportStyler.getTemplateStyles(isSingle, excelForEachParams);
    }

    private void setMergedRegionStyle(Row row, int ci, ExcelForEachParams params) {
        int i;
        for (i = 1; i < params.getColspan(); ++i) {
            if (params.getCellStyle() == null) continue;
            row.getCell(ci + i).setCellStyle(params.getCellStyle());
        }
        for (i = 1; i < params.getRowspan(); ++i) {
            for (int j = 0; j < params.getColspan(); ++j) {
                if (params.getCellStyle() == null) continue;
                row.getCell(ci + j).setCellStyle(params.getCellStyle());
            }
        }
    }

    private Object[] getAllDataColumns(Cell cell, String name, MergedRegionHelper mergedRegionHelper) {
        ArrayList<ExcelForEachParams> columns = new ArrayList<ExcelForEachParams>();
        cell.setCellValue("");
        columns.add(this.getExcelTemplateParams(name.replace("}}", ""), cell, mergedRegionHelper));
        int rowspan = 1;
        int colspan = 1;
        if (!name.contains("}}")) {
            int index = cell.getColumnIndex();
            int startIndex = cell.getColumnIndex();
            Row row = cell.getRow();
            while (index < row.getLastCellNum()) {
                String cellStringString;
                int colSpan = columns.get(columns.size() - 1) != null ? ((ExcelForEachParams)columns.get(columns.size() - 1)).getColspan() : 1;
                index += colSpan;
                for (int i = 1; i < colSpan; ++i) {
                    columns.add(null);
                }
                cell = row.getCell(index);
                if (cell == null) {
                    columns.add(null);
                    continue;
                }
                try {
                    cellStringString = cell.getStringCellValue();
                    if (StringUtils.isBlank((CharSequence)cellStringString) && colspan + startIndex <= index) {
                        throw new ExcelExportException("for each \u5f53\u4e2d\u5b58\u5728\u7a7a\u5b57\u7b26\u4e32,\u8bf7\u68c0\u67e5\u6a21\u677f");
                    }
                    if (StringUtils.isBlank((CharSequence)cellStringString) && colspan + startIndex > index) {
                        columns.add(new ExcelForEachParams(null, cell.getCellStyle(), 0));
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new ExcelExportException(ExcelExportEnum.TEMPLATE_ERROR, (Throwable)e);
                }
                cell.setCellValue("");
                if (cellStringString.contains("}}")) {
                    columns.add(this.getExcelTemplateParams(cellStringString.replace("}}", ""), cell, mergedRegionHelper));
                    int lastCellColspan = ((ExcelForEachParams)columns.get(columns.size() - 1)).getColspan();
                    for (int i = 1; i < lastCellColspan; ++i) {
                        columns.add(null);
                    }
                    break;
                }
                if (cellStringString.contains("]]")) {
                    columns.add(this.getExcelTemplateParams(cellStringString.replace("]]", ""), cell, mergedRegionHelper));
                    colspan = index - startIndex + 1;
                    index = startIndex - ((ExcelForEachParams)columns.get(columns.size() - 1)).getColspan();
                    row = row.getSheet().getRow(row.getRowNum() + 1);
                    ++rowspan;
                    continue;
                }
                columns.add(this.getExcelTemplateParams(cellStringString.replace("]]", ""), cell, mergedRegionHelper));
            }
        }
        colspan = 0;
        for (int i = 0; i < columns.size(); ++i) {
            colspan += columns.get(i) != null ? ((ExcelForEachParams)columns.get(i)).getColspan() : 0;
        }
        return new Object[]{rowspan, colspan /= rowspan, columns};
    }

    private ExcelForEachParams getExcelTemplateParams(String name, Cell cell, MergedRegionHelper mergedRegionHelper) {
        name = name.trim();
        ExcelForEachParams params = new ExcelForEachParams(name, cell.getCellStyle(), cell.getRow().getHeight());
        if (name.startsWith("'") && name.endsWith("'")) {
            params.setName(null);
            params.setConstValue(name.substring(1, name.length() - 1));
        }
        if ("&NULL&".equals(name)) {
            params.setName(null);
            params.setConstValue("");
        }
        if ("&INDEX&".equals(name)) {
            params.setName(null);
            params.setConstValue("&INDEX&");
        }
        if (mergedRegionHelper.isMergedRegion(cell.getRowIndex() + 1, cell.getColumnIndex())) {
            Integer[] colAndrow = mergedRegionHelper.getRowAndColSpan(cell.getRowIndex() + 1, cell.getColumnIndex());
            params.setRowspan(colAndrow[0]);
            params.setColspan(colAndrow[1]);
        }
        params.setNeedSum(this.templateSumHandler.isSumKey(params.getName()));
        params.setWidth(cell.getSheet().getColumnWidth(cell.getColumnIndex()));
        return params;
    }

    private void sortAndFilterExportField(List<ExcelExportEntity> excelParams, Map<String, Integer> titlemap) {
        for (int i = excelParams.size() - 1; i >= 0; --i) {
            if (excelParams.get(i).getList() != null && excelParams.get(i).getList().size() > 0) {
                this.sortAndFilterExportField(excelParams.get(i).getList(), titlemap);
                if (excelParams.get(i).getList().size() == 0) {
                    excelParams.remove(i);
                    continue;
                }
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            if (titlemap.containsKey(excelParams.get(i).getName())) {
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            excelParams.remove(i);
        }
        this.sortAllParams(excelParams);
    }
}

