/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.pdf.imports;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.params.ExcelCollectionParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.excel.imports.base.ImportBaseService;
import cn.afterturn.easypoi.pdf.entity.PdfImportParams;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.tabula.ObjectExtractor;
import technology.tabula.Page;
import technology.tabula.PageIterator;
import technology.tabula.RectangularTextContainer;
import technology.tabula.Table;
import technology.tabula.extractors.ExtractionAlgorithm;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

public class PdfImportService
extends ImportBaseService {
    private static Logger LOGGER = LoggerFactory.getLogger(PdfImportService.class);
    private PDDocument document;
    private ExtractionAlgorithm algorithm = new SpreadsheetExtractionAlgorithm();

    public ExcelImportResult importExcelByIs(InputStream inputstream, Class<?> pojoClass, PdfImportParams params, boolean needMore) throws Exception {
        int len;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel import start ,class is {}", pojoClass);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputstream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        ByteArrayInputStream userIs = new ByteArrayInputStream(baos.toByteArray());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel clone success");
        }
        return this.importExcelByIs(PDDocument.load((InputStream)userIs), pojoClass, params, needMore);
    }

    public ExcelImportResult importExcelByIs(PDDocument pdDocument, Class<?> pojoClass, PdfImportParams params, boolean needMore) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel import start ,class is {}", pojoClass);
        }
        ArrayList result = new ArrayList();
        String targetId = null;
        Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        if (etarget != null) {
            targetId = etarget.value();
        }
        HashMap<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
        ArrayList<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
        this.getAllExcelField("", fileds, excelParams, excelCollection, pojoClass, null, null);
        this.document = pdDocument;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Document create success");
        }
        ExcelImportResult importResult = new ExcelImportResult();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" start to read excel by is ,startTime is {}", (Object)new Date());
        }
        this.importExcel(result, this.document, pojoClass, params, excelParams, excelCollection);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" end to read excel list by sheet ,endTime is {}", (Object)new Date());
        }
        if (params.isReadSingleCell() && LOGGER.isDebugEnabled()) {
            LOGGER.debug(" read Key-Value ,endTime is {}", (Object)System.currentTimeMillis());
        }
        importResult.setList(result);
        return importResult;
    }

    private Collection importExcel(List result, PDDocument document, Class<?> pojoClass, PdfImportParams params, Map<String, ExcelImportEntity> excelParams, List<ExcelCollectionParams> excelCollection) throws Exception {
        ArrayList maps = new ArrayList();
        PageIterator pi = new ObjectExtractor(document).extract();
        int rowNum = 0;
        int pageNum = 0;
        Map<Integer, String> titlemap = null;
        while (pi.hasNext()) {
            String titleString;
            String cellText;
            RectangularTextContainer cell;
            int k;
            Object object;
            List rows;
            List tables;
            Page page = pi.next();
            if (pageNum++ < 1) {
                tables = this.algorithm.extract(page);
                for (Table table : tables) {
                    rows = table.getRows();
                    if (rows.size() <= params.getHeadRows()) {
                        throw new RuntimeException("\u6807\u9898\u884c\u4e0d\u6b63\u786e");
                    }
                    for (List row : rows) {
                        if (rowNum < params.getTitleRows()) {
                            ++rowNum;
                            continue;
                        }
                        if (rowNum < params.getTitleRows() + params.getHeadRows()) {
                            ++rowNum;
                            titlemap = this.getTitleMap(row, params, excelCollection, excelParams);
                            continue;
                        }
                        if (rowNum < params.getTitleRows() + params.getHeadRows() + params.getStartRows()) {
                            ++rowNum;
                            continue;
                        }
                        object = PoiPublicUtil.createObject(pojoClass, "");
                        for (k = 0; k < row.size(); ++k) {
                            cell = (RectangularTextContainer)row.get(k);
                            cellText = params.getCellHandler() != null ? params.getCellHandler().getValue(cell) : ((cellText = cell.getText()) == null ? "" : cellText.trim());
                            titleString = titlemap.get(k);
                            if (!excelParams.containsKey(titleString)) continue;
                            this.setValues(excelParams.get(titleString), object, cellText);
                        }
                        result.add(object);
                        ++rowNum;
                    }
                }
                continue;
            }
            tables = this.algorithm.extract(page);
            for (Table table : tables) {
                rows = table.getRows();
                for (List row : rows) {
                    object = PoiPublicUtil.createObject(pojoClass, "");
                    for (k = 0; k < row.size(); ++k) {
                        cell = (RectangularTextContainer)row.get(k);
                        cellText = cell.getText();
                        cellText = cellText == null ? "" : cellText.trim();
                        titleString = titlemap.get(k);
                        if (!excelParams.containsKey(titleString)) continue;
                        this.setValues(excelParams.get(titleString), object, cellText);
                    }
                    result.add(object);
                    ++rowNum;
                }
            }
        }
        return result;
    }

    private Map<Integer, String> getTitleMap(List<RectangularTextContainer> row, PdfImportParams params, List<ExcelCollectionParams> excelCollection, Map<String, ExcelImportEntity> excelParams) {
        LinkedHashMap<Integer, String> titlemap = new LinkedHashMap<Integer, String>();
        Object collectionName = null;
        for (int k = 0; k < row.size(); ++k) {
            RectangularTextContainer cell = row.get(k);
            String cellText = cell.getText();
            String value = cellText == null ? "" : cellText.trim();
            value = value.replace("\n", "");
            titlemap.put(k, value);
        }
        Set<String> keys = excelParams.keySet();
        for (String key : keys) {
            if (!key.startsWith("FIXED_")) continue;
            String[] arr = key.split("_");
            titlemap.put(Integer.parseInt(arr[1]), key);
        }
        return titlemap;
    }

    public void setAlgorithm(ExtractionAlgorithm algorithm) {
        this.algorithm = algorithm;
    }
}

