/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.pdf.watermark;

import cn.afterturn.easypoi.pdf.watermark.IWatermarkProcessor;
import cn.afterturn.easypoi.pdf.watermark.RemoveResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkRemover {
    Logger logger = LoggerFactory.getLogger(WatermarkRemover.class);
    IWatermarkProcessor remover;
    List<RemoveResult> pageTokens = new ArrayList<RemoveResult>();
    List<String> watermarks = null;
    int pageStartIndex;
    int pageLength;

    public WatermarkRemover(IWatermarkProcessor remover, int pageStartIndex, int pageLength, List<String> watermarks) {
        this.remover = remover;
        this.pageStartIndex = pageStartIndex;
        this.pageLength = pageLength;
        this.watermarks = watermarks;
    }

    public void removeWatermark() {
        for (int i = this.pageStartIndex; i < this.pageStartIndex + this.pageLength && i < this.remover.getDocument().getNumberOfPages(); ++i) {
            try {
                this.processPage(i, this.remover.getDocument().getPage(i));
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u3010\u89e3\u6790PDF\u9875\u9762\u5931\u8d25\u3011", (Throwable)e);
            }
        }
    }

    public void processPage(int index, PDPage page) throws Exception {
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        parser.parse();
        List tokens = parser.getTokens();
        if (Objects.nonNull(tokens)) {
            for (int j = 0; j < tokens.size(); ++j) {
                Operator op;
                Object next = tokens.get(j);
                if (Objects.isNull(next) || !(next instanceof Operator) || !(op = (Operator)next).getName().equals("Tj")) continue;
                COSString previous = (COSString)tokens.get(j - 1);
                String string = previous.getString();
                if (null != this.watermarks && this.watermarks.contains(string)) {
                    previous.setValue("".getBytes("GBK"));
                    continue;
                }
                if (!this.remover.isWatermarkWord(string)) continue;
                previous.setValue("".getBytes("GBK"));
            }
        }
        RemoveResult pageResult = new RemoveResult(page, index, tokens);
        this.pageTokens.add(pageResult);
    }

    public List<RemoveResult> getPageTokens() {
        return this.pageTokens;
    }
}

