/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.wps.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;

public class EasyPoiWpsUtil {
    public static String getKeyValueStr(final Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(){
            {
                for (Map.Entry entry : params.entrySet()) {
                    this.add(entry.getKey());
                }
            }
        };
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = params.get(key) + "&";
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String getSignature(final Map<String, String> params, String appSecret) {
        ArrayList<String> keys = new ArrayList<String>(){
            {
                for (Map.Entry entry : params.entrySet()) {
                    this.add(entry.getKey());
                }
            }
        };
        keys.sort(String::compareTo);
        StringBuilder contents = new StringBuilder();
        for (String key : keys) {
            if (key.equals("_w_signature")) continue;
            contents.append(key).append("=").append(params.get(key));
        }
        contents.append("_w_secretkey=").append(appSecret);
        byte[] bytes = HmacUtils.hmacSha1((byte[])appSecret.getBytes(), (byte[])contents.toString().getBytes());
        String sign = Base64.encodeBase64String((byte[])bytes);
        try {
            return URLEncoder.encode(sign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> paramToMap(String paramStr) {
        final String[] params = paramStr.split("&");
        return new HashMap<String, String>(){
            {
                for (String param1 : params) {
                    String[] param = param1.split("=");
                    if (param.length < 2) continue;
                    String key = param[0];
                    StringBuilder value = new StringBuilder(param[1]);
                    for (int j = 2; j < param.length; ++j) {
                        value.append("=").append(param[j]);
                    }
                    this.put(key, value.toString());
                }
            }
        };
    }
}

