/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.core.response;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import retrofit2.Response;

public class HttpxBinaryResponseContent
implements Closeable {
    private final Response<ResponseBody> response;

    public HttpxBinaryResponseContent(Response<ResponseBody> response) {
        if (response == null || response.body() == null) {
            throw new IllegalArgumentException("Response or ResponseBody cannot be null");
        }
        this.response = response;
    }

    public byte[] getContent() throws IOException {
        if (this.response.body() == null) {
            throw new IOException("ResponseBody is null");
        }
        try (BufferedSource source = ((ResponseBody)this.response.body()).source();){
            byte[] byArray = source.readByteArray();
            return byArray;
        }
    }

    public String getText() throws IOException {
        if (this.response.body() == null) {
            throw new IOException("ResponseBody is null");
        }
        try (BufferedSource source = ((ResponseBody)this.response.body()).source();){
            String string = source.readUtf8();
            return string;
        }
    }

    public String getEncoding() {
        return this.response.body() != null && ((ResponseBody)this.response.body()).contentType() != null ? Objects.requireNonNull(Objects.requireNonNull(((ResponseBody)this.response.body()).contentType()).charset()).toString() : null;
    }

    public Iterator<byte[]> iterBytes(final int chunkSize) throws IOException {
        if (this.response.body() == null) {
            throw new IOException("ResponseBody is null");
        }
        return new Iterator<byte[]>(){
            final BufferedSource source;
            final byte[] buffer;
            boolean hasMore;
            {
                this.source = ((ResponseBody)HttpxBinaryResponseContent.this.response.body()).source();
                this.buffer = new byte[chunkSize];
                this.hasMore = true;
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.source.exhausted()) {
                        this.hasMore = false;
                    }
                }
                catch (IOException e) {
                    this.hasMore = false;
                }
                return this.hasMore;
            }

            @Override
            public byte[] next() {
                try {
                    this.source.read(this.buffer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.buffer;
            }
        };
    }

    public Iterator<String> iterText(final int chunkSize) throws IOException {
        if (this.response.body() == null) {
            throw new IOException("ResponseBody is null");
        }
        return new Iterator<String>(){
            final BufferedSource source;
            final byte[] buffer;
            boolean hasMore;
            {
                this.source = ((ResponseBody)HttpxBinaryResponseContent.this.response.body()).source();
                this.buffer = new byte[chunkSize];
                this.hasMore = true;
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.source.exhausted()) {
                        this.hasMore = false;
                    }
                }
                catch (IOException e) {
                    this.hasMore = false;
                }
                return this.hasMore;
            }

            @Override
            public String next() {
                try {
                    int bytesRead = this.source.read(this.buffer);
                    return new String(this.buffer, 0, bytesRead);
                }
                catch (IOException iOException) {
                    return "";
                }
            }
        };
    }

    public void writeToFile(String file) throws IOException {
        if (this.response.body() == null) {
            throw new IOException("ResponseBody is null");
        }
        try (BufferedSource source = ((ResponseBody)this.response.body()).source();
             FileOutputStream fos = new FileOutputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = source.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
        }
    }

    public void streamToFile(String file, int chunkSize) throws IOException {
        if (this.response.body() == null) {
            throw new IOException("ResponseBody is null");
        }
        try (BufferedSource source = ((ResponseBody)this.response.body()).source();
             FileOutputStream fos = new FileOutputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[chunkSize];
            while ((bytesRead = source.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.response.body() != null) {
            ((ResponseBody)this.response.body()).close();
        }
    }
}

