/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.zhipu.oapi.ClientV4;
import com.zhipu.oapi.service.v4.api.ClientBaseService;
import com.zhipu.oapi.service.v4.api.GenerationChain;
import com.zhipu.oapi.service.v4.api.assistant.AssistantApi;
import com.zhipu.oapi.service.v4.assistant.AssistantApiResponse;
import com.zhipu.oapi.service.v4.assistant.AssistantCompletion;
import com.zhipu.oapi.service.v4.assistant.AssistantParameters;
import com.zhipu.oapi.service.v4.assistant.conversation.ConversationParameters;
import com.zhipu.oapi.service.v4.assistant.conversation.ConversationUsageListResponse;
import com.zhipu.oapi.service.v4.assistant.conversation.ConversationUsageListStatus;
import com.zhipu.oapi.service.v4.assistant.query_support.AssistantSupportResponse;
import com.zhipu.oapi.service.v4.assistant.query_support.AssistantSupportStatus;
import com.zhipu.oapi.service.v4.assistant.query_support.QuerySupportParams;
import com.zhipu.oapi.utils.FlowableRequestSupplier;
import com.zhipu.oapi.utils.RequestSupplier;
import io.reactivex.Single;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;

public class AssistantClientService
extends ClientBaseService {
    private final AssistantApi assistantApi;

    public AssistantClientService(OkHttpClient client, String baseUrl) {
        super(client, baseUrl);
        this.assistantApi = (AssistantApi)this.retrofit.create(AssistantApi.class);
    }

    public AssistantGenerationChain assistantCompletionStream(AssistantParameters request) {
        Call<ResponseBody> responseBodyCall = this.assistantApi.assistantCompletionStream((Map<String, Object>)request.getOptions());
        return new AssistantGenerationChain(request, responseBodyCall);
    }

    public AssistantSupportChain querySupport(QuerySupportParams request) {
        Single<AssistantSupportStatus> assistantSupportStatusSingle = this.assistantApi.querySupport(request.getOptions());
        return new AssistantSupportChain(request, assistantSupportStatusSingle);
    }

    public ConversationChain queryConversationUsage(ConversationParameters request) {
        Single<ConversationUsageListStatus> statusSingle = this.assistantApi.queryConversationUsage(request.getOptions());
        return new ConversationChain(request, statusSingle);
    }

    public static class ConversationChain
    extends GenerationChain<ConversationUsageListStatus, ConversationUsageListResponse> {
        private final ConversationParameters params;
        private final Single<ConversationUsageListStatus> objectSingle;

        public ConversationChain(ConversationParameters params, Single<ConversationUsageListStatus> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public ConversationUsageListResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, ConversationUsageListResponse.class);
        }
    }

    public static class AssistantSupportChain
    extends GenerationChain<AssistantSupportStatus, AssistantSupportResponse> {
        private final QuerySupportParams params;
        private final Single<AssistantSupportStatus> objectSingle;

        public AssistantSupportChain(QuerySupportParams params, Single<AssistantSupportStatus> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public AssistantSupportResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, AssistantSupportResponse.class);
        }
    }

    public static class AssistantGenerationChain
    extends GenerationChain<AssistantCompletion, AssistantApiResponse> {
        private final AssistantParameters params;
        private final Call<ResponseBody> responseBodyCall;

        public AssistantGenerationChain(AssistantParameters params, Call<ResponseBody> responseBodyCall) {
            this.params = params;
            this.responseBodyCall = responseBodyCall;
        }

        @Override
        public AssistantApiResponse apply(ClientV4 clientV4) {
            FlowableRequestSupplier<Map, Call> supplier = params -> this.responseBodyCall;
            return clientV4.streamRequest(this.params, supplier, AssistantApiResponse.class, AssistantCompletion.class);
        }
    }
}

