/*
 * Decompiled with CFR 0.152.
 */
package cn.bywei.swaggerlazydoc.core;

import cn.bywei.swaggerlazydoc.core.util.MD5Utils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
public class SwaggerLazydoc {
    @Value(value="${swagger.lazydoc.enable:true}")
    boolean enable;
    @Value(value="${swagger.lazydoc.basePackage:null}")
    String basePackage;
    @Value(value="${swagger.lazydoc.title:API\u67e5\u770b\u5668}")
    String title;
    @Value(value="${swagger.lazydoc.description:API\u670d\u52a1\u7684\u8bf4\u660e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bf4\u660e\u670d\u52a1\u7684\u4f5c\u7528}")
    String description;
    @Value(value="${swagger.lazydoc.termsOfServiceUrl:http://localhost/}")
    String termsOfServiceUrl;
    @Value(value="${swagger.lazydoc.contact.name:swagger-lazydoc}")
    String contactName;
    @Value(value="${swagger.lazydoc.contact.url:www.bywei.cn}")
    String contactUrl;
    @Value(value="${swagger.lazydoc.contact.mail:master@bywei.cn}")
    String contactMail;
    @Value(value="${swagger.lazydoc.version:2.0.0}")
    String version;
    @Value(value="${swagger.lazydoc.auth:false}")
    String auth;
    @Value(value="${swagger.lazydoc.username:null}")
    String username;
    @Value(value="${swagger.lazydoc.password:null}")
    String password;
    @Value(value="${swagger.lazydoc.cloudUrl:http://www.bywei.cn/}")
    String cloudUrl;

    @Bean
    public Docket allApi() {
        if (!this.enable) {
            return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.none()).paths(PathSelectors.none()).build().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
        }
        ApiSelectorBuilder builder = new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).apiInfo(this.apiInfo()).select();
        if (this.isNotBlank(this.basePackage)) {
            builder.apis(RequestHandlerSelectors.basePackage((String)this.basePackage));
        } else {
            builder.apis(RequestHandlerSelectors.withClassAnnotation(RestController.class));
        }
        builder.paths(PathSelectors.any());
        return builder.build().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    @Bean
    public CorsFilter apiCrosFilter() {
        if (!this.enable) {
            return new CorsFilter((CorsConfigurationSource)new UrlBasedCorsConfigurationSource());
        }
        UrlBasedCorsConfigurationSource urlBasedCorsConfigurationSource = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.addAllowedOrigin("*");
        urlBasedCorsConfigurationSource.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)urlBasedCorsConfigurationSource);
    }

    private List<ApiKey> securitySchemes() {
        ArrayList<ApiKey> apiKeyList = new ArrayList<ApiKey>();
        apiKeyList.add(new ApiKey("auth", this.auth, "header"));
        this.username = this.isBlank(this.username) ? null : this.username;
        apiKeyList.add(new ApiKey("username", this.username, "header"));
        this.password = this.isBlank(this.password) ? null : MD5Utils.encode(this.password);
        apiKeyList.add(new ApiKey("password", this.password, "header"));
        apiKeyList.add(new ApiKey("cloudUrl", this.cloudUrl, "header"));
        return apiKeyList;
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
        securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build());
        return securityContexts;
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(new SecurityReference("Authorization", authorizationScopes));
        return securityReferences;
    }

    private ApiInfo apiInfo() {
        ApiInfo apiInfo = new ApiInfoBuilder().title(this.title).description(this.description).termsOfServiceUrl(this.termsOfServiceUrl).contact(new Contact(this.contactName, this.contactUrl, this.contactMail)).version(this.version).build();
        return apiInfo;
    }

    private boolean isNotBlank(String value) {
        return !this.isBlank(value);
    }

    private boolean isBlank(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        return value.equalsIgnoreCase("null") || value.trim().length() == 0;
    }
}

