/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.edi.console.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClients {
    private static Logger log = LoggerFactory.getLogger(HttpClients.class);
    public static final String PROTOCOL_HTTPS = "https";
    public static final String PROTOCOL_HTTP = "http";
    public static final String BOUNDARY = Long.toHexString(System.currentTimeMillis());
    public static final String CRLF = "\r\n";

    public static HttpRequest create(String url) {
        return new HttpRequest(url);
    }

    static RuntimeException unchecked(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    static <K, V> Map<K, V> newMap(Object ... args) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("The number of arguments must be an even number");
            }
            for (int i = 0; i < args.length; i += 2) {
                map.put(args[i], args[i + 1]);
            }
        }
        return map;
    }

    static <T> List<T> newList(T ... args) {
        int length = args == null ? 1 : args.length;
        ArrayList<T> list = new ArrayList<T>(length);
        if (args == null) {
            list.add(null);
        } else {
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i]);
            }
        }
        return list;
    }

    public static class HttpResponse {
        public static final String HEADER_SET_COOKIE = "Set-Cookie";
        private String url;
        private HttpMethod method;
        private int responseCode;
        private String responseMessage;
        private Map<String, List<String>> headerMap;
        private List<HttpCookie> cookies;
        private byte[] content;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpResponse(HttpURLConnection hc) {
            try {
                this.headerMap = Collections.unmodifiableMap(hc.getHeaderFields());
                String cookieHeader = hc.getHeaderField(HEADER_SET_COOKIE);
                this.cookies = cookieHeader != null ? Collections.unmodifiableList(HttpCookie.parse(cookieHeader)) : HttpClients.newList(new Object[0]);
                this.responseCode = hc.getResponseCode();
                this.responseMessage = hc.getResponseMessage();
                InputStream is = this.responseCode >= 400 ? hc.getErrorStream() : hc.getInputStream();
                try {
                    if (is != null) {
                        this.content = IOUtils.toByteArray((InputStream)is);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            catch (Exception e) {
                throw HttpClients.unchecked(e);
            }
        }

        public String getUrl() {
            return this.url;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public Map<String, List<String>> getHeaderMap() {
            return this.headerMap;
        }

        public List<HttpCookie> getCookies() {
            return this.cookies;
        }

        public Map<String, HttpCookie> getCookieMap() {
            Map<String, HttpCookie> cookieMap = HttpClients.newMap(new Object[0]);
            for (HttpCookie cookie : this.getCookies()) {
                cookieMap.put(cookie.getName(), cookie);
            }
            return cookieMap;
        }

        public byte[] getContent() {
            if (this.content == null) {
                return new byte[0];
            }
            return this.content;
        }

        public InputStream getContentAsInputStream() {
            return new ByteArrayInputStream(this.getContent());
        }

        public String getContentAsString() {
            return new String(this.getContent());
        }

        public String getContentAsString(String encoding) throws UnsupportedEncodingException {
            return new String(this.getContent(), encoding);
        }

        public String toString() {
            return "HttpResponse [url=" + this.url + ", method=" + (Object)((Object)this.method) + ", responseCode=" + this.responseCode + ", responseMessage=" + this.responseMessage + ", headerMap=" + this.headerMap + ", cookies=" + this.cookies + ", content=bytes[length=" + this.content.length + "]]";
        }
    }

    public static class HttpRequest {
        public static final String HEADER_AUTHORIZATION = "Authorization";
        public static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
        public static final String HEADER_ACCEPT = "Accept";
        public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
        public static final String HEADER_ACCEPT_LANGUAGE = "Accept-age";
        public static final String HEADER_CONTENT_TYPE = "Content-Type";
        public static final String HEADER_CACHE_CONTROL = "Cache-Control";
        public static final String HEADER_CONNECTION = "Connection";
        public static final String HEADER_COOKIE = "Cookie";
        public static final String HEADER_USER_AGENT = "User-Agent";
        public static final String HEADER_HOST = "Host";
        private String url;
        private String proxyHostname;
        private int proxyPort;
        private Proxy.Type proxyType;
        private String proxyUsername;
        private String proxyPassword;
        private String proxyBasicAuthorizationEncoding = "UTF-8";
        private String encoding = "UTF-8";
        private int connectTimeout = 60000;
        private int readTimeout = 120000;
        private String username;
        private String password;
        private String basicAuthorizationEncoding = "UTF-8";
        private InputStream certStream;
        private String certPassword;
        private byte[] content;
        private Map<String, List<String>> parameterMap = HttpClients.newMap(new Object[0]);
        private List<HttpRequestUpload> uploads = HttpClients.newList(new Object[0]);
        private Map<String, String> headerPropertyMap = HttpClients.newMap(new Object[0]);
        private List<HttpCookie> cookies = HttpClients.newList(new Object[0]);

        private HttpRequest(String url) {
            this.url = url;
        }

        public HttpRequest setProxyHostname(String proxyHostname) {
            this.proxyHostname = proxyHostname == null ? null : proxyHostname.trim();
            return this;
        }

        public HttpRequest setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public HttpRequest setProxyType(Proxy.Type proxyType) {
            this.proxyType = proxyType;
            return this;
        }

        public HttpRequest setProxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername == null ? null : proxyUsername.trim();
            return this;
        }

        public HttpRequest setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public HttpRequest setProxyBasicAuthorizationEncoding(String proxyBasicAuthorizationEncoding) {
            this.proxyBasicAuthorizationEncoding = proxyBasicAuthorizationEncoding;
            return this;
        }

        public HttpRequest setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public HttpRequest setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public HttpRequest setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public HttpRequest setUsername(String username) {
            this.username = username;
            return this;
        }

        public HttpRequest setPassword(String password) {
            this.password = password;
            return this;
        }

        public HttpRequest setBasicAuthorizationEncoding(String basicAuthorizationEncoding) {
            this.basicAuthorizationEncoding = basicAuthorizationEncoding;
            return this;
        }

        public HttpRequest setCertStream(InputStream certStream) {
            this.certStream = certStream;
            return this;
        }

        public HttpRequest setCertPassword(String certPassword) {
            this.certPassword = certPassword;
            return this;
        }

        public HttpRequest setHeaderContentType(String headerContentType) {
            return this.setHeader(HEADER_CONTENT_TYPE, headerContentType);
        }

        public HttpRequest setHeaderAccept(String headerAccept) {
            return this.setHeader(HEADER_ACCEPT, headerAccept);
        }

        public HttpRequest setHeaderAcceptEncoding(String headerAcceptEncoding) {
            return this.setHeader(HEADER_ACCEPT_ENCODING, headerAcceptEncoding);
        }

        public HttpRequest setHeaderAcceptage(String headerAcceptage) {
            return this.setHeader(HEADER_ACCEPT_LANGUAGE, headerAcceptage);
        }

        public HttpRequest setHeaderCacheControl(String headerCacheControl) {
            return this.setHeader(HEADER_CACHE_CONTROL, headerCacheControl);
        }

        public HttpRequest setHeaderConnection(String headerConnection) {
            return this.setHeader(HEADER_CONNECTION, headerConnection);
        }

        public HttpRequest setHeaderUserAgent(String headerUserAgent) {
            return this.setHeader(HEADER_USER_AGENT, headerUserAgent);
        }

        public HttpRequest setHeaderHost(String headerHost) {
            return this.setHeader(HEADER_HOST, headerHost);
        }

        public HttpRequest setHeader(String name, String value) {
            if (HEADER_COOKIE.equalsIgnoreCase(name)) {
                throw new UnsupportedOperationException("Use addCookies method set cookie");
            }
            if (HEADER_AUTHORIZATION.equalsIgnoreCase(name)) {
                throw new UnsupportedOperationException("Use setUsername and setPassword method for Basic Authorization");
            }
            this.headerPropertyMap.put(name, value);
            return this;
        }

        public HttpRequest setContent(byte[] content) {
            this.content = content;
            return this;
        }

        public HttpRequest setContent(InputStream content) throws IOException {
            return this.setContent(IOUtils.toByteArray((InputStream)content));
        }

        public HttpRequest setContent(String content) {
            return this.setContent(content.getBytes());
        }

        public HttpRequest setContent(String content, String encoding) throws UnsupportedEncodingException {
            return this.setContent(content.getBytes(encoding));
        }

        public HttpRequest addParameters(String name, String ... values) {
            if (name != null && values != null) {
                List<String> valueList = this.parameterMap.get(name = name.trim());
                if (valueList == null) {
                    valueList = HttpClients.newList(values);
                    this.parameterMap.put(name, valueList);
                } else {
                    valueList.addAll(HttpClients.newList(values));
                }
            }
            return this;
        }

        public HttpRequest addUploads(String name, String filename, byte[] data) {
            try {
                File file = new File(System.getProperty("java.io.tmpdir").concat("/lang/Https/uploads"), filename);
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                this.addUploads(name, file);
            }
            catch (IOException e) {
                throw HttpClients.unchecked(e);
            }
            return this;
        }

        public HttpRequest addUploads(String name, File file) throws IOException {
            HttpRequestUpload upload = new HttpRequestUpload();
            upload.name = name;
            upload.file = file;
            this.uploads.add(upload);
            return this;
        }

        public HttpRequest addCookies(HttpCookie ... cookies) {
            if (cookies != null) {
                for (HttpCookie cookie : cookies) {
                    if (cookie == null) continue;
                    this.cookies.add(cookie);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpResponse request(HttpMethod method) {
            method = method == null ? HttpMethod.GET : method;
            StringBuilder address = new StringBuilder(this.url.trim());
            if (!HttpMethod.POST.equals((Object)method) || this.content != null) {
                this.handleGet(address);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("The address is:%s", address));
            }
            URL url = new URL(address.toString());
            HttpURLConnection hc = this.proxyPort != 0 ? this.handleProxy(url) : (HttpURLConnection)url.openConnection();
            this.handleConfig(method, hc);
            this.handleHeaders(method, hc);
            if (this.cookies != null) {
                this.handleCookies(url);
            }
            if (this.username != null && this.username.length() != 0) {
                this.handleBasic(hc);
            }
            if (this.certStream != null) {
                this.handleSSL(url, hc);
            }
            try {
                if (HttpMethod.POST.equals((Object)method)) {
                    this.handlePost(hc);
                }
                hc.connect();
                HttpResponse httpResponse = this.handleResponse(method, hc);
                hc.disconnect();
                return httpResponse;
            }
            catch (Throwable throwable) {
                try {
                    hc.disconnect();
                    throw throwable;
                }
                catch (Exception e) {
                    throw HttpClients.unchecked(e);
                }
            }
        }

        private HttpResponse handleResponse(HttpMethod method, HttpURLConnection hc) {
            HttpResponse response = new HttpResponse(hc);
            response.url = this.url;
            response.method = method;
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handlePost(HttpURLConnection hc) throws IOException, UnsupportedEncodingException {
            OutputStream os = hc.getOutputStream();
            try {
                if (!this.uploads.isEmpty()) {
                    this.handleUploads(os);
                } else if (this.content != null) {
                    os.write(this.content);
                } else {
                    int parameterCount = 0;
                    for (String name : this.parameterMap.keySet()) {
                        List<String> values = this.parameterMap.get(name);
                        for (String value : values) {
                            if (parameterCount > 0) {
                                IOUtils.write((String)"&", (OutputStream)os);
                            }
                            ++parameterCount;
                            IOUtils.write((String)URLEncoder.encode(name, this.encoding), (OutputStream)os);
                            IOUtils.write((String)"=", (OutputStream)os);
                            IOUtils.write((String)URLEncoder.encode(value, this.encoding), (OutputStream)os);
                        }
                    }
                }
            }
            finally {
                os.close();
            }
        }

        private void handleConfig(HttpMethod method, HttpURLConnection hc) throws ProtocolException {
            hc.setConnectTimeout(this.connectTimeout);
            hc.setReadTimeout(this.readTimeout);
            hc.setRequestMethod(method.name());
            hc.setDoOutput(true);
            hc.setDoInput(true);
            hc.setUseCaches(false);
        }

        private void handleGet(StringBuilder address) throws UnsupportedEncodingException {
            int parameterCount = 0;
            int questionMarkIndex = address.lastIndexOf("?");
            for (String name : this.parameterMap.keySet()) {
                List<String> values = this.parameterMap.get(name);
                for (String value : values) {
                    if (parameterCount > 0) {
                        address.append('&');
                    } else if (questionMarkIndex != -1) {
                        if (address.lastIndexOf("&") != address.length() - 1) {
                            address.append('&');
                        }
                    } else if (questionMarkIndex != address.length() - 1) {
                        address.append('?');
                    }
                    ++parameterCount;
                    address.append(URLEncoder.encode(name, this.encoding));
                    address.append('=');
                    address.append(URLEncoder.encode(value, this.encoding));
                }
            }
        }

        private HttpURLConnection handleProxy(URL url) throws IOException, UnsupportedEncodingException {
            Proxy.Type proxyType = this.proxyType == null ? Proxy.Type.HTTP : this.proxyType;
            Proxy proxy = this.proxyHostname != null ? new Proxy(proxyType, new InetSocketAddress(this.proxyHostname, this.proxyPort)) : new Proxy(proxyType, new InetSocketAddress(this.proxyPort));
            if (log.isDebugEnabled()) {
                log.debug(String.format("The connection by proxy::%s", proxy));
            }
            HttpURLConnection hc = (HttpURLConnection)url.openConnection(proxy);
            if (this.proxyUsername != null && this.proxyUsername.length() != 0) {
                this.handleProxyBasic(hc);
            }
            return hc;
        }

        private void handleProxyBasic(HttpURLConnection hc) throws UnsupportedEncodingException {
            this.proxyPassword = this.proxyPassword == null ? "" : this.proxyPassword;
            byte[] token = (this.proxyUsername + ':' + this.proxyPassword).getBytes(this.proxyBasicAuthorizationEncoding);
            String authorization = "Basic ".concat(new String(Base64.encodeBase64((byte[])token), this.proxyBasicAuthorizationEncoding));
            hc.setRequestProperty(HEADER_PROXY_AUTHORIZATION, authorization);
        }

        private void handleHeaders(HttpMethod method, HttpURLConnection hc) {
            if (method.equals((Object)HttpMethod.POST)) {
                if (this.uploads.isEmpty() && !this.headerPropertyMap.containsKey(HEADER_CONTENT_TYPE)) {
                    if (this.encoding != null) {
                        this.headerPropertyMap.put(HEADER_CONTENT_TYPE, "application/x-www-form-urlencoded;charset=".concat(this.encoding));
                    } else {
                        this.headerPropertyMap.put(HEADER_CONTENT_TYPE, "application/x-www-form-urlencoded");
                    }
                } else {
                    this.headerPropertyMap.put(HEADER_CONTENT_TYPE, "multipart/form-data; boundary=".concat(BOUNDARY));
                }
            }
            for (String name : this.headerPropertyMap.keySet()) {
                hc.setRequestProperty(name, this.headerPropertyMap.get(name));
            }
        }

        private void handleCookies(URL url) throws UnsupportedEncodingException {
            StringBuilder cookieBuilder = new StringBuilder();
            for (HttpCookie cookie : this.cookies) {
                if (cookie.getName() == null || cookie.getValue() == null || cookie.getSecure() && !url.getProtocol().equals(HttpClients.PROTOCOL_HTTPS) || cookie.hasExpired() || cookie.getPath() != null && !cookie.getPath().equals("/") && !url.getPath().regionMatches(0, cookie.getPath(), 0, cookie.getPath().length())) continue;
                if (cookieBuilder.length() != 0) {
                    cookieBuilder.append(";");
                }
                cookieBuilder.append(URLEncoder.encode(cookie.getName(), this.encoding));
                cookieBuilder.append("=");
                cookieBuilder.append(URLEncoder.encode(cookie.getValue(), this.encoding));
            }
        }

        private void handleBasic(HttpURLConnection hc) throws UnsupportedEncodingException {
            this.password = this.password == null ? "" : this.password;
            byte[] token = (this.username + ':' + this.password).getBytes(this.basicAuthorizationEncoding);
            String authorization = "Basic ".concat(new String(Base64.encodeBase64((byte[])token), this.basicAuthorizationEncoding));
            hc.setRequestProperty(HEADER_AUTHORIZATION, authorization);
        }

        private void handleSSL(URL url, HttpURLConnection hc) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
            if (!url.getProtocol().equals(HttpClients.PROTOCOL_HTTPS)) {
                throw new IllegalStateException(String.format("You can not add a certificate of non-SSL connection:%s", url));
            }
            this.certPassword = this.certPassword == null ? "" : this.certPassword;
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(this.certStream, this.certPassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, this.certPassword.toCharArray());
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(kmf.getKeyManagers(), tm, null);
            SSLSocketFactory factory = sslContext.getSocketFactory();
            ((HttpsURLConnection)hc).setSSLSocketFactory(factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleUploads(OutputStream os) throws IOException {
            Charset charset = this.encoding == null ? Charset.forName("UTF-8") : Charset.forName(this.encoding);
            StringBuilder writer = new StringBuilder();
            for (String name : this.parameterMap.keySet()) {
                List<String> values = this.parameterMap.get(name);
                for (String value : values) {
                    writer.append("--").append(BOUNDARY).append(HttpClients.CRLF).append("Content-Disposition: form-data; name=\"").append(name.replace("\"", "%22")).append("\"").append(HttpClients.CRLF).append(HttpClients.CRLF).append(value).append(HttpClients.CRLF);
                }
            }
            os.write(writer.toString().getBytes(charset));
            for (HttpRequestUpload upload : this.uploads) {
                String contentType;
                FileInputStream is = new FileInputStream(upload.file);
                try {
                    contentType = URLConnection.guessContentTypeFromStream(is);
                    if (contentType == null) {
                        contentType = URLConnection.guessContentTypeFromName(upload.file.getName());
                    }
                    contentType = contentType != null ? contentType.concat(";charset=").concat(charset.name()) : "application/octet-stream;charset=".concat(charset.name());
                }
                finally {
                    ((InputStream)is).close();
                }
                is = new FileInputStream(upload.file);
                try {
                    String header = "--" + BOUNDARY + HttpClients.CRLF + "Content-Disposition: form-data; name=\"" + upload.name.replace("\"", "%22") + "\"; filename=\"" + upload.file.getName().replace("\"", "%22") + "\"" + HttpClients.CRLF + "Content-Type: " + contentType + HttpClients.CRLF + "Content-Transfer-Encoding: binary" + HttpClients.CRLF + HttpClients.CRLF;
                    os.write(header.getBytes(charset));
                    IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                    os.write(HttpClients.CRLF.getBytes(charset));
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            os.write(("--" + BOUNDARY + "--" + HttpClients.CRLF).getBytes(charset));
        }

        public HttpResponse get() {
            return this.request(HttpMethod.GET);
        }

        public HttpResponse post() {
            return this.request(HttpMethod.POST);
        }

        public HttpResponse put() {
            return this.request(HttpMethod.PUT);
        }

        public HttpResponse delete() {
            return this.request(HttpMethod.DELETE);
        }
    }

    static class HttpRequestUpload {
        String name;
        File file;

        HttpRequestUpload() {
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        PATCH,
        DELETE,
        TRACE;

    }
}

