/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.edi.console.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderSupport;

public class SpringPropertyUtils {
    private static Map<String, Properties> map = new HashMap<String, Properties>();

    public static synchronized Properties getEnvProperties(String env) {
        if (map.get(env) != null) {
            return map.get(env);
        }
        ClassPathXmlApplicationContext applicationContext = null;
        AbstractApplicationContext abstractContext = null;
        Properties properties = new Properties();
        String oldEnv = System.getProperty("spring.profiles.default");
        try {
            String[] postProcessorNames;
            System.setProperty("spring.profiles.default", env);
            applicationContext = new ClassPathXmlApplicationContext("applicationContext-properties.xml");
            abstractContext = (AbstractApplicationContext)applicationContext;
            for (String ppName : postProcessorNames = abstractContext.getBeanNamesForType(BeanFactoryPostProcessor.class, true, true)) {
                BeanFactoryPostProcessor beanProcessor = (BeanFactoryPostProcessor)abstractContext.getBean(ppName, BeanFactoryPostProcessor.class);
                if (!(beanProcessor instanceof PropertyResourceConfigurer)) continue;
                PropertyResourceConfigurer propertyResourceConfigurer = (PropertyResourceConfigurer)beanProcessor;
                Method mergeProperties = PropertiesLoaderSupport.class.getDeclaredMethod("mergeProperties", new Class[0]);
                mergeProperties.setAccessible(true);
                Properties props = (Properties)mergeProperties.invoke((Object)propertyResourceConfigurer, new Object[0]);
                Method convertProperties = PropertyResourceConfigurer.class.getDeclaredMethod("convertProperties", Properties.class);
                convertProperties.setAccessible(true);
                convertProperties.invoke((Object)propertyResourceConfigurer, props);
                properties.putAll((Map<?, ?>)props);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (oldEnv == null) {
                System.getProperties().remove("spring.profiles.default");
            } else {
                System.setProperty("spring.profiles.default", oldEnv);
            }
        }
        map.put(env, properties);
        return properties;
    }
}

