/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.edi.console.utils.dbutils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbUtilsTemplate {
    private DataSource dataSource;
    private static final Log LOG = LogFactory.getLog(DbUtilsTemplate.class);

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int update(String sql) {
        return this.update(sql, null);
    }

    public int update(String sql, Object param) {
        return this.update(sql, new Object[]{param});
    }

    public int update(String sql, Object[] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        int affectedRows = 0;
        try {
            affectedRows = params == null ? queryRunner.update(sql) : queryRunner.update(sql, params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to update data", (Throwable)e);
        }
        return affectedRows;
    }

    public int[] batchUpdate(String sql, Object[][] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        int[] affectedRows = new int[]{};
        try {
            affectedRows = queryRunner.batch(sql, params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to batch update data", (Throwable)e);
        }
        return affectedRows;
    }

    public List<Map<String, Object>> find(String sql) {
        return this.find(sql, null);
    }

    public List<Map<String, Object>> find(String sql, Object param) {
        return this.find(sql, new Object[]{param});
    }

    public List<Map<String, Object>> find(String sql, Object[] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            list = params == null ? (List)queryRunner.query(sql, (ResultSetHandler)new MapListHandler()) : (List)queryRunner.query(sql, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to query data", (Throwable)e);
        }
        return list;
    }

    public <T> List<T> find(Class<T> entityClass, String sql) {
        return this.find(entityClass, sql, null);
    }

    public <T> List<T> find(Class<T> entityClass, String sql, Object param) {
        return this.find(entityClass, sql, new Object[]{param});
    }

    public <T> List<T> find(Class<T> entityClass, String sql, Object[] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        List list = new ArrayList();
        try {
            list = params == null ? (List)queryRunner.query(sql, (ResultSetHandler)new BeanListHandler(entityClass)) : (List)queryRunner.query(sql, (ResultSetHandler)new BeanListHandler(entityClass), params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to query data", (Throwable)e);
        }
        return list;
    }

    public <T> T findFirst(Class<T> entityClass, String sql) {
        return this.findFirst(entityClass, sql, null);
    }

    public <T> T findFirst(Class<T> entityClass, String sql, Object param) {
        return this.findFirst(entityClass, sql, new Object[]{param});
    }

    public <T> T findFirst(Class<T> entityClass, String sql, Object[] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        Object object = null;
        try {
            object = params == null ? queryRunner.query(sql, (ResultSetHandler)new BeanHandler(entityClass)) : queryRunner.query(sql, (ResultSetHandler)new BeanHandler(entityClass), params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to query data", (Throwable)e);
        }
        return (T)object;
    }

    public Map<String, Object> findFirst(String sql) {
        return this.findFirst(sql, null);
    }

    public Map<String, Object> findFirst(String sql, Object param) {
        return this.findFirst(sql, new Object[]{param});
    }

    public Map<String, Object> findFirst(String sql, Object[] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        Map map = null;
        try {
            map = params == null ? (Map)queryRunner.query(sql, (ResultSetHandler)new MapHandler()) : (Map)queryRunner.query(sql, (ResultSetHandler)new MapHandler(), params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to query data", (Throwable)e);
        }
        return map;
    }

    public Object findBy(String sql, String columnName) {
        return this.findBy(sql, columnName, null);
    }

    public Object findBy(String sql, String columnName, Object param) {
        return this.findBy(sql, columnName, new Object[]{param});
    }

    public Object findBy(String sql, String columnName, Object[] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        Object object = null;
        try {
            object = params == null ? queryRunner.query(sql, (ResultSetHandler)new ScalarHandler(columnName)) : queryRunner.query(sql, (ResultSetHandler)new ScalarHandler(columnName), params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to query data", (Throwable)e);
        }
        return object;
    }

    public Object findBy(String sql, int columnIndex) {
        return this.findBy(sql, columnIndex, null);
    }

    public Object findBy(String sql, int columnIndex, Object param) {
        return this.findBy(sql, columnIndex, new Object[]{param});
    }

    public Object findBy(String sql, int columnIndex, Object[] params) {
        QueryRunner queryRunner = new QueryRunner(this.dataSource);
        Object object = null;
        try {
            object = params == null ? queryRunner.query(sql, (ResultSetHandler)new ScalarHandler(columnIndex)) : queryRunner.query(sql, (ResultSetHandler)new ScalarHandler(columnIndex), params);
        }
        catch (SQLException e) {
            LOG.error((Object)"Error occured while attempting to query data", (Throwable)e);
        }
        return object;
    }
}

