/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.edi.console.utils.lang;

import cn.com.sinosoft.edi.console.utils.Lang;
import cn.com.sinosoft.edi.console.utils.lang.ClassFilter;
import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class Classes {
    private static final String PATH_DELIMITER_JAR = "!/";
    private static final String PATH_DELIMITER_CLASSES = "classes/";
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private static PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();

    private Classes() {
    }

    public static Set<Class> scanPackage(String basePackage, ClassFilter classFilter) {
        String packageSearchPath = "classpath*:" + basePackage.replace('.', '/') + "/" + DEFAULT_RESOURCE_PATTERN;
        try {
            Resource[] resources = pathMatchingResourcePatternResolver.getResources(packageSearchPath);
            LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
            for (Resource resource : resources) {
                String path = resource.getURL().getPath();
                int p = path.lastIndexOf(PATH_DELIMITER_CLASSES);
                if (p != -1) {
                    p += PATH_DELIMITER_CLASSES.length();
                } else {
                    p = path.lastIndexOf(PATH_DELIMITER_JAR);
                    if (p != -1) {
                        p += PATH_DELIMITER_JAR.length();
                    }
                }
                if (p == -1) continue;
                String name = path.substring(p, path.lastIndexOf(".")).replace('/', '.');
                try {
                    Class<Object> type = Class.forName(name, false, Classes.class.getClassLoader());
                    if (type == null || !classFilter.accept(type)) continue;
                    classes.add(type);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return classes;
        }
        catch (Exception e) {
            throw Lang.unchecked(e, "scan package path %s fail ", basePackage);
        }
    }

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (Byte.TYPE.getName().equals(className)) {
                return Byte.TYPE;
            }
            if (Short.TYPE.getName().equals(className)) {
                return Short.TYPE;
            }
            if (Integer.TYPE.getName().equals(className)) {
                return Integer.TYPE;
            }
            if (Long.TYPE.getName().equals(className)) {
                return Long.TYPE;
            }
            if (Float.TYPE.getName().equals(className)) {
                return Float.TYPE;
            }
            if (Double.TYPE.getName().equals(className)) {
                return Double.TYPE;
            }
            if (Boolean.TYPE.getName().equals(className)) {
                return Boolean.TYPE;
            }
            if (Character.TYPE.getName().equals(className)) {
                return Character.TYPE;
            }
            int p = className.lastIndexOf("[]");
            if (p != -1) {
                return Array.newInstance(Classes.forName(className.substring(0, p)), 0).getClass();
            }
            throw Lang.unchecked(e);
        }
    }
}

