/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.edi.console.utils.lang;

import cn.com.sinosoft.edi.console.utils.Lang;
import cn.com.sinosoft.edi.console.utils.lang.Mirrors;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class Compares {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private static final Logger log = LoggerFactory.getLogger(Compares.class);

    private Compares() {
    }

    public static Set<ValueMeta> compareProperty(String packagePattern, Object source, Object target) {
        return Compares.compareProperty(packagePattern, source, target, "$", new HashSet<Integer>());
    }

    private static Set<ValueMeta> compareProperty(String packagePattern, Object source, Object target, String prefixPath, Set<Integer> idHashs) {
        Set<Object> diffMetas = Lang.newSet(new Object[0]);
        if (source == null || target == null) {
            if (source == null && target == null) {
                return diffMetas;
            }
            ValueMeta propertyValueDiffMeta = new ValueMeta();
            propertyValueDiffMeta.path = prefixPath;
            propertyValueDiffMeta.sourceValue = source;
            propertyValueDiffMeta.targetValue = target;
            diffMetas.add(propertyValueDiffMeta);
            return diffMetas;
        }
        if (Lang.isBaseType(source.getClass()) || Lang.isBaseType(target.getClass())) {
            if (!Lang.equals(source, target)) {
                ValueMeta propertyValueDiffMeta = new ValueMeta();
                propertyValueDiffMeta.path = prefixPath;
                propertyValueDiffMeta.sourceValue = source;
                propertyValueDiffMeta.targetValue = target;
                diffMetas.add(propertyValueDiffMeta);
            }
            return diffMetas;
        }
        if (idHashs.contains(System.identityHashCode(source)) || idHashs.contains(System.identityHashCode(target))) {
            return diffMetas;
        }
        idHashs.add(System.identityHashCode(source));
        idHashs.add(System.identityHashCode(target));
        Class<?> type = null;
        if (source.getClass().isAssignableFrom(target.getClass())) {
            type = source.getClass();
        } else if (target.getClass().isAssignableFrom(source.getClass())) {
            type = target.getClass();
        }
        if (type == null) {
            ValueMeta propertyValueDiffMeta = new ValueMeta();
            propertyValueDiffMeta.path = prefixPath;
            propertyValueDiffMeta.sourceValue = source;
            propertyValueDiffMeta.targetValue = target;
            diffMetas.add(propertyValueDiffMeta);
            return diffMetas;
        }
        if (Collection.class.isAssignableFrom(type)) {
            source = ((Collection)source).toArray();
            target = ((Collection)target).toArray();
            type = source.getClass();
        }
        if (type.isArray()) {
            int length = Math.max(Array.getLength(source), Array.getLength(target));
            for (int i = 0; i < length; ++i) {
                String path = prefixPath.concat("[").concat(String.valueOf(i)).concat("]");
                Object sourceValue = Array.getLength(source) >= length ? Array.get(source, i) : null;
                Object targetValue = Array.getLength(target) >= length ? Array.get(target, i) : null;
                diffMetas.addAll(Compares.compareProperty(packagePattern, sourceValue, targetValue, path, idHashs));
            }
            return diffMetas;
        }
        if (Map.class.isAssignableFrom(type)) {
            ValueMeta propertyValueDiffMeta = new ValueMeta();
            propertyValueDiffMeta.path = prefixPath;
            propertyValueDiffMeta.sourceValue = source;
            propertyValueDiffMeta.targetValue = target;
            diffMetas.add(propertyValueDiffMeta);
            return diffMetas;
        }
        if (!ANT_PATH_MATCHER.match(packagePattern.replace('.', '/'), type.getPackage().getName().replace('.', '/'))) {
            return diffMetas;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Mirrors.getPropertys(type)) {
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null) continue;
                if (!readMethod.isAccessible()) {
                    readMethod.setAccessible(true);
                }
                String path = prefixPath.concat(".").concat(propertyDescriptor.getName());
                try {
                    Object sourceValue = readMethod.invoke((Object)source, new Object[0]);
                    Object targetValue = readMethod.invoke((Object)target, new Object[0]);
                    diffMetas.addAll(Compares.compareProperty(packagePattern, sourceValue, targetValue, path, idHashs));
                }
                catch (Throwable e) {
                    log.warn(String.format("\ufffd\u0531\u0236\ufffd\ufffd\ufffd\u00b7\ufffd\ufffd%s\u02b1\ufffd\ufffd\ufffd\ufffd\ufffd\ucce3", path), e);
                }
            }
            return diffMetas;
        }
        catch (Exception e) {
            throw Lang.unchecked(e);
        }
    }

    public static Set<ValueMeta> compareField(String packagePattern, Object source, Object target) {
        return Compares.compareField(packagePattern, source, target, "$", new HashSet<Integer>());
    }

    private static Set<ValueMeta> compareField(String packagePattern, Object source, Object target, String prefixPath, Set<Integer> idHashs) {
        Set<Object> diffMetas = Lang.newSet(new Object[0]);
        if (source == null || target == null) {
            if (source == null && target == null) {
                return diffMetas;
            }
            ValueMeta propertyValueDiffMeta = new ValueMeta();
            propertyValueDiffMeta.path = prefixPath;
            propertyValueDiffMeta.sourceValue = source;
            propertyValueDiffMeta.targetValue = target;
            diffMetas.add(propertyValueDiffMeta);
            return diffMetas;
        }
        if (Lang.isBaseType(source.getClass()) || Lang.isBaseType(target.getClass())) {
            if (!Lang.equals(source, target)) {
                ValueMeta propertyValueDiffMeta = new ValueMeta();
                propertyValueDiffMeta.path = prefixPath;
                propertyValueDiffMeta.sourceValue = source;
                propertyValueDiffMeta.targetValue = target;
                diffMetas.add(propertyValueDiffMeta);
            }
            return diffMetas;
        }
        if (idHashs.contains(System.identityHashCode(source)) || idHashs.contains(System.identityHashCode(target))) {
            return diffMetas;
        }
        idHashs.add(System.identityHashCode(source));
        idHashs.add(System.identityHashCode(target));
        Class<?> type = null;
        if (source.getClass().isAssignableFrom(target.getClass())) {
            type = source.getClass();
        } else if (target.getClass().isAssignableFrom(source.getClass())) {
            type = target.getClass();
        }
        if (type == null) {
            ValueMeta propertyValueDiffMeta = new ValueMeta();
            propertyValueDiffMeta.path = prefixPath;
            propertyValueDiffMeta.sourceValue = source;
            propertyValueDiffMeta.targetValue = target;
            diffMetas.add(propertyValueDiffMeta);
            return diffMetas;
        }
        if (Collection.class.isAssignableFrom(type)) {
            source = ((Collection)source).toArray();
            target = ((Collection)target).toArray();
            type = source.getClass();
        }
        if (type.isArray()) {
            int length = Math.max(Array.getLength(source), Array.getLength(target));
            for (int i = 0; i < length; ++i) {
                String path = prefixPath.concat("[").concat(String.valueOf(i)).concat("]");
                Object sourceValue = Array.getLength(source) >= length ? Array.get(source, i) : null;
                Object targetValue = Array.getLength(target) >= length ? Array.get(target, i) : null;
                diffMetas.addAll(Compares.compareField(packagePattern, sourceValue, targetValue, path, idHashs));
            }
            return diffMetas;
        }
        if (Map.class.isAssignableFrom(type)) {
            ValueMeta propertyValueDiffMeta = new ValueMeta();
            propertyValueDiffMeta.path = prefixPath;
            propertyValueDiffMeta.sourceValue = source;
            propertyValueDiffMeta.targetValue = target;
            diffMetas.add(propertyValueDiffMeta);
            return diffMetas;
        }
        if (!ANT_PATH_MATCHER.match(packagePattern.replace('.', '/'), type.getPackage().getName().replace('.', '/'))) {
            return diffMetas;
        }
        try {
            Field[] fields;
            for (Field field : fields = Mirrors.getFields(type)) {
                String path = prefixPath.concat(".").concat(field.getName());
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    Object sourceValue = field.get(source);
                    Object targetValue = field.get(target);
                    diffMetas.addAll(Compares.compareField(packagePattern, sourceValue, targetValue, path, idHashs));
                }
                catch (Throwable e) {
                    log.warn(String.format("\ufffd\u0531\u0236\ufffd\ufffd\ufffd\u00b7\ufffd\ufffd%s\u02b1\ufffd\ufffd\ufffd\ufffd\ufffd\ucce3", path), e);
                }
            }
            return diffMetas;
        }
        catch (Exception e) {
            throw Lang.unchecked(e);
        }
    }

    public static class ValueMeta {
        String path;
        Object sourceValue;
        Object targetValue;

        public String getPath() {
            return this.path;
        }

        public Object getSourceValue() {
            return this.sourceValue;
        }

        public Object getTargetValue() {
            return this.targetValue;
        }

        public String toString() {
            return "diff:path=" + this.path + ", sourceValue=" + this.sourceValue + ", targetValue=" + this.targetValue;
        }
    }
}

