/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.edi.console.utils.lang;

import cn.com.sinosoft.edi.console.utils.Lang;
import cn.com.sinosoft.edi.console.utils.lang.Mirrors;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Maps {
    private Maps() {
    }

    public static <K, V> Map<K, V> caseInsensitiveMap(final Map<K, V> source) {
        final LinkedHashMap<String, V> lowerCaseMap = new LinkedHashMap<String, V>();
        for (K key : source.keySet()) {
            if (key == null || !(key instanceof String)) continue;
            lowerCaseMap.put(Maps.toLowercase(key), source.get(key));
        }
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return source.entrySet();
            }

            @Override
            public boolean containsKey(Object key) {
                if (key != null && key instanceof String) {
                    return lowerCaseMap.containsKey(Maps.toLowercase(key));
                }
                return source.containsKey(key);
            }

            @Override
            public V get(Object key) {
                if (key != null && key instanceof String) {
                    return lowerCaseMap.get(Maps.toLowercase(key));
                }
                return source.get(key);
            }

            @Override
            public V put(K key, V value) {
                if (key != null && key instanceof String) {
                    String lowercaseKey = Maps.toLowercase(key);
                    source.put(key, value);
                    return lowerCaseMap.put(lowercaseKey, value);
                }
                return source.put(key, value);
            }
        };
    }

    private static String toLowercase(Object key) {
        return key.toString().toLowerCase();
    }

    public static Object toMap(Object obj) {
        return Maps.toMap(obj, new ConcurrentHashMap<Integer, Object>());
    }

    private static Object toMap(Object obj, Map<Integer, Object> hashMap) {
        if (obj == null) {
            return obj;
        }
        if (Lang.isBaseType(obj.getClass())) {
            return obj;
        }
        Integer hash = System.identityHashCode(obj);
        Object map = hashMap.get(hash);
        if (map != null) {
            return map;
        }
        if (obj instanceof List) {
            List<Object> newList = Lang.newList(new Object[0]);
            for (Object o : (List)obj) {
                newList.add(Maps.toMap(o, hashMap));
            }
            hashMap.put(hash, newList);
            return newList;
        }
        if (obj instanceof Set) {
            Set<Object> newSet = Lang.newSet(new Object[0]);
            for (Object o : (Set)obj) {
                newSet.add(Maps.toMap(o, hashMap));
            }
            hashMap.put(hash, newSet);
            return newSet;
        }
        if (obj instanceof Map) {
            Map<Object, Object> newMap = Lang.newMap(new Object[0]);
            for (Object key : ((Map)obj).keySet()) {
                newMap.put(Maps.toMap(key, hashMap), Maps.toMap(((Map)obj).get(key), hashMap));
            }
            hashMap.put(hash, newMap);
            return newMap;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            Map<String, Object> newMap = Lang.newMap(new Object[0]);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Mirrors.getPropertys(obj.getClass())) {
                Method readMethod;
                if ("class".equals(propertyDescriptor.getName()) || (readMethod = propertyDescriptor.getReadMethod()) == null) continue;
                Object value = readMethod.invoke(obj, new Object[0]);
                newMap.put(propertyDescriptor.getName(), Maps.toMap(value, hashMap));
            }
            hashMap.put(hash, newMap);
            return newMap;
        }
        catch (Exception e) {
            throw Lang.unchecked(e);
        }
    }
}

