/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.edi.console.utils.lang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class Numbers {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static final Map<Character, Integer> digitMap = new ConcurrentHashMap<Character, Integer>();
    public static final int MAX_RADIX;
    public static final int MIN_RADIX = 2;

    public static String toString(long i, int radix) {
        boolean negative;
        if (radix < 2 || radix > MAX_RADIX) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(i);
        }
        int size = 65;
        int charPos = 64;
        char[] buf = new char[65];
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            buf[charPos--] = digits[(int)(-(i % (long)radix))];
            i /= (long)radix;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    static NumberFormatException forInputString(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    public static long toLong(String s, int radix) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Numbers.MIN_RADIX");
        }
        if (radix > MAX_RADIX) {
            throw new NumberFormatException("radix " + radix + " greater than Numbers.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw Numbers.forInputString(s);
                }
                if (len == 1) {
                    throw Numbers.forInputString(s);
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                Integer digit;
                if ((digit = digitMap.get(Character.valueOf(s.charAt(i++)))) == null) {
                    throw Numbers.forInputString(s);
                }
                if (digit < 0) {
                    throw Numbers.forInputString(s);
                }
                if (result < multmin) {
                    throw Numbers.forInputString(s);
                }
                if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                    throw Numbers.forInputString(s);
                }
                result -= (long)digit.intValue();
            }
        } else {
            throw Numbers.forInputString(s);
        }
        return negative ? result : -result;
    }

    public static byte[] toByteArray(long n) {
        byte[] bs = new byte[8];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (i << 3));
        }
        return bs;
    }

    public static long toLong(byte[] bs) {
        Assert.isTrue((bs.length == 8 ? 1 : 0) != 0, (String)"The byte array's length must be 8");
        long n = 0L;
        for (int i = 0; i < bs.length; ++i) {
            n |= ((long)bs[i] & 0xFFL) << (i << 3);
        }
        return n;
    }

    public static byte[] toByteArray(int n) {
        byte[] bs = new byte[4];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (i << 3));
        }
        return bs;
    }

    public static int toInt(byte[] bs) {
        Assert.isTrue((bs.length == 4 ? 1 : 0) != 0, (String)"The byte array's length must be 4");
        int n = 0;
        for (int i = 0; i < bs.length; ++i) {
            n = (int)((long)n | ((long)bs[i] & 0xFFL) << (i << 3));
        }
        return n;
    }

    public static byte[] toByteArray(short n) {
        byte[] bs = new byte[2];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (i << 3));
        }
        return bs;
    }

    public static short toShort(byte[] bs) {
        Assert.isTrue((bs.length == 2 ? 1 : 0) != 0, (String)"The byte array's length must be 2");
        short n = 0;
        for (int i = 0; i < bs.length; ++i) {
            n = (short)((long)n | ((long)bs[i] & 0xFFL) << (i << 3));
        }
        return n;
    }

    static {
        for (int i = 0; i < digits.length; ++i) {
            digitMap.put(Character.valueOf(digits[i]), i);
        }
        MAX_RADIX = digits.length;
    }
}

