/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.sqlHelper.utils;

import cn.craccd.sqlHelper.utils.Condition;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ConditionWrapper {
    boolean andLink;
    List<Object> list = new ArrayList<Object>();

    public String build(List<Object> values) {
        String sql = "";
        if (this.list.size() > 0) {
            ArrayList<String> blocks = new ArrayList<String>();
            for (Object object : this.list) {
                String block;
                if (object instanceof Condition) {
                    Condition condition = (Condition)object;
                    block = null;
                    if (condition.getValue() == null) {
                        block = condition.getOperation().equals("IS NULL") || condition.getOperation().equals("IS NOT NULL") ? this.buildColumn(condition.getColumn(), String.class) + " " + condition.getOperation() : this.buildColumn(condition.getColumn(), String.class) + " " + condition.getOperation() + " null";
                    } else if (condition.getValue() instanceof List) {
                        block = this.buildColumn(condition.getColumn(), condition.getValue().getClass()) + " " + condition.getOperation() + " " + this.buildIn(condition.getValue());
                        values.addAll((List)condition.getValue());
                    } else {
                        block = this.buildColumn(condition.getColumn(), condition.getValue().getClass()) + " " + condition.getOperation() + " ?";
                        values.add(condition.getValue());
                    }
                    blocks.add(block);
                }
                if (!(object instanceof ConditionWrapper)) continue;
                ConditionWrapper conditionWrapper = (ConditionWrapper)object;
                block = " (" + conditionWrapper.build(values) + ") ";
                blocks.add(block);
            }
            sql = this.andLink ? StrUtil.join((CharSequence)" AND ", (Object[])new Object[]{blocks}) : StrUtil.join((CharSequence)" OR ", (Object[])new Object[]{blocks});
        }
        return sql;
    }

    public String buildColumn(String column, Class<?> clazz) {
        if (clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Short.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Boolean.class)) {
            return "CAST(`" + StrUtil.toUnderlineCase((CharSequence)column) + "` AS DECIMAL(30,10))";
        }
        if (clazz.equals(String.class) || clazz.equals(Boolean.class) || clazz.equals(Collection.class)) {
            return "`" + StrUtil.toUnderlineCase((CharSequence)column) + "`";
        }
        return "`" + StrUtil.toUnderlineCase((CharSequence)column) + "`";
    }

    public String buildIn(Object value) {
        ArrayList<String> ask = new ArrayList<String>();
        for (Object obj : (Collection)value) {
            ask.add("?");
        }
        if (ask.size() > 0) {
            return " (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{ask}) + ") ";
        }
        return " (null) ";
    }

    public ConditionWrapper eq(String column, Object params) {
        this.list.add(new Condition(column, "=", params));
        return this;
    }

    public ConditionWrapper ne(String column, Object params) {
        this.list.add(new Condition(column, "<>", params));
        return this;
    }

    public ConditionWrapper lt(String column, Object params) {
        this.list.add(new Condition(column, "<", params));
        return this;
    }

    public ConditionWrapper lte(String column, Object params) {
        this.list.add(new Condition(column, "<=", params));
        return this;
    }

    public ConditionWrapper gt(String column, Object params) {
        this.list.add(new Condition(column, ">", params));
        return this;
    }

    public ConditionWrapper gte(String column, Object params) {
        this.list.add(new Condition(column, "<=", params));
        return this;
    }

    public ConditionWrapper like(String column, String params) {
        this.list.add(new Condition(column, "LIKE", "%" + params + "%"));
        return this;
    }

    public ConditionWrapper in(String column, Collection<?> params) {
        this.list.add(new Condition(column, "IN", params));
        return this;
    }

    public ConditionWrapper nin(String column, Collection<?> params) {
        this.list.add(new Condition(column, "NOT IN", params));
        return this;
    }

    public ConditionWrapper isNull(String column) {
        this.list.add(new Condition(column, "IS NULL", null));
        return this;
    }

    public ConditionWrapper isNotNull(String column) {
        this.list.add(new Condition(column, "IS NOT NULL", null));
        return this;
    }

    public boolean notEmpty() {
        return this.list.size() > 0;
    }
}

