/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.sqlHelper.utils;

import cn.craccd.sqlHelper.bean.Page;
import cn.craccd.sqlHelper.bean.Sort;
import cn.craccd.sqlHelper.config.CompositeIndex;
import cn.craccd.sqlHelper.config.InitValue;
import cn.craccd.sqlHelper.config.SingleIndex;
import cn.craccd.sqlHelper.config.Table;
import cn.craccd.sqlHelper.utils.ConditionAndWrapper;
import cn.craccd.sqlHelper.utils.ConditionWrapper;
import cn.craccd.sqlHelper.utils.SnowFlake;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SqlHelper {
    @Value(value="${spring.database.type}")
    String database;
    @Value(value="${spring.database.package}")
    String packageName;
    @Value(value="${spring.database.print:false}")
    Boolean print;
    @Autowired
    JdbcTemplate jdbcTemplate;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    SnowFlake snowFlake = new SnowFlake(1L, 1L);
    String separator = System.getProperty("line.separator");

    @PostConstruct
    private void scan() {
        if (StrUtil.isEmpty((CharSequence)this.packageName)) {
            return;
        }
        Set set = ClassUtil.scanPackage((String)this.packageName);
        for (Class clazz : set) {
            Field[] fields;
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) continue;
            this.checkOrCreateTable(clazz);
            String sql = "";
            if (this.database.equals("sqlite")) {
                sql = "PRAGMA TABLE_INFO(`" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`)";
            } else if (this.database.equals("mysql")) {
                sql = "SHOW COLUMNS FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
            } else if (this.database.equals("postgresql")) {
                sql = "SELECT column_name as name FROM information_schema.columns WHERE table_schema='public' AND table_name='" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "'";
            }
            this.logQuery(this.formatSql(sql));
            List columns = this.jdbcTemplate.queryForList(this.formatSql(sql));
            if (this.database.equals("sqlite")) {
                sql = "PRAGMA INDEX_LIST(`" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`)";
            } else if (this.database.equals("mysql")) {
                sql = "SHOW INDEX FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
            } else if (this.database.equals("postgresql")) {
                sql = "SELECT A.INDEXNAME as name FROM PG_AM B LEFT JOIN PG_CLASS F ON B.OID = F.RELAM LEFT JOIN PG_STAT_ALL_INDEXES E ON F.OID = E.INDEXRELID LEFT JOIN PG_INDEX C ON E.INDEXRELID = C.INDEXRELID LEFT OUTER JOIN PG_DESCRIPTION D ON C.INDEXRELID = D.OBJOID, PG_INDEXES A WHERE A.SCHEMANAME = E.SCHEMANAME AND A.TABLENAME = E.RELNAME AND A.INDEXNAME = E.INDEXRELNAME AND E.SCHEMANAME = 'public' AND E.RELNAME = '" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "' ";
            }
            this.logQuery(this.formatSql(sql));
            List indexs = this.jdbcTemplate.queryForList(this.formatSql(sql));
            for (Field field : fields = ReflectUtil.getFields((Class)clazz)) {
                InitValue defaultValue;
                if (!field.getName().equals("id")) {
                    this.checkOrCreateColumn(clazz, field.getName(), columns);
                }
                if (field.isAnnotationPresent(SingleIndex.class)) {
                    SingleIndex singleIndex = field.getAnnotation(SingleIndex.class);
                    this.checkOrCreateIndex(clazz, field.getName(), singleIndex.unique(), (List<Map<String, Object>>)indexs);
                }
                if (!field.isAnnotationPresent(InitValue.class) || (defaultValue = field.getAnnotation(InitValue.class)).value() == null) continue;
                this.updateDefaultValue(clazz, field.getName(), defaultValue.value());
            }
            if (!clazz.isAnnotationPresent(CompositeIndex.class)) continue;
            CompositeIndex compositeIndex = clazz.getAnnotation(CompositeIndex.class);
            this.checkOrCreateIndex(clazz, compositeIndex.colums(), compositeIndex.unique(), (List<Map<String, Object>>)indexs);
        }
    }

    private void logQuery(String sql) {
        this.logQuery(sql, null);
    }

    private void logQuery(String sql, Object[] params) {
        if (this.print.booleanValue()) {
            try {
                if (params != null) {
                    for (Object object : params) {
                        if (object instanceof String) {
                            object = object.toString().replace("$", "RDS_CHAR_DOLLAR");
                            sql = sql.replaceFirst("\\?", "'" + object + "'").replace("RDS_CHAR_DOLLAR", "$");
                            continue;
                        }
                        sql = sql.replaceFirst("\\?", String.valueOf(object));
                    }
                }
                this.logger.info(this.separator + sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkOrCreateIndex(Class<?> clazz, String name, boolean unique, List<Map<String, Object>> indexs) {
        this.checkOrCreateIndex(clazz, new String[]{name}, unique, indexs);
    }

    private void checkOrCreateIndex(Class<?> clazz, String[] colums, boolean unique, List<Map<String, Object>> indexs) {
        ArrayList<String> columList = new ArrayList<String>();
        for (String colum : colums) {
            columList.add(StrUtil.toUnderlineCase((CharSequence)colum));
        }
        String name = StrUtil.join((CharSequence)"&", (Object[])new Object[]{columList}) + "@" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName());
        Boolean hasIndex = false;
        for (Map<String, Object> map : indexs) {
            if (!StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("name")) && !StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("Key_name"))) continue;
            hasIndex = true;
        }
        if (!hasIndex.booleanValue()) {
            String type = unique ? "UNIQUE INDEX" : "INDEX";
            String length = "";
            if (this.database.equals("mysql")) {
                length = "(100)";
            }
            columList = new ArrayList();
            for (String colum : colums) {
                columList.add(StrUtil.toUnderlineCase((CharSequence)("`" + colum + "`" + length)));
            }
            String sql = "CREATE " + type + "  `" + StrUtil.toUnderlineCase((CharSequence)name) + "` ON `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`(" + StrUtil.join((CharSequence)",", (Object[])new Object[]{columList}) + ")";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.execute(this.formatSql(sql));
        }
    }

    private void checkOrCreateColumn(Class<?> clazz, String name, List<Map<String, Object>> columns) {
        Boolean hasColumn = false;
        for (Map<String, Object> map : columns) {
            if (!StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("name")) && !StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("Field"))) continue;
            hasColumn = true;
        }
        if (!hasColumn.booleanValue()) {
            String sql = "ALTER TABLE `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "` ADD COLUMN `" + StrUtil.toUnderlineCase((CharSequence)name) + "` TEXT";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.execute(this.formatSql(sql));
        }
    }

    private void checkOrCreateTable(Class<?> clazz) {
        String sql = "CREATE TABLE IF NOT EXISTS `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "` (id BIGINT NOT NULL PRIMARY KEY)";
        this.logQuery(this.formatSql(sql));
        this.jdbcTemplate.execute(this.formatSql(sql));
    }

    private void updateDefaultValue(Class<?> clazz, String column, String value) {
        String sql = "SELECT COUNT(*) FROM " + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + " WHERE `" + StrUtil.toUnderlineCase((CharSequence)column) + "` IS NULL";
        this.logQuery(this.formatSql(sql));
        Long count = (Long)this.jdbcTemplate.queryForObject(this.formatSql(sql), Long.class);
        if (count > 0L) {
            sql = "UPDATE " + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + " SET `" + StrUtil.toUnderlineCase((CharSequence)column) + "` = ? WHERE `" + StrUtil.toUnderlineCase((CharSequence)column) + "` IS NULL";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.update(this.formatSql(sql), new Object[]{value});
        }
    }

    public void insertOrUpdate(Object object) {
        Long time = System.currentTimeMillis();
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        Object objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? this.findById(id, object.getClass()) : null;
        try {
            if (objectOrg == null) {
                Field[] fields;
                if (ReflectUtil.getField(object.getClass(), (String)"createTime") != null) {
                    ReflectUtil.setFieldValue((Object)object, (String)"createTime", (Object)time);
                }
                if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                    ReflectUtil.setFieldValue((Object)object, (String)"updateTime", (Object)time);
                }
                this.setDefaultVaule(object);
                ReflectUtil.setFieldValue((Object)object, (String)"id", (Object)this.snowFlake.nextId());
                String sql = "";
                ArrayList<String> fieldsPart = new ArrayList<String>();
                ArrayList<String> placeHolder = new ArrayList<String>();
                ArrayList<Object> paramValues = new ArrayList<Object>();
                for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
                    fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`");
                    placeHolder.add("?");
                    paramValues.add(ReflectUtil.getFieldValue((Object)object, (Field)field));
                }
                sql = "INSERT INTO `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + ") VALUES (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{placeHolder}) + ")";
                this.logQuery(this.formatSql(sql), paramValues.toArray());
                this.jdbcTemplate.update(this.formatSql(sql), paramValues.toArray());
            } else {
                Field[] fields = ReflectUtil.getFields(object.getClass());
                if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                    ReflectUtil.setFieldValue((Object)object, (String)"updateTime", (Object)time);
                }
                ArrayList<String> fieldsPart = new ArrayList<String>();
                ArrayList<Object> paramValues = new ArrayList<Object>();
                for (Field field : fields) {
                    if (field.getName().equals("id") || ReflectUtil.getFieldValue((Object)object, (Field)field) == null) continue;
                    fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`=?");
                    paramValues.add(ReflectUtil.getFieldValue((Object)object, (Field)field));
                }
                paramValues.add(id);
                String sql = "UPDATE `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` SET " + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + " WHERE id = ?";
                this.logQuery(this.formatSql(sql), paramValues.toArray());
                this.jdbcTemplate.update(this.formatSql(sql), paramValues.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert(Object object) {
        Object objectOrg;
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        Object v0 = objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? this.findById(id, object.getClass()) : null;
        if (objectOrg != null) {
            ReflectUtil.setFieldValue((Object)object, (String)"id", (Object)this.snowFlake.nextId());
        }
        if (ReflectUtil.getFieldValue((Object)object, (String)"id") == null) {
            ReflectUtil.setFieldValue((Object)object, (String)"id", (Object)this.snowFlake.nextId());
        }
        this.insertOrUpdate(object);
    }

    public <T> void insertAll(List<T> list) {
        Long time = System.currentTimeMillis();
        HashMap idMap = new HashMap();
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, (String)"id") == null) continue;
            String id = (String)ReflectUtil.getFieldValue(object, (String)"id");
            Object objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? (Object)this.findById(id, object.getClass()) : null;
            idMap.put((String)ReflectUtil.getFieldValue(object, (String)"id"), objectOrg);
        }
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, (String)"id") != null && idMap.get((String)ReflectUtil.getFieldValue(object, (String)"id")) != null) {
                ReflectUtil.setFieldValue(object, (String)"id", (Object)this.snowFlake.nextId());
            }
            if (ReflectUtil.getFieldValue(object, (String)"id") == null) {
                ReflectUtil.setFieldValue(object, (String)"id", (Object)this.snowFlake.nextId());
            }
            if (ReflectUtil.getField(object.getClass(), (String)"createTime") != null) {
                ReflectUtil.setFieldValue(object, (String)"createTime", (Object)time);
            }
            if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                ReflectUtil.setFieldValue(object, (String)"updateTime", (Object)time);
            }
            this.setDefaultVaule(object);
        }
        ArrayList<Object[]> paramValues = new ArrayList<Object[]>();
        String sqls = null;
        for (T object : list) {
            Field[] fields = ReflectUtil.getFields(object.getClass());
            ArrayList<String> fieldsPart = new ArrayList<String>();
            ArrayList<String> placeHolder = new ArrayList<String>();
            ArrayList<Object> params = new ArrayList<Object>();
            for (Field field : fields) {
                fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`");
                placeHolder.add("?");
                params.add(ReflectUtil.getFieldValue(object, (Field)field));
            }
            paramValues.add(params.toArray());
            if (sqls != null) continue;
            sqls = "INSERT INTO `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + ") VALUES (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{placeHolder}) + ")";
        }
        this.jdbcTemplate.batchUpdate(this.formatSql(sqls), paramValues);
    }

    public void updateById(Object object) {
        if (StrUtil.isEmpty((CharSequence)((String)ReflectUtil.getFieldValue((Object)object, (String)"id")))) {
            return;
        }
        this.insertOrUpdate(object);
    }

    public void addCountById(String id, String property, Long count, Class<?> clazz) {
        String sql = "UPDATE `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "` SET `" + property + "` = CAST(`" + property + "` AS DECIMAL(30,10)) + ? WHERE `id` =  ?";
        Object[] params = new Object[]{count, id};
        this.logQuery(this.formatSql(sql), params);
        this.jdbcTemplate.update(this.formatSql(sql), params);
    }

    public void updateAllColumnById(Object object) {
        if (StrUtil.isEmpty((CharSequence)((String)ReflectUtil.getFieldValue((Object)object, (String)"id")))) {
            return;
        }
        Field[] fields = ReflectUtil.getFields(object.getClass());
        ArrayList<String> fieldsPart = new ArrayList<String>();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (Field field : fields) {
            if (field.getName().equals("id")) continue;
            fieldsPart.add("`" + StrUtil.toUnderlineCase((CharSequence)field.getName()) + "`=?");
            paramValues.add(ReflectUtil.getFieldValue((Object)object, (Field)field));
        }
        paramValues.add((String)ReflectUtil.getFieldValue((Object)object, (String)"id"));
        String sql = "UPDATE `" + StrUtil.toUnderlineCase((CharSequence)object.getClass().getSimpleName()) + "` SET " + StrUtil.join((CharSequence)",", (Object[])new Object[]{fieldsPart}) + " WHERE id = ?";
        this.logQuery(this.formatSql(sql), paramValues.toArray());
        this.jdbcTemplate.update(this.formatSql(sql), paramValues.toArray());
    }

    public void deleteById(String id, Class<?> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return;
        }
        this.deleteByQuery(new ConditionAndWrapper().eq("id", id), clazz);
    }

    public void deleteByIds(Collection<String> ids, Class<?> clazz) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.deleteByQuery(new ConditionAndWrapper().in("id", (Collection)ids), clazz);
    }

    public void deleteByIds(String[] ids, Class<?> clazz) {
        this.deleteByIds(Arrays.asList(ids), clazz);
    }

    public void deleteByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "DELETE FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        this.logQuery(this.formatSql(sql), values.toArray());
        this.jdbcTemplate.update(this.formatSql(sql), values.toArray());
    }

    private void setDefaultVaule(Object object) {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (!field.isAnnotationPresent(InitValue.class)) continue;
            InitValue defaultValue = field.getAnnotation(InitValue.class);
            String value = defaultValue.value();
            if (ReflectUtil.getFieldValue((Object)object, (Field)field) != null) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)value);
            }
            if (type.equals(Short.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Short.parseShort(value));
            }
            if (type.equals(Integer.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Integer.parseInt(value));
            }
            if (type.equals(Long.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Long.parseLong(value));
            }
            if (type.equals(Float.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Float.valueOf(Float.parseFloat(value)));
            }
            if (type.equals(Double.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Double.parseDouble(value));
            }
            if (!type.equals(Boolean.class)) continue;
            ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Boolean.parseBoolean(value));
        }
    }

    public Page findPage(ConditionWrapper conditionWrapper, Sort sort, Page page, Class<?> clazz) {
        ArrayList<Object> values = new ArrayList<Object>();
        Long count = this.findCountByQuery(conditionWrapper, clazz);
        String sql = "SELECT * FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY id DESC";
        sql = this.database.equalsIgnoreCase("mysql") || this.database.equalsIgnoreCase("sqlite") ? sql + " LIMIT " + (page.getCurr() - 1) * page.getLimit() + "," + page.getLimit() : sql + " LIMIT " + page.getLimit() + " OFFSET " + (page.getCurr() - 1) * page.getLimit();
        page.setCount(count);
        this.logQuery(this.formatSql(sql), values.toArray());
        page.setRecords(this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz));
        return page;
    }

    public Page findPage(Sort sort, Page page, Class<?> clazz) {
        return this.findPage(null, sort, page, clazz);
    }

    public Page findPage(ConditionWrapper conditionWrapper, Page page, Class<?> clazz) {
        return this.findPage(conditionWrapper, null, page, clazz);
    }

    public Page findPage(Page page, Class<?> clazz) {
        return this.findPage(null, null, page, clazz);
    }

    public <T> T findById(String id, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        return this.findOneByQuery(new ConditionAndWrapper().eq("id", id), clazz);
    }

    public <T> T findOneByQuery(ConditionWrapper conditionWrapper, Sort sort, Class<T> clazz) {
        ArrayList<Object> values = new ArrayList<Object>();
        List<Object> list = new ArrayList();
        String sql = "SELECT * FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY id DESC";
        sql = sql + " limit 1";
        this.logQuery(this.formatSql(sql), values.toArray());
        list = this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz);
        return (T)(list.size() > 0 ? list.get(0) : null);
    }

    public <T> T findOneByQuery(Sort sort, Class<T> clazz) {
        return this.findOneByQuery(null, sort, clazz);
    }

    public <T> T findOneByQuery(ConditionWrapper conditionWrapper, Class<T> clazz) {
        return this.findOneByQuery(conditionWrapper, null, clazz);
    }

    public <T> List<T> findListByQuery(ConditionWrapper conditionWrapper, Sort sort, Class<T> clazz) {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "SELECT * FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        sql = sort != null ? sql + " " + sort.toString() : sql + " ORDER BY id DESC";
        this.logQuery(this.formatSql(sql), values.toArray());
        return this.buildObjects(this.jdbcTemplate.queryForList(this.formatSql(sql), values.toArray()), clazz);
    }

    public <T> List<T> findListByQuery(ConditionWrapper conditionWrapper, Class<T> clazz) {
        return this.findListByQuery(conditionWrapper, null, clazz);
    }

    public <T> List<T> findListByQuery(Sort sort, Class<T> clazz) {
        return this.findListByQuery(null, sort, clazz);
    }

    public <T> List<T> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, String property, Class<T> propertyClass) {
        List<?> list = this.findListByQuery(conditionWrapper, documentClass);
        List<T> propertyList = this.extractProperty(list, property, propertyClass);
        return propertyList;
    }

    public List<String> findPropertiesByQuery(ConditionWrapper conditionWrapper, Class<?> documentClass, String property) {
        return this.findPropertiesByQuery(conditionWrapper, documentClass, property, String.class);
    }

    public List<String> findPropertiesByIds(Collection<String> ids, Class<?> documentClass, String property) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList<String>();
        }
        ConditionAndWrapper ConditionAndWrapper2 = new ConditionAndWrapper();
        ConditionAndWrapper2.in("id", (Collection)ids);
        return this.findPropertiesByQuery(ConditionAndWrapper2, documentClass, property, String.class);
    }

    public List<String> findPropertiesByIds(String[] ids, Class<?> documentClass, String property) {
        return this.findPropertiesByIds(Arrays.asList(ids), documentClass, property);
    }

    public List<String> findIdsByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        return this.findPropertiesByQuery(conditionWrapper, clazz, "id");
    }

    public <T> List<T> findListByIds(Collection<String> ids, Class<T> clazz) {
        return this.findListByIds(ids, null, clazz);
    }

    public <T> List<T> findListByIds(String[] ids, Class<T> clazz) {
        return this.findListByIds(Arrays.asList(ids), null, clazz);
    }

    public <T> List<T> findListByIds(Collection<String> ids, Sort sort, Class<T> clazz) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList();
        }
        ConditionAndWrapper ConditionAndWrapper2 = new ConditionAndWrapper();
        ConditionAndWrapper2.in("id", (Collection)ids);
        return this.findListByQuery(ConditionAndWrapper2, sort, clazz);
    }

    public <T> List<T> findListByIds(String[] ids, Sort sort, Class<T> clazz) {
        return this.findListByIds(Arrays.asList(ids), sort, clazz);
    }

    public <T> List<T> findAll(Class<T> clazz) {
        return this.findAll(null, clazz);
    }

    public <T> List<T> findAll(Sort sort, Class<T> clazz) {
        return this.findListByQuery(null, sort, clazz);
    }

    public List<String> findAllIds(Class<?> clazz) {
        return this.findIdsByQuery(null, clazz);
    }

    public Long findCountByQuery(ConditionWrapper conditionWrapper, Class<?> clazz) {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "SELECT COUNT(*) FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
        if (conditionWrapper != null && conditionWrapper.notEmpty()) {
            sql = sql + " WHERE " + conditionWrapper.build(values);
        }
        this.logQuery(this.formatSql(sql), values.toArray());
        return (Long)this.jdbcTemplate.queryForObject(this.formatSql(sql), values.toArray(), Long.class);
    }

    public Long findAllCount(Class<?> clazz) {
        return this.findCountByQuery(null, clazz);
    }

    private <T> List<T> extractProperty(List<?> list, String property, Class<T> clazz) {
        HashSet<Object> rs = new HashSet<Object>();
        for (Object object : list) {
            Object value = ReflectUtil.getFieldValue(object, (String)property);
            if (!value.getClass().equals(clazz)) continue;
            rs.add(value);
        }
        return new ArrayList(rs);
    }

    private <T> List<T> buildObjects(List<Map<String, Object>> queryForList, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            Field[] fields = ReflectUtil.getFields(clazz);
            for (Map<String, Object> map : queryForList) {
                T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                block3: for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    for (Field field : fields) {
                        if (!StrUtil.toUnderlineCase((CharSequence)field.getName()).equals(mapKey)) continue;
                        ReflectUtil.setFieldValue(obj, (String)field.getName(), (Object)mapValue);
                        continue block3;
                    }
                }
                list.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private String formatSql(String sql) {
        if (StrUtil.isEmpty((CharSequence)sql)) {
            return "";
        }
        if (!this.database.equalsIgnoreCase("mysql")) {
            sql = sql.replace("`", "\"");
        }
        String tab = "\t";
        sql = sql.replace("FROM", this.separator + "FROM").replace("WHERE", this.separator + "WHERE").replace("ORDER", this.separator + "ORDER").replace("LEFT", this.separator + "LEFT").replace("LIMIT", this.separator + "LIMIT").replace("AND", this.separator + tab + "AND").replace("SET", this.separator + "SET").replace("VALUES", this.separator + "VALUES");
        return sql;
    }
}

