/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.router;

import cn.dev33.satoken.exception.SaTokenException;
import java.util.HashMap;
import java.util.Map;

public enum SaHttpMethod {
    GET,
    HEAD,
    POST,
    PUT,
    PATCH,
    DELETE,
    OPTIONS,
    TRACE,
    CONNECT,
    ALL;

    private static final Map<String, SaHttpMethod> map;

    public static SaHttpMethod toEnum(String method) {
        if (method == null) {
            throw new SaTokenException("\u65e0\u6548Method\uff1a" + method).setCode(10321);
        }
        SaHttpMethod reqMethod = map.get(method.toUpperCase());
        if (reqMethod == null) {
            throw new SaTokenException("\u65e0\u6548Method\uff1a" + method).setCode(10321);
        }
        return reqMethod;
    }

    public static SaHttpMethod[] toEnumArray(String ... methods) {
        SaHttpMethod[] arr = new SaHttpMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            arr[i] = SaHttpMethod.toEnum(methods[i]);
        }
        return arr;
    }

    static {
        map = new HashMap<String, SaHttpMethod>();
        for (SaHttpMethod reqMethod : SaHttpMethod.values()) {
            map.put(reqMethod.name(), reqMethod);
        }
    }
}

