/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sign;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.secure.SaSecureUtil;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.Map;
import java.util.TreeMap;

public interface SaSignTemplate {
    default public String joinParams(Map<String, Object> paramsMap) {
        StringBuilder sb = new StringBuilder();
        for (String key : paramsMap.keySet()) {
            Object value = paramsMap.get(key);
            if (SaFoxUtil.isEmpty(value)) continue;
            sb.append(key).append("=").append(value).append("&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    default public String joinParamsDictSort(Map<String, Object> paramsMap) {
        if (!(paramsMap instanceof TreeMap)) {
            paramsMap = new TreeMap<String, Object>(paramsMap);
        }
        return this.joinParams(paramsMap);
    }

    default public String createSign(Map<String, Object> paramsMap, String key) {
        SaTokenException.throwByNull(key, "\u53c2\u4e0e\u53c2\u6570\u7b7e\u540d\u7684\u79d8\u94a5\u4e0d\u53ef\u4e3a\u7a7a", 12201);
        String paramsStr = this.joinParamsDictSort(paramsMap);
        String fullStr = paramsStr + "&key=" + key;
        return SaSecureUtil.md5(fullStr);
    }

    default public boolean isValidSign(Map<String, Object> paramsMap, String key, String sign) {
        String theSign = this.createSign(paramsMap, key);
        return theSign.equals(sign);
    }

    default public void checkSign(Map<String, Object> paramsMap, String key, String sign) {
        if (!this.isValidSign(paramsMap, key, sign)) {
            throw new SaTokenException("\u65e0\u6548\u7b7e\u540d\uff1a" + sign).setCode(12202);
        }
    }

    default public Map<String, Object> addSignParams(Map<String, Object> paramsMap, String key) {
        paramsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        paramsMap.put("nonce", SaFoxUtil.getRandomString(32));
        paramsMap.put("sign", this.createSign(paramsMap, key));
        return paramsMap;
    }

    default public String addSignParamsToString(Map<String, Object> paramsMap, String key) {
        paramsMap = this.addSignParams(paramsMap, key);
        return this.joinParams(paramsMap);
    }

    default public boolean isValidTimestamp(long timestamp, long allowDisparity) {
        long disparity = Math.abs(System.currentTimeMillis() - timestamp);
        return allowDisparity == -1L || disparity <= allowDisparity;
    }

    default public void checkTimestamp(long timestamp, long allowDisparity) {
        if (!this.isValidTimestamp(timestamp, allowDisparity)) {
            throw new SaTokenException("timestamp \u8d85\u51fa\u5141\u8bb8\u7684\u8303\u56f4\uff1a" + timestamp).setCode(12203);
        }
    }
}

