/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.SaCheckDisable;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.annotation.SaMode;
import cn.dev33.satoken.config.SaCookieConfig;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaCookie;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.context.model.SaStorage;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.DisableServiceException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.NotSafeException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.TokenSign;
import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StpLogic {
    public String loginType;

    public StpLogic(String loginType) {
        this.loginType = loginType;
        SaManager.putStpLogic(this);
    }

    public String getLoginType() {
        return this.loginType;
    }

    public StpLogic setLoginType(String loginType) {
        this.loginType = loginType;
        SaManager.putStpLogic(this);
        return this;
    }

    public String getTokenName() {
        return this.splicingKeyTokenName();
    }

    public String createTokenValue(Object loginId, String device, long timeout, Map<String, Object> extraData) {
        return SaStrategy.me.createToken.apply(loginId, this.loginType);
    }

    public void setTokenValue(String tokenValue) {
        this.setTokenValue(tokenValue, new SaLoginModel().setTimeout(this.getConfig().getTimeout()));
    }

    public void setTokenValue(String tokenValue, int cookieTimeout) {
        this.setTokenValue(tokenValue, new SaLoginModel().setTimeout(cookieTimeout));
    }

    public void setTokenValue(String tokenValue, SaLoginModel loginModel) {
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return;
        }
        this.setTokenValueToStorage(tokenValue);
        if (this.getConfig().getIsReadCookie().booleanValue()) {
            this.setTokenValueToCookie(tokenValue, loginModel.getCookieTimeout());
        }
        if (loginModel.getIsWriteHeaderOrGlobalConfig().booleanValue()) {
            this.setTokenValueToResponseHeader(tokenValue);
        }
    }

    public void setTokenValueToStorage(String tokenValue) {
        SaStorage storage = SaHolder.getStorage();
        String tokenPrefix = this.getConfig().getTokenPrefix();
        if (!SaFoxUtil.isEmpty(tokenPrefix)) {
            storage.set(this.splicingKeyJustCreatedSave(), tokenPrefix + " " + tokenValue);
        } else {
            storage.set(this.splicingKeyJustCreatedSave(), tokenValue);
        }
        storage.set("JUST_CREATED_NOT_PREFIX_", tokenValue);
    }

    public void setTokenValueToCookie(String tokenValue, int cookieTimeout) {
        SaCookieConfig cfg = this.getConfig().getCookie();
        SaCookie cookie = new SaCookie().setName(this.getTokenName()).setValue(tokenValue).setMaxAge(cookieTimeout).setDomain(cfg.getDomain()).setPath(cfg.getPath()).setSecure(cfg.getSecure()).setHttpOnly(cfg.getHttpOnly()).setSameSite(cfg.getSameSite());
        SaHolder.getResponse().addCookie(cookie);
    }

    public void setTokenValueToResponseHeader(String tokenValue) {
        String tokenName = this.getTokenName();
        SaResponse response = SaHolder.getResponse();
        response.setHeader(tokenName, tokenValue);
        response.addHeader("Access-Control-Expose-Headers", tokenName);
    }

    public String getTokenValue() {
        String tokenValue = this.getTokenValueNotCut();
        String tokenPrefix = this.getConfig().getTokenPrefix();
        if (!SaFoxUtil.isEmpty(tokenPrefix)) {
            tokenValue = SaFoxUtil.isEmpty(tokenValue) || !tokenValue.startsWith(tokenPrefix + " ") ? null : tokenValue.substring(tokenPrefix.length() + " ".length());
        }
        return tokenValue;
    }

    public String getTokenValueNotCut() {
        SaStorage storage = SaHolder.getStorage();
        SaRequest request = SaHolder.getRequest();
        SaTokenConfig config = this.getConfig();
        String keyTokenName = this.getTokenName();
        String tokenValue = null;
        if (storage.get(this.splicingKeyJustCreatedSave()) != null) {
            tokenValue = String.valueOf(storage.get(this.splicingKeyJustCreatedSave()));
        }
        if (tokenValue == null && config.getIsReadBody().booleanValue()) {
            tokenValue = request.getParam(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadHeader().booleanValue()) {
            tokenValue = request.getHeader(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadCookie().booleanValue()) {
            tokenValue = request.getCookieValue(keyTokenName);
        }
        return tokenValue;
    }

    public String getTokenValueNotNull() {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            throw new SaTokenException("\u672a\u80fd\u8bfb\u53d6\u5230\u6709\u6548Token").setCode(11001);
        }
        return tokenValue;
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginType = this.getLoginType();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = this.getSessionTimeout();
        info.tokenSessionTimeout = this.getTokenSessionTimeout();
        info.tokenActivityTimeout = this.getTokenActivityTimeout();
        info.loginDevice = this.getLoginDevice();
        return info;
    }

    public void login(Object id) {
        this.login(id, new SaLoginModel());
    }

    public void login(Object id, String device) {
        this.login(id, new SaLoginModel().setDevice(device));
    }

    public void login(Object id, boolean isLastingCookie) {
        this.login(id, new SaLoginModel().setIsLastingCookie(isLastingCookie));
    }

    public void login(Object id, long timeout) {
        this.login(id, new SaLoginModel().setTimeout(timeout));
    }

    public void login(Object id, SaLoginModel loginModel) {
        String token = this.createLoginSession(id, loginModel);
        this.setTokenValue(token, loginModel);
    }

    public String createLoginSession(Object id) {
        return this.createLoginSession(id, new SaLoginModel());
    }

    public String createLoginSession(Object id, SaLoginModel loginModel) {
        SaTokenException.throwByNull(id, "\u8d26\u53f7id\u4e0d\u80fd\u4e3a\u7a7a", 11002);
        SaTokenConfig config = this.getConfig();
        loginModel.build(config);
        String tokenValue = this.distUsableToken(id, loginModel);
        SaSession session = this.getSessionByLoginId(id, true);
        session.updateMinTimeout(loginModel.getTimeout());
        session.addTokenSign(tokenValue, loginModel.getDeviceOrDefault());
        this.saveTokenToIdMapping(tokenValue, id, loginModel.getTimeout());
        this.setLastActivityToNow(tokenValue);
        SaTokenEventCenter.doLogin(this.loginType, id, tokenValue, loginModel);
        if (config.getMaxLoginCount() != -1) {
            this.logoutByMaxLoginCount(id, session, null, config.getMaxLoginCount());
        }
        return tokenValue;
    }

    protected String distUsableToken(Object id, SaLoginModel loginModel) {
        String tokenValue;
        Boolean isConcurrent = this.getConfig().getIsConcurrent();
        if (!isConcurrent.booleanValue()) {
            this.replaced(id, loginModel.getDevice());
        }
        if (SaFoxUtil.isNotEmpty(loginModel.getToken())) {
            return loginModel.getToken();
        }
        if (isConcurrent.booleanValue() && this.getConfigOfIsShare() && SaFoxUtil.isNotEmpty(tokenValue = this.getTokenValueByLoginId(id, loginModel.getDeviceOrDefault()))) {
            return tokenValue;
        }
        return this.createTokenValue(id, loginModel.getDeviceOrDefault(), loginModel.getTimeout(), loginModel.getExtraData());
    }

    public void logout() {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return;
        }
        if (this.getConfig().getIsReadCookie().booleanValue()) {
            SaCookieConfig cookie = this.getConfig().getCookie();
            SaHolder.getResponse().deleteCookie(this.getTokenName(), cookie.getPath(), cookie.getDomain());
        }
        SaHolder.getStorage().delete(this.splicingKeyJustCreatedSave());
        SaHolder.getStorage().delete("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_");
        this.logoutByTokenValue(tokenValue);
    }

    public void logout(Object loginId) {
        this.logout(loginId, null);
    }

    public void logout(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            for (TokenSign tokenSign : session.tokenSignListCopyByDevice(device)) {
                String tokenValue = tokenSign.getValue();
                session.removeTokenSign(tokenValue);
                this.clearLastActivity(tokenValue);
                this.deleteTokenToIdMapping(tokenValue);
                this.deleteTokenSession(tokenValue);
                SaTokenEventCenter.doLogout(this.loginType, loginId, tokenValue);
            }
            session.logoutByTokenSignCountToZero();
        }
    }

    public void logoutByMaxLoginCount(Object loginId, SaSession session, String device, int maxLoginCount) {
        if (session == null && (session = this.getSessionByLoginId(loginId, false)) == null) {
            return;
        }
        List<TokenSign> list = session.tokenSignListCopyByDevice(device);
        for (int i = 0; i < list.size() - maxLoginCount; ++i) {
            String tokenValue = list.get(i).getValue();
            session.removeTokenSign(tokenValue);
            this.clearLastActivity(tokenValue);
            this.deleteTokenToIdMapping(tokenValue);
            this.deleteTokenSession(tokenValue);
            SaTokenEventCenter.doLogout(this.loginType, loginId, tokenValue);
        }
        session.logoutByTokenSignCountToZero();
    }

    public void logoutByTokenValue(String tokenValue) {
        this.clearLastActivity(tokenValue);
        this.deleteTokenSession(tokenValue);
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId != null) {
            this.deleteTokenToIdMapping(tokenValue);
        }
        if (!this.isValidLoginId(loginId)) {
            return;
        }
        SaTokenEventCenter.doLogout(this.loginType, loginId, tokenValue);
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            session.removeTokenSign(tokenValue);
            session.logoutByTokenSignCountToZero();
        }
    }

    public void kickout(Object loginId) {
        this.kickout(loginId, null);
    }

    public void kickout(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            for (TokenSign tokenSign : session.tokenSignListCopyByDevice(device)) {
                String tokenValue = tokenSign.getValue();
                session.removeTokenSign(tokenValue);
                this.clearLastActivity(tokenValue);
                this.updateTokenToIdMapping(tokenValue, "-5");
                SaTokenEventCenter.doKickout(this.loginType, loginId, tokenValue);
            }
            session.logoutByTokenSignCountToZero();
        }
    }

    public void kickoutByTokenValue(String tokenValue) {
        this.clearLastActivity(tokenValue);
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (!this.isValidLoginId(loginId)) {
            return;
        }
        this.updateTokenToIdMapping(tokenValue, "-5");
        SaTokenEventCenter.doKickout(this.loginType, loginId, tokenValue);
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            session.removeTokenSign(tokenValue);
            session.logoutByTokenSignCountToZero();
        }
    }

    public void replaced(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session != null) {
            for (TokenSign tokenSign : session.tokenSignListCopyByDevice(device)) {
                String tokenValue = tokenSign.getValue();
                session.removeTokenSign(tokenValue);
                this.clearLastActivity(tokenValue);
                this.updateTokenToIdMapping(tokenValue, "-4");
                SaTokenEventCenter.doReplaced(this.loginType, loginId, tokenValue);
            }
        }
    }

    public boolean isLogin() {
        return this.getLoginIdDefaultNull() != null;
    }

    public void checkLogin() {
        this.getLoginId();
    }

    public Object getLoginId() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            throw NotLoginException.newInstance(this.loginType, "-1").setCode(11011);
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null) {
            throw NotLoginException.newInstance(this.loginType, "-2", tokenValue).setCode(11012);
        }
        if (loginId.equals("-3")) {
            throw NotLoginException.newInstance(this.loginType, "-3", tokenValue).setCode(11013);
        }
        if (loginId.equals("-4")) {
            throw NotLoginException.newInstance(this.loginType, "-4", tokenValue).setCode(11014);
        }
        if (loginId.equals("-5")) {
            throw NotLoginException.newInstance(this.loginType, "-5", tokenValue).setCode(11015);
        }
        this.checkActivityTimeout(tokenValue);
        if (this.getConfig().getAutoRenew().booleanValue()) {
            this.updateLastActivityToNow(tokenValue);
        }
        return loginId;
    }

    public <T> T getLoginId(T defaultValue) {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId == null) {
            return defaultValue;
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(loginId.toString());
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(loginId.toString());
        }
        if (defaultValue instanceof String) {
            return (T)loginId.toString();
        }
        return (T)loginId;
    }

    public Object getLoginIdDefaultNull() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (!this.isValidLoginId(loginId)) {
            return null;
        }
        if (this.getTokenActivityTimeoutByToken(tokenValue) == -2L) {
            return null;
        }
        return loginId;
    }

    public String getLoginIdAsString() {
        return String.valueOf(this.getLoginId());
    }

    public int getLoginIdAsInt() {
        return Integer.parseInt(String.valueOf(this.getLoginId()));
    }

    public long getLoginIdAsLong() {
        return Long.parseLong(String.valueOf(this.getLoginId()));
    }

    public Object getLoginIdByToken(String tokenValue) {
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return null;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (!this.isValidLoginId(loginId)) {
            return null;
        }
        return loginId;
    }

    public String getLoginIdNotHandle(String tokenValue) {
        return this.getSaTokenDao().get(this.splicingKeyTokenValue(tokenValue));
    }

    public Object getExtra(String key) {
        throw new ApiDisabledException().setCode(11031);
    }

    public Object getExtra(String tokenValue, String key) {
        throw new ApiDisabledException().setCode(11031);
    }

    public boolean isValidLoginId(Object loginId) {
        return loginId != null && !NotLoginException.ABNORMAL_LIST.contains(loginId.toString());
    }

    public void deleteTokenToIdMapping(String tokenValue) {
        this.getSaTokenDao().delete(this.splicingKeyTokenValue(tokenValue));
    }

    public void updateTokenToIdMapping(String tokenValue, Object loginId) {
        SaTokenException.throwBy(SaFoxUtil.isEmpty(loginId), "LoginId \u4e0d\u80fd\u4e3a\u7a7a", 11003);
        this.getSaTokenDao().update(this.splicingKeyTokenValue(tokenValue), loginId.toString());
    }

    public void saveTokenToIdMapping(String tokenValue, Object loginId, long timeout) {
        this.getSaTokenDao().set(this.splicingKeyTokenValue(tokenValue), String.valueOf(loginId), timeout);
    }

    public SaSession getSessionBySessionId(String sessionId, boolean isCreate) {
        SaSession session = this.getSaTokenDao().getSession(sessionId);
        if (session == null && isCreate) {
            session = SaStrategy.me.createSession.apply(sessionId);
            this.getSaTokenDao().setSession(session, this.getConfig().getTimeout());
        }
        return session;
    }

    public SaSession getSessionBySessionId(String sessionId) {
        return this.getSessionBySessionId(sessionId, false);
    }

    public SaSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeySession(loginId), isCreate);
    }

    public SaSession getSessionByLoginId(Object loginId) {
        return this.getSessionBySessionId(this.splicingKeySession(loginId), true);
    }

    public SaSession getSession(boolean isCreate) {
        return this.getSessionByLoginId(this.getLoginId(), isCreate);
    }

    public SaSession getSession() {
        return this.getSession(true);
    }

    public SaSession getTokenSessionByToken(String tokenValue, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), isCreate);
    }

    public SaSession getTokenSessionByToken(String tokenValue) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), true);
    }

    public SaSession getTokenSession(boolean isCreate) {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return null;
        }
        if (this.getConfig().getTokenSessionCheckLogin().booleanValue()) {
            this.checkLogin();
        }
        return this.getTokenSessionByToken(tokenValue, isCreate);
    }

    public SaSession getTokenSession() {
        return this.getTokenSession(true);
    }

    public SaSession getAnonTokenSession(boolean isCreate) {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isNotEmpty(tokenValue)) {
            SaSession session = this.getTokenSessionByToken(tokenValue, false);
            if (session != null) {
                return session;
            }
            String loginId = this.getLoginIdNotHandle(tokenValue);
            if (this.isValidLoginId(loginId)) {
                return this.getTokenSessionByToken(tokenValue, isCreate);
            }
        }
        if (isCreate) {
            tokenValue = this.createTokenValue(null, null, this.getConfig().getTimeout(), null);
            this.setLastActivityToNow(tokenValue);
            this.setTokenValue(tokenValue);
            return this.getTokenSessionByToken(tokenValue, isCreate);
        }
        return null;
    }

    public SaSession getAnonTokenSession() {
        return this.getAnonTokenSession(true);
    }

    public void deleteTokenSession(String tokenValue) {
        this.getSaTokenDao().delete(this.splicingKeyTokenSession(tokenValue));
    }

    protected void setLastActivityToNow(String tokenValue) {
        if (tokenValue == null || !this.isOpenActivityCheck()) {
            return;
        }
        this.getSaTokenDao().set(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()), this.getConfig().getTimeout());
    }

    protected void clearLastActivity(String tokenValue) {
        if (tokenValue == null || !this.isOpenActivityCheck()) {
            return;
        }
        this.getSaTokenDao().delete(this.splicingKeyLastActivityTime(tokenValue));
    }

    public void checkActivityTimeout(String tokenValue) {
        if (tokenValue == null || !this.isOpenActivityCheck()) {
            return;
        }
        SaStorage storage = SaHolder.getStorage();
        if (storage.get("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_") != null) {
            return;
        }
        long timeout = this.getTokenActivityTimeoutByToken(tokenValue);
        if (timeout == -1L) {
            return;
        }
        if (timeout == -2L) {
            throw NotLoginException.newInstance(this.loginType, "-3", tokenValue).setCode(11016);
        }
        storage.set("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_", true);
    }

    public void checkActivityTimeout() {
        this.checkActivityTimeout(this.getTokenValue());
    }

    public void updateLastActivityToNow(String tokenValue) {
        if (tokenValue == null || !this.isOpenActivityCheck()) {
            return;
        }
        this.getSaTokenDao().update(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()));
    }

    public void updateLastActivityToNow() {
        this.updateLastActivityToNow(this.getTokenValue());
    }

    public long getTokenTimeout() {
        return this.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(this.getTokenValue()));
    }

    public long getTokenTimeoutByLoginId(Object loginId) {
        return this.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(this.getTokenValueByLoginId(loginId)));
    }

    public long getSessionTimeout() {
        return this.getSessionTimeoutByLoginId(this.getLoginIdDefaultNull());
    }

    public long getSessionTimeoutByLoginId(Object loginId) {
        return this.getSaTokenDao().getSessionTimeout(this.splicingKeySession(loginId));
    }

    public long getTokenSessionTimeout() {
        return this.getTokenSessionTimeoutByTokenValue(this.getTokenValue());
    }

    public long getTokenSessionTimeoutByTokenValue(String tokenValue) {
        return this.getSaTokenDao().getSessionTimeout(this.splicingKeyTokenSession(tokenValue));
    }

    public long getTokenActivityTimeout() {
        return this.getTokenActivityTimeoutByToken(this.getTokenValue());
    }

    public long getTokenActivityTimeoutByToken(String tokenValue) {
        if (tokenValue == null) {
            return -2L;
        }
        if (!this.isOpenActivityCheck()) {
            return -1L;
        }
        String keyLastActivityTime = this.splicingKeyLastActivityTime(tokenValue);
        String lastActivityTimeString = this.getSaTokenDao().get(keyLastActivityTime);
        if (lastActivityTimeString == null) {
            return -2L;
        }
        long lastActivityTime = Long.parseLong(lastActivityTimeString);
        long apartSecond = (System.currentTimeMillis() - lastActivityTime) / 1000L;
        long timeout = this.getConfig().getActivityTimeout() - apartSecond;
        if (timeout < 0L) {
            return -2L;
        }
        return timeout;
    }

    public void renewTimeout(long timeout) {
        String tokenValue = this.getTokenValue();
        this.renewTimeout(tokenValue, timeout);
        if (this.getConfig().getIsReadCookie().booleanValue()) {
            this.setTokenValueToCookie(tokenValue, (int)timeout);
        }
    }

    public void renewTimeout(String tokenValue, long timeout) {
        Object loginId = this.getLoginIdByToken(tokenValue);
        if (loginId == null) {
            return;
        }
        SaTokenDao dao = this.getSaTokenDao();
        dao.updateTimeout(this.splicingKeyTokenValue(tokenValue), timeout);
        SaSession tokenSession = this.getTokenSessionByToken(tokenValue, false);
        if (tokenSession != null) {
            tokenSession.updateTimeout(timeout);
        }
        this.getSessionByLoginId(loginId).updateMinTimeout(timeout);
        if (this.isOpenActivityCheck()) {
            dao.updateTimeout(this.splicingKeyLastActivityTime(tokenValue), timeout);
        }
        SaTokenEventCenter.doRenewTimeout(tokenValue, loginId, timeout);
    }

    public List<String> getRoleList() {
        try {
            return this.getRoleList(this.getLoginId());
        }
        catch (NotLoginException e) {
            return SaFoxUtil.emptyList();
        }
    }

    public List<String> getRoleList(Object loginId) {
        return SaManager.getStpInterface().getRoleList(loginId, this.loginType);
    }

    public boolean hasRole(String role) {
        return this.hasElement(this.getRoleList(), role);
    }

    public boolean hasRole(Object loginId, String role) {
        return this.hasElement(this.getRoleList(loginId), role);
    }

    public boolean hasRoleAnd(String ... roleArray) {
        try {
            this.checkRoleAnd(roleArray);
            return true;
        }
        catch (NotLoginException | NotRoleException e) {
            return false;
        }
    }

    public boolean hasRoleOr(String ... roleArray) {
        try {
            this.checkRoleOr(roleArray);
            return true;
        }
        catch (NotLoginException | NotRoleException e) {
            return false;
        }
    }

    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            throw new NotRoleException(role, this.loginType).setCode(11041);
        }
    }

    public void checkRoleAnd(String ... roleArray) {
        Object loginId = this.getLoginId();
        List<String> roleList = this.getRoleList(loginId);
        for (String role : roleArray) {
            if (this.hasElement(roleList, role)) continue;
            throw new NotRoleException(role, this.loginType).setCode(11041);
        }
    }

    public void checkRoleOr(String ... roleArray) {
        Object loginId = this.getLoginId();
        List<String> roleList = this.getRoleList(loginId);
        for (String role : roleArray) {
            if (!this.hasElement(roleList, role)) continue;
            return;
        }
        if (roleArray.length > 0) {
            throw new NotRoleException(roleArray[0], this.loginType).setCode(11041);
        }
    }

    public List<String> getPermissionList() {
        try {
            return this.getPermissionList(this.getLoginId());
        }
        catch (NotLoginException e) {
            return SaFoxUtil.emptyList();
        }
    }

    public List<String> getPermissionList(Object loginId) {
        return SaManager.getStpInterface().getPermissionList(loginId, this.loginType);
    }

    public boolean hasPermission(String permission) {
        return this.hasElement(this.getPermissionList(), permission);
    }

    public boolean hasPermission(Object loginId, String permission) {
        return this.hasElement(this.getPermissionList(loginId), permission);
    }

    public boolean hasPermissionAnd(String ... permissionArray) {
        try {
            this.checkPermissionAnd(permissionArray);
            return true;
        }
        catch (NotLoginException | NotPermissionException e) {
            return false;
        }
    }

    public boolean hasPermissionOr(String ... permissionArray) {
        try {
            this.checkPermissionOr(permissionArray);
            return true;
        }
        catch (NotLoginException | NotPermissionException e) {
            return false;
        }
    }

    public void checkPermission(String permission) {
        if (!this.hasPermission(permission)) {
            throw new NotPermissionException(permission, this.loginType).setCode(11051);
        }
    }

    public void checkPermissionAnd(String ... permissionArray) {
        Object loginId = this.getLoginId();
        List<String> permissionList = this.getPermissionList(loginId);
        for (String permission : permissionArray) {
            if (this.hasElement(permissionList, permission)) continue;
            throw new NotPermissionException(permission, this.loginType).setCode(11051);
        }
    }

    public void checkPermissionOr(String ... permissionArray) {
        Object loginId = this.getLoginId();
        List<String> permissionList = this.getPermissionList(loginId);
        for (String permission : permissionArray) {
            if (!this.hasElement(permissionList, permission)) continue;
            return;
        }
        if (permissionArray.length > 0) {
            throw new NotPermissionException(permissionArray[0], this.loginType).setCode(11051);
        }
    }

    public String getTokenValueByLoginId(Object loginId) {
        return this.getTokenValueByLoginId(loginId, null);
    }

    public String getTokenValueByLoginId(Object loginId, String device) {
        List<String> tokenValueList = this.getTokenValueListByLoginId(loginId, device);
        return tokenValueList.size() == 0 ? null : tokenValueList.get(tokenValueList.size() - 1);
    }

    public List<String> getTokenValueListByLoginId(Object loginId) {
        return this.getTokenValueListByLoginId(loginId, null);
    }

    public List<String> getTokenValueListByLoginId(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return Collections.emptyList();
        }
        List<TokenSign> tokenSignList = session.tokenSignListCopy();
        ArrayList<String> tokenValueList = new ArrayList<String>();
        for (TokenSign tokenSign : tokenSignList) {
            if (device != null && !tokenSign.getDevice().equals(device)) continue;
            tokenValueList.add(tokenSign.getValue());
        }
        return tokenValueList;
    }

    public String getLoginDevice() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        if (!this.isLogin()) {
            return null;
        }
        SaSession session = this.getSessionByLoginId(this.getLoginIdDefaultNull(), false);
        if (session == null) {
            return null;
        }
        List<TokenSign> tokenSignList = session.tokenSignListCopy();
        for (TokenSign tokenSign : tokenSignList) {
            if (!tokenSign.getValue().equals(tokenValue)) continue;
            return tokenSign.getDevice();
        }
        return null;
    }

    public List<String> searchTokenValue(String keyword, int start, int size, boolean sortType) {
        return this.getSaTokenDao().searchData(this.splicingKeyTokenValue(""), keyword, start, size, sortType);
    }

    public List<String> searchSessionId(String keyword, int start, int size, boolean sortType) {
        return this.getSaTokenDao().searchData(this.splicingKeySession(""), keyword, start, size, sortType);
    }

    public List<String> searchTokenSessionId(String keyword, int start, int size, boolean sortType) {
        return this.getSaTokenDao().searchData(this.splicingKeyTokenSession(""), keyword, start, size, sortType);
    }

    public void checkByAnnotation(SaCheckLogin at) {
        this.checkLogin();
    }

    public void checkByAnnotation(SaCheckRole at) {
        String[] roleArray = at.value();
        if (at.mode() == SaMode.AND) {
            this.checkRoleAnd(roleArray);
        } else {
            this.checkRoleOr(roleArray);
        }
    }

    public void checkByAnnotation(SaCheckPermission at) {
        String[] permissionArray = at.value();
        try {
            if (at.mode() == SaMode.AND) {
                this.checkPermissionAnd(permissionArray);
            } else {
                this.checkPermissionOr(permissionArray);
            }
        }
        catch (NotPermissionException e) {
            if (at.orRole().length > 0) {
                for (String role : at.orRole()) {
                    String[] rArr = SaFoxUtil.convertStringToArray(role);
                    if (!this.hasRoleAnd(rArr)) continue;
                    return;
                }
            }
            throw e;
        }
    }

    public void checkByAnnotation(SaCheckSafe at) {
        this.checkSafe(at.value());
    }

    public void checkByAnnotation(SaCheckDisable at) {
        Object loginId = this.getLoginId();
        for (String service : at.value()) {
            this.checkDisableLevel(loginId, service, at.level());
        }
    }

    public void disable(Object loginId, long time) {
        this.disableLevel(loginId, "login", 1, time);
    }

    public boolean isDisable(Object loginId) {
        return this.isDisableLevel(loginId, "login", 1);
    }

    public void checkDisable(Object loginId) {
        this.checkDisableLevel(loginId, "login", 1);
    }

    public long getDisableTime(Object loginId) {
        return this.getDisableTime(loginId, "login");
    }

    public void untieDisable(Object loginId) {
        this.untieDisable(loginId, "login");
    }

    public void disable(Object loginId, String service, long time) {
        this.disableLevel(loginId, service, 1, time);
    }

    public boolean isDisable(Object loginId, String service) {
        return this.isDisableLevel(loginId, service, 1);
    }

    public void checkDisable(Object loginId, String ... services) {
        if (services != null) {
            for (String service : services) {
                this.checkDisableLevel(loginId, service, 1);
            }
        }
    }

    public long getDisableTime(Object loginId, String service) {
        return this.getSaTokenDao().getTimeout(this.splicingKeyDisable(loginId, service));
    }

    public void untieDisable(Object loginId, String ... services) {
        if (SaFoxUtil.isEmpty(loginId)) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u89e3\u7981\u7684\u8d26\u53f7").setCode(11062);
        }
        if (services == null || services.length == 0) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u89e3\u7981\u7684\u670d\u52a1").setCode(11063);
        }
        for (String service : services) {
            this.getSaTokenDao().delete(this.splicingKeyDisable(loginId, service));
            SaTokenEventCenter.doUntieDisable(this.loginType, loginId, service);
        }
    }

    public void disableLevel(Object loginId, int level, long time) {
        this.disableLevel(loginId, "login", level, time);
    }

    public void disableLevel(Object loginId, String service, int level, long time) {
        if (SaFoxUtil.isEmpty(loginId)) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u5c01\u7981\u7684\u8d26\u53f7").setCode(11062);
        }
        if (SaFoxUtil.isEmpty(service)) {
            throw new SaTokenException("\u8bf7\u63d0\u4f9b\u8981\u5c01\u7981\u7684\u670d\u52a1").setCode(11063);
        }
        if (level < 1) {
            throw new SaTokenException("\u5c01\u7981\u7b49\u7ea7\u4e0d\u53ef\u4ee5\u5c0f\u4e8e\u6700\u5c0f\u503c\uff1a1").setCode(11064);
        }
        this.getSaTokenDao().set(this.splicingKeyDisable(loginId, service), String.valueOf(level), time);
        SaTokenEventCenter.doDisable(this.loginType, loginId, service, level, time);
    }

    public boolean isDisableLevel(Object loginId, int level) {
        return this.isDisableLevel(loginId, "login", level);
    }

    public boolean isDisableLevel(Object loginId, String service, int level) {
        int disableLevel = this.getDisableLevel(loginId, service);
        if (disableLevel == -2) {
            return false;
        }
        return disableLevel >= level;
    }

    public void checkDisableLevel(Object loginId, int level) {
        this.checkDisableLevel(loginId, "login", level);
    }

    public void checkDisableLevel(Object loginId, String service, int level) {
        String value = this.getSaTokenDao().get(this.splicingKeyDisable(loginId, service));
        if (SaFoxUtil.isEmpty(value)) {
            return;
        }
        Integer disableLevel = SaFoxUtil.getValueByType(value, Integer.TYPE);
        if (disableLevel >= level) {
            throw new DisableServiceException(this.loginType, loginId, service, disableLevel, level, this.getDisableTime(loginId, service)).setCode(11061);
        }
    }

    public int getDisableLevel(Object loginId) {
        return this.getDisableLevel(loginId, "login");
    }

    public int getDisableLevel(Object loginId, String service) {
        String value = this.getSaTokenDao().get(this.splicingKeyDisable(loginId, service));
        if (SaFoxUtil.isEmpty(value)) {
            return -2;
        }
        return SaFoxUtil.getValueByType(value, Integer.TYPE);
    }

    public void switchTo(Object loginId) {
        SaHolder.getStorage().set(this.splicingKeySwitch(), loginId);
    }

    public void endSwitch() {
        SaHolder.getStorage().delete(this.splicingKeySwitch());
    }

    public boolean isSwitch() {
        return SaHolder.getStorage().get(this.splicingKeySwitch()) != null;
    }

    public Object getSwitchLoginId() {
        return SaHolder.getStorage().get(this.splicingKeySwitch());
    }

    public void switchTo(Object loginId, SaFunction function) {
        try {
            this.switchTo(loginId);
            function.run();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.endSwitch();
        }
    }

    public void openSafe(long safeTime) {
        this.openSafe("important", safeTime);
    }

    public void openSafe(String service, long safeTime) {
        this.checkLogin();
        String tokenValue = this.getTokenValueNotNull();
        this.getSaTokenDao().set(this.splicingKeySafe(tokenValue, service), "SAFE_AUTH_SAVE_VALUE", safeTime);
        SaTokenEventCenter.doOpenSafe(this.loginType, tokenValue, service, safeTime);
    }

    public boolean isSafe() {
        return this.isSafe("important");
    }

    public boolean isSafe(String service) {
        return this.isSafe(this.getTokenValue(), service);
    }

    public boolean isSafe(String tokenValue, String service) {
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return false;
        }
        String value = this.getSaTokenDao().get(this.splicingKeySafe(tokenValue, service));
        return !SaFoxUtil.isEmpty(value);
    }

    public void checkSafe() {
        this.checkSafe("important");
    }

    public void checkSafe(String service) {
        String tokenValue = this.getTokenValue();
        if (!this.isSafe(tokenValue, service)) {
            throw new NotSafeException(this.loginType, tokenValue, service).setCode(11071);
        }
    }

    public long getSafeTime() {
        return this.getSafeTime("important");
    }

    public long getSafeTime(String service) {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return -2L;
        }
        return this.getSaTokenDao().getTimeout(this.splicingKeySafe(tokenValue, service));
    }

    public void closeSafe() {
        this.closeSafe("important");
    }

    public void closeSafe(String service) {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty(tokenValue)) {
            return;
        }
        this.getSaTokenDao().delete(this.splicingKeySafe(tokenValue, service));
        SaTokenEventCenter.doCloseSafe(this.loginType, tokenValue, service);
    }

    public String splicingKeyTokenName() {
        return this.getConfig().getTokenName();
    }

    public String splicingKeyTokenValue(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":token:" + tokenValue;
    }

    public String splicingKeySession(Object loginId) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":session:" + loginId;
    }

    public String splicingKeyTokenSession(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":token-session:" + tokenValue;
    }

    public String splicingKeyLastActivityTime(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":last-activity:" + tokenValue;
    }

    public String splicingKeySwitch() {
        return "SWITCH_TO_SAVE_KEY_" + this.loginType;
    }

    public String splicingKeyJustCreatedSave() {
        return "JUST_CREATED_";
    }

    public String splicingKeyDisable(Object loginId, String service) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":disable:" + service + ":" + loginId;
    }

    public String splicingKeySafe(String tokenValue, String service) {
        return this.getConfig().getTokenName() + ":" + this.loginType + ":safe:" + service + ":" + tokenValue;
    }

    public SaTokenConfig getConfig() {
        return SaManager.getConfig();
    }

    public boolean getConfigOfIsShare() {
        return this.getConfig().getIsShare();
    }

    public boolean isOpenActivityCheck() {
        return this.getConfig().getActivityTimeout() != -1L;
    }

    public int getConfigOfCookieTimeout() {
        long timeout = this.getConfig().getTimeout();
        if (timeout == -1L) {
            return Integer.MAX_VALUE;
        }
        return (int)timeout;
    }

    public SaTokenDao getSaTokenDao() {
        return SaManager.getSaTokenDao();
    }

    public boolean hasElement(List<String> list, String element) {
        return SaStrategy.me.hasElement.apply(list, element);
    }
}

