/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class SaTokenDaoRedis
implements SaTokenDao {
    public StringRedisTemplate stringRedisTemplate;
    public RedisTemplate<String, Object> objectRedisTemplate;
    public boolean isInit;

    @Autowired
    public void init(RedisConnectionFactory connectionFactory) {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer valueSerializer = new JdkSerializationRedisSerializer();
        StringRedisTemplate stringTemplate = new StringRedisTemplate();
        stringTemplate.setConnectionFactory(connectionFactory);
        stringTemplate.afterPropertiesSet();
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)keySerializer);
        template.setHashKeySerializer((RedisSerializer)keySerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        template.afterPropertiesSet();
        if (!this.isInit) {
            this.stringRedisTemplate = stringTemplate;
            this.objectRedisTemplate = template;
            this.isInit = true;
        }
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public long getTimeout(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public Object getObject(String key) {
        return this.objectRedisTemplate.opsForValue().get((Object)key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.objectRedisTemplate.opsForValue().set((Object)key, object);
        } else {
            this.objectRedisTemplate.opsForValue().set((Object)key, object, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.objectRedisTemplate.delete((Object)key);
    }

    public long getObjectTimeout(String key) {
        return this.objectRedisTemplate.getExpire((Object)key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        this.objectRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        Set keys = this.stringRedisTemplate.keys((Object)(prefix + "*" + keyword + "*"));
        ArrayList list = new ArrayList(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size);
    }
}

