/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jwt;

import cn.dev33.satoken.jwt.exception.SaJwtException;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTException;
import java.util.Map;
import java.util.Objects;

public class SaJwtTemplate {
    public static final String LOGIN_TYPE = "loginType";
    public static final String LOGIN_ID = "loginId";
    public static final String DEVICE = "device";
    public static final String EFF = "eff";
    public static final String RN_STR = "rnStr";
    public static final long NEVER_EXPIRE = -1L;
    public static final long NOT_VALUE_EXPIRE = -2L;

    public String createToken(String loginType, Object loginId, Map<String, Object> extraData, String keyt) {
        JWT jwt = JWT.create().setPayload(LOGIN_TYPE, (Object)loginType).setPayload(LOGIN_ID, loginId).setPayload(RN_STR, (Object)SaFoxUtil.getRandomString((int)32)).addPayloads(extraData);
        return this.generateToken(jwt, keyt);
    }

    public String createToken(String loginType, Object loginId, String device, long timeout, Map<String, Object> extraData, String keyt) {
        long effTime = timeout;
        if (timeout != -1L) {
            effTime = timeout * 1000L + System.currentTimeMillis();
        }
        JWT jwt = JWT.create().setPayload(LOGIN_TYPE, (Object)loginType).setPayload(LOGIN_ID, loginId).setPayload(DEVICE, (Object)device).setPayload(EFF, (Object)effTime).setPayload(RN_STR, (Object)SaFoxUtil.getRandomString((int)32)).addPayloads(extraData);
        return this.generateToken(jwt, keyt);
    }

    public String generateToken(JWT jwt, String keyt) {
        return jwt.setKey(keyt.getBytes()).sign();
    }

    public JWT parseToken(String token, String loginType, String keyt, boolean isCheckTimeout) {
        Long effTime;
        if (keyt == null) {
            throw new SaJwtException("\u8bf7\u914d\u7f6e jwt \u79d8\u94a5");
        }
        if (token == null) {
            throw new SaJwtException("jwt \u5b57\u7b26\u4e32\u4e0d\u53ef\u4e3a\u7a7a");
        }
        JWT jwt = null;
        try {
            jwt = JWT.of((String)token);
        }
        catch (JWTException e) {
            throw new SaJwtException("jwt \u89e3\u6790\u5931\u8d25\uff1a" + token, e).setCode(30201);
        }
        JSONObject payloads = jwt.getPayloads();
        boolean verify = jwt.setKey(keyt.getBytes()).verify();
        if (!verify) {
            throw new SaJwtException("jwt \u7b7e\u540d\u65e0\u6548\uff1a" + token).setCode(30202);
        }
        if (!Objects.equals(loginType, payloads.getStr((Object)LOGIN_TYPE))) {
            throw new SaJwtException("jwt loginType \u65e0\u6548\uff1a" + token).setCode(30203);
        }
        if (isCheckTimeout && (effTime = payloads.getLong((Object)EFF, Long.valueOf(0L))) != -1L && (effTime == null || effTime < System.currentTimeMillis())) {
            throw new SaJwtException("jwt \u5df2\u8fc7\u671f\uff1a" + token).setCode(30204);
        }
        return jwt;
    }

    public JSONObject getPayloads(String token, String loginType, String keyt) {
        return this.parseToken(token, loginType, keyt, true).getPayloads();
    }

    public JSONObject getPayloadsNotCheck(String token, String loginType, String keyt) {
        return this.parseToken(token, loginType, keyt, false).getPayloads();
    }

    public Object getLoginId(String token, String loginType, String keyt) {
        return this.getPayloads(token, loginType, keyt).get((Object)LOGIN_ID);
    }

    public Object getLoginIdOrNull(String token, String loginType, String keyt) {
        try {
            return this.getPayloads(token, loginType, keyt).get((Object)LOGIN_ID);
        }
        catch (SaJwtException e) {
            return null;
        }
    }

    public long getTimeout(String token, String loginType, String keyt) {
        if (token == null) {
            return -2L;
        }
        JWT jwt = null;
        try {
            jwt = JWT.of((String)token);
        }
        catch (JWTException e) {
            return -2L;
        }
        JSONObject payloads = jwt.getPayloads();
        boolean verify = jwt.setKey(keyt.getBytes()).verify();
        if (!verify) {
            return -2L;
        }
        if (!Objects.equals(loginType, payloads.getStr((Object)LOGIN_TYPE))) {
            return -2L;
        }
        Long effTime = (Long)payloads.get((Object)EFF, Long.class);
        if (effTime == -1L) {
            return -1L;
        }
        if (effTime == null || effTime < System.currentTimeMillis()) {
            return -2L;
        }
        return (effTime - System.currentTimeMillis()) / 1000L;
    }
}

