/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jwt;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.jwt.SaJwtUtil;
import cn.dev33.satoken.jwt.exception.SaJwtException;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpLogic;
import java.util.List;
import java.util.Map;

public class StpLogicJwtForMixin
extends StpLogic {
    public StpLogicJwtForMixin() {
        super("login");
    }

    public StpLogicJwtForMixin(String loginType) {
        super(loginType);
    }

    public String jwtSecretKey() {
        String keyt = this.getConfig().getJwtSecretKey();
        SaJwtException.throwByNull(keyt, "\u8bf7\u914d\u7f6ejwt\u79d8\u94a5", 30205);
        return keyt;
    }

    public String createTokenValue(Object loginId, String device, long timeout, Map<String, Object> extraData) {
        return SaJwtUtil.createToken(this.loginType, loginId, device, timeout, extraData, this.jwtSecretKey());
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginType = this.getLoginType();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = -2L;
        info.tokenSessionTimeout = -2L;
        info.tokenActivityTimeout = -2L;
        info.loginDevice = this.getLoginDevice();
        return info;
    }

    public String getLoginIdNotHandle(String tokenValue) {
        try {
            Object loginId = SaJwtUtil.getLoginId(tokenValue, this.loginType, this.jwtSecretKey());
            return String.valueOf(loginId);
        }
        catch (SaJwtException e) {
            return null;
        }
    }

    public void logout() {
        SaHolder.getStorage().delete(this.splicingKeyJustCreatedSave());
        if (this.getConfig().getIsReadCookie().booleanValue()) {
            SaHolder.getResponse().deleteCookie(this.getTokenName());
        }
    }

    public void logout(Object loginId, String device) {
        throw new ApiDisabledException();
    }

    public void logoutByTokenValue(String tokenValue) {
        throw new ApiDisabledException();
    }

    public void kickout(Object loginId, String device) {
        throw new ApiDisabledException();
    }

    public void kickoutByTokenValue(String tokenValue) {
        throw new ApiDisabledException();
    }

    public void replaced(Object loginId, String device) {
        throw new ApiDisabledException();
    }

    public Object getExtra(String key) {
        return this.getExtra(this.getTokenValue(), key);
    }

    public Object getExtra(String tokenValue, String key) {
        return SaJwtUtil.getPayloads(tokenValue, this.loginType, this.jwtSecretKey()).get((Object)key);
    }

    public void deleteTokenToIdMapping(String tokenValue) {
    }

    public void updateTokenToIdMapping(String tokenValue, Object loginId) {
    }

    public void saveTokenToIdMapping(String tokenValue, Object loginId, long timeout) {
    }

    public long getTokenTimeout() {
        return SaJwtUtil.getTimeout(this.getTokenValue(), this.loginType, this.jwtSecretKey());
    }

    public List<String> searchTokenValue(String keyword, int start, int size, boolean sortType) {
        throw new ApiDisabledException();
    }

    public boolean getConfigOfIsShare() {
        return false;
    }
}

